/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedFunctionArgumentLookupElement;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpAttributeCanBeAddedToOverriddenMemberInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpMatchExpressionImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsRegistry;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PhpExpectedValuesShouldBeUsedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpExpectedValuesShouldBeUsedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                this.check((PsiElement)assignmentExpression.getVariable(), (PsiElement)assignmentExpression.getValue(), PhpExpectedFunctionArgumentsRegistry.INSTANCE_WITHOUT_ASSIGNED_VALUES);
            }

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                PsiElement right;
                PsiElement left;
                if (PhpTokenTypes.tsCOMPARE_EQUALITY_OPS.contains(expression.getOperationType()) && !this.check(left = expression.getLeftOperand(), right = expression.getRightOperand())) {
                    this.check(right, left);
                }
            }

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                PsiElement argument = switchStatement.getArgument();
                for (PhpCase aCase : switchStatement.getCases()) {
                    this.check(argument, aCase.getArgument());
                }
            }

            public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
                PhpExpression argument = matchExpression.getArgument();
                for (PhpExpression condition : PhpMatchExpressionImpl.getAllConditions(matchExpression)) {
                    this.check((PsiElement)argument, (PsiElement)condition);
                }
            }

            public void visitPhpFunction(Function function) {
                final List<PhpExpectedFunctionArgument> expectedReturnValues = PhpExpectedValuesShouldBeUsedInspection.getFromAttributes(PhpExpectedFunctionArgumentsRegistry.INSTANCE.getValues(function));
                if (!expectedReturnValues.isEmpty()) {
                    PhpControlFlowUtil.processFlow(function.getControlFlow(), new PhpInstructionProcessor(){

                        public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                            this.check(instruction.getArgument(), expectedReturnValues);
                            return true;
                        }
                    });
                }
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.check((PsiElement)reference, reference.getParameters());
            }

            public void check(PsiElement reference, PsiElement[] parameters) {
                if (parameters.length == 0) {
                    return;
                }
                Function function = (Function)ContainerUtil.getOnlyItem(PhpWorkaroundUtil.resolveTargetFunctions(reference));
                if (function == null) {
                    return;
                }
                IntStream.range(0, parameters.length).forEach(i -> this.check(parameters[i], PhpExpectedValuesShouldBeUsedInspection.getFromAttributes(PhpExpectedFunctionArgumentsRegistry.INSTANCE.getParameterValues(function, i))));
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.visitPhpFunctionCall((FunctionReference)reference);
            }

            public void visitPhpNewExpression(NewExpression expression) {
                this.check((PsiElement)expression, expression.getParameters());
            }

            public void visitPhpAttribute(PhpAttribute attribute) {
                this.check((PsiElement)attribute, attribute.getParameters());
            }

            public void visitPhpReturn(PhpReturn returnStatement) {
                PsiElement argument = returnStatement.getArgument();
                this.check((PsiElement)PhpPsiUtil.getParentOfClass((PsiElement)returnStatement, Function.class), argument);
            }

            private boolean check(PsiElement variableWithExpectedValues, PsiElement value) {
                return this.check(variableWithExpectedValues, value, PhpExpectedFunctionArgumentsRegistry.INSTANCE);
            }

            private boolean check(PsiElement variableWithExpectedValues, PsiElement value, PhpExpectedFunctionArgumentsRegistry registry) {
                if (variableWithExpectedValues == null || value == null) {
                    return false;
                }
                List<PhpExpectedFunctionArgument> arguments = PhpExpectedValuesShouldBeUsedInspection.getFromAttributes(registry.getValues(variableWithExpectedValues, false));
                return this.check(value, arguments);
            }

            private boolean check(PsiElement value, List<PhpExpectedFunctionArgument> arguments) {
                if (!arguments.isEmpty() && !PhpExpectedValuesShouldBeUsedInspection.mayMatchExpectedArguments(value, arguments, new HashSet<PsiElement>())) {
                    holder.registerProblem(value, PhpExpectedValuesShouldBeUsedInspection.createShouldBeOneOfMessage(arguments), (LocalQuickFix[])ContainerUtil.map2Array(arguments, LocalQuickFix.class, PhpReplaceWithExpectedArgumentQuickFix::new));
                    return true;
                }
                return false;
            }
        };
    }

    @NotNull
    @Nls
    public static String createShouldBeOneOfMessage(Collection<PhpExpectedFunctionArgument> arguments) {
        String string = PhpBundle.message("inspection.message.should.be.one", StringUtil.join(arguments, argument -> PhpLangUtil.toShortName(argument.getValue()), (String)", "));
        if (string == null) {
            PhpExpectedValuesShouldBeUsedInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static @Unmodifiable List<PhpExpectedFunctionArgument> getFromAttributes(List<PhpExpectedFunctionArgument> arguments1) {
        List list = ContainerUtil.filter(arguments1, PhpExpectedFunctionArgument::isFromAttribute);
        if (list == null) {
            PhpExpectedValuesShouldBeUsedInspection.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static boolean mayMatchExpectedArguments(@Nullable PsiElement value, final List<PhpExpectedFunctionArgument> arguments, final Collection<PsiElement> visited) {
        PhpAccessVariableInstruction instruction;
        if (visited == null || value == null || !visited.add(value)) {
            return true;
        }
        Set inferredValues = ContainerUtil.map2Set(PhpExpectedFunctionArgumentsRegistry.INFERRED_VALUES_INSTANCE.getValues(value, true), PhpExpectedFunctionArgument::getValue);
        if (ContainerUtil.exists(arguments, arg -> inferredValues.contains(arg.getValue()) || arg.matches(value))) {
            return true;
        }
        if (value instanceof Variable && (instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)((Variable)value), PhpAccessVariableInstruction.class)) != null) {
            final Ref res = new Ref((Object)false);
            PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    if (instruction.getAccess().isWrite()) {
                        if (PhpExpectedValuesShouldBeUsedInspection.mayMatchExpectedArguments(((PhpAccessVariableInstructionImpl)instruction).getAssignedValue(), arguments, visited)) {
                            res.set((Object)true);
                        }
                        return false;
                    }
                    return true;
                }
            });
            return (Boolean)res.get() != false || PhpExpectedValuesShouldBeUsedInspection.areAmbiguousInferredValues(value);
        }
        return !PhpExpectedFunctionArgumentLookupElement.ELEMENT_CAN_BE_EXPECTED_ARGUMENT.value((Object)value) && PhpExpectedValuesShouldBeUsedInspection.areAmbiguousInferredValues(value);
    }

    private static boolean areAmbiguousInferredValues(@NotNull PsiElement value) {
        if (value == null) {
            PhpExpectedValuesShouldBeUsedInspection.$$$reportNull$$$0(3);
        }
        return PhpExpectedFunctionArgumentsRegistry.INFERRED_VALUES_INSTANCE.getValues(value, false).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpExpectedValuesShouldBeUsedInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpExpectedValuesShouldBeUsedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createShouldBeOneOfMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "areAmbiguousInferredValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpReplaceWithExpectedArgumentQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final PhpExpectedFunctionArgument myArgument;

        private PhpReplaceWithExpectedArgumentQuickFix(PhpExpectedFunctionArgument argument) {
            this.myArgument = argument;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with", PhpLangUtil.toShortName(this.myArgument.getValue()));
            if (string == null) {
                PhpReplaceWithExpectedArgumentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithExpectedArgumentQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithExpectedArgumentQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithExpectedArgumentQuickFix.$$$reportNull$$$0(3);
            }
            PhpPsiElement replacedReference = (PhpPsiElement)element.replace(this.myArgument.createReference(project));
            PhpAttributeCanBeAddedToOverriddenMemberInspection.shortenClassReferences(replacedReference);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpExpectedValuesShouldBeUsedInspection$PhpReplaceWithExpectedArgumentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpExpectedValuesShouldBeUsedInspection$PhpReplaceWithExpectedArgumentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

