/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoveAttributeQuickFix
extends PsiUpdateModCommandAction<PhpAttribute> {
    @Nullable
    @NlsSafe
    private final String myAttributeName;

    public PhpRemoveAttributeQuickFix(@NotNull PhpAttribute element) {
        if (element == null) {
            PhpRemoveAttributeQuickFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
        this.myAttributeName = element.getName();
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.remove.attribute", this.myAttributeName);
        if (string == null) {
            PhpRemoveAttributeQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PhpAttribute element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpRemoveAttributeQuickFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpRemoveAttributeQuickFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpRemoveAttributeQuickFix.$$$reportNull$$$0(4);
        }
        PhpRemoveAttributeQuickFix.removeAttribute((PsiElement)element);
    }

    public static void removeAttribute(@NotNull PsiElement element) {
        PhpAttributesList list;
        if (element == null) {
            PhpRemoveAttributeQuickFix.$$$reportNull$$$0(5);
        }
        if ((list = PhpPsiUtil.getParentOfClass(element, PhpAttributesList.class)) != null && list.getAttributes().size() == 1) {
            list.delete();
        } else {
            PhpCodeEditUtil.removeStatementWithDelivery(element, PhpTokenTypes.opCOMMA);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpRemoveAttributeQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpRemoveAttributeQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeAttribute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

