/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpAddAttributeQuickFixBase;
import com.jetbrains.php.lang.inspections.classes.PhpAddMethodStubsQuickFix;
import com.jetbrains.php.lang.inspections.classes.PhpMakeClassAbstractQuickFix;
import com.jetbrains.php.lang.inspections.classes.PhpMakeMethodNonFinalQuickFix;
import com.jetbrains.php.lang.inspections.classes.PhpMakeMethodNonStaticQuickFix;
import com.jetbrains.php.lang.inspections.classes.PhpMakeNonFinalQuickFix;
import com.jetbrains.php.lang.inspections.codeStyle.PhpMethodMayBeStaticInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpChangeMethodModifiersQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpMakeMethodNonAbstractQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpSwitchLanguageLevelQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeReturnTypeQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpMissingReturnTypeInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassFieldsListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PhpHierarchyChecksInspection
extends PhpInspection {
    private static final String TENTATIVE_TYPE_ATTRIBUTE_FQN = "\\JetBrains\\PhpStorm\\Internal\\TentativeType";
    private static final String RETURN_TYPE_WILL_CHANGE_ATTRIBUTE_FQN = "\\ReturnTypeWillChange";
    private static final LocalQuickFix SUPPRESS_TENTATIVE_TYPE_WARNING = new PhpAddAttributeQuickFixBase("\\ReturnTypeWillChange");
    private static final PhpAddMethodStubsQuickFix FIX = new PhpAddMethodStubsQuickFix();
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{FIX};

    protected Collection<MethodCheck> getMethodChecks() {
        return List.of(MethodCheck.STATIC, MethodCheck.ABSTRACT, MethodCheck.VISIBILITY, MethodCheck.FINAL, MethodCheck.DECLARATION, MethodCheck.RETURN);
    }

    @NotNull
    public static ProblemDescriptor getMethodSignatureDescriptor(@NotNull Method method, @NotNull PsiElement identifier, @InspectionMessage String descriptionTemplate, ProblemHighlightType highlightType, boolean isOnTheFly, LocalQuickFix ... fixes) {
        if (method == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(0);
        }
        if (identifier == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(1);
        }
        if (fixes == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(2);
        }
        int firstChildAfterAttributeStart = PhpClassFieldsListImpl.getFirstChildNodeSkippingAttributes((PsiElement)method).getPsi().getStartOffsetInParent();
        ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)method.getProject()).createProblemDescriptor((PsiElement)method, TextRange.create((int)firstChildAfterAttributeStart, (int)identifier.getTextRangeInParent().getEndOffset()), descriptionTemplate, highlightType, isOnTheFly, fixes);
        if (problemDescriptor == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(3);
        }
        return problemDescriptor;
    }

    protected void doCheckClass(PhpClass clazz, boolean isOnTheFly, ProblemsHolder holder) {
        for (Method method2 : clazz.getOwnMethods()) {
            String name = method2.getName();
            PhpClass containingClass = method2.getContainingClass();
            PsiElement node = method2.getNameIdentifier();
            if (containingClass == null || node == null || name.equalsIgnoreCase(containingClass.getName()) || method2 instanceof PhpDocMethod || containingClass.isTrait()) continue;
            PhpModifier modifier = method2.getModifier();
            if (!method2.isStatic() || !"__clone".equalsIgnoreCase(name) && !"__construct".equalsIgnoreCase(name) && !"__destruct".equalsIgnoreCase(name)) continue;
            String text = "__construct".equalsIgnoreCase(name) ? PhpBundle.message("inspection.message.constructor.cannot.be.static", new Object[0]) : ("__destruct".equalsIgnoreCase(name) ? PhpBundle.message("inspection.message.destructor.cannot.be.static", new Object[0]) : PhpBundle.message("inspection.message.clone.method.cannot.be.static", new Object[0]));
            PhpModifier newMod = PhpModifier.instance((PhpModifier.Access)modifier.getAccess(), (PhpModifier.Abstractness)modifier.getAbstractness(), (PhpModifier.State)PhpModifier.State.DYNAMIC);
            holder.registerProblem(PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method2, node, text, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{new PhpChangeMethodModifiersQuickFix(containingClass.isInterface() ? null : newMod)}));
        }
        boolean clazzIsAbstract = clazz.isAbstract();
        if (clazz.isInterface() || clazzIsAbstract && !clazz.hasTraitUses() || clazz.isTrait()) {
            return;
        }
        List<Method> abstractMethods = PhpHierarchyChecksInspection.getNonImplementedAbstractMethods(clazz);
        abstractMethods.addAll(PhpHierarchyChecksInspection.getNonImplementedPropertyHooks(clazz));
        if (!abstractMethods.isEmpty()) {
            StringBuilder methodList = new StringBuilder();
            if (abstractMethods.size() == 1) {
                methodList.append("method '").append(abstractMethods.get(0).getName()).append("'");
            } else {
                methodList.append("methods ");
                Iterator<Method> methodIterator = abstractMethods.iterator();
                while (methodIterator.hasNext()) {
                    Method abstractMethod = methodIterator.next();
                    methodList.append("'").append(abstractMethod.getName()).append("'");
                    if (!methodIterator.hasNext()) continue;
                    methodList.append(", ");
                }
            }
            PsiElement startNode = clazz.getFirstChild();
            while (startNode instanceof PhpAttributesList) {
                startNode = PhpPsiUtil.getNextSiblingIgnoreWhitespace(startNode, true);
            }
            PsiElement endNode = clazz.getImplementedInterfaces().length > 0 ? PsiTreeUtil.getChildOfType((PsiElement)clazz, ImplementsList.class) : (!clazz.getSuperClasses().isEmpty() ? PsiTreeUtil.getChildOfType((PsiElement)clazz, ExtendsList.class) : (clazz.getNameNode() != null ? clazz.getNameNode().getPsi() : startNode));
            boolean hasMethodsToImplement = ContainerUtil.exists(abstractMethods, method -> PhpHierarchyChecksInspection.shouldAddMethodStub(method, clazz) || method instanceof PhpPropertyHook);
            ProblemDescriptorImpl descriptor = new ProblemDescriptorImpl(startNode, endNode, clazzIsAbstract ? PhpBundle.message("inspection.hierarchyChecks.should.implement", methodList.toString()) : PhpBundle.message("inspection.hierarchyChecks.descr", methodList.toString()), PhpHierarchyChecksInspection.appendMakeClassAbstractQuickFix(isOnTheFly && hasMethodsToImplement ? FIXES : LocalQuickFix.EMPTY_ARRAY, clazz), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, isOnTheFly);
            holder.registerProblem((ProblemDescriptor)descriptor);
        }
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(4);
        }
        return new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                PhpHierarchyChecksInspection.this.doCheckClass(clazz, isOnTheFly, holder);
                for (Method method : clazz.getOwnMethods()) {
                    String name = method.getName();
                    PhpClass containingClass = method.getContainingClass();
                    PsiElement node = method.getNameIdentifier();
                    if (containingClass == null || node == null || name.equalsIgnoreCase(containingClass.getName()) || method instanceof PhpDocMethod || containingClass.isTrait()) continue;
                    HashMap problemsFromSuperMethods = new HashMap();
                    PhpClassHierarchyUtils.processSuperMethods((Method)method, (superMethod, subClass, baseClass) -> {
                        if (PhpClassImpl.NOT_AVAILABLE_BY_LANGUAGE_LEVEL.value((Object)superMethod)) {
                            return true;
                        }
                        PhpClass superContainingClass = superMethod.getContainingClass();
                        if (superContainingClass == null || superContainingClass.isTrait() && (PhpLanguageLevel.current((Project)holder.getProject()).isLessThan(PhpLanguageLevel.PHP800) || !superMethod.isAbstract())) {
                            return true;
                        }
                        String superName = isOnTheFly ? PhpHierarchyChecksInspection.buildSuperName(superMethod, superContainingClass) : null;
                        for (MethodCheck methodCheck : PhpHierarchyChecksInspection.this.getMethodChecks()) {
                            MethodProblem problem = superMethod instanceof PhpDocMethod ? MethodProblem.empty(superContainingClass) : methodCheck.findProblem(clazz, subClass, baseClass, (Method)superMethod, method, superName, node, isOnTheFly);
                            problemsFromSuperMethods.put(methodCheck, PhpHierarchyChecksInspection.chooseProblemWithApplicableStrictness((MethodProblem)problemsFromSuperMethods.get(methodCheck), problem));
                        }
                        return PhpLangUtil.equalsMethodNames(name, "__construct");
                    });
                    for (MethodProblem problem : problemsFromSuperMethods.values()) {
                        if (problem.myProblemRegistar == null) continue;
                        problem.myProblemRegistar.accept(holder);
                    }
                }
            }

            public void visitPhpParameter(Parameter parameter) {
                if (parameter.isPromotedField()) {
                    this.checkField(parameter.getProject(), (PhpPromotedFieldParameterImpl)parameter);
                }
            }

            public void visitPhpField(Field field) {
                Project project = field.getProject();
                if (!PhpLanguageFeature.TYPED_PROPERTIES.isSupported(project)) {
                    return;
                }
                if (field instanceof PhpDocProperty) {
                    return;
                }
                if (field.isConstant()) {
                    this.checkClassConstant(project, field);
                    return;
                }
                this.checkField(project, field);
            }

            private void checkClassConstant(Project project, Field constant) {
                PsiElement nameIdentifier = constant.getNameIdentifier();
                PhpTypeDeclaration typeDeclaration = constant.getTypeDeclaration();
                if (nameIdentifier == null) {
                    return;
                }
                PhpClassHierarchyUtils.processSuperFields((Field)constant, (superConstant, superClass, baseClass) -> {
                    String message;
                    PhpType superType = superConstant.getDeclaredType().global(project);
                    PhpType childType = constant.getDeclaredType();
                    if (!(superType.isEmpty() || superType.equals((Object)PhpType.MIXED) || PhpHierarchyChecksInspection.compatibleByCovariance(project, childType, superType).isCompatible() || (message = PhpHierarchyChecksInspection.getMessage(superConstant)) == null)) {
                        if (typeDeclaration != null && !PhpHierarchyChecksInspection.isGroupedDeclarations(constant.getParentList())) {
                            holder.registerProblem((PsiElement)typeDeclaration, message, new LocalQuickFix[]{new PhpChangeFieldTypeToMatchSuperQuickFix(constant, superType)});
                        } else {
                            holder.registerProblem(nameIdentifier, message, new LocalQuickFix[]{new PhpChangeFieldTypeToMatchSuperQuickFix(constant, superType)});
                        }
                    }
                    return false;
                });
            }

            private void checkField(Project project, Field field) {
                PsiElement readonlyKeyword;
                Ref isSuperFieldHasSetHook = new Ref((Object)false);
                PhpClassHierarchyUtils.processSuperFields((Field)field, (superField, baseClass, superClass) -> {
                    String message;
                    if (superField instanceof PhpDocProperty || superField instanceof PhpClassImpl.MyRenamableFakePsiElement) {
                        return false;
                    }
                    PhpType superType = superField.getDeclaredType().global(project);
                    PsiElement nameIdentifier = field.getNameIdentifier();
                    boolean hasSetHook = ContainerUtil.exists((Iterable)superField.getPropertyHooksList(), it -> it.getHookType() == PhpPropertyHook.PhpPropertyHookType.SET);
                    boolean hasGetHook = ContainerUtil.exists((Iterable)superField.getPropertyHooksList(), it -> it.getHookType() == PhpPropertyHook.PhpPropertyHookType.GET);
                    if (!PhpHierarchyChecksInspection.compatibleByInvariance(project, field.getDeclaredType().global(project), superType, superField.isAbstract(), hasSetHook && !hasGetHook, superField.isVirtualProperty() && hasSetHook, superField.isVirtualProperty() && hasGetHook) && (message = PhpHierarchyChecksInspection.getMessage(superField)) != null) {
                        PhpClassFieldsList fieldsList = field.getParentList();
                        PhpTypeDeclaration typeDeclaration = field.getTypeDeclaration();
                        if ((field instanceof PhpPromotedFieldParameterImpl || !PhpHierarchyChecksInspection.isGroupedDeclarations(fieldsList)) && typeDeclaration != null) {
                            holder.registerProblem((PsiElement)typeDeclaration, message, new LocalQuickFix[]{new PhpChangeFieldTypeToMatchSuperQuickFix(field, superType)});
                        } else if (nameIdentifier != null) {
                            holder.registerProblem(nameIdentifier, message, new LocalQuickFix[]{new PhpChangeFieldTypeToMatchSuperQuickFix(field, superType)});
                        }
                    }
                    if (PhpLanguageFeature.READONLY_PROPERTIES.isSupported(project)) {
                        String message2;
                        if ((!superField.hasPropertyHooksContainer() || superField instanceof PhpPromotedFieldParameterImpl) && superField.isReadonly() != field.isReadonly()) {
                            PsiElement readonlyKeyword = PhpHierarchyChecksInspection.getReadonlyKeyword(field);
                            String string = message2 = superField.isReadonly() ? PhpBundle.message("inspection.message.readonly.property.non.readonly", new Object[0]) : PhpBundle.message("inspection.message.non.readonly.property.readonly", new Object[0]);
                            if (readonlyKeyword != null) {
                                if (field instanceof PhpPromotedFieldParameterImpl || !PhpHierarchyChecksInspection.isGroupedDeclarations(field.getParentList())) {
                                    holder.registerProblem(readonlyKeyword, message2, new LocalQuickFix[]{PhpRemoveReadonlyModifierQuickFix.INSTANCE});
                                } else if (nameIdentifier != null) {
                                    holder.registerProblem(nameIdentifier, message2, new LocalQuickFix[]{PhpRemoveReadonlyModifierQuickFix.INSTANCE});
                                }
                            } else if (nameIdentifier != null) {
                                holder.registerProblem(nameIdentifier, message2, new LocalQuickFix[]{PhpAddReadonlyModifierQuickFix.INSTANCE});
                            }
                        }
                        if (superField.isFinal()) {
                            String descriptionTemplate = isOnTheFly ? PhpBundle.message("inspection.message.cannot.override.final.property.1", superClass.getName(), superField.getName()) : PhpBundle.message("inspection.message.cannot.override.final.property", new Object[0]);
                            PsiElement modifier = FieldImpl.getVisibilityPsi(superField);
                            if (modifier == null) {
                                holder.registerProblem((PsiElement)field, descriptionTemplate, new LocalQuickFix[0]);
                            } else {
                                holder.registerProblem((PsiElement)field, descriptionTemplate, new LocalQuickFix[]{LocalQuickFix.from((ModCommandAction)new PhpMakeNonFinalQuickFix((PsiElement)superField))});
                            }
                            return false;
                        }
                        List<PhpPropertyHook> superFinalHooks = superField.getPropertyHooksList().stream().filter(Method::isFinal).toList();
                        field.getPropertyHooksList().forEach(it -> {
                            PhpPropertyHook superFinalHook = (PhpPropertyHook)ContainerUtil.find((Iterable)superFinalHooks, h -> h.getHookType() == it.getHookType());
                            if (superFinalHook != null) {
                                String descriptionTemplate = isOnTheFly ? PhpBundle.message("inspection.message.cannot.override.final.property.hook.1", it.getName()) : PhpBundle.message("inspection.message.cannot.override.final.property.hook", new Object[0]);
                                holder.registerProblem((PsiElement)it, descriptionTemplate, new LocalQuickFix[]{LocalQuickFix.from((ModCommandAction)new PhpMakeNonFinalQuickFix((PsiElement)superFinalHook))});
                            }
                        });
                        if (field.isReadonly()) {
                            isSuperFieldHasSetHook.set((Object)ContainerUtil.exists((Iterable)superField.getPropertyHooksList(), (Condition)PhpPropertyHook.IS_SET_HOOK));
                        }
                        if (superClass.isTrait() && superField.hasPropertyHooksContainer()) {
                            message2 = PhpBundle.message("inspection.php.cannot.define.the.same.hooked.property", superClass.getFQN(), baseClass.getFQN());
                            holder.registerProblem((PsiElement)field, message2, new LocalQuickFix[0]);
                        }
                        PhpHierarchyChecksInspection.registerDeclarationProblemForPropertyHooks(field, superField, superClass, isOnTheFly, holder);
                    }
                    return false;
                });
                if (((Boolean)isSuperFieldHasSetHook.get()).booleanValue() && (readonlyKeyword = PhpHierarchyChecksInspection.getReadonlyKeyword(field)) != null) {
                    holder.registerProblem(readonlyKeyword, PhpBundle.message("inspection.message.set.access.level.must.be.omitted", new Object[0]), new LocalQuickFix[]{PhpRemoveReadonlyModifierQuickFix.INSTANCE});
                }
            }
        };
    }

    public static void registerDeclarationProblemForPropertyHooks(Field field, Field superField, PhpClass clazz, boolean isOnTheFly, ProblemsHolder holder) {
        for (PhpPropertyHook.PhpPropertyHookType type : PhpPropertyHook.PhpPropertyHookType.values()) {
            PsiElement identifier;
            PhpPropertyHook hook = (PhpPropertyHook)ContainerUtil.find((Iterable)field.getPropertyHooksList(), it -> it.getHookType() == type);
            PhpPropertyHook superHook = (PhpPropertyHook)ContainerUtil.find((Iterable)superField.getPropertyHooksList(), it -> it.getHookType() == type);
            if (hook == null || superHook == null || (identifier = hook.getNameIdentifier()) == null) continue;
            MethodProblem problem = MethodCheck.DECLARATION.findProblem(clazz, clazz, clazz, (Method)superHook, (Method)hook, superHook.getName(), identifier, isOnTheFly);
            if (problem.myProblemRegistar == null) continue;
            problem.myProblemRegistar.accept(holder);
        }
    }

    @Nullable
    public static PsiElement getReadonlyKeyword(Field field) {
        if (field instanceof PhpPromotedFieldParameterImpl) {
            return FieldImpl.getReadonlyKeyword((PsiElement)field);
        }
        PhpClassFieldsList fieldsList = field.getParentList();
        if (fieldsList == null) {
            return null;
        }
        PhpModifierList modifierList = fieldsList.getModifierList();
        if (modifierList == null) {
            return null;
        }
        return FieldImpl.getReadonlyKeyword((PsiElement)modifierList);
    }

    public static @Unmodifiable List<PhpPropertyHook> getNonImplementedPropertyHooks(PhpClass clazz) {
        if (PhpLanguageLevel.current((Project)clazz.getProject()).isLessThan(PhpLanguageLevel.PHP840) || clazz.isInterface() || clazz.isAbstract()) {
            return Collections.emptyList();
        }
        ArrayList abstractHooks = new ArrayList();
        ArrayList implementedHooks = new ArrayList();
        PhpClassHierarchyUtils.processSupers((PhpClass)clazz, (boolean)true, (boolean)false, curClass -> {
            Field[] ownFields = curClass.getOwnFields();
            Arrays.stream(ownFields).forEach(f -> {
                List hooks = f.getPropertyHooksList();
                abstractHooks.addAll(ContainerUtil.filter((Collection)hooks, it -> it.isAbstract()));
                implementedHooks.addAll(ContainerUtil.map((Collection)ContainerUtil.filter((Collection)hooks, it -> !it.isAbstract()), h -> h.getName()));
                if (hooks.isEmpty()) {
                    for (PhpPropertyHook.PhpPropertyHookType type : PhpPropertyHook.PhpPropertyHookType.values()) {
                        implementedHooks.add(f.getName() + "::" + type.keyWord);
                    }
                }
            });
            return true;
        });
        return ContainerUtil.filter(abstractHooks, hook -> !implementedHooks.contains(hook.getName()));
    }

    @NotNull
    private static List<Method> getNonImplementedAbstractMethods(PhpClass clazz) {
        HashMap abstractMethods = new HashMap();
        Set nonAbstractMethodNames = CollectionFactory.createCaseInsensitiveStringSet();
        PhpClassHierarchyUtils.processMethods((PhpClass)clazz, (PhpClass)clazz, (method, subClass, baseClass) -> {
            if (!method.isAbstract() || PhpHierarchyChecksInspection.isAbstractInAllMultiResolvedClasses(method)) {
                PhpClass containingClass = method.getContainingClass();
                if (containingClass != null && PhpClassImpl.isImplicitEnumFQN(containingClass.getFQN())) {
                    return true;
                }
                if (!method.isAbstract()) {
                    nonAbstractMethodNames.add(method.getName());
                }
                if (!(!clazz.isAbstract() || containingClass != null && containingClass.isTrait() && method.getModifier().isPrivate())) {
                    return true;
                }
                if (method.isAbstract()) {
                    abstractMethods.put(method.getName(), method);
                }
            }
            return true;
        }, (boolean)false, (boolean)false);
        List list = (List)EntryStream.of(abstractMethods).filterKeys(name -> !nonAbstractMethodNames.contains(name)).values().collect(Collectors.toList());
        if (list == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static MethodProblem chooseProblemWithApplicableStrictness(@Nullable MethodProblem existingProblem, @NotNull MethodProblem newProblem) {
        if (newProblem == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(6);
        }
        if (existingProblem == null || existingProblem.myClass == null || newProblem.myClass == null) {
            MethodProblem methodProblem = newProblem;
            if (methodProblem == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(7);
            }
            return methodProblem;
        }
        if (existingProblem.myProblemRegistar != null && newProblem.myProblemRegistar != null && existingProblem.myElementToHighlight != newProblem.myElementToHighlight) {
            return new MethodProblem(existingProblem.myClass, existingProblem.myElementToHighlight, holder -> {
                existingProblem.myProblemRegistar.accept((ProblemsHolder)holder);
                newProblem.myProblemRegistar.accept((ProblemsHolder)holder);
            });
        }
        if (PhpLangUtil.equalsClassNames(existingProblem.myClass.getFQN(), newProblem.myClass.getFQN())) {
            MethodProblem methodProblem = existingProblem.myProblemRegistar == null || newProblem.myProblemRegistar != null ? existingProblem : newProblem;
            if (methodProblem == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(8);
            }
            return methodProblem;
        }
        MethodProblem methodProblem = newProblem.myProblemRegistar != null ? newProblem : existingProblem;
        if (methodProblem == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(9);
        }
        return methodProblem;
    }

    private static boolean isAbstractInAllMultiResolvedClasses(Method method) {
        PhpClass aClass = method.getContainingClass();
        if (aClass == null) {
            return true;
        }
        Collection classes = PhpIndex.getInstance((Project)method.getProject()).getAnyByFQN(aClass.getFQN());
        return ContainerUtil.all((Collection)classes, c -> {
            Method m = c.findOwnMethodByName((CharSequence)method.getName());
            return m != null && m.isAbstract() && !(m instanceof PhpDocMethod);
        });
    }

    private static boolean shouldCheckConstructor(@Nullable PhpClass clazz, @Nullable PhpClass subClass, @Nullable PhpClass baseClass, Method constructor) {
        if (clazz == null || subClass == null || baseClass == null) {
            return false;
        }
        if (constructor.isAbstract()) {
            if (PhpLanguageLevel.current((Project)clazz.getProject()).isAtLeast(PhpLanguageLevel.PHP740)) {
                return true;
            }
            return clazz == subClass || baseClass.isInterface();
        }
        return false;
    }

    private static boolean compatibleByInvariance(@NotNull Project project, @NotNull PhpType type, @NotNull PhpType superType, boolean isSuperFieldAbstract, boolean hasOnlySetHook, boolean covariantByHooks, boolean contravariantByHooks) {
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(10);
        }
        if (type == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(11);
        }
        if (superType == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(12);
        }
        if (covariantByHooks && contravariantByHooks) {
            return true;
        }
        boolean compatibleByCovariance = PhpHierarchyChecksInspection.streamOfTypes(type).map(t -> PhpHierarchyChecksInspection.compatibleByCovariance(project, t, superType)).allMatch(Compatibility::isCompatible);
        if (isSuperFieldAbstract && compatibleByCovariance) {
            return true;
        }
        boolean compatibleByContravariance = PhpHierarchyChecksInspection.streamOfTypes(superType).map(superT -> PhpHierarchyChecksInspection.compatibleByContravariance(project, type, superT)).allMatch(Compatibility::isCompatible);
        if (isSuperFieldAbstract && compatibleByContravariance && hasOnlySetHook) {
            return true;
        }
        return !(!covariantByHooks && !compatibleByCovariance || !contravariantByHooks && !compatibleByContravariance);
    }

    @NotNull
    public static @NotNull StreamEx<@NotNull PhpType> streamOfTypes(@NotNull PhpType type) {
        if (type == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(13);
        }
        if (type.isEmpty()) {
            StreamEx streamEx = StreamEx.of((Object)PhpType.EMPTY);
            if (streamEx == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(14);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.of((Collection)type.getTypes()).map(t -> new PhpType().add(t));
        if (streamEx == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(15);
        }
        return streamEx;
    }

    public static boolean areDeclarationsFullyCompatible(@NotNull Method childMethod, @NotNull Method superMethod, @Nullable PhpClass childClass) {
        if (childMethod == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(16);
        }
        if (superMethod == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(17);
        }
        boolean returnTypeCompatible = PhpHierarchyChecksInspection.compatibleByReturnType(childMethod.getProject(), childMethod, superMethod.getDeclaredType(), childClass).isCompatible() || PhpHierarchyChecksInspection.hasTentativeReturnTypeAttribute(superMethod);
        return returnTypeCompatible && ((Compatibility)PhpHierarchyChecksInspection.checkDeclarationsCompatibility((Method)superMethod, (Method)childMethod).first).isCompatible();
    }

    public static Compatibility compatibleByReturnType(@NotNull Project project, @NotNull Method childMethod, PhpType superMethodDeclaredType) {
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(18);
        }
        if (childMethod == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(19);
        }
        return PhpHierarchyChecksInspection.compatibleByReturnType(project, childMethod, superMethodDeclaredType, null);
    }

    public static Compatibility compatibleByReturnType(@NotNull Project project, @NotNull Method method, PhpType superMethodDeclaredType, @Nullable PhpClass childClass) {
        PhpReturnType childReturnType;
        PhpType type;
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(20);
        }
        if (method == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(21);
        }
        PhpType phpType = type = (childReturnType = (PhpReturnType)method.getTypeDeclaration()) != null ? childReturnType.getType() : PhpType.EMPTY;
        if (childClass != null) {
            if (childClass.isAnonymous()) {
                if (ContainerUtil.exists((Iterable)type.getTypes(), arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.SELF_CLASS_IN_TRAIT).isSigned(arg_0))) {
                    return Compatibility.COMPATIBLE;
                }
            }
            type = type.map(s -> PhpTypeSignatureKey.SELF_CLASS_IN_TRAIT.isSigned(s) ? childClass.getFQN() : s);
        }
        return PhpHierarchyChecksInspection.getCompatibility(project, method, superMethodDeclaredType, type);
    }

    public static Compatibility getCompatibility(@NotNull Project project, @NotNull Method method, PhpType superMethodDeclaredType, PhpType childType) {
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(22);
        }
        if (method == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(23);
        }
        PhpReturnType childReturnType = (PhpReturnType)method.getTypeDeclaration();
        if (childType.isEmpty()) {
            if (superMethodDeclaredType.isEmpty()) {
                return Compatibility.COMPATIBLE;
            }
            PhpLanguageLevel maxLanguageLevel = (PhpLanguageLevel)ArrayUtil.getLastElement((Object[])PhpLanguageLevel.values());
            String hint = PhpMissingReturnTypeInspection.createTypeHint(maxLanguageLevel, (PhpScopeHolder)method, superMethodDeclaredType);
            return StringUtil.isNotEmpty((String)hint) ? Compatibility.NON_COMPATIBLE.withFixes(new LocalQuickFix[]{new PhpMissingReturnTypeInspection.PhpAddReturnTypeQuickFix(maxLanguageLevel, hint, superMethodDeclaredType)}) : Compatibility.NON_COMPATIBLE;
        }
        Map referenceCompatibilityMap = PhpHierarchyChecksInspection.streamOfTypes(childType).mapToEntry(t -> PhpHierarchyChecksInspection.compatibleByReturnType(project, superMethodDeclaredType, t)).filterValues(Predicate.not(Compatibility::isCompatible)).toMap();
        if (referenceCompatibilityMap.isEmpty()) {
            return Compatibility.COMPATIBLE;
        }
        if (childReturnType == null) {
            return Compatibility.NON_COMPATIBLE;
        }
        boolean standaloneTypeDeclaration = childReturnType.getClassReferences().size() == 1 || childReturnType.isIntersection();
        PhpChangeReturnTypeQuickFix changeReturnTypeFix = new PhpChangeReturnTypeQuickFix(project, childType, superMethodDeclaredType);
        if (standaloneTypeDeclaration) {
            return ((Compatibility)ContainerUtil.getFirstItem(referenceCompatibilityMap.values())).withFixes(new LocalQuickFix[]{changeReturnTypeFix});
        }
        return Compatibility.createUnionTypeCompatibility(referenceCompatibilityMap, (PhpTypeDeclaration)childReturnType, changeReturnTypeFix);
    }

    private static Compatibility compatibleByReturnType(Project project, PhpType superMethodReturnType, PhpType child) {
        boolean nullable = child.isNullable();
        PhpType superType = superMethodReturnType.global(project);
        if (superType.equals((Object)PhpType.MIXED)) {
            return child.equals((Object)PhpType.VOID) ? Compatibility.NON_COMPATIBLE : Compatibility.COMPATIBLE;
        }
        if (nullable && !superType.isEmpty() && !superType.isNullable()) {
            return Compatibility.NON_COMPATIBLE;
        }
        if (superType.isEmpty()) {
            return Compatibility.COMPATIBLE;
        }
        if (child.equals((Object)PhpType.NEVER)) {
            return Compatibility.COMPATIBLE;
        }
        PhpType childType = child.global(project);
        if (PhpHierarchyChecksInspection.hasStaticReference(superMethodReturnType)) {
            PhpType superTypeWithoutStatic = superMethodReturnType.filterOut(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0)).global(project);
            return child.getTypes().stream().anyMatch(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0)) || PhpHierarchyChecksInspection.compatibleByCovariance(project, childType, superTypeWithoutStatic).isCompatible() ? Compatibility.COMPATIBLE : Compatibility.NON_COMPATIBLE;
        }
        return PhpHierarchyChecksInspection.compatibleByCovariance(project, childType, superType);
    }

    private static boolean hasStaticReference(PhpType superTypeUnresolved) {
        return superTypeUnresolved.getTypes().stream().anyMatch(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0));
    }

    @NotNull
    private static @NotNull LocalQuickFix @NotNull [] getAccessFixes(PhpModifier currentMethodModifier, PhpModifier.Access superMethodAccess) {
        LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])((StreamEx)StreamEx.of((Object[])PhpModifier.Access.values()).filter(access -> access.getLevel() >= superMethodAccess.getLevel())).map(targetAccess -> new PhpChangeMethodModifiersQuickFix(currentMethodModifier.copy(targetAccess))).toArray((Object[])LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(24);
        }
        return localQuickFixArray;
    }

    @NotNull
    private static @NotNull LocalQuickFix @NotNull [] appendMakeClassAbstractQuickFix(@NotNull @NotNull LocalQuickFix @NotNull [] fixes, @NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(25);
        }
        if (fixes == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(26);
        }
        if (clazz.isFinal()) {
            if (fixes == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(27);
            }
            return fixes;
        }
        LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)((Object)new PhpMakeClassAbstractQuickFix(clazz.getName())));
        if (localQuickFixArray == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(28);
        }
        return localQuickFixArray;
    }

    @Nullable
    @InspectionMessage
    private static String getMessage(@NotNull Field superField) {
        PhpClass containingClass;
        if (superField == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(29);
        }
        if ((containingClass = superField.getContainingClass()) == null) {
            return null;
        }
        String fqn = containingClass.getFQN();
        PhpType superType = superField.getDeclaredType().global(superField.getProject());
        if (superType.isEmpty()) {
            return PhpBundle.message("inspection.hierarchyChecks.field.type.redeclaration.must.not.be.defined", fqn);
        }
        return PhpBundle.message("inspection.hierarchyChecks.field.type.redeclaration.match.super.type", superType, fqn);
    }

    public static boolean isGroupedDeclarations(@Nullable PhpClassFieldsList fieldsList) {
        return fieldsList != null && fieldsList.getFields().size() > 1;
    }

    @NotNull
    public static String buildSuperName(@NotNull Method superMethod, @NotNull PhpClass superContainingClass) {
        if (superMethod == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(30);
        }
        if (superContainingClass == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(31);
        }
        String string = PhpPresentationUtil.formatParameters(new StringBuilder().append(superContainingClass.getName()).append(superMethod.isStatic() ? "::" : "->").append(superMethod.getName()), superMethod.getParameters()).toString();
        if (string == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public static @NotNull Pair<@NotNull Compatibility, @Nullable Parameter> checkDeclarationsCompatibility(Method superMethod, Method method) {
        Parameter lastParameter;
        Parameter parameter;
        int i;
        boolean checkIfLessParameters;
        if (superMethod.isReturningByReference() && !method.isReturningByReference()) {
            Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE.withFixes(LocalQuickFix.from((ModCommandAction)new PhpAddReturnByReferenceQuickFix((Function)method))), null);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(33);
            }
            return pair;
        }
        if ((superMethod.getParameters().length == 0 || method.getParameters().length == 0) && method instanceof PhpPropertyHook) {
            Pair pair = Pair.create((Object)Compatibility.COMPATIBLE, null);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(34);
            }
            return pair;
        }
        Parameter[] parameters = method.getParameters();
        Parameter[] superParameters = superMethod.getParameters();
        PhpLanguageLevel level = PhpProjectConfigurationFacade.getInstance(method.getProject()).getLanguageLevel();
        int paramsLen = parameters.length;
        int superParamsLen = superParameters.length;
        boolean lastSuperVariadic = superParamsLen > 0 && superParameters[superParamsLen - 1].isVariadic();
        boolean lastVariadic = paramsLen > 0 && parameters[paramsLen - 1].isVariadic();
        boolean bl = checkIfLessParameters = level.isLessThan(PhpLanguageLevel.PHP800) || !lastVariadic && !lastSuperVariadic;
        if (paramsLen == 0 && superParamsLen != 0 || paramsLen < superParamsLen && checkIfLessParameters) {
            if (level.isAtLeast(PhpLanguageLevel.PHP800) && (lastVariadic || lastSuperVariadic)) {
                Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, null);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(35);
                }
                return pair;
            }
            LazyInitializer.LazyValue<PhpAddMissingParamsQuickFix.MissingParameters> params = PhpAddMissingParamsQuickFix.calculateMissingParameters((Function)method, (Function)superMethod);
            Pair pair = params == null ? Pair.create((Object)Compatibility.NON_COMPATIBLE, null) : Pair.create((Object)Compatibility.NON_COMPATIBLE.withFixes(new LocalQuickFix[]{new PhpAddMissingParamsQuickFix(params)}), null);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(36);
            }
            return pair;
        }
        int minParamsLen = Math.min(superParamsLen, paramsLen);
        for (i = 0; i < minParamsLen; ++i) {
            Parameter superParameter = superParameters[i];
            parameter = parameters[i];
            if (parameter.getName().isEmpty() || superParameter.getName().isEmpty()) {
                Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, null);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(37);
                }
                return pair;
            }
            if (parameter.isPassByRef() != superParameter.isPassByRef()) {
                Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, (Object)parameter);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(38);
                }
                return pair;
            }
            if (superParameter.isOptional() && !parameter.isOptional()) {
                Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, (Object)parameter);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(39);
                }
                return pair;
            }
            Compatibility compatibilityByType = PhpHierarchyChecksInspection.compatibleByType(parameter, superParameter);
            if (compatibilityByType.isCompatible()) continue;
            Pair pair = Pair.create((Object)compatibilityByType, (Object)parameter);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(40);
            }
            return pair;
        }
        if (lastSuperVariadic && !(lastParameter = parameters[paramsLen - 1]).isVariadic()) {
            Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, (Object)(!lastParameter.getName().isEmpty() ? lastParameter : null));
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(41);
            }
            return pair;
        }
        int maxParamsLen = Math.max(superParamsLen, paramsLen);
        for (i = minParamsLen; i < maxParamsLen; ++i) {
            Compatibility compatibleByType;
            if (i < paramsLen) {
                parameter = parameters[i];
                if (parameter.getName().isEmpty()) {
                    Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, null);
                    if (pair == null) {
                        PhpHierarchyChecksInspection.$$$reportNull$$$0(42);
                    }
                    return pair;
                }
                if (lastSuperVariadic && !(compatibleByType = PhpHierarchyChecksInspection.compatibleByType(parameter, superParameters[superParamsLen - 1])).isCompatible()) {
                    Pair pair = Pair.create((Object)compatibleByType, (Object)parameter);
                    if (pair == null) {
                        PhpHierarchyChecksInspection.$$$reportNull$$$0(43);
                    }
                    return pair;
                }
                if (parameter.isOptional() || parameter.isVariadic()) continue;
                Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, (Object)parameter);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(44);
                }
                return pair;
            }
            Parameter lastParameter2 = parameters[paramsLen - 1];
            if (!lastParameter2.isVariadic()) {
                Pair pair = Pair.create((Object)Compatibility.NON_COMPATIBLE, null);
                if (pair == null) {
                    PhpHierarchyChecksInspection.$$$reportNull$$$0(45);
                }
                return pair;
            }
            compatibleByType = PhpHierarchyChecksInspection.compatibleByType(lastParameter2, superParameters[i]);
            if (compatibleByType.isCompatible()) continue;
            Pair pair = Pair.create((Object)compatibleByType, (Object)lastParameter2);
            if (pair == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(46);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)Compatibility.COMPATIBLE, null);
        if (pair == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(47);
        }
        return pair;
    }

    private static Compatibility compatibleByType(@NotNull Parameter parameter, @NotNull Parameter superParameter) {
        if (parameter == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(48);
        }
        if (superParameter == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(49);
        }
        PhpType superType = PhpHierarchyChecksInspection.getParameterType(superParameter);
        PhpType type = PhpHierarchyChecksInspection.getParameterType(parameter);
        if (PhpType.intersects((PhpType)PhpType.MIXED, (PhpType)type)) {
            return Compatibility.COMPATIBLE;
        }
        PhpType typeDefaultNullAware = (!PhpType.intersects((PhpType)PhpType.NULL, (PhpType)superType) || parameter.getDeclaredType().isEmpty() && !superParameter.getDeclaredType().isEmpty() && superType.isNullable() && PhpType.NULL.equals((Object)((ParameterImpl)parameter).getDefaultValueType())) && !PhpType.NULL.equals((Object)parameter.getDeclaredType()) ? type.filterNull() : type;
        boolean variadic = parameter.isVariadic();
        boolean superVariadic = superParameter.isVariadic();
        PhpLanguageLevel level = PhpLanguageLevel.current((Project)parameter.getProject());
        if (variadic == superVariadic || parameter.getDefaultValue() != null || variadic && level.isAtLeast(PhpLanguageLevel.PHP800)) {
            if (typeDefaultNullAware.isEmpty() != superType.isEmpty()) {
                if (typeDefaultNullAware.isEmpty() && !superType.isEmpty()) {
                    return level.isAtLeast(PhpLanguageLevel.PHP720) ? Compatibility.COMPATIBLE : Compatibility.COMPATIBLE_IN_72;
                }
                return Compatibility.NON_COMPATIBLE;
            }
            Map nonCompatible = PhpHierarchyChecksInspection.streamOfTypes(superType).mapToEntry(superT -> PhpHierarchyChecksInspection.parameterTypeSuperCompatible(typeDefaultNullAware, superT, parameter.getProject())).filterValues(Predicate.not(Compatibility::isCompatible)).toMap();
            return PhpHierarchyChecksInspection.createAddNonCompatibleTypes(parameter.getProject(), nonCompatible);
        }
        return Compatibility.NON_COMPATIBLE;
    }

    @NotNull
    private static Compatibility createAddNonCompatibleTypes(Project project, Map<PhpType, Compatibility> nonCompatible) {
        if (nonCompatible.isEmpty()) {
            Compatibility compatibility = Compatibility.COMPATIBLE;
            if (compatibility == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(50);
            }
            return compatibility;
        }
        if (!PhpLanguageFeature.UNION_TYPES.isSupported(project)) {
            Compatibility compatibility = (Compatibility)ContainerUtil.getFirstItem(nonCompatible.values());
            if (compatibility == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(51);
            }
            return compatibility;
        }
        Compatibility compatibility = Compatibility.NON_COMPATIBLE.withFixes(new LocalQuickFix[]{new PhpAppendNonCompatibleClassReferencesToParameterQuickFix(nonCompatible.keySet())});
        if (compatibility == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(52);
        }
        return compatibility;
    }

    @NotNull
    private static PhpType getParameterType(@NotNull Parameter parameter) {
        if (parameter == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(53);
        }
        PhpType type = parameter.getDeclaredType();
        if (PhpLanguageFeature.NULLABLES.isSupported(parameter.getProject()) && PhpType.NULL.equals((Object)((ParameterImpl)parameter).getDefaultValueType())) {
            type = new PhpType().add(type).add(PhpType.NULL);
        }
        if (parameter.isVariadic()) {
            PhpType elementType = type.unpluralize();
            type = PhpType.MIXED.equals((Object)elementType) ? PhpType.EMPTY : elementType;
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(54);
        }
        return phpType;
    }

    private static boolean typeSuperCompatible(PhpType type, PhpType superType, Project project) {
        return type.equals((Object)superType) || PhpHierarchyChecksInspection.unwrapAlias(type, project).equals((Object)PhpHierarchyChecksInspection.unwrapAlias(superType, project));
    }

    private static Compatibility parameterTypeSuperCompatible(PhpType type, PhpType superType, Project project) {
        if (PhpHierarchyChecksInspection.typeSuperCompatible(type, superType, project)) {
            return Compatibility.COMPATIBLE;
        }
        return PhpHierarchyChecksInspection.compatibleByContravariance(project, type, superType);
    }

    private static Compatibility compatibleByContravariance(Project project, PhpType type, PhpType superType) {
        return PhpHierarchyChecksInspection.compatibleByCovariance(project, superType, type);
    }

    public static boolean shouldAddMethodStub(@NotNull Method abstractMethod, @NotNull PhpClass klass) {
        if (abstractMethod == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(55);
        }
        if (klass == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(56);
        }
        return abstractMethod.getContainingClass() != klass && !(abstractMethod instanceof PhpPropertyHook);
    }

    public static boolean hasTentativeReturnTypeAttribute(@NotNull Method method) {
        if (method == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(57);
        }
        return !method.getAttributes(TENTATIVE_TYPE_ATTRIBUTE_FQN).isEmpty();
    }

    private static Compatibility compatibleByCovariance(Project project, PhpType type, PhpType superType) {
        if (type.isEmpty() && !superType.isEmpty()) {
            return Compatibility.NON_COMPATIBLE;
        }
        if (PhpHierarchyChecksInspection.streamOfTypes(superType).anyMatch(superT -> PhpHierarchyChecksInspection.typeSuperCompatible(type, superT, project))) {
            return Compatibility.COMPATIBLE;
        }
        if (type.isComplete() && superType.isComplete()) {
            if (!superType.isNullable() && !superType.equals((Object)PhpType.MIXED) && type.isNullable()) {
                return Compatibility.NON_COMPATIBLE;
            }
            if (PhpHierarchyChecksInspection.compatibleByIterable(type, superType)) {
                return PhpLanguageFeature.ITERABLE_TYPE_HINT.isSupported(project) ? Compatibility.COMPATIBLE : Compatibility.COMPATIBLE_IN_72;
            }
            if (PhpHierarchyChecksInspection.isCompatibleByCovariance(project, superType, type)) {
                return PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP740) ? Compatibility.COMPATIBLE : Compatibility.COMPATIBLE_IN_74;
            }
        }
        return Compatibility.NON_COMPATIBLE;
    }

    private static boolean isCompatibleByCovariance(@NotNull Project project, @NotNull PhpType superType, @NotNull PhpType type) {
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(58);
        }
        if (superType == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(59);
        }
        if (type == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(60);
        }
        PhpIndex index = PhpIndex.getInstance((Project)project);
        for (String t : type.getTypes()) {
            for (String superT : superType.getTypes()) {
                if (!(superT.equalsIgnoreCase(t) || superT.equalsIgnoreCase("\\bool") && t.equalsIgnoreCase("\\false") || superT.equalsIgnoreCase("\\bool") && t.equalsIgnoreCase("\\true") || "\\object".equalsIgnoreCase(superT) && !PhpType.isPrimitiveType((String)t)) && !PhpType.findSuper((String)superT, (String)t, (PhpIndex)index)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean compatibleByIterable(@NotNull PhpType type, @NotNull PhpType superType) {
        if (type == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(61);
        }
        if (superType == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(62);
        }
        if ((PhpType.intersects((PhpType)type, (PhpType)PhpType.ARRAY) || PhpType.intersects((PhpType)type, (PhpType)PhpType.TRAVERSABLE)) && PhpType.intersects((PhpType)superType, (PhpType)PhpType.ITERABLE)) {
            return true;
        }
        return PhpType.intersects((PhpType)superType, (PhpType)PhpType.ARRAY) && PhpType.intersects((PhpType)superType, (PhpType)PhpType.TRAVERSABLE) && PhpType.intersects((PhpType)type, (PhpType)PhpType.ITERABLE);
    }

    public static PhpType unwrapAlias(@NotNull PhpType type, @NotNull Project project) {
        if (type == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(63);
        }
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(64);
        }
        return type.map(fqn -> PhpHierarchyChecksInspection.unwrapAlias(project, fqn));
    }

    @NotNull
    private static String unwrapAlias(@NotNull Project project, @NotNull String fqn) {
        PhpClass original;
        PhpClass phpClass;
        if (project == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(65);
        }
        if (fqn == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(66);
        }
        if (!PhpType.isPrimitiveType((String)fqn) && !PhpType.isPluralType((String)fqn) && !PhpType.isAnonymousClass((String)fqn) && (phpClass = (PhpClass)ContainerUtil.getOnlyItem((Collection)PhpIndex.getInstance((Project)project).getAnyByFQN(fqn))) instanceof PhpClassAlias && (original = ((PhpClassAlias)phpClass).getOriginal()) != null) {
            String string = original.getFQN();
            if (string == null) {
                PhpHierarchyChecksInspection.$$$reportNull$$$0(67);
            }
            return string;
        }
        String string = fqn;
        if (string == null) {
            PhpHierarchyChecksInspection.$$$reportNull$$$0(68);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 8, 9, 14, 15, 24, 27, 28, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 50, 51, 52, 54, 67, 68 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 24: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProblem";
                break;
            }
            case 10: 
            case 18: 
            case 20: 
            case 22: 
            case 58: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 13: 
            case 60: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childMethod";
                break;
            }
            case 17: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superField";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superContainingClass";
                break;
            }
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superParameter";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abstractMethod";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignatureDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonImplementedAbstractMethods";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseProblemWithApplicableStrictness";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "streamOfTypes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessFixes";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "appendMakeClassAbstractQuickFix";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSuperName";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDeclarationsCompatibility";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddNonCompatibleTypes";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapAlias";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignatureDescriptor";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 24: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 67: 
            case 68: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chooseProblemWithApplicableStrictness";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compatibleByInvariance";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "streamOfTypes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "areDeclarationsFullyCompatible";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "compatibleByReturnType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibility";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "appendMakeClassAbstractQuickFix";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "buildSuperName";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "compatibleByType";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddMethodStub";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "hasTentativeReturnTypeAttribute";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleByCovariance";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "compatibleByIterable";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "unwrapAlias";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 8, 9, 14, 15, 24, 27, 28, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 50, 51, 52, 54, 67, 68 -> new IllegalStateException(string);
        };
    }

    public static abstract class MethodCheck {
        public static final MethodCheck STATIC = new MethodCheck(){

            @Override
            @NotNull
            public MethodProblem findProblem(PhpClass clazz, PhpClass subClass, PhpClass baseClass, Method superMethod, Method method, String superName, @NotNull PsiElement node, boolean isOnTheFly) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (superMethod.isStatic() != method.isStatic()) {
                    ProblemDescriptor problemDescriptor;
                    String methodName;
                    String string = methodName = isOnTheFly ? superName : "";
                    if (superMethod.isStatic()) {
                        LocalQuickFix[] localQuickFixArray;
                        String string2 = PhpBundle.message("inspection.message.cannot.make.static.method.non.static", methodName);
                        if (PhpMethodMayBeStaticInspection.methodMayBeStatic(method)) {
                            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                            localQuickFixArray = localQuickFixArray2;
                            localQuickFixArray2[0] = PhpMethodMayBeStaticInspection.MAKE_METHOD_STATIC_FIX;
                        } else {
                            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                        }
                        problemDescriptor = PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method, node, string2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, localQuickFixArray);
                    } else {
                        problemDescriptor = PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method, node, PhpBundle.message("inspection.message.cannot.make.non.static.method.static", methodName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, PhpMakeMethodNonStaticQuickFix.INSTANCE);
                    }
                    ProblemDescriptor descriptor = problemDescriptor;
                    return new MethodProblem(superMethod.getContainingClass(), node, holder -> holder.registerProblem(descriptor));
                }
                MethodProblem methodProblem = MethodProblem.empty(superMethod.getContainingClass());
                if (methodProblem == null) {
                    1.$$$reportNull$$$0(1);
                }
                return methodProblem;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$MethodCheck$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$MethodCheck$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findProblem";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "findProblem";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        public static final MethodCheck ABSTRACT = new MethodCheck(){

            @Override
            @NotNull
            public MethodProblem findProblem(PhpClass clazz, PhpClass subClass, PhpClass baseClass, Method superMethod, Method method, String superName, @NotNull PsiElement node, boolean isOnTheFly) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (baseClass == null) {
                    MethodProblem methodProblem = MethodProblem.empty(superMethod.getContainingClass());
                    if (methodProblem == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return methodProblem;
                }
                if (!baseClass.isInterface() && !baseClass.isTrait() && !superMethod.isAbstract() && method.isAbstract()) {
                    String descriptionTemplate = isOnTheFly ? PhpBundle.message("inspection.message.cannot.make.non.abstract.method.abstract.1", superName) : PhpBundle.message("inspection.message.cannot.make.non.abstract.method.abstract", new Object[0]);
                    return new MethodProblem(superMethod.getContainingClass(), node, holder -> holder.registerProblem(PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method, node, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, PhpMakeMethodNonAbstractQuickFix.INSTANCE)));
                }
                MethodProblem methodProblem = MethodProblem.empty(superMethod.getContainingClass());
                if (methodProblem == null) {
                    2.$$$reportNull$$$0(2);
                }
                return methodProblem;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$MethodCheck$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$MethodCheck$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findProblem";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "findProblem";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
        public static final MethodCheck FINAL = new MethodCheck(){

            @Override
            @NotNull
            public MethodProblem findProblem(PhpClass clazz, PhpClass subClass, PhpClass baseClass, Method superMethod, Method method, String superName, @NotNull PsiElement node, boolean isOnTheFly) {
                if (node == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (superMethod.isFinal()) {
                    String descriptionTemplate = isOnTheFly ? PhpBundle.message("inspection.message.cannot.override.final.method.1", superName) : PhpBundle.message("inspection.message.cannot.override.final.method", new Object[0]);
                    return new MethodProblem(superMethod.getContainingClass(), node, holder -> holder.registerProblem(PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method, node, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, LocalQuickFix.from((ModCommandAction)new PhpMakeMethodNonFinalQuickFix(superMethod)))));
                }
                MethodProblem methodProblem = MethodProblem.empty(superMethod.getContainingClass());
                if (methodProblem == null) {
                    3.$$$reportNull$$$0(1);
                }
                return methodProblem;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$MethodCheck$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$MethodCheck$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findProblem";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "findProblem";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        public static final MethodCheck VISIBILITY = new MethodCheck(){

            @Override
            @NotNull
            public MethodProblem findProblem(PhpClass clazz, PhpClass subClass, PhpClass baseClass, Method superMethod, Method method, String superName, @NotNull PsiElement node, boolean isOnTheFly) {
                PhpClass superContainingClass;
                if (node == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!((superContainingClass = superMethod.getContainingClass()) == null || superContainingClass.isTrait() || superMethod.getAccess().getLevel() <= method.getAccess().getLevel() || ("__construct".equals(superMethod.getName()) || "__destruct".equals(superMethod.getName())) && (PhpLangUtil.isObject(superContainingClass) || "__construct".equals(superMethod.getName()) && !PhpProjectConfigurationFacade.getInstance(superMethod.getProject()).getLanguageLevel().isLessThan(PhpLanguageLevel.PHP720)))) {
                    String descriptionTemplate = isOnTheFly ? PhpBundle.message("inspection.message.cannot.make.method", superMethod.getAccess(), superName, method.getAccess()) : PhpBundle.message("inspection.message.cannot.make.method.visibility.lower.than.super.s", new Object[0]);
                    Consumer<ProblemsHolder> registar = holder -> holder.registerProblem(PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method, node, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, PhpHierarchyChecksInspection.getAccessFixes(method.getModifier(), superMethod.getAccess())));
                    return new MethodProblem(superContainingClass, node, registar);
                }
                MethodProblem methodProblem = MethodProblem.empty(superContainingClass);
                if (methodProblem == null) {
                    4.$$$reportNull$$$0(1);
                }
                return methodProblem;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$MethodCheck$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$MethodCheck$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findProblem";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "findProblem";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        public static final MethodCheck DECLARATION = new MethodCheck(){

            @Override
            @NotNull
            public MethodProblem findProblem(PhpClass clazz, PhpClass subClass, PhpClass baseClass, Method superMethod, Method method, String superName, @NotNull PsiElement node, boolean isOnTheFly) {
                if (node == null) {
                    5.$$$reportNull$$$0(0);
                }
                PhpClass superContainingClass = superMethod.getContainingClass();
                if ((PhpLanguageLevel.current((Project)superMethod.getProject()).isAtLeast(PhpLanguageLevel.PHP800) || superMethod.isAbstract()) && (!"__construct".equalsIgnoreCase(method.getName()) || PhpHierarchyChecksInspection.shouldCheckConstructor(clazz, subClass, baseClass, superMethod))) {
                    Pair<Compatibility, Parameter> result = PhpHierarchyChecksInspection.checkDeclarationsCompatibility(superMethod, method);
                    if (!((Compatibility)result.first).isCompatible()) {
                        String descriptionTemplate = isOnTheFly ? PhpBundle.message("declaration.must.be.compatible.with.0", superName) : PhpBundle.message("declaration.must.be.compatible.with.super", new Object[0]);
                        ProblemDescriptor descriptor = result.second != null ? InspectionManager.getInstance((Project)((Parameter)result.second).getProject()).createProblemDescriptor((PsiElement)result.second, descriptionTemplate, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING) : PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method, node, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]);
                        return new MethodProblem(superContainingClass, descriptor.getPsiElement(), holder -> ((Compatibility)result.first).registerProblem((ProblemsHolder)holder, descriptor));
                    }
                }
                MethodProblem methodProblem = MethodProblem.empty(superContainingClass);
                if (methodProblem == null) {
                    5.$$$reportNull$$$0(1);
                }
                return methodProblem;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$MethodCheck$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$MethodCheck$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findProblem";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "findProblem";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        public static final MethodCheck RETURN = new MethodCheck(){

            @Override
            @NotNull
            public MethodProblem findProblem(PhpClass clazz, PhpClass subClass, PhpClass baseClass, Method superMethod, Method method, String superName, @NotNull PsiElement node, boolean isOnTheFly) {
                boolean suppressTentativeType;
                if (node == null) {
                    6.$$$reportNull$$$0(0);
                }
                Compatibility compatibility = PhpHierarchyChecksInspection.compatibleByReturnType(method.getProject(), method, superMethod.getDeclaredType());
                boolean isTentativeType = PhpHierarchyChecksInspection.hasTentativeReturnTypeAttribute(superMethod);
                boolean bl = suppressTentativeType = isTentativeType && (!method.getAttributes(PhpHierarchyChecksInspection.RETURN_TYPE_WILL_CHANGE_ATTRIBUTE_FQN).isEmpty() || PhpLanguageLevel.current((Project)method.getProject()).isLessThan(PhpLanguageLevel.PHP810));
                if (!compatibility.isCompatible() && !suppressTentativeType) {
                    LocalQuickFix[] localQuickFixArray;
                    ProblemHighlightType highlightType;
                    PhpTypeDeclaration returnType = method.getTypeDeclaration();
                    String descriptionTemplate = isOnTheFly ? PhpBundle.message("inspection.message.return.type.declaration.must.be.compatible.with", superName, superMethod.getDeclaredType().global(method.getProject()).toString()) : PhpBundle.message("return.type.declaration.must.be.compatible.with.super", new Object[0]);
                    ProblemHighlightType problemHighlightType = highlightType = isTentativeType ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    if (isTentativeType) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = SUPPRESS_TENTATIVE_TYPE_WARNING;
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    ProblemDescriptor descriptor = returnType != null ? InspectionManager.getInstance((Project)returnType.getProject()).createProblemDescriptor((PsiElement)returnType, descriptionTemplate, isOnTheFly, fixes, highlightType) : PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method, node, descriptionTemplate, highlightType, isOnTheFly, fixes);
                    return new MethodProblem(superMethod.getContainingClass(), descriptor.getPsiElement(), holder -> compatibility.registerProblem((ProblemsHolder)holder, descriptor));
                }
                MethodProblem methodProblem = MethodProblem.empty(superMethod.getContainingClass());
                if (methodProblem == null) {
                    6.$$$reportNull$$$0(1);
                }
                return methodProblem;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$MethodCheck$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$MethodCheck$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findProblem";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "findProblem";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };

        @NotNull
        public abstract MethodProblem findProblem(PhpClass var1, PhpClass var2, PhpClass var3, Method var4, Method var5, String var6, @NotNull PsiElement var7, boolean var8);
    }

    public static class MethodProblem {
        @Nullable
        private final PhpClass myClass;
        @Nullable
        private final PsiElement myElementToHighlight;
        @Nullable
        public final Consumer<ProblemsHolder> myProblemRegistar;

        public MethodProblem(@Nullable PhpClass aClass, @Nullable PsiElement highlight, @Nullable Consumer<ProblemsHolder> registar) {
            this.myClass = aClass;
            this.myElementToHighlight = highlight;
            this.myProblemRegistar = registar;
        }

        public static MethodProblem empty(PhpClass classFQN) {
            return new MethodProblem(classFQN, null, null);
        }
    }

    public static class Compatibility {
        private static final Compatibility COMPATIBLE = new Compatibility(true, null, new LocalQuickFix[0]);
        private static final Compatibility NON_COMPATIBLE = new Compatibility(false, null, new LocalQuickFix[0]);
        private static final Compatibility COMPATIBLE_IN_72 = new Compatibility(false, PhpLanguageLevel.PHP720, PhpSwitchLanguageLevelQuickFix.getInstance(PhpLanguageLevel.PHP720));
        private static final Compatibility COMPATIBLE_IN_74 = new Compatibility(false, PhpLanguageLevel.PHP740, PhpSwitchLanguageLevelQuickFix.getInstance(PhpLanguageLevel.PHP740));
        protected final LocalQuickFix[] myFixes;
        private final boolean myCompatible;
        @Nullable
        private final PhpLanguageLevel myCompatibleLanguageLevel;

        private Compatibility(boolean compatible, @Nullable PhpLanguageLevel languageLevel, LocalQuickFix ... fixes) {
            if (fixes == null) {
                Compatibility.$$$reportNull$$$0(0);
            }
            this.myCompatible = compatible;
            this.myCompatibleLanguageLevel = languageLevel;
            this.myFixes = fixes;
        }

        public Compatibility withFixes(LocalQuickFix ... fixes) {
            if (fixes == null) {
                Compatibility.$$$reportNull$$$0(1);
            }
            return new Compatibility(this.myCompatible, this.myCompatibleLanguageLevel, (LocalQuickFix[])ArrayUtil.mergeArrays((Object[])this.myFixes, (Object[])fixes));
        }

        public boolean isCompatible() {
            return this.myCompatible;
        }

        public void registerProblem(ProblemsHolder holder, ProblemDescriptor descriptor) {
            LocalQuickFix[] fixes = (LocalQuickFix[])ArrayUtil.mergeArrays((Object[])((LocalQuickFix[])descriptor.getFixes()), (Object[])this.myFixes);
            if (this.myCompatibleLanguageLevel != null) {
                holder.registerProblem(descriptor.getPsiElement(), descriptor.getTextRangeInElement(), PhpBundle.message("inspection.message.from.php.this.allowed", descriptor.getDescriptionTemplate(), this.myCompatibleLanguageLevel.getPresentableName()), fixes);
            } else {
                holder.registerProblem(descriptor.getPsiElement(), descriptor.getDescriptionTemplate(), descriptor.getHighlightType(), descriptor.getTextRangeInElement(), fixes);
            }
        }

        private static Compatibility createUnionTypeCompatibility(final Map<PhpType, Compatibility> nonCompatibleReferences, final @NotNull PhpTypeDeclaration typeDeclaration, final @NotNull PhpChangeReturnTypeQuickFix changeReturnTypeFix) {
            if (typeDeclaration == null) {
                Compatibility.$$$reportNull$$$0(2);
            }
            if (changeReturnTypeFix == null) {
                Compatibility.$$$reportNull$$$0(3);
            }
            return new Compatibility(false, null, new LocalQuickFix[0]){

                @Override
                public void registerProblem(ProblemsHolder holder, ProblemDescriptor descriptor) {
                    InspectionManager manager = InspectionManager.getInstance((Project)holder.getProject());
                    for (Map.Entry e : nonCompatibleReferences.entrySet()) {
                        PsiElement element = Compatibility.findElementToHighlight(typeDeclaration, (PhpType)e.getKey());
                        if (element == null) continue;
                        Object[] fixes = (LocalQuickFix[])ArrayUtil.append((Object[])((LocalQuickFix[])descriptor.getFixes()), (Object)LocalQuickFix.from((ModCommandAction)new PhpRemoveClassReferenceFromTypeDeclaration(element)));
                        if (PhpLanguageFeature.UNION_TYPES.isSupported(holder.getProject())) {
                            fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)((Object)changeReturnTypeFix));
                        }
                        ((Compatibility)e.getValue()).registerProblem(holder, manager.createProblemDescriptor(element, descriptor.getDescriptionTemplate(), holder.isOnTheFly(), (LocalQuickFix[])fixes, descriptor.getHighlightType()));
                    }
                }
            };
        }

        private static PsiElement findElementToHighlight(@NotNull PhpTypeDeclaration typeDeclaration, PhpType type) {
            if (typeDeclaration == null) {
                Compatibility.$$$reportNull$$$0(4);
            }
            if (type.hasIntersectionType()) {
                return (PsiElement)ContainerUtil.find(PhpTypeDeclarationImpl.getClassReferenceGroups(typeDeclaration), e -> PhpTypeDeclarationImpl.getTypeDeclarationPartType(e).equals((Object)type));
            }
            return (PsiElement)ContainerUtil.find((Iterable)typeDeclaration.getClassReferences(), ref -> ref.resolveLocalType().equals((Object)type));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeDeclaration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeReturnTypeFix";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$Compatibility";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withFixes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createUnionTypeCompatibility";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findElementToHighlight";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpAddReturnByReferenceQuickFix
    extends PsiUpdateModCommandAction<Function> {
        public PhpAddReturnByReferenceQuickFix(@NotNull Function function) {
            if (function == null) {
                PhpAddReturnByReferenceQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)function);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.make.function.return.by.reference", new Object[0]);
            if (string == null) {
                PhpAddReturnByReferenceQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull Function function, @NotNull ModPsiUpdater updater) {
            PsiElement identifier;
            if (context == null) {
                PhpAddReturnByReferenceQuickFix.$$$reportNull$$$0(2);
            }
            if (function == null) {
                PhpAddReturnByReferenceQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpAddReturnByReferenceQuickFix.$$$reportNull$$$0(4);
            }
            if ((identifier = function.getNameIdentifier()) == null) {
                return;
            }
            function.addBefore(PhpPsiElementFactory.createBitAnd(context.project()), identifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpAddReturnByReferenceQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpAddReturnByReferenceQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpAddMissingParamsQuickFix
    extends PsiUpdateModCommandQuickFix {
        @FileModifier.SafeFieldForPreview
        private final LazyInitializer.LazyValue<MissingParameters> myMissingParameters;

        protected PhpAddMissingParamsQuickFix(LazyInitializer.LazyValue<MissingParameters> missingParameters) {
            this.myMissingParameters = missingParameters;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.missing.parameters", new Object[0]);
            if (string == null) {
                PhpAddMissingParamsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Function function;
            if (project == null) {
                PhpAddMissingParamsQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddMissingParamsQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddMissingParamsQuickFix.$$$reportNull$$$0(3);
            }
            if ((function = (Function)ObjectUtils.tryCast((Object)element, Function.class)) == null) {
                return;
            }
            Parameter[] existingParams = function.getParameters();
            MissingParameters missingParameters = (MissingParameters)this.myMissingParameters.get();
            ArrayList<PhpParameterInfo> newParameters = new ArrayList<PhpParameterInfo>(missingParameters.atBeginning);
            Arrays.stream(existingParams).map(param -> new PhpParameterInfo(-1, (Parameter)param)).forEach(newParameters::add);
            newParameters.addAll(missingParameters.atEnd);
            PhpMethodDescriptor methodDescriptor = new PhpMethodDescriptor(function);
            PhpChangeInfo info = new PhpChangeInfo(methodDescriptor, newParameters.toArray(new PhpParameterInfo[0]), methodDescriptor.getVisibility(), methodDescriptor.getName(), methodDescriptor.getReturnTypeText(), null, false, true);
            PhpChangeSignatureUsageProcessor.processFunctionDeclaration(info, function);
        }

        @Nullable
        private static LazyInitializer.LazyValue<MissingParameters> calculateMissingParameters(@NotNull Function method, @NotNull Function superMethod) {
            if (method == null) {
                PhpAddMissingParamsQuickFix.$$$reportNull$$$0(4);
            }
            if (superMethod == null) {
                PhpAddMissingParamsQuickFix.$$$reportNull$$$0(5);
            }
            Parameter[] parameters = method.getParameters();
            Object[] superParameters = superMethod.getParameters();
            int paramsLen = parameters.length;
            int superParamsLen = superParameters.length;
            List superParameterPointers = ContainerUtil.map((Object[])superParameters, p -> SmartPointerManager.getInstance((Project)method.getProject()).createSmartPsiElementPointer((PsiElement)p));
            if (paramsLen == 0) {
                return LazyInitializer.create(() -> new MissingParameters(Collections.emptyList(), PhpAddMissingParamsQuickFix.takeSuperParameters(superParameterPointers, paramsLen, superParamsLen)));
            }
            Parameter firstParameter = parameters[0];
            Parameter lastParameter = parameters[paramsLen - 1];
            if (lastParameter.isVariadic()) {
                return null;
            }
            int indexOfFirstParameter = (int)StreamEx.of((Object[])superParameters).indexOf(p -> p.getName().equals(firstParameter.getName())).orElse(-1L);
            if (indexOfFirstParameter == -1) {
                return null;
            }
            int indexOfLastParameter = (int)StreamEx.of((Object[])superParameters).indexOf(p -> p.getName().equals(lastParameter.getName())).orElse(-1L);
            if (indexOfLastParameter == -1) {
                return null;
            }
            int indexLen = indexOfLastParameter - indexOfFirstParameter + 1;
            if (indexLen != paramsLen) {
                return null;
            }
            if (indexOfFirstParameter == superParamsLen - 1) {
                return LazyInitializer.create(() -> new MissingParameters(PhpAddMissingParamsQuickFix.takeSuperParameters(superParameterPointers, 0, superParamsLen - 1), Collections.emptyList()));
            }
            if (indexOfFirstParameter == 0) {
                return LazyInitializer.create(() -> new MissingParameters(Collections.emptyList(), PhpAddMissingParamsQuickFix.takeSuperParameters(superParameterPointers, paramsLen, superParamsLen)));
            }
            return LazyInitializer.create(() -> new MissingParameters(PhpAddMissingParamsQuickFix.takeSuperParameters(superParameterPointers, 0, indexOfFirstParameter), PhpAddMissingParamsQuickFix.takeSuperParameters(superParameterPointers, indexOfLastParameter + 1, superParamsLen)));
        }

        @NotNull
        private static List<PhpParameterInfo> takeSuperParameters(List<SmartPsiElementPointer<Parameter>> superParameters, int startInclusive, int endExclusive) {
            List<PhpParameterInfo> list = IntStream.range(startInclusive, endExclusive).mapToObj(i -> (Parameter)((SmartPsiElementPointer)superParameters.get(i)).getElement()).filter(Objects::nonNull).map(element -> new PhpParameterInfo(-1, (Parameter)element)).toList();
            if (list == null) {
                PhpAddMissingParamsQuickFix.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpAddMissingParamsQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpAddMissingParamsQuickFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "takeSuperParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "calculateMissingParameters";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }

        record MissingParameters(@NotNull List<PhpParameterInfo> atBeginning, @NotNull List<PhpParameterInfo> atEnd) {
            @NotNull
            private final List<PhpParameterInfo> atBeginning;
            @NotNull
            private final List<PhpParameterInfo> atEnd;

            MissingParameters(@NotNull List<PhpParameterInfo> atBeginning, @NotNull List<PhpParameterInfo> atEnd) {
                if (atBeginning == null) {
                    MissingParameters.$$$reportNull$$$0(0);
                }
                if (atEnd == null) {
                    MissingParameters.$$$reportNull$$$0(1);
                }
            }

            @NotNull
            public List<PhpParameterInfo> atBeginning() {
                List<PhpParameterInfo> list = this.atBeginning;
                if (list == null) {
                    MissingParameters.$$$reportNull$$$0(2);
                }
                return list;
            }

            @NotNull
            public List<PhpParameterInfo> atEnd() {
                List<PhpParameterInfo> list = this.atEnd;
                if (list == null) {
                    MissingParameters.$$$reportNull$$$0(3);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "atBeginning";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "atEnd";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpAddMissingParamsQuickFix$MissingParameters";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpAddMissingParamsQuickFix$MissingParameters";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "atBeginning";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "atEnd";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        }
    }

    public static final class PhpAppendNonCompatibleClassReferencesToParameterQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final PhpType myNonCompatibleType;
        private final String myNonCompatibleTypePresentation;

        private PhpAppendNonCompatibleClassReferencesToParameterQuickFix(Set<PhpType> nonCompatibleTypes) {
            this.myNonCompatibleType = nonCompatibleTypes.stream().reduce(new PhpType(), (type, type2) -> type.add(type2));
            this.myNonCompatibleTypePresentation = StreamEx.of((Collection)this.myNonCompatibleType.getTypes()).map(PhpLangUtil::toShortName).joining((CharSequence)"|");
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            if (this.myNonCompatibleType.equals((Object)PhpType.MIXED)) {
                String string = PhpBundle.message("intention.family.name.change.to.mixed", new Object[0]);
                if (string == null) {
                    PhpAppendNonCompatibleClassReferencesToParameterQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = PhpBundle.message("intention.family.name.append", this.myNonCompatibleTypePresentation);
            if (string == null) {
                PhpAppendNonCompatibleClassReferencesToParameterQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public static void appendNonCompatibleClassReferencesToParameter(PsiElement element, PhpType nonCompatibleTypes) {
            Parameter parameter = PhpPsiUtil.getParentOfClass(element, false, Parameter.class);
            PhpTypeDeclarationImpl typeDeclaration = (PhpTypeDeclarationImpl)((Object)PhpPsiUtil.getChildByCondition((PsiElement)parameter, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance)));
            assert (typeDeclaration != null);
            if (nonCompatibleTypes.equals((Object)PhpType.MIXED)) {
                typeDeclaration.update(PhpType.MIXED);
                return;
            }
            for (String type : nonCompatibleTypes.getTypes()) {
                typeDeclaration.addTypeReference(type);
            }
            if (typeDeclaration.isNullable() && typeDeclaration.findNullReference() == null) {
                PhpAnnotatorVisitor.PhpReplaceNullableNotationWithNullAsPartOfUnionType.replaceNullableNotationWithNullReference(typeDeclaration, typeDeclaration.getFirstChild());
            }
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpAppendNonCompatibleClassReferencesToParameterQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpAppendNonCompatibleClassReferencesToParameterQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpAppendNonCompatibleClassReferencesToParameterQuickFix.$$$reportNull$$$0(4);
            }
            PhpAppendNonCompatibleClassReferencesToParameterQuickFix.appendNonCompatibleClassReferencesToParameter(element, this.myNonCompatibleType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpAppendNonCompatibleClassReferencesToParameterQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpAppendNonCompatibleClassReferencesToParameterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class PhpAddReadonlyModifierQuickFix
    extends PsiUpdateModCommandQuickFix {
        public static final PhpAddReadonlyModifierQuickFix INSTANCE = new PhpAddReadonlyModifierQuickFix();

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.readonly.modifier", new Object[0]);
            if (string == null) {
                PhpAddReadonlyModifierQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpAddReadonlyModifierQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddReadonlyModifierQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddReadonlyModifierQuickFix.$$$reportNull$$$0(3);
            }
            Field field = (Field)ObjectUtils.tryCast((Object)element.getParent(), Field.class);
            assert (field != null);
            PhpClassFieldsList fieldsList = field.getParentList();
            if (PhpHierarchyChecksInspection.isGroupedDeclarations(fieldsList)) {
                PhpClassFieldsList copyFieldsList = FieldImpl.copyListWithSingleField(field, fieldsList);
                PhpAddReadonlyModifierQuickFix.insertReadonlyModifier(project, copyFieldsList);
                fieldsList.getParent().addAfter((PsiElement)copyFieldsList, (PsiElement)fieldsList);
                PhpMoveClassMemberBase.removeFieldWithPhpDoc(field);
            } else if (field instanceof PhpPromotedFieldParameterImpl) {
                PhpTypeDeclaration declaration = field.getTypeDeclaration();
                field.addBefore(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, "readonly"), (PsiElement)(declaration == null ? field.getNameIdentifier() : declaration));
            } else {
                assert (fieldsList != null);
                PhpAddReadonlyModifierQuickFix.insertReadonlyModifier(project, fieldsList);
            }
        }

        private static void insertReadonlyModifier(@NotNull Project project, @NotNull PhpClassFieldsList copyFieldsList) {
            if (project == null) {
                PhpAddReadonlyModifierQuickFix.$$$reportNull$$$0(4);
            }
            if (copyFieldsList == null) {
                PhpAddReadonlyModifierQuickFix.$$$reportNull$$$0(5);
            }
            PhpModifierList modifierList = copyFieldsList.getModifierList();
            assert (modifierList != null);
            modifierList.add((PsiElement)PhpPsiElementFactory.createWhiteSpace(project));
            modifierList.add(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, "readonly"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpAddReadonlyModifierQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copyFieldsList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpAddReadonlyModifierQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "insertReadonlyModifier";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpRemoveReadonlyModifierQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpRemoveReadonlyModifierQuickFix INSTANCE = new PhpRemoveReadonlyModifierQuickFix();

        private PhpRemoveReadonlyModifierQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.readonly.modifier", new Object[0]);
            if (string == null) {
                PhpRemoveReadonlyModifierQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                PhpRemoveReadonlyModifierQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpRemoveReadonlyModifierQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRemoveReadonlyModifierQuickFix.$$$reportNull$$$0(3);
            }
            if ((parent = element.getParent()) instanceof PhpPromotedFieldParameterImpl) {
                PsiElement keyword = PhpHierarchyChecksInspection.getReadonlyKeyword((Field)parent);
                assert (keyword != null);
                keyword.delete();
            } else if (parent instanceof Field) {
                PhpClassFieldsList fieldsList = ((Field)parent).getParentList();
                assert (fieldsList != null);
                PhpClassFieldsList copyList = FieldImpl.copyListWithSingleField((Field)parent, fieldsList);
                Field copyField = (Field)ContainerUtil.getFirstItem((Collection)copyList.getFields());
                PsiElement readonlyKeyword = PhpHierarchyChecksInspection.getReadonlyKeyword(copyField);
                assert (readonlyKeyword != null);
                readonlyKeyword.delete();
                fieldsList.getParent().addAfter((PsiElement)copyList, (PsiElement)fieldsList);
                PhpMoveClassMemberBase.removeFieldWithPhpDoc((Field)parent);
            } else {
                element.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpRemoveReadonlyModifierQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpRemoveReadonlyModifierQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpRemoveClassReferenceFromTypeDeclaration
    extends PsiUpdateModCommandAction<PsiElement> {
        private final String myElementText;

        protected PhpRemoveClassReferenceFromTypeDeclaration(@NotNull PsiElement element) {
            if (element == null) {
                PhpRemoveClassReferenceFromTypeDeclaration.$$$reportNull$$$0(0);
            }
            super(element);
            this.myElementText = element.getText();
        }

        @IntentionName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("annotator.fix.remove", this.myElementText);
            if (string == null) {
                PhpRemoveClassReferenceFromTypeDeclaration.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpRemoveClassReferenceFromTypeDeclaration.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpRemoveClassReferenceFromTypeDeclaration.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpRemoveClassReferenceFromTypeDeclaration.$$$reportNull$$$0(4);
            }
            PhpCodeEditUtil.removeStatementWithDelivery(element, PhpTokenTypes.opBIT_OR);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpRemoveClassReferenceFromTypeDeclaration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpHierarchyChecksInspection$PhpRemoveClassReferenceFromTypeDeclaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

