/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpArrayOffsetMethodsReferenceContributor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class PhpArrayAccessCanBeReplacedWithForeachValueInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayAccessCanBeReplacedWithForeachValueInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                if (expression.isWriteAccess()) {
                    return;
                }
                PhpPsiElement value = expression.getValue();
                Variable foreachKey = PhpArrayAccessCanBeReplacedWithForeachValueInspection.this.findWrittenVariable(expression);
                if (value == null || foreachKey == null) {
                    return;
                }
                ForeachStatement anForeach = PhpPsiUtil.getParentOfClass((PsiElement)foreachKey, ForeachStatement.class);
                if (anForeach == null) {
                    return;
                }
                PsiElement array = anForeach.getArray();
                Variable foreachValue = anForeach.getValue();
                if (array != null && anForeach.getKey() == foreachKey && foreachValue != null && PhpArrayAccessCanBeReplacedWithForeachValueInspection.this.isResolvedToForeachArray(value, array, foreachValue) && !PhpArrayAccessCanBeReplacedWithForeachValueInspection.haveOffsetGet(array)) {
                    String valueText = foreachValue.getText();
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.message.can.be.replaced.with", valueText), new LocalQuickFix[]{new PhpReplaceWithExpressionQuickFix(valueText)});
                }
            }
        };
    }

    private static boolean haveOffsetGet(@NotNull PsiElement array) {
        if (array == null) {
            PhpArrayAccessCanBeReplacedWithForeachValueInspection.$$$reportNull$$$0(1);
        }
        PhpIndex index = PhpIndex.getInstance((Project)array.getProject());
        return new PhpType().add(array).global(array.getProject()).getTypes().stream().flatMap(fqn -> index.getAnyByFQN(fqn).stream()).anyMatch(c -> PhpArrayOffsetMethodsReferenceContributor.findArrayAccessOffsetMethod(c, "offsetGet") != null);
    }

    private boolean isResolvedToForeachArray(final @NotNull PhpPsiElement variable, final @NotNull PsiElement foreachArray, final @NotNull Variable foreachValue) {
        if (variable == null) {
            PhpArrayAccessCanBeReplacedWithForeachValueInspection.$$$reportNull$$$0(2);
        }
        if (foreachArray == null) {
            PhpArrayAccessCanBeReplacedWithForeachValueInspection.$$$reportNull$$$0(3);
        }
        if (foreachValue == null) {
            PhpArrayAccessCanBeReplacedWithForeachValueInspection.$$$reportNull$$$0(4);
        }
        if (variable instanceof Variable) {
            if (!(foreachArray instanceof Variable) || !PhpLangUtil.equalsVariableNames(((Variable)foreachArray).getName(), variable.getName())) {
                return false;
            }
            PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
            if (instruction == null) {
                return false;
            }
            final Ref ambiguous = new Ref((Object)false);
            final Ref resolvedToArrayVariable = new Ref((Object)false);
            PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(this){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    boolean isArrayValue;
                    boolean isArray = PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName());
                    boolean bl = isArrayValue = instruction.getAnchor() != foreachValue && PhpLangUtil.equalsVariableNames(instruction.getVariableName(), foreachValue.getName());
                    if (isArray && instruction.getAnchor() == foreachArray) {
                        resolvedToArrayVariable.set((Object)true);
                        return false;
                    }
                    if ((isArray || isArrayValue) && PhpArrayAccessCanBeReplacedWithForeachValueInspection.isWrite(instruction.getAccess())) {
                        ambiguous.set((Object)true);
                        this.haltTraversal();
                        return false;
                    }
                    return super.processAccessVariableInstruction(instruction);
                }

                public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                    ambiguous.set((Object)true);
                    this.haltTraversal();
                    return super.processEntryPointInstruction(instruction);
                }
            });
            return (Boolean)ambiguous.get() == false && (Boolean)resolvedToArrayVariable.get() != false;
        }
        return false;
    }

    private Variable findWrittenVariable(ArrayAccessExpression expression) {
        PhpPsiElement value;
        ArrayIndex index = expression.getIndex();
        final PhpPsiElement expressionValue = expression.getValue();
        PhpPsiElement phpPsiElement = value = index != null ? index.getValue() : null;
        if (value instanceof Variable) {
            final HashSet res = new HashSet();
            final Ref ambiguous = new Ref((Object)false);
            PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(value, PhpAccessVariableInstruction.class);
            if (instruction != null) {
                PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(this){

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        if (PhpArrayAccessCanBeReplacedWithForeachValueInspection.isWrite(instruction.getAccess())) {
                            ContainerUtil.addIfNotNull((Collection)res, (Object)((Variable)ObjectUtils.tryCast((Object)instruction.getAnchor(), Variable.class)));
                            return false;
                        }
                        return super.processAccessVariableInstruction(instruction);
                    }

                    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                        PhpAccessInstruction.Access access = instruction.getAccess();
                        PhpPsiElement anchor = instruction.getAnchor();
                        if (PhpArrayAccessCanBeReplacedWithForeachValueInspection.isWrite(access) && PhpArrayAccessCanBeReplacedWithForeachValueInspection.sameValue((PsiElement)anchor, (PsiElement)expressionValue)) {
                            ambiguous.set((Object)true);
                            this.haltTraversal();
                            return false;
                        }
                        return super.processArrayAccessInstruction(instruction);
                    }

                    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                        ambiguous.set((Object)true);
                        this.haltTraversal();
                        return super.processEntryPointInstruction(instruction);
                    }
                });
            }
            return (Boolean)ambiguous.get() != false ? null : (Variable)ContainerUtil.getOnlyItem(res);
        }
        return null;
    }

    private static boolean isWrite(PhpAccessInstruction.Access access) {
        return access.isUnset() || !access.isRead() && !access.isLightRead();
    }

    private static boolean sameValue(PsiElement anchor, PsiElement expressionValue) {
        while (anchor instanceof ArrayAccessExpression) {
            anchor = ((ArrayAccessExpression)anchor).getValue();
        }
        return anchor == null || PhpPsiUtil.areElementsEquivalent(anchor, expressionValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreachArray";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreachValue";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpArrayAccessCanBeReplacedWithForeachValueInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "haveOffsetGet";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isResolvedToForeachArray";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpReplaceWithExpressionQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myExpressionText;

        private PhpReplaceWithExpressionQuickFix(String expressionText) {
            this.myExpressionText = expressionText;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", this.myExpressionText);
            if (string == null) {
                PhpReplaceWithExpressionQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithExpressionQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithExpressionQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithExpressionQuickFix.$$$reportNull$$$0(3);
            }
            element.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, PhpExpression.class, this.myExpressionText));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpArrayAccessCanBeReplacedWithForeachValueInspection$PhpReplaceWithExpressionQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpArrayAccessCanBeReplacedWithForeachValueInspection$PhpReplaceWithExpressionQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

