/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.intentions.PhpInvertIfIntention;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.unwrap.PhpTryUnwrapper;
import com.jetbrains.php.refactoring.unwrap.PhpUnwrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExceptionImmediatelyRethrownInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpExceptionImmediatelyRethrownInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpCatch(Catch phpCatch) {
                PhpExpression throwArgument;
                Statement onlyStatement = PhpInvertIfIntention.getOnlyStatement((PsiElement)phpCatch.getStatement());
                if (onlyStatement == null) {
                    return;
                }
                Variable exception = phpCatch.getException();
                if (exception == null) {
                    return;
                }
                PhpThrowExpression throwExpression = PhpExceptionImmediatelyRethrownInspection.getOnlyThrowExpressionChild(onlyStatement);
                PhpExpression phpExpression = throwArgument = throwExpression != null ? throwExpression.getArgument() : null;
                if (throwArgument instanceof Variable && PhpLangUtil.equalsVariableNames(throwArgument.getName(), exception.getName()) && PhpExceptionImmediatelyRethrownInspection.exceptionTypesInDifferentHierarchiesWithFollowingCatches(phpCatch)) {
                    Try parentTry = PhpPsiUtil.getParentOfClass((PsiElement)phpCatch, Try.class);
                    if (parentTry == null) {
                        return;
                    }
                    PsiUpdateModCommandAction fix = parentTry.getCatchClauses().length > 1 || parentTry.getFinallyBlock() != null ? new PhpDeleteElementQuickFix((PsiElement)phpCatch, PhpBundle.message("delete.catch.statement", new Object[0])) : new PhpUnwrapTryQuickFix(parentTry);
                    holder.problem((PsiElement)onlyStatement, PhpBundle.message("inspection.message.exception.immediately.rethrown", new Object[0])).fix((ModCommandAction)fix).register();
                }
            }
        };
    }

    private static boolean exceptionTypesInDifferentHierarchiesWithFollowingCatches(Catch aCatch) {
        Catch nextCatch = aCatch;
        PhpType followingCatchesType = new PhpType();
        while ((nextCatch = (Catch)ObjectUtils.tryCast((Object)PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)nextCatch, true), Catch.class)) != null) {
            nextCatch.getExceptionTypes().forEach(arg_0 -> ((PhpType)followingCatchesType).add(arg_0));
        }
        if (followingCatchesType.isEmpty()) {
            return true;
        }
        PhpType currentCatchType = new PhpType();
        aCatch.getExceptionTypes().forEach(arg_0 -> ((PhpType)currentCatchType).add(arg_0));
        Project project = aCatch.getProject();
        currentCatchType = currentCatchType.global(project);
        followingCatchesType = followingCatchesType.global(project);
        PhpIndex index = PhpIndex.getInstance((Project)project);
        return !currentCatchType.isConvertibleFrom(followingCatchesType, index) && !followingCatchesType.isConvertibleFrom(currentCatchType, index);
    }

    @Nullable
    private static PhpThrowExpression getOnlyThrowExpressionChild(Statement statement) {
        return PhpPsiUtil.getOnlyPsiChild(statement, PhpThrowExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpExceptionImmediatelyRethrownInspection", "buildVisitor"));
    }

    private static final class PhpUnwrapTryQuickFix
    extends PsiUpdateModCommandAction<Try> {
        private PhpUnwrapTryQuickFix(Try aTry) {
            super((PsiElement)aTry);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("unwrap.try", new Object[0]);
            if (string == null) {
                PhpUnwrapTryQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull Try element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpUnwrapTryQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpUnwrapTryQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpUnwrapTryQuickFix.$$$reportNull$$$0(3);
            }
            new PhpTryUnwrapper().unwrapElement((PsiElement)element, new PhpUnwrapper.Context(true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpExceptionImmediatelyRethrownInspection$PhpUnwrapTryQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpExceptionImmediatelyRethrownInspection$PhpUnwrapTryQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

