/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpReplaceWithElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpConcatenationWithEmptyStringCanBeInlinedInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpStrFunctionsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIdempotentOperationInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIdempotentOperationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                PsiElement idempotentOperand;
                PsiElement left = PhpPsiUtil.unparenthesize(expression.getLeftOperand());
                PsiElement right = PhpPsiUtil.unparenthesize(expression.getRightOperand());
                PsiElement operation = expression.getOperation();
                if (operation == null) {
                    return;
                }
                IElementType opType = PsiUtilCore.getElementType((PsiElement)operation);
                Object object = PhpIdempotentOperationInspection.isIdempotentOperand(left, opType, false) ? left : (idempotentOperand = PhpIdempotentOperationInspection.isIdempotentOperand(right, opType, true) ? right : null);
                if (idempotentOperand == null) {
                    return;
                }
                PhpType oppositeOperandNativeType = idempotentOperand == left ? PhpIdempotentOperationInspection.getType(right) : PhpIdempotentOperationInspection.getType(left);
                PhpType idempotentOperandType = new PhpType().add(idempotentOperand);
                if ((PhpType.FLOAT.equals((Object)oppositeOperandNativeType) || PhpType.FLOAT_INT.equals((Object)oppositeOperandNativeType)) && idempotentOperandType.equals((Object)PhpType.INT) || idempotentOperandType.equals((Object)oppositeOperandNativeType)) {
                    String operatorText = operation.getText() + " " + idempotentOperand.getText();
                    PhpReplaceWithElementQuickFix fix = new PhpReplaceWithElementQuickFix((PsiElement)expression, idempotentOperand == left ? right : left, PhpBundle.message("annotator.fix.remove", idempotentOperand.getText()));
                    holder.problem(idempotentOperand, PhpBundle.message("inspection.message.expression.not.changed.after.applying", operatorText)).fix((ModCommandAction)fix).register();
                }
            }
        };
    }

    private static boolean isIdempotentOperand(PsiElement element, IElementType type, boolean right) {
        if (type == PhpTokenTypes.opPLUS || right && type == PhpTokenTypes.opMINUS) {
            return PhpStrFunctionsInspection.isNumber(element, "0");
        }
        if (type == PhpTokenTypes.opMUL || type == PhpTokenTypes.opDIV && right) {
            return PhpStrFunctionsInspection.isNumber(element, "1") || PhpStrFunctionsInspection.isNumber(element, "1.0");
        }
        if (type == PhpTokenTypes.opCONCAT) {
            return PhpConcatenationWithEmptyStringCanBeInlinedInspection.isEmptyStringLiteral(element);
        }
        return false;
    }

    private static PhpType getType(@Nullable PsiElement element) {
        return element == null ? PhpType.EMPTY : new PhpType().add(element).global(element.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpIdempotentOperationInspection", "buildVisitor"));
    }
}

