/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpNamedArgumentsWithChangedOrderInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpConvertToJsonValidateInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "isProperBinaryExpression", "expression", "Lcom/jetbrains/php/lang/psi/elements/BinaryExpression;", "ConvertToJsonValidateQuickFix", "intellij.php.impl"})
public final class PhpConvertToJsonValidateInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(this, holder){
            final /* synthetic */ PhpConvertToJsonValidateInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (!PhpConvertToJsonValidateInspection.access$isProperBinaryExpression(this.this$0, expression)) {
                    return;
                }
                T t = PhpPsiUtil.getChildByCondition((PsiElement)expression, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF);
                FunctionReference functionReference = t instanceof FunctionReference ? (FunctionReference)t : null;
                if (functionReference == null) {
                    return;
                }
                FunctionReference jsonLastErrorFunctionReference = functionReference;
                PhpCallInstruction phpCallInstruction = PhpControlFlowUtil.getCallInstruction(jsonLastErrorFunctionReference);
                if (phpCallInstruction == null) {
                    return;
                }
                PhpCallInstruction instruction = phpCallInstruction;
                Ref ref = Ref.create();
                Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
                Ref refToFunctionReference = ref;
                PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor((Ref<FunctionReference>)refToFunctionReference){
                    final /* synthetic */ Ref<FunctionReference> $refToFunctionReference;
                    {
                        this.$refToFunctionReference = $refToFunctionReference;
                    }

                    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                        FunctionReference functionReference = instruction.getFunctionReference();
                        Intrinsics.checkNotNullExpressionValue((Object)functionReference, (String)"getFunctionReference(...)");
                        FunctionReference processingJsonDecodeFunctionReference = functionReference;
                        if (!PhpLangUtil.equalsClassNames("json_decode", processingJsonDecodeFunctionReference.getName())) {
                            return false;
                        }
                        if (processingJsonDecodeFunctionReference.getParent() instanceof Statement) {
                            this.$refToFunctionReference.set((Object)processingJsonDecodeFunctionReference);
                        }
                        return false;
                    }
                });
                if (!refToFunctionReference.isNull()) {
                    PsiElement psiElement = (PsiElement)expression;
                    String string = PhpBundle.message("inspection.convert.to.json.validate", new Object[0]);
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                    Object object = refToFunctionReference.get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    localQuickFixArray[0] = new ConvertToJsonValidateQuickFix((FunctionReference)object, expression);
                    this.$holder.registerProblem(psiElement, string, localQuickFixArray);
                }
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP830;
    }

    private final boolean isProperBinaryExpression(BinaryExpression expression) {
        ConstantReference constantRef;
        FunctionReference functionRef;
        PsiElement psiElement = expression.getLeftOperand();
        Object object = psiElement instanceof FunctionReference ? (FunctionReference)psiElement : null;
        if (object == null) {
            psiElement = expression.getRightOperand();
            object = psiElement instanceof FunctionReference ? (FunctionReference)psiElement : null;
        }
        if ((functionRef = object) == null) {
            return false;
        }
        PsiElement psiElement2 = expression.getRightOperand();
        Object object2 = psiElement2 instanceof ConstantReference ? (ConstantReference)psiElement2 : null;
        if (object2 == null) {
            psiElement2 = expression.getLeftOperand();
            object2 = psiElement2 instanceof ConstantReference ? (ConstantReference)psiElement2 : null;
        }
        if ((constantRef = object2) == null) {
            return false;
        }
        if (!PhpLangUtil.equalsClassNames("json_last_error", functionRef.getName())) {
            return false;
        }
        if (!PhpLangUtil.equalsClassNames("JSON_ERROR_NONE", constantRef.getName())) {
            return false;
        }
        return PhpTokenTypes.tsCOMPARE_EQUALITY_OPS.contains(expression.getOperationType()) && !Intrinsics.areEqual((Object)PhpTokenTypes.kwINSTANCEOF, (Object)expression.getOperationType());
    }

    public static final /* synthetic */ boolean access$isProperBinaryExpression(PhpConvertToJsonValidateInspection $this, BinaryExpression expression) {
        return $this.isProperBinaryExpression(expression);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpConvertToJsonValidateInspection$ConvertToJsonValidateQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "functionReference", "Lcom/jetbrains/php/lang/psi/elements/FunctionReference;", "binaryExpression", "Lcom/jetbrains/php/lang/psi/elements/BinaryExpression;", "<init>", "(Lcom/jetbrains/php/lang/psi/elements/FunctionReference;Lcom/jetbrains/php/lang/psi/elements/BinaryExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.php.impl"})
    public static final class ConvertToJsonValidateQuickFix
    extends LocalQuickFixOnPsiElement {
        public ConvertToJsonValidateQuickFix(@NotNull FunctionReference functionReference, @NotNull BinaryExpression binaryExpression) {
            Intrinsics.checkNotNullParameter((Object)functionReference, (String)"functionReference");
            Intrinsics.checkNotNullParameter((Object)binaryExpression, (String)"binaryExpression");
            super((PsiElement)functionReference, (PsiElement)binaryExpression);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.convert.to.json.validate", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            block7: {
                PsiElement associativeParameter;
                FunctionReference jsonValidateFunctionReference;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                FunctionReference functionReference = startElement instanceof FunctionReference ? (FunctionReference)startElement : null;
                if (functionReference == null) {
                    return;
                }
                FunctionReference functionReference2 = functionReference;
                ParameterList parameterList = functionReference2.getParameterList();
                PsiElement parameterList2 = parameterList != null ? parameterList.copy() : null;
                functionReference2.getParent().delete();
                BinaryExpression binaryExpression = endElement instanceof BinaryExpression ? (BinaryExpression)endElement : null;
                if (binaryExpression == null) {
                    return;
                }
                BinaryExpression binaryExpression2 = binaryExpression;
                IElementType operationType = binaryExpression2.getOperationType();
                boolean shouldNegate = Intrinsics.areEqual((Object)operationType, (Object)PhpTokenTypes.opNOT_IDENTICAL) || Intrinsics.areEqual((Object)operationType, (Object)PhpTokenTypes.opNOT_EQUAL);
                PsiElement psiElement = shouldNegate ? binaryExpression2.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, UnaryExpression.class, "!json_validate()")).getLastChild() : binaryExpression2.replace((PsiElement)PhpPsiElementFactory.createFunctionReference(project, "json_validate()"));
                FunctionReference functionReference3 = jsonValidateFunctionReference = psiElement instanceof FunctionReference ? (FunctionReference)psiElement : null;
                if (jsonValidateFunctionReference == null) {
                    return;
                }
                if (parameterList2 != null) {
                    ParameterList parameterList3 = jsonValidateFunctionReference.getParameterList();
                    if (parameterList3 != null) {
                        parameterList3.replace(parameterList2);
                    }
                }
                if ((associativeParameter = jsonValidateFunctionReference.getParameter("associative", 1)) == null) break block7;
                PsiElement psiElement2 = ParameterListImpl.getNameIdentifier(associativeParameter);
                if (Intrinsics.areEqual((Object)(psiElement2 != null ? psiElement2.getText() : null), (Object)"associative") || !PhpNamedArgumentsWithChangedOrderInspection.isNamedArgument(associativeParameter)) {
                    ParameterList parameterList4 = jsonValidateFunctionReference.getParameterList();
                    ParameterListImpl parameterListImpl = parameterList4 instanceof ParameterListImpl ? (ParameterListImpl)parameterList4 : null;
                    if (parameterListImpl != null) {
                        parameterListImpl.removeParameter(associativeParameter);
                    }
                }
            }
        }
    }
}

