/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpSwitchCanBeReplacedWithMatchExpressionInspection;
import com.jetbrains.php.lang.intentions.PhpReplaceIfWithSwitchIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIfCanBeReplacedWithMatchExpressionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIfCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpIf(If ifStatement) {
                if (ifStatement.getParent() instanceof Else) {
                    return;
                }
                PsiElement expression = PhpReplaceIfWithSwitchIntention.getConditionExpression(ifStatement, PhpTokenTypes.opIDENTICAL, true);
                if (expression == null) {
                    return;
                }
                SmartList branches = new SmartList();
                PhpReplaceIfWithSwitchIntention.collectBranches(ifStatement, expression, (List<PhpReplaceIfWithSwitchIntention.IfStatementBranch>)branches, (List<If>)new SmartList(), PhpTokenTypes.opIDENTICAL);
                Else elseBranch = ifStatement.getElseBranch();
                if (branches.size() < 3 || elseBranch == null) {
                    return;
                }
                if (!PhpSwitchCanBeReplacedWithMatchExpressionInspection.canBeReplacedWithMatchExpression((PsiElement)ifStatement, (List<? extends PhpReplaceIfWithSwitchIntention.ControlStatementBranch>)branches, (PsiElement)elseBranch)) {
                    return;
                }
                holder.registerProblem(ifStatement.getFirstChild(), PhpBundle.message("inspection.message.can.be.replaced.with.match.expression", new Object[0]), new LocalQuickFix[]{PhpReplaceIfWithMatchExpressionFix.INSTANCE});
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpIfCanBeReplacedWithMatchExpressionInspection", "buildVisitor"));
    }

    public static class PhpReplaceIfWithMatchExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpReplaceIfWithMatchExpressionFix();

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.if.with.match.expression", new Object[0]);
            if (string == null) {
                PhpReplaceIfWithMatchExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceIfWithMatchExpressionFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceIfWithMatchExpressionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceIfWithMatchExpressionFix.$$$reportNull$$$0(3);
            }
            If ifStatement = PhpPsiUtil.getParentOfClass(element, If.class);
            assert (ifStatement != null);
            SmartList branches = new SmartList();
            PsiElement expression = PhpReplaceIfWithSwitchIntention.getConditionExpression(ifStatement, PhpTokenTypes.opIDENTICAL, true);
            PhpReplaceIfWithSwitchIntention.collectBranches(ifStatement, expression, (List<PhpReplaceIfWithSwitchIntention.IfStatementBranch>)branches, (List<If>)new SmartList(), PhpTokenTypes.opIDENTICAL);
            if (branches.isEmpty()) {
                return;
            }
            PhpSwitchCanBeReplacedWithMatchExpressionInspection.PhpReplaceSwitchWithMatchExpressionFix.applyFix(project, (PsiElement)ifStatement, expression, (List<? extends PhpReplaceIfWithSwitchIntention.ControlStatementBranch>)branches);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpIfCanBeReplacedWithMatchExpressionInspection$PhpReplaceIfWithMatchExpressionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpIfCanBeReplacedWithMatchExpressionInspection$PhpReplaceIfWithMatchExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

