/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpIncludeInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpApplyingEmptyIndexOperatorOnStringInspection;
import com.jetbrains.php.lang.inspections.PhpArrayIndexImmediatelyRewrittenInspection;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedVariableInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayMapInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpSwitchCanBeReplacedWithMatchExpressionInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.probablyBug.PhpDivisionByZeroInspection;
import com.jetbrains.php.lang.intentions.PhpNegateExpressionIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.StatementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNullSafeOperatorCanBeUsedInspection
extends PhpInspection {
    private static final Map<IElementType, Predicate<PsiElement>> CAST_TYPES_TO_NULL_RESULT_OF_CAST = Map.of(PhpTokenTypes.opINTEGER_CAST, PhpNullSafeOperatorCanBeUsedInspection::isIntZero, PhpTokenTypes.opSTRING_CAST, PhpApplyingEmptyIndexOperatorOnStringInspection::isEmptyStringExpression, PhpTokenTypes.opBOOLEAN_CAST, PhpLangUtil::isFalse, PhpTokenTypes.opARRAY_CAST, PhpLoopCanBeConvertedToArrayMapInspection::isEmptyArrayCreation);

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNullSafeOperatorCanBeUsedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpTernaryExpression(TernaryExpression expression) {
                if (expression.isShort()) {
                    return;
                }
                PhpPsiElement condition = expression.getCondition();
                PhpPsiElement trueVariant = expression.getTrueVariant();
                PhpPsiElement falseVariant = expression.getFalseVariant();
                ConditionalBranch conditionalBranch = 1.getConditionalBranch((PsiElement)condition, (PsiElement)trueVariant, (PsiElement)falseVariant);
                this.doCheck((PsiElement)expression, (PsiElement)expression, conditionalBranch.myCondition, conditionalBranch.myTrueVariant, Collections.singletonList(conditionalBranch.myFalseVariant), null);
            }

            public void visitPhpIf(If ifStatement) {
                Statement onlyStatement;
                if (ifStatement.getElseIfBranches().length > 0) {
                    return;
                }
                Statement statement = ifStatement.getStatement();
                Object object = onlyStatement = statement instanceof GroupStatement ? ((GroupStatement)statement).getOnlyStatement() : statement;
                if (onlyStatement instanceof StatementImpl) {
                    if (ifStatement.getElseBranch() != null || onlyStatement instanceof PhpReturn) {
                        this.tryMultipleBranches(ifStatement, (PsiElement)onlyStatement);
                        return;
                    }
                    PsiElement firstChild = PhpNullSafeOperatorCanBeUsedInspection.getSingleChild((PsiElement)onlyStatement);
                    if (firstChild == null) {
                        return;
                    }
                    if (firstChild instanceof MemberReference) {
                        this.doCheck(ifStatement.getFirstChild(), (PsiElement)ifStatement, (PsiElement)ifStatement.getCondition(), firstChild, firstChild, null);
                    } else if (firstChild instanceof AssignmentExpression) {
                        this.tryAssignmentInsideIf(ifStatement, (AssignmentExpression)firstChild);
                    }
                }
            }

            private void tryAssignmentInsideIf(If ifStatement, @NotNull AssignmentExpression assignmentExpression) {
                if (assignmentExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                Variable variable = (Variable)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), Variable.class);
                PhpPsiElement value = assignmentExpression.getValue();
                if (variable != null) {
                    this.doCheck(ifStatement.getFirstChild(), (PsiElement)ifStatement, (PsiElement)ifStatement.getCondition(), (PsiElement)value, PhpNullSafeOperatorCanBeUsedInspection.getAllPreviousWrites(variable), null);
                }
            }

            private void doCheck(PsiElement elementToHighlight, PsiElement elementToReplace, PsiElement condition, PsiElement memberReference, PsiElement memberReferenceExpression, @Nullable PsiElement elementToDelete) {
                PsiElement classReference = PhpNullSafeOperatorCanBeUsedInspection.findClassReferenceInCondition(condition);
                if (classReference != null && memberReference instanceof MemberReferenceImpl && PhpNullSafeOperatorCanBeUsedInspection.findSameClassReference(classReference, memberReference) != null && !PhpSideEffectDetector.canContainSideEffect(classReference)) {
                    holder.registerProblem(elementToHighlight, PhpBundle.message("inspection.message.can.be.replaced.with.operator", new Object[0]), new LocalQuickFix[]{new PhpReplaceWithNullSafeOperatorQuickFix(elementToReplace, classReference, memberReferenceExpression, elementToDelete)});
                }
            }

            private void doCheck(PsiElement elementToHighlight, PsiElement elementToReplace, PsiElement condition, PsiElement memberReferenceExpression, Collection<PsiElement> defaultValues, @Nullable PsiElement elementToDelete) {
                MemberReference memberReference = PhpNullSafeOperatorCanBeUsedInspection.extractMemberReferenceCastAware(memberReferenceExpression, defaultValues);
                if (memberReference != null) {
                    this.doCheck(elementToHighlight, elementToReplace, condition, (PsiElement)memberReference, memberReferenceExpression, elementToDelete);
                }
            }

            private void tryMultipleBranches(@NotNull If ifStatement, @NotNull PsiElement onlyStatement) {
                PsiElement element;
                if (ifStatement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (onlyStatement == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((element = 1.getSingleStatementInElseBranch(ifStatement)) != null) {
                    Pair<PsiElement, PhpExpression> destructedStatementInIf = PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureStatement(onlyStatement);
                    Pair<PsiElement, PhpExpression> destructedStatementInElse = PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureStatement(element);
                    PhpPsiElement condition = ifStatement.getCondition();
                    PsiElement trueVariant = (PsiElement)destructedStatementInIf.second;
                    PsiElement falseVariant = (PsiElement)destructedStatementInElse.second;
                    if (destructedStatementInIf.first != null && destructedStatementInElse.first != null && ((PsiElement)destructedStatementInIf.first).getClass() == ((PsiElement)destructedStatementInElse.first).getClass()) {
                        ConditionalBranch conditionalBranch = 1.getConditionalBranch((PsiElement)condition, trueVariant, falseVariant);
                        this.doCheck(ifStatement.getFirstChild(), (PsiElement)ifStatement, conditionalBranch.myCondition, conditionalBranch.myTrueVariant, Collections.singleton(conditionalBranch.myFalseVariant), 1.getSingleStatementInElseBranch(ifStatement));
                    }
                }
            }

            private static ConditionalBranch getConditionalBranch(PsiElement condition, PsiElement trueVariant, PsiElement falseVariant) {
                boolean swap = false;
                if (condition instanceof UnaryExpression && PhpNegateExpressionIntention.isNegation((UnaryExpression)condition)) {
                    condition = ((UnaryExpression)condition).getValue();
                    swap = true;
                } else if (condition instanceof BinaryExpression && (((BinaryExpression)condition).getOperationType() == PhpTokenTypes.opEQUAL || ((BinaryExpression)condition).getOperationType() == PhpTokenTypes.opIDENTICAL)) {
                    swap = true;
                }
                if (swap) {
                    PsiElement tmp = trueVariant;
                    trueVariant = falseVariant;
                    falseVariant = tmp;
                }
                if (condition == null || trueVariant == null || falseVariant == null) {
                    return ConditionalBranch.EMPTY;
                }
                return new ConditionalBranch(condition, trueVariant, falseVariant);
            }

            @Nullable
            private static PsiElement getSingleStatementInElseBranch(@NotNull If ifStatement) {
                Else elseBranch;
                if (ifStatement == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((elseBranch = ifStatement.getElseBranch()) != null) {
                    PhpPsiElement statement = elseBranch.getStatement();
                    return statement instanceof GroupStatement ? ((GroupStatement)statement).getOnlyStatement() : statement;
                }
                return (PsiElement)ObjectUtils.tryCast((Object)PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)ifStatement, true), PhpReturn.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignmentExpression";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ifStatement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "onlyStatement";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpNullSafeOperatorCanBeUsedInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "tryAssignmentInsideIf";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "tryMultipleBranches";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getSingleStatementInElseBranch";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isIntZero(@Nullable PsiElement element) {
        return PhpDivisionByZeroInspection.isZero(element) && PhpType.global((PsiElement[])new PsiElement[]{element}).equals((Object)PhpType.INT);
    }

    @Nullable
    private static MemberReference extractMemberReferenceCastAware(PsiElement value, Collection<PsiElement> defaultValues) {
        IElementType elementType;
        Predicate<PsiElement> predicate;
        if (defaultValues.isEmpty()) {
            return null;
        }
        if (value instanceof UnaryExpression && (predicate = CAST_TYPES_TO_NULL_RESULT_OF_CAST.get(elementType = PsiUtilCore.getElementType((PsiElement)((UnaryExpression)value).getOperation()))) != null) {
            if (ContainerUtil.all(defaultValues, predicate::test)) {
                return (MemberReference)ObjectUtils.tryCast((Object)((UnaryExpression)value).getValue(), MemberReference.class);
            }
        }
        return value instanceof MemberReference && ContainerUtil.all(defaultValues, PhpLangUtil::isNull) ? (MemberReference)value : null;
    }

    @Nullable
    public static PsiElement getSingleChild(@Nullable PsiElement statement) {
        if (statement == null) {
            return null;
        }
        PsiElement firstChild = statement.getFirstChild();
        PsiElement semicolon = PhpPsiUtil.getNextSiblingIgnoreWhitespace(firstChild, true);
        if (!PhpPsiUtil.isOfType(semicolon, PhpTokenTypes.opSEMICOLON) || semicolon != statement.getLastChild()) {
            return null;
        }
        return firstChild;
    }

    private static Collection<PsiElement> getAllPreviousWrites(Variable variable) {
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        if (instruction != null) {
            final ArrayList<PsiElement> res = new ArrayList<PsiElement>();
            final Ref ambiguous = new Ref((Object)false);
            PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if (access.isRead() || access.isLightRead() && !access.isUnset()) {
                        return true;
                    }
                    PsiElement value = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
                    if (value == null) {
                        ambiguous.set((Object)true);
                        this.haltTraversal();
                    } else {
                        res.add(value);
                    }
                    return false;
                }

                public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                    ambiguous.set((Object)true);
                    this.haltTraversal();
                    return super.processEntryPointInstruction(instruction);
                }
            });
            if (!((Boolean)ambiguous.get()).booleanValue()) {
                return res;
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    private static PsiElement findClassReferenceInCondition(PsiElement condition) {
        Variable variable;
        if (condition instanceof BinaryExpression) {
            IElementType type = ((BinaryExpression)condition).getOperationType();
            PsiElement classReference = PhpNullSafeOperatorCanBeUsedInspection.chooseNotNullLiteral((BinaryExpression)condition);
            if (PhpTokenTypes.opNOT_IDENTICAL == type || PhpTokenTypes.opIDENTICAL == type || (PhpTokenTypes.opNOT_EQUAL == type || PhpTokenTypes.opEQUAL == type) && PhpNullSafeOperatorCanBeUsedInspection.hasOnlyNonPrimitiveType(classReference)) {
                return classReference;
            }
        }
        if (condition instanceof PhpIsset && ((PhpIsset)condition).getVariables().length == 1 && (variable = (Variable)ObjectUtils.tryCast((Object)((PhpIsset)condition).getVariables()[0], Variable.class)) != null && PhpNullSafeOperatorCanBeUsedInspection.isAlwaysDefined(variable)) {
            return variable;
        }
        return PhpNullSafeOperatorCanBeUsedInspection.hasOnlyNonPrimitiveType(condition) ? condition : null;
    }

    private static boolean hasOnlyNonPrimitiveType(PsiElement element) {
        PhpType type = PhpType.global((PsiElement[])new PsiElement[]{element});
        return !type.isAmbiguous() && ContainerUtil.all((Collection)type.getTypes(), t -> PhpType.isNull((String)t) || !PhpType.isNotExtendablePrimitiveType((String)t));
    }

    private static boolean isAlwaysDefined(final Variable variable) {
        final Ref mayBeDefined = new Ref((Object)false);
        final Ref mayBeUndefined = new Ref((Object)false);
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        if (instruction != null) {
            PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if (access.isUnset()) {
                        mayBeUndefined.set((Object)true);
                        return false;
                    }
                    if (access.isLightRead()) {
                        return true;
                    }
                    if (PhpArrayIndexImmediatelyRewrittenInspection.isPlainWriteAccess((PsiElement)instruction.getAnchor())) {
                        mayBeDefined.set((Object)true);
                        return false;
                    }
                    return super.processAccessVariableInstruction(instruction);
                }

                public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                    Set<CharSequence> names;
                    Function function = (Function)ObjectUtils.tryCast((Object)instruction.getAnchor(), Function.class);
                    if (function != null && (names = PhpUndefinedVariableInspection.getPredefinedVariableNames(function)) != null && names.contains(variable.getNameCS())) {
                        mayBeDefined.set((Object)true);
                        return false;
                    }
                    mayBeUndefined.set((Object)true);
                    return super.processEntryPointInstruction(instruction);
                }

                public boolean processIncludeInstruction(PhpIncludeInstruction instruction) {
                    mayBeUndefined.set((Object)true);
                    return false;
                }
            });
        }
        return (Boolean)mayBeDefined.get() != false && (Boolean)mayBeUndefined.get() == false;
    }

    @Nullable
    private static PsiElement chooseNotNullLiteral(BinaryExpression condition) {
        if (PhpLangUtil.isNull(condition.getLeftOperand())) {
            return condition.getRightOperand();
        }
        if (PhpLangUtil.isNull(condition.getRightOperand())) {
            return condition.getLeftOperand();
        }
        return null;
    }

    @Nullable
    private static PsiElement findSameClassReference(PsiElement conditionClassReference, PsiElement memberReferenceExpression) {
        MemberReference memberReference;
        MemberReference memberReference2 = memberReference = memberReferenceExpression instanceof MemberReference ? (MemberReference)memberReferenceExpression : (MemberReference)PhpPsiUtil.getChildByCondition(memberReferenceExpression, (Condition<? super PsiElement>)((Condition)MemberReference.class::isInstance));
        if (memberReference == null) {
            return null;
        }
        PhpExpression classReference = memberReference.getClassReference();
        while (classReference != null) {
            if (memberReference.getReferenceType().isDynamic() && PhpPsiUtil.areElementsEquivalent(conditionClassReference, (PsiElement)classReference)) {
                return !((MemberReferenceImpl)memberReference).isNullSafeDereference() ? classReference : null;
            }
            if (!(classReference instanceof MemberReference)) break;
            memberReference = (MemberReference)classReference;
            classReference = ((MemberReference)classReference).getClassReference();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpNullSafeOperatorCanBeUsedInspection", "buildVisitor"));
    }

    private static final class ConditionalBranch {
        static final ConditionalBranch EMPTY = new ConditionalBranch(null, null, null);
        public PsiElement myCondition;
        public PsiElement myTrueVariant;
        public PsiElement myFalseVariant;

        private ConditionalBranch(PsiElement condition, PsiElement trueVariant, PsiElement falseVariant) {
            this.myCondition = condition;
            this.myTrueVariant = trueVariant;
            this.myFalseVariant = falseVariant;
        }
    }

    private static class PhpReplaceWithNullSafeOperatorQuickFix
    extends LocalQuickFixOnPsiElement {
        @FileModifier.SafeFieldForPreview
        private final SmartPsiElementPointer<PsiElement> myClassReference;
        private final SmartPsiElementPointer<PsiElement> myElementToDelete;

        private PhpReplaceWithNullSafeOperatorQuickFix(PsiElement toReplace, PsiElement classReference, PsiElement memberReferenceExpression, @Nullable PsiElement toDelete) {
            super(toReplace, memberReferenceExpression);
            this.myClassReference = SmartPointerManager.getInstance((Project)classReference.getProject()).createSmartPsiElementPointer(classReference, classReference.getContainingFile());
            this.myElementToDelete = toDelete != null ? SmartPointerManager.getInstance((Project)toDelete.getProject()).createSmartPsiElementPointer(toDelete, toDelete.getContainingFile()) : null;
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            PsiElement elementToDelete;
            if (target == null) {
                PhpReplaceWithNullSafeOperatorQuickFix.$$$reportNull$$$0(0);
            }
            PsiElement toReplace = PsiTreeUtil.findSameElementInCopy((PsiElement)this.getStartElement(), (PsiFile)target);
            PsiElement memberReferenceExpression = PsiTreeUtil.findSameElementInCopy((PsiElement)this.getEndElement(), (PsiFile)target);
            PsiElement classReference = PsiTreeUtil.findSameElementInCopy((PsiElement)this.myClassReference.getElement(), (PsiFile)target);
            PsiElement psiElement = elementToDelete = this.myElementToDelete != null ? PsiTreeUtil.findSameElementInCopy((PsiElement)this.myElementToDelete.getElement(), (PsiFile)target) : null;
            if (toReplace == null || memberReferenceExpression == null || classReference == null) {
                return null;
            }
            return new PhpReplaceWithNullSafeOperatorQuickFix(toReplace, classReference, memberReferenceExpression, elementToDelete);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithNullSafeOperatorQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement elementToReplace, @NotNull PsiElement memberReferenceExpression) {
            if (project == null) {
                PhpReplaceWithNullSafeOperatorQuickFix.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                PhpReplaceWithNullSafeOperatorQuickFix.$$$reportNull$$$0(3);
            }
            if (elementToReplace == null) {
                PhpReplaceWithNullSafeOperatorQuickFix.$$$reportNull$$$0(4);
            }
            if (memberReferenceExpression == null) {
                PhpReplaceWithNullSafeOperatorQuickFix.$$$reportNull$$$0(5);
            }
            String text = memberReferenceExpression.getText();
            PsiElement arrow = PhpPsiUtil.getNextSiblingIgnoreWhitespace(PhpNullSafeOperatorCanBeUsedInspection.findSameClassReference(this.myClassReference.getElement(), memberReferenceExpression), true);
            if (arrow == null) {
                return;
            }
            Object expressionToReplaceText = arrow.getTextRange().shiftLeft(memberReferenceExpression.getTextRange().getStartOffset()).replace(text, "?->");
            PsiElement parent = memberReferenceExpression.getParent();
            if (parent instanceof AssignmentExpression && (expressionToReplaceText = PhpReplaceWithNullSafeOperatorQuickFix.recreateAssignmentText((String)expressionToReplaceText, (AssignmentExpression)parent)) == null) {
                return;
            }
            if (parent instanceof PhpReturn && parent.getFirstChild() != null) {
                expressionToReplaceText = parent.getFirstChild().getText() + " " + (String)expressionToReplaceText;
            }
            Statement nullSafeReference = elementToReplace instanceof Statement ? PhpPsiElementFactory.createStatement(project, (String)expressionToReplaceText + ";") : PhpPsiElementFactory.createPhpPsiFromText(project, PhpExpression.class, (String)expressionToReplaceText);
            elementToReplace.replace((PsiElement)nullSafeReference);
            if (this.myElementToDelete != null && this.myElementToDelete.getElement() != null) {
                this.myElementToDelete.getElement().delete();
            }
        }

        @Nullable
        private static String recreateAssignmentText(String nullSafeReferenceText, AssignmentExpression parent) {
            PhpPsiElement variable = parent.getVariable();
            return variable != null ? variable.getText() + "=" + nullSafeReferenceText : null;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.operator", new Object[0]);
            if (string == null) {
                PhpReplaceWithNullSafeOperatorQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpNullSafeOperatorCanBeUsedInspection$PhpReplaceWithNullSafeOperatorQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToReplace";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberReferenceExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpNullSafeOperatorCanBeUsedInspection$PhpReplaceWithNullSafeOperatorQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModifierForPreview";
                    break;
                }
                case 1: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 6 -> new IllegalStateException(string);
            };
        }
    }
}

