/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpCustomExitPointRegistry;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.PhpMatchArmConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCaseConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpBaseCaseConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpForLoopHostInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpNullSafeDerefConditionInstructionImpl;
import com.jetbrains.php.codeInsight.typeInference.PhpAmbiguousCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpStrictVariableDfaState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpScopeHolderVisitor;
import com.jetbrains.php.lang.inspections.codeSmell.PhpBooleanUsageVisitor;
import com.jetbrains.php.lang.inspections.codeSmell.PhpInstanceofIsAlwaysTrueInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpParameterByRefIsNotUsedAsReferenceInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpInitialDfaBasedTypeStateAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.array.PhpDfaBasedArrayAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.array.PhpPreviousArrayDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.cast.PhpDfaBasedTypeCastAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.cast.PhpPreviousTypeCastDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.constant.PhpDfaBasedConstantAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.constant.PhpPreviousConstantDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.field.PhpDfaBasedFieldAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.field.PhpPreviousFieldDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.function.PhpDfaBasedFunctionAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.function.PhpPreviousFunctionDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.variable.PhpDfaBasedVariableAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.variable.PhpPreviousVariableDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysConstantEvaluator;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpConditionAlreadyCheckedInspection
extends PhpInspection {
    private static final PhpStrictVariableDfaState STRICT_NOT_NULL = new PhpStrictVariableDfaState(PhpDfaBasedTypeState.NOT_NULL);
    public static final PhpDfaBasedTypeState STRICT_BOOLEAN_STATE = new PhpAmbiguousCompositeTypeState(PhpDfaBaseStateConditionDFAnalyzer.STRICT_ALWAYS_TRUE, PhpDfaBasedTypeState.ALWAYS_FALSE);
    private static final java.util.function.Function<PhpStateCompatibilityDescriptor, PhpExpressionAlwaysConstantEvaluator.ConstantValue> COMPATIBILITY_TO_VALUE = d -> d.myCompatibilityResult ? PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE : PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(0);
        }
        return new PhpScopeHolderVisitor(this){

            @Override
            protected void check(@NotNull PhpScopeHolder scopeHolder) {
                if (scopeHolder == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpControlFlow flow = PhpCustomExitPointRegistry.getControlFlow(scopeHolder);
                final HashSet checkedRanges = new HashSet();
                Set conditionsPresentedInControlFlowConditions = ((StreamEx)StreamEx.of((Object[])flow.getInstructions()).select(PhpConditionInstruction.class).filter(PhpConditionInstruction::getResult)).map(PhpConditionInstruction::getCondition).nonNull().map(PsiElement::getTextRange).toSet();
                Object2IntOpenHashMap visitedSwitchCases = new Object2IntOpenHashMap();
                final Set<CharSequence> assignedAtLeastTwice = this.collectVariableNamesAssignedAtLeastTwice(flow);
                PhpControlFlowUtil.processFlow(flow, new PhpInstructionProcessor((Object2IntMap)visitedSwitchCases, conditionsPresentedInControlFlowConditions, checkedRanges){
                    final /* synthetic */ Object2IntMap val$visitedSwitchCases;
                    final /* synthetic */ Set val$conditionsPresentedInControlFlowConditions;
                    final /* synthetic */ Collection val$checkedRanges;
                    {
                        this.val$visitedSwitchCases = object2IntMap;
                        this.val$conditionsPresentedInControlFlowConditions = set;
                        this.val$checkedRanges = collection;
                    }

                    public boolean processCaseConditionInstruction(PhpCaseConditionInstruction instruction) {
                        if (instruction.getResult() && !this.processedTooManyCaseConditionsForSwitch(instruction)) {
                            return this.processConditionInstruction((PhpBaseCaseConditionInstructionImpl)instruction);
                        }
                        return super.processCaseConditionInstruction(instruction);
                    }

                    private boolean processedTooManyCaseConditionsForSwitch(PhpCaseConditionInstruction instruction) {
                        PsiElement switchArgument = instruction.getSwitchArgument();
                        if (switchArgument == null) {
                            return false;
                        }
                        int visited = this.val$visitedSwitchCases.getOrDefault((Object)switchArgument, 0);
                        if (visited >= 500) {
                            return true;
                        }
                        this.val$visitedSwitchCases.put((Object)switchArgument, visited + 1);
                        return false;
                    }

                    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                        PsiElement condition;
                        PsiElement circuitRightOperand = ((PhpConditionInstructionImpl)instruction).getShortCircuitRightOperand();
                        if (circuitRightOperand != null && this.checkCondition((PhpInstruction)instruction, circuitRightOperand, true, ContainerUtil.union((Collection)this.val$conditionsPresentedInControlFlowConditions, (Collection)this.val$checkedRanges))) {
                            this.val$checkedRanges.add(circuitRightOperand.getTextRange());
                        }
                        if ((condition = instruction.getCondition()) == null || !instruction.getResult()) {
                            return true;
                        }
                        if (this.checkCondition((PhpInstruction)instruction, condition, false, this.val$checkedRanges)) {
                            this.val$checkedRanges.add(condition.getTextRange());
                        }
                        return super.processConditionInstruction(instruction);
                    }
                });
                PhpControlFlowUtil.processFlow(flow, new PhpInstructionProcessor(){

                    public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                        PsiElement anchor = instruction.getAnchor();
                        this.doCheckAnchor((PhpInstruction)instruction, anchor);
                        return super.processReturnInstruction(instruction);
                    }

                    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                        for (PsiElement parameter : instruction.getFunctionReference().getParameters()) {
                            this.doCheckAnchor((PhpInstruction)instruction, parameter);
                        }
                        return super.processPhpCallInstruction(instruction);
                    }

                    private void doCheckAnchor(PhpInstruction instruction, PsiElement anchor) {
                        PhpExpressionAlwaysConstantEvaluator.ConstantValue value;
                        if (anchor != null && !ContainerUtil.exists((Iterable)checkedRanges, c -> c.contains(anchor.getTextRange())) && (value = PhpExpressionAlwaysConstantEvaluator.ConstantValue.fromValue(anchor, true)) != PhpExpressionAlwaysConstantEvaluator.ConstantValue.UNKNOWN && this.checkCondition(instruction, anchor, false, checkedRanges)) {
                            checkedRanges.add(anchor.getTextRange());
                        }
                    }

                    public boolean processInstruction(PhpInstruction instruction) {
                        this.tryCheckUnsetAccess(instruction);
                        return super.processInstruction(instruction);
                    }

                    private void tryCheckUnsetAccess(PhpInstruction instruction) {
                        if (instruction instanceof PhpAccessInstruction && ((PhpAccessInstruction)instruction).getAccess().isUnset()) {
                            PsiElement anchor = instruction.getAnchor();
                            PhpStateArgumentInfo info = PhpStateArgumentInfo.tryCreateInfo(anchor, true);
                            if (info == null) {
                                return;
                            }
                            this.checkAlreadyCompatibleInstruction(instruction, anchor, new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(info.getArgumentName(), PhpDfaBaseStateConditionDFAnalyzer.NOT_ISSET, instruction), PhpExpressionAlwaysConstantEvaluator.ConstantValue.UNKNOWN);
                        }
                    }

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        this.tryCheckUnsetAccess((PhpInstruction)instruction);
                        Variable variable = (Variable)ObjectUtils.tryCast((Object)instruction.getAnchor(), Variable.class);
                        if (variable == null || ContainerUtil.exists((Iterable)checkedRanges, c -> c.contains(variable.getTextRange()))) {
                            return true;
                        }
                        if (PhpParameterByRefIsNotUsedAsReferenceInspection.isReturnedFromReturnByRefFunction((PsiElement)variable)) {
                            return true;
                        }
                        if (instruction.getAccess().isReadWrite() || PhpConditionAlreadyCheckedInspection.argumentOfDynamicFunction(variable)) {
                            return true;
                        }
                        if (this.doCheckVariableAccess(instruction, variable, assignedAtLeastTwice)) {
                            checkedRanges.add(variable.getTextRange());
                        }
                        if (instruction.getAccess().isUnset()) {
                            return true;
                        }
                        return super.processAccessVariableInstruction(instruction);
                    }
                });
            }

            @NotNull
            private Set<CharSequence> collectVariableNamesAssignedAtLeastTwice(PhpControlFlow flow) {
                final HashSet assignedOnce = new HashSet();
                final HashSet<CharSequence> assignedAtLeastTwice = new HashSet<CharSequence>();
                PhpControlFlowUtil.processFlow(flow, new PhpInstructionProcessor(this){

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        PsiElement value = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
                        if (value != null) {
                            String assignedName;
                            CharSequence name = instruction.getVariableName();
                            if (!assignedOnce.add(name)) {
                                assignedAtLeastTwice.add(name);
                            }
                            if (value instanceof Variable && !assignedOnce.add(assignedName = ((Variable)value).getName())) {
                                assignedAtLeastTwice.add(assignedName);
                            }
                        }
                        return super.processAccessVariableInstruction(instruction);
                    }
                });
                HashSet<CharSequence> hashSet = assignedAtLeastTwice;
                if (hashSet == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashSet;
            }

            private boolean doCheckVariableAccess(PhpAccessVariableInstruction instruction, @NotNull Variable variable, Set<CharSequence> variableNamesAssignedAtLeastTwice) {
                PsiElement assignedValue;
                if (variable == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((assignedValue = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue()) != null) {
                    if (this.doCheckForAssignment(instruction, (PsiElement)variable, assignedValue, variableNamesAssignedAtLeastTwice)) {
                        return true;
                    }
                    if (this.doCheckForAssignment(instruction, assignedValue, (PsiElement)variable, variableNamesAssignedAtLeastTwice)) {
                        return true;
                    }
                }
                if (VariableImpl.isLocalWriteAccess((PsiElement)variable) || !PhpType.isBooleanGlobal((Project)variable.getProject(), (PhpType)variable.getType())) {
                    return false;
                }
                PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> stateWithInstruction = new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(instruction.getVariableName(), STRICT_BOOLEAN_STATE, (PhpInstruction)instruction, PhpStateArgumentInfo.tryCreateInfo((PsiElement)variable, true));
                return this.doCheckState((PhpInstruction)instruction, (PsiElement)variable, false, stateWithInstruction, d -> {
                    PhpExpressionAlwaysConstantEvaluator.ConstantValue value = PhpConditionAlreadyCheckedInspection.traceBackConcreteBooleanState(variable, d);
                    return value == null || !variable.isWriteAccess(true) ? value : null;
                });
            }

            private boolean doCheckForAssignment(PhpAccessVariableInstruction instruction, @NotNull PsiElement variable, @NotNull PsiElement value, Set<CharSequence> variableNamesAssignedAtLeastTwice) {
                if (variable == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (value == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (!(variable instanceof Variable) || !variableNamesAssignedAtLeastTwice.contains(((Variable)variable).getName())) {
                    return false;
                }
                PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> stateForAssignment = PhpConditionAlreadyCheckedInspection.getStateForAssignment(variable, value, (PhpInstruction)instruction);
                return this.checkAlreadyCompatibleInstruction((PhpInstruction)instruction, variable, stateForAssignment, PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE);
            }

            private boolean checkAlreadyCompatibleInstruction(PhpInstruction instruction, @NotNull PsiElement anchor, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> compatibleState, PhpExpressionAlwaysConstantEvaluator.ConstantValue overriddenConstantValue) {
                if (anchor == null) {
                    1.$$$reportNull$$$0(5);
                }
                return compatibleState != null && this.doCheckState(instruction, anchor, false, compatibleState, d -> COMPATIBILITY_TO_VALUE.apply((PhpStateCompatibilityDescriptor)d) == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE ? overriddenConstantValue : null);
            }

            private boolean checkCondition(PhpInstruction instruction, PsiElement condition, boolean searchFromSelf, Collection<? extends TextRange> checkedRanges) {
                PsiElement elementToCheckForSideEffects;
                if (ContainerUtil.exists(checkedRanges, t -> condition.getTextRange().contains(t))) {
                    return false;
                }
                Object object = elementToCheckForSideEffects = 1.isAssertion(condition) ? ((FunctionReference)condition).getParameterList() : condition;
                if (PhpSideEffectDetector.canContainSideEffect(elementToCheckForSideEffects)) {
                    return false;
                }
                boolean result = !(instruction instanceof PhpConditionInstruction) || ((PhpConditionInstruction)instruction).getResult();
                for (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> state : PhpConditionAlreadyCheckedInspection.getState(instruction, condition, searchFromSelf || result, true)) {
                    if (!this.doCheckState(instruction, condition, searchFromSelf, state, COMPATIBILITY_TO_VALUE)) continue;
                    return true;
                }
                return false;
            }

            private static boolean isAssertion(PsiElement condition) {
                FunctionReference reference;
                return condition instanceof FunctionReference && (PhpControlFlowBuilder.isSupportedBuiltInAssertion(reference = (FunctionReference)condition) || PhpDfaBaseStateConditionDFAnalyzer.isSupportedThirdPartyAssertion(reference));
            }

            private boolean doCheckState(PhpInstruction instruction, PsiElement condition, boolean searchFromSelf, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> state, java.util.function.Function<PhpStateCompatibilityDescriptor,  @Nullable PhpExpressionAlwaysConstantEvaluator.ConstantValue> constantValueSupplier) {
                if (state != null && !StringUtil.isEmpty((CharSequence)state.getVariableName()) && state.getState() != PhpDfaBasedTypeState.UNKNOWN) {
                    boolean prevInstructionIsCondition;
                    boolean result;
                    if (PhpConditionAlreadyCheckedInspection.isLogicalExpr(condition) && !(state.getState() instanceof PhpAmbiguousCompositeTypeState)) {
                        return false;
                    }
                    PhpStateCompatibilityDescriptor p = PhpConditionAlreadyCheckedInspection.getAlreadyCheckedInstruction(instruction, condition, state, searchFromSelf, null);
                    if (p == null) {
                        return false;
                    }
                    PhpInstruction alreadyCheckedInstruction = p.myInstruction;
                    PsiElement alreadyCoveredCondition = alreadyCheckedInstruction.getAnchor();
                    if (alreadyCoveredCondition instanceof Function) {
                        alreadyCoveredCondition = PhpConditionAlreadyCheckedInspection.findParameterByName((Function)alreadyCoveredCondition, state.getVariableName());
                    }
                    boolean bl = result = !(prevInstructionIsCondition = alreadyCheckedInstruction instanceof PhpConditionInstruction) || ((PhpConditionInstruction)alreadyCheckedInstruction).getResult();
                    if (alreadyCoveredCondition != null) {
                        int choice;
                        PhpExpressionAlwaysConstantEvaluator.ConstantValue value = constantValueSupplier.apply(p);
                        if (value == null) {
                            return false;
                        }
                        if (instruction instanceof PhpNullSafeDerefConditionInstructionImpl) {
                            this.handleNullSafeDeref(instruction.getAnchor(), alreadyCoveredCondition.getText(), value, prevInstructionIsCondition, result);
                            return true;
                        }
                        if (instruction instanceof PhpCaseConditionInstruction && value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE) {
                            PsiElement anchor = instruction.getAnchor();
                            if (PhpConditionAlreadyCheckedInspection.isDefaultCaseExists(anchor)) {
                                return true;
                            }
                            if (instruction instanceof PhpMatchArmConditionInstruction && PhpConditionAlreadyCheckedInspection.isLastConditionInMatch(anchor)) {
                                return true;
                            }
                        }
                        if (PhpConditionAlreadyCheckedInspection.isLogicalExpressionSemanticMayChangeAfterRemoval(condition, value)) {
                            return true;
                        }
                        if (value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE && PhpConditionAlreadyCheckedInspection.isLogicalPartOfAssertion(condition)) {
                            return true;
                        }
                        int n = choice = value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE ? 1 : 0;
                        if (instruction instanceof PhpAccessVariableInstructionImpl) {
                            if (((PhpAccessVariableInstructionImpl)instruction).getAssignedValue() != null && condition.getParent() instanceof AssignmentExpression) {
                                holder.problem(condition.getParent(), PhpBundle.message("inspection.message.variable.already.equal.to.assigned.value", new Object[0])).fix((ModCommandAction)PhpConditionAlreadyCheckedInspection.createNavigateToCauseFix(alreadyCoveredCondition, value)).register();
                            } else {
                                holder.registerProblem(condition, PhpBundle.message("variable.always.have.value.0", choice), PhpConditionAlreadyCheckedInspection.getFixes((Variable)condition, value, isOnTheFly));
                            }
                            return true;
                        }
                        @Nls String message = 1.getMessage(condition, alreadyCoveredCondition, prevInstructionIsCondition, result, choice);
                        holder.registerProblem(condition, message, PhpConditionAlreadyCheckedInspection.getFixes(condition, alreadyCoveredCondition, isOnTheFly, value));
                        return true;
                    }
                }
                return false;
            }

            @NotNull
            @Nls
            private static String getMessage(PsiElement condition, PsiElement alreadyCoveredCondition, boolean prevInstructionIsCondition, boolean result, int choice) {
                if (alreadyCoveredCondition instanceof PhpFile) {
                    String string = 1.isAssertion(condition) ? PhpBundle.message("inspection.message.assertion.always.true", choice) : PhpBundle.message("inspection.message.always.true", choice);
                    if (string == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return string;
                }
                if (1.isAssertion(condition)) {
                    String string = prevInstructionIsCondition ? PhpBundle.message("inspection.message.assertion.always.true.because", choice, alreadyCoveredCondition.getText(), result ? 1 : 0) : PhpBundle.message("inspection.message.assertion.always.true.because.evaluated", choice, alreadyCoveredCondition.getText());
                    if (string == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    return string;
                }
                String string = prevInstructionIsCondition ? PhpBundle.message("inspection.message.always.true.because", choice, alreadyCoveredCondition.getText(), result ? 1 : 0) : PhpBundle.message("inspection.message.always.true.because.evaluated", choice, alreadyCoveredCondition.getText());
                if (string == null) {
                    1.$$$reportNull$$$0(8);
                }
                return string;
            }

            private void handleNullSafeDeref(PsiElement classReference, String alreadyCoveredCondition, PhpExpressionAlwaysConstantEvaluator.ConstantValue value, boolean prevInstructionIsCondition, boolean prevInstructionResult) {
                String message;
                int choice;
                int n = choice = value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE ? 1 : 0;
                if (classReference == null) {
                    return;
                }
                String string = prevInstructionIsCondition ? PhpBundle.message("inspection.nullsafe.deref.unnecessary.because", choice, alreadyCoveredCondition, prevInstructionResult ? 1 : 0) : (message = PhpBundle.message("inspection.nullsafe.deref.unnecessary.because.evaluated", choice, alreadyCoveredCondition));
                if (value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE) {
                    PsiElement opQuest = PhpPsiUtil.getNextSiblingIgnoreWhitespace(classReference, true);
                    if (opQuest == null) {
                        return;
                    }
                    holder.registerProblem(opQuest, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{LocalQuickFix.from((ModCommandAction)new PhpDeleteElementQuickFix(opQuest))});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 6, 7, 8 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scopeHolder";
                        break;
                    }
                    case 1: 
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpConditionAlreadyCheckedInspection$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "anchor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpConditionAlreadyCheckedInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "collectVariableNamesAssignedAtLeastTwice";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "check";
                        break;
                    }
                    case 1: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "doCheckVariableAccess";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "doCheckForAssignment";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "checkAlreadyCompatibleInstruction";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 6, 7, 8 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Nullable
    public static PhpStateCompatibilityDescriptor getAlreadyCheckedInstruction(@NotNull PhpInstruction instruction, PsiElement condition, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, boolean searchFromSelf, @Nullable Consumer<PhpPreviousDfaAnalyzerProcessor> processorCustomizer) {
        PhpStateFromPreviousDFA previousStateFromDFA;
        PhpStateCompatibilityDescriptor compatibleStateFromPreviousDFA;
        if (instruction == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(1);
        }
        if ((compatibleStateFromPreviousDFA = PhpConditionAlreadyCheckedInspection.getCompatibleState(instruction, condition, currentState, previousStateFromDFA = PhpConditionAlreadyCheckedInspection.getStateFromPreviousDFA(instruction, searchFromSelf, PhpConditionAlreadyCheckedInspection.createPreviousProcessor(condition, currentState, false), processorCustomizer))) != null) {
            return compatibleStateFromPreviousDFA;
        }
        PhpStateFromPreviousDFA previousStateFromDfaStopOnNegations = PhpConditionAlreadyCheckedInspection.getStateFromPreviousDFA(instruction, searchFromSelf, PhpConditionAlreadyCheckedInspection.createPreviousProcessor(condition, currentState, true), processorCustomizer);
        PhpStateCompatibilityDescriptor compatibleStateFromPreviousDfaStopOnNegations = PhpConditionAlreadyCheckedInspection.getCompatibleState(instruction, condition, currentState, previousStateFromDfaStopOnNegations);
        if (compatibleStateFromPreviousDfaStopOnNegations != null) {
            return compatibleStateFromPreviousDfaStopOnNegations;
        }
        PhpStateFromPreviousDFA previousStateFromForInitialExpressions = PhpConditionAlreadyCheckedInspection.getStateFromPreviousDFA(instruction, searchFromSelf, PhpConditionAlreadyCheckedInspection.createForConditionalPreviousProcessor(condition, currentState), processorCustomizer);
        PhpStateCompatibilityDescriptor compatibleStateFromForInitialExpressions = PhpConditionAlreadyCheckedInspection.getCompatibleState(instruction, condition, currentState, previousStateFromForInitialExpressions);
        if (compatibleStateFromForInitialExpressions != null && !compatibleStateFromForInitialExpressions.myCompatibilityResult) {
            return compatibleStateFromForInitialExpressions;
        }
        return null;
    }

    @NotNull
    private static PhpStateFromPreviousDFA getStateFromPreviousDFA(@NotNull PhpInstruction instruction, boolean searchFromSelf, @Nullable PhpPreviousDfaAnalyzerProcessor dfaStateProcessor, @Nullable Consumer<PhpPreviousDfaAnalyzerProcessor> processorCustomizer) {
        if (instruction == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(2);
        }
        if (dfaStateProcessor == null) {
            return new PhpStateFromPreviousDFA(null, null);
        }
        if (processorCustomizer != null) {
            processorCustomizer.accept(dfaStateProcessor);
        }
        PhpControlFlowUtil.processPredecessors(instruction, searchFromSelf, dfaStateProcessor);
        PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> state = dfaStateProcessor.getState();
        MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> states = dfaStateProcessor.getSkippedStates();
        return new PhpStateFromPreviousDFA(state, states);
    }

    @Nullable
    private static PhpPreviousDfaAnalyzerProcessor createPreviousProcessor(PsiElement condition, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, boolean stopOnNegations) {
        return PhpConditionAlreadyCheckedInspection.createPreviousAnalyzer(condition, currentState, stopOnNegations, condition.getTextRange(), true);
    }

    private static PhpPreviousDfaAnalyzerProcessor createForConditionalPreviousProcessor(PsiElement condition, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState) {
        For aFor = (For)ObjectUtils.tryCast((Object)condition.getParent(), For.class);
        if (aFor != null && ArrayUtil.indexOf((Object[])aFor.getConditionalExpressions(), (Object)condition) >= 0) {
            PhpInstructionImpl lastRepeatedExpression;
            PhpPreviousDfaAnalyzerProcessor processor2 = PhpConditionAlreadyCheckedInspection.createPreviousProcessor(condition, currentState, true);
            if (processor2 == null) {
                return null;
            }
            PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)aFor);
            PhpForLoopHostInstructionImpl instruction = scopeHolder != null ? (PhpForLoopHostInstructionImpl)PhpCustomExitPointRegistry.getControlFlow(scopeHolder).getInstruction((PsiElement)aFor, PhpForLoopHostInstructionImpl.class) : null;
            PhpInstructionImpl phpInstructionImpl = lastRepeatedExpression = instruction != null ? instruction.getLastRepeatedExpression() : null;
            if (lastRepeatedExpression == null) {
                return null;
            }
            processor2.setConditionToStop(arg_0 -> lastRepeatedExpression.equals(arg_0));
            return processor2;
        }
        return null;
    }

    public static boolean isLogicalPartOfAssertion(PsiElement condition) {
        PsiElement parent;
        PsiElement argument = condition;
        while (PhpConditionAlreadyCheckedInspection.isLogicalPartOfArgument(parent = argument.getParent())) {
            argument = parent;
        }
        FunctionReference functionCall = PhpPsiUtil.getParentOfClass(argument, FunctionReference.class);
        return functionCall != null && !(functionCall instanceof MethodReference) && functionCall.getParameter(0) == argument && PhpLangUtil.equalsFunctionNames(functionCall.getName(), "assert");
    }

    private static boolean isLogicalPartOfArgument(PsiElement parent) {
        return parent instanceof ParenthesizedExpression || parent instanceof BinaryExpression && PhpTokenTypes.tsLOGICAL_OPS.contains(((BinaryExpression)parent).getOperationType());
    }

    @Nullable
    private static PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> getStateForAssignment(@NotNull PsiElement variable, @NotNull PsiElement assignedValue, PhpInstruction instruction) {
        PhpStateArgumentInfo variableInfo;
        if (variable == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(3);
        }
        if (assignedValue == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(4);
        }
        if ((variableInfo = PhpStateArgumentInfo.tryCreateInfo(variable, true)) == null) {
            return null;
        }
        PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> proxyState = new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>(variableInfo.getArgumentName(), new PhpDfaBasedTypeState("dummy"), instruction, variableInfo);
        PhpPreviousDfaAnalyzerProcessor processor2 = PhpConditionAlreadyCheckedInspection.createPreviousAnalyzer(variable, proxyState, false, variable.getTextRange(), true);
        if (processor2 != null) {
            PhpPreviousDfaBaseStateConditionDFAnalyzer analyzer = processor2.createAnalyzer();
            analyzer.setTryToCreateIntRangeState(false);
            PhpDfaBasedTypeState primitiveTypeCheckState = analyzer.getPrimitiveTypeCheckState(assignedValue, false, true);
            if (primitiveTypeCheckState != null) {
                return proxyState.copy((Object)primitiveTypeCheckState);
            }
        }
        return null;
    }

    private static boolean isLastConditionInMatch(PsiElement anchor) {
        PhpMatchExpression matchExpression = PhpPsiUtil.getParentOfClass(anchor, PhpMatchExpression.class);
        if (matchExpression != null) {
            PhpMatchArm lastArm = (PhpMatchArm)ContainerUtil.getLastItem((List)matchExpression.getMatchArms());
            return lastArm != null && ContainerUtil.getLastItem((List)lastArm.getConditions()) == anchor;
        }
        return false;
    }

    private static boolean argumentOfDynamicFunction(Variable variable) {
        FunctionReference functionCall = PhpPsiUtil.getParentOfClass((PsiElement)variable, FunctionReference.class);
        if (functionCall != null && StringUtil.isEmpty((String)functionCall.getName())) {
            return ArrayUtil.contains((Object)variable, (Object[])functionCall.getParameters());
        }
        return false;
    }

    private static boolean isLogicalExpressionSemanticMayChangeAfterRemoval(PsiElement condition, PhpExpressionAlwaysConstantEvaluator.ConstantValue value) {
        PsiElement parent = condition.getParent();
        if (parent instanceof BinaryExpression && PhpConditionAlreadyCheckedInspection.isLogicalExpr(parent)) {
            IElementType operationType;
            PsiElement left = ((BinaryExpression)parent).getLeftOperand();
            PsiElement right = ((BinaryExpression)parent).getRightOperand();
            if (left == condition && ((operationType = ((BinaryExpression)parent).getOperationType()) == PhpTokenTypes.opAND && value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE || operationType == PhpTokenTypes.opOR && value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE) && PhpSideEffectDetector.canContainSideEffect(right)) {
                return true;
            }
            if (!PhpBooleanUsageVisitor.isInBooleanUsageContext(parent) && !new PhpType().add(left == condition ? right : left).global(condition.getProject()).isBoolean()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isDefaultCaseExists(@Nullable PsiElement anchor) {
        PhpSwitch phpSwitch = PhpPsiUtil.getParentOfClass(anchor, PhpSwitch.class);
        if (phpSwitch != null && phpSwitch.getDefaultCase() != null) {
            return true;
        }
        PhpMatchExpression phpMatchExpression = PhpPsiUtil.getParentOfClass(anchor, PhpMatchExpression.class);
        return phpMatchExpression != null && phpMatchExpression.getDefaultMatchArm() != null;
    }

    @Nullable
    private static PhpExpressionAlwaysConstantEvaluator.ConstantValue traceBackConcreteBooleanState(Variable variable, PhpStateCompatibilityDescriptor descriptor) {
        boolean falseCompatible;
        boolean trueCompatible = PhpConditionAlreadyCheckedInspection.isCompatible(variable, descriptor, PhpDfaBaseStateConditionDFAnalyzer.STRICT_ALWAYS_TRUE);
        if (trueCompatible != (falseCompatible = PhpConditionAlreadyCheckedInspection.isCompatible(variable, descriptor, PhpDfaBasedTypeState.ALWAYS_FALSE))) {
            return trueCompatible ? PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE : PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE;
        }
        return null;
    }

    private static boolean isCompatible(Variable variable, PhpStateCompatibilityDescriptor descriptor, PhpDfaBasedTypeState state) {
        Boolean compatibleState = PhpConditionAlreadyCheckedInspection.isCompatibleState((PsiElement)variable, descriptor.myPreviousCompatibleState, state, (MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState>)MultiMap.empty());
        return compatibleState != null && compatibleState == descriptor.myCompatibilityResult;
    }

    @Nullable
    public static PhpPreviousDfaAnalyzerProcessor createPreviousAnalyzer(@NotNull PsiElement condition, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, boolean stopOnNegations, TextRange outerTextRange, boolean global) {
        if (condition == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(5);
        }
        return PhpConditionAlreadyCheckedInspection.createAnalyzer(condition.getProject(), currentState.getVariableName().toString(), stopOnNegations, outerTextRange, condition, currentState, currentState.getInfo(), global);
    }

    @Nullable
    public static PhpPreviousDfaAnalyzerProcessor createAnalyzer(@NotNull Project project, String stateVariableName, boolean stopOnNegations, TextRange outerTextRange, PsiElement condition, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, PhpStateArgumentInfo info, boolean global) {
        if (project == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(6);
        }
        if (info instanceof PhpStateArgumentInfo.PhpFunctionStateArgumentInfo) {
            return new PhpPreviousFunctionDfaAnalyzerProcessor(project, stateVariableName, stopOnNegations, outerTextRange, (PhpStateArgumentInfo.PhpFunctionStateArgumentInfo)info, currentState, global, PhpConditionAlreadyCheckedInspection.findSameFunctionCall(condition, (PhpStateArgumentInfo.PhpFunctionStateArgumentInfo)info));
        }
        if (info instanceof PhpStateArgumentInfo.PhpTypeCastArgumentInfo) {
            return new PhpPreviousTypeCastDfaAnalyzerProcessor(project, stateVariableName, stopOnNegations, outerTextRange, (PhpStateArgumentInfo.PhpTypeCastArgumentInfo)info, currentState, global);
        }
        if (PhpPreviousConstantDfaAnalyzerProcessor.applicable(stateVariableName)) {
            return PhpPreviousConstantDfaAnalyzerProcessor.createFromVariableName(project, stateVariableName, condition, stopOnNegations, outerTextRange, currentState, global);
        }
        if (PhpPreviousFieldDfaAnalyzerProcessor.applicable(stateVariableName)) {
            return PhpPreviousFieldDfaAnalyzerProcessor.createFromVariableName(project, stateVariableName, condition, stopOnNegations, outerTextRange, currentState, global);
        }
        if (PhpPreviousArrayDfaAnalyzerProcessor.applicable(stateVariableName)) {
            return PhpPreviousArrayDfaAnalyzerProcessor.createFromVariableName(project, stateVariableName, condition, stopOnNegations, outerTextRange, currentState, global);
        }
        return new PhpPreviousVariableDfaAnalyzerProcessor(project, stateVariableName, stopOnNegations, outerTextRange, currentState, true, global, PhpPsiUtil.getScopeHolder(condition));
    }

    @Nullable
    private static FunctionReference findSameFunctionCall(PsiElement condition, PhpStateArgumentInfo.PhpFunctionStateArgumentInfo info) {
        return (FunctionReference)ContainerUtil.find(PhpPsiUtil.findChildrenNonStrict(condition, FunctionReference.class), c -> c.getSignature().equals(info.getSignature()));
    }

    @NotNull
    public static Collection<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>> getState(PhpInstruction conditionInstruction, PsiElement condition, boolean result, boolean global) {
        ArrayList res = new ArrayList();
        for (PhpInitialDfaBasedTypeStateAnalyzer<?> processor2 : PhpConditionAlreadyCheckedInspection.createProcessorsToFindInitialState()) {
            if (!global) {
                processor2.setNonGlobal();
            }
            processor2.processCondition(conditionInstruction, condition, result);
            PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction state = processor2.getState();
            if (state == null || state.getState() == PhpDfaBasedTypeState.UNKNOWN) continue;
            res.add(state);
        }
        List list = StreamEx.of(res).groupRuns((s1, s2) -> PhpLangUtil.equalsVariableNames(s1.getVariableName(), s2.getVariableName())).flatMap(statesForSameVariable -> StreamEx.of((Collection)statesForSameVariable).distinct(s -> ((PhpDfaBasedTypeState)s.getState()).getCustomHashCode())).toList();
        if (list == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static LocalQuickFix[] getFixes(Variable variable, PhpExpressionAlwaysConstantEvaluator.ConstantValue constantValue, boolean isOnTheFly) {
        ArrayList<PhpExpressionAlwaysConstantEvaluator.PhpIntroduceConstantQuickFix> fixes = new ArrayList<PhpExpressionAlwaysConstantEvaluator.PhpIntroduceConstantQuickFix>();
        ContainerUtil.addIfNotNull(fixes, (Object)PhpInstanceofIsAlwaysTrueInspection.getFix(constantValue, (PsiElement)variable));
        if (isOnTheFly && (constantValue == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE || constantValue == PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE)) {
            fixes.add(new PhpExpressionAlwaysConstantEvaluator.PhpIntroduceConstantQuickFix(constantValue));
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @NotNull
    public static List<PhpInitialDfaBasedTypeStateAnalyzer<?>> createProcessorsToFindInitialState() {
        List list = ContainerUtil.concat(PhpConditionAlreadyCheckedInspection.getProcessors(false), PhpConditionAlreadyCheckedInspection.getProcessors(true));
        if (list == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static List<PhpInitialDfaBasedTypeStateAnalyzer<?>> getProcessors(boolean reverseBinaryExpression) {
        return Arrays.asList(new PhpInitialDfaBasedTypeStateAnalyzer[]{new PhpDfaBasedVariableAnalyzerProcessor(reverseBinaryExpression), new PhpDfaBasedFieldAnalyzerProcessor(reverseBinaryExpression), new PhpDfaBasedConstantAnalyzerProcessor(reverseBinaryExpression), new PhpDfaBasedArrayAnalyzerProcessor(reverseBinaryExpression), new PhpDfaBasedFunctionAnalyzerProcessor(reverseBinaryExpression), new PhpDfaBasedTypeCastAnalyzerProcessor(reverseBinaryExpression)});
    }

    @Nullable
    public static Parameter findParameterByName(Function function, CharSequence name) {
        return (Parameter)ContainerUtil.find((Object[])function.getParameters(), param -> PhpLangUtil.equalsParameterNames(param.getName(), name));
    }

    public static boolean isSilenceOperator(PsiElement p) {
        return p instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)p).getOperation(), PhpTokenTypes.opSILENCE);
    }

    @Nullable
    private static PhpStateCompatibilityDescriptor getCompatibleState(@NotNull PhpInstruction instruction, PsiElement condition, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, PhpStateFromPreviousDFA previousStateFromDFA) {
        if (instruction == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(9);
        }
        PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> previousState = previousStateFromDFA.state();
        MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates = previousStateFromDFA.parentToChildMapOfSkippedStates();
        if (previousState == null) {
            return null;
        }
        PhpDfaBasedTypeState previousDfaState = (PhpDfaBasedTypeState)previousState.getState();
        if (previousDfaState.is(PhpDfaBasedTypeState.UNKNOWN) || previousDfaState.is(PhpDfaBasedTypeState.AMBIGUOUS)) {
            return null;
        }
        Boolean compatibleState = PhpConditionAlreadyCheckedInspection.isCompatibleState(condition, previousDfaState, (PhpDfaBasedTypeState)currentState.getState(), skippedStates);
        if (instruction instanceof PhpAccessVariableInstruction && compatibleState == Boolean.FALSE) {
            return null;
        }
        if (compatibleState == null && currentState.getInstruction() instanceof PhpNullSafeDerefConditionInstructionImpl) {
            compatibleState = (Boolean)ObjectUtils.chooseNotNull((Object)PhpConditionAlreadyCheckedInspection.isCompatibleState(condition, previousDfaState, PhpDfaBasedTypeState.NOT_FALSE, skippedStates), (Object)PhpConditionAlreadyCheckedInspection.isCompatibleState(condition, previousDfaState, STRICT_NOT_NULL, skippedStates));
        }
        return compatibleState != null ? new PhpStateCompatibilityDescriptor(previousState.getInstruction(), compatibleState, previousDfaState) : null;
    }

    @Nullable
    private static Boolean isCompatibleState(PsiElement condition, PhpDfaBasedTypeState previousDfaState, PhpDfaBasedTypeState state, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
        if (previousDfaState.excludedBy(condition.getProject(), state, true, skippedStates)) {
            return Boolean.FALSE;
        }
        if (previousDfaState.coveredBy(condition.getProject(), state, true, skippedStates)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static boolean isModifyingAccess(PhpAccessInstruction.Access access, boolean global) {
        return access.isWrite() || access.isWriteRef() || access.isUnset() || global && access.isReadRef();
    }

    private static boolean isLogicalExpr(PsiElement condition) {
        return (condition = PhpPsiUtil.unparenthesize(condition)) instanceof BinaryExpression && PhpTokenTypes.tsLOGICAL_OPS.contains(((BinaryExpression)condition).getOperationType());
    }

    private static LocalQuickFix @NotNull [] getFixes(PsiElement redundantCondition, PsiElement conditionToNavigate, boolean isOnTheFly, PhpExpressionAlwaysConstantEvaluator.ConstantValue constantValue) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        ContainerUtil.addIfNotNull(fixes, (Object)PhpInstanceofIsAlwaysTrueInspection.getFix(constantValue, redundantCondition));
        if (isOnTheFly) {
            fixes.add(LocalQuickFix.from((ModCommandAction)PhpConditionAlreadyCheckedInspection.createNavigateToCauseFix(conditionToNavigate, constantValue)));
        }
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            PhpConditionAlreadyCheckedInspection.$$$reportNull$$$0(10);
        }
        return localQuickFixArray;
    }

    @NotNull
    private static PhpNavigateToElementQuickFix createNavigateToCauseFix(PsiElement conditionToNavigate, PhpExpressionAlwaysConstantEvaluator.ConstantValue value) {
        int choice = value == PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE ? 1 : 0;
        return new PhpNavigateToElementQuickFix(conditionToNavigate, PhpBundle.message("intention.family.name.navigate.to.cause", new Object[0]), PhpBundle.message("hint.evaluation.makes.subsequent.condition.always.true", choice));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpConditionAlreadyCheckedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpConditionAlreadyCheckedInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessorsToFindInitialState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAlreadyCheckedInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStateFromPreviousDFA";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStateForAssignment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPreviousAnalyzer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAnalyzer";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibleState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 10 -> new IllegalStateException(string);
        };
    }

    public record PhpStateFromPreviousDFA(@Nullable PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> state, @Nullable MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> parentToChildMapOfSkippedStates) {
    }

    public static class PhpStateCompatibilityDescriptor {
        private final PhpInstruction myInstruction;
        public final boolean myCompatibilityResult;
        private final PhpDfaBasedTypeState myPreviousCompatibleState;

        private PhpStateCompatibilityDescriptor(PhpInstruction instruction, boolean compatibilityResult, PhpDfaBasedTypeState previousCompatibleState) {
            this.myInstruction = instruction;
            this.myCompatibilityResult = compatibilityResult;
            this.myPreviousCompatibleState = previousCompatibleState;
        }
    }
}

