/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpKeyTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnpackingArraysWithStringKeysInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnpackingArraysWithStringKeysInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                Project project = expression.getProject();
                if (PhpLanguageLevel.current((Project)project).isAtLeast(PhpLanguageLevel.PHP810)) {
                    return;
                }
                List<PsiElement> unpackedArraysWithStringKeys = ArrayCreationExpressionImpl.children(expression).stream().filter(ArrayCreationExpressionImpl::isUnpackedArrayArgument).filter(PhpUnpackingArraysWithStringKeysInspection::arrayContainsStringKey).collect(Collectors.toList());
                if (unpackedArraysWithStringKeys.isEmpty()) {
                    return;
                }
                LocalQuickFix fix = LocalQuickFix.from((ModCommandAction)new PhpReplaceWithArrayMergeQuickFix(expression));
                unpackedArraysWithStringKeys.forEach(array -> holder.registerProblem(array, PhpBundle.message("inspection.php.unpacking.arrays.with.string.keys.inspection", new Object[0]), new LocalQuickFix[]{fix}));
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP740;
    }

    private static boolean arrayContainsStringKey(PsiElement element) {
        PsiElement array = PhpPsiUtil.unparenthesize(element.getLastChild());
        PhpTypedElement typedElement = (PhpTypedElement)ObjectUtils.tryCast((Object)array, PhpTypedElement.class);
        if (typedElement == null) {
            return false;
        }
        if (array instanceof Variable && PhpUnpackingArraysWithStringKeysInspection.isUnsetted((Variable)array)) {
            return false;
        }
        PhpType type = PhpUnpackingArraysWithStringKeysInspection.getKeyElementType(typedElement);
        return PhpType.intersects((PhpType)type, (PhpType)PhpType.STRING);
    }

    private static PhpType getKeyElementType(PhpTypedElement element) {
        Set types = element.getType().getTypes();
        PhpType type = new PhpType();
        for (String s : types) {
            if (!PhpKeyTypeProvider.isArrayKeySignature((String)s)) continue;
            type.add(s.substring(2));
        }
        return type;
    }

    private static boolean isUnsetted(Variable variable) {
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        if (instruction == null) {
            return true;
        }
        final Ref isUnsetted = new Ref((Object)false);
        PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (access.isReadRef() || PhpPsiUtil.getParentOfClass((PsiElement)instruction.getAnchor(), PhpUnset.class) != null) {
                    isUnsetted.set((Object)true);
                    return false;
                }
                return true;
            }
        });
        return (Boolean)isUnsetted.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/PhpUnpackingArraysWithStringKeysInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithArrayMergeQuickFix
    extends PsiUpdateModCommandAction<ArrayCreationExpression> {
        private PhpReplaceWithArrayMergeQuickFix(ArrayCreationExpression expression) {
            super((PsiElement)expression);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull ArrayCreationExpression expression, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithArrayMergeQuickFix.$$$reportNull$$$0(0);
            }
            if (expression == null) {
                PhpReplaceWithArrayMergeQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpReplaceWithArrayMergeQuickFix.$$$reportNull$$$0(2);
            }
            FunctionReference replacement = PhpPsiElementFactory.createFunctionReference(context.project(), String.format("array_merge(%s)", PhpReplaceWithArrayMergeQuickFix.constructArguments(expression)));
            expression.replace((PsiElement)replacement);
        }

        @NotNull
        private static String constructArguments(@NotNull ArrayCreationExpression expression) {
            if (expression == null) {
                PhpReplaceWithArrayMergeQuickFix.$$$reportNull$$$0(3);
            }
            List arguments = ContainerUtil.map(ArrayCreationExpressionImpl.children(expression), child -> child.getLastChild().getText());
            String string = StringUtil.join((Collection)arguments, (String)", ");
            if (string == null) {
                PhpReplaceWithArrayMergeQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.array.merge.expression", new Object[0]);
            if (string == null) {
                PhpReplaceWithArrayMergeQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnpackingArraysWithStringKeysInspection$PhpReplaceWithArrayMergeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpUnpackingArraysWithStringKeysInspection$PhpReplaceWithArrayMergeQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "constructArguments";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "constructArguments";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

