/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.constantCondition;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpAmbiguousCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpExhaustiveDelegateState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpRangeCheckDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpVariableCheckDfaBasedTypeState;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpPreviousDfaBaseStateConditionDFAnalyzer
extends PhpDfaBaseStateConditionDFAnalyzer {
    public static final PhpDfaBasedTypeState EMPTY_CHECK_STATE = new PhpAmbiguousCompositeTypeState(NOT_ISSET, PhpDfaBasedTypeState.ALWAYS_FALSE);
    private final boolean myReverseBinaryExpression;
    protected boolean myPreserveStatesInAmbiguousStates;
    private final Collection<Function<PhpInstruction, Boolean>> myStateDependenciesCheckers = new SmartHashSet();

    public PhpPreviousDfaBaseStateConditionDFAnalyzer(boolean global, boolean stopOnNegations, boolean reverseBinaryExpression) {
        super(global, stopOnNegations);
        this.myReverseBinaryExpression = reverseBinaryExpression;
    }

    @Override
    @NotNull
    public PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState performDFA(@Nullable PsiElement condition, boolean result) {
        PhpExpression expression;
        if (condition instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)condition;
            IElementType operationType = binaryExpression.getOperationType();
            PsiElement right = binaryExpression.getRightOperand();
            if (PhpLangUtil.isShortCircuitOperator(operationType) && this.canInvalidateDependency(right)) {
                return PhpPreviousDfaBaseStateConditionDFAnalyzer.createUnknownState();
            }
            if (ContainerUtil.exists((Object[])PhpRangeCheckDfaBasedTypeState.Operand.values(), o -> o.myTokenType == operationType)) {
                PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState state;
                PsiElement left = binaryExpression.getLeftOperand();
                PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState phpVariableDfaState = state = this.myReverseBinaryExpression ? this.tryCreateRangeState(result, PhpPreviousDfaBaseStateConditionDFAnalyzer.invertNonSymmetricOperands(operationType), right, left) : this.tryCreateRangeState(result, operationType, left, right);
                if (state != null) {
                    PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState phpVariableDfaState2 = state;
                    if (phpVariableDfaState2 == null) {
                        PhpPreviousDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(0);
                    }
                    return phpVariableDfaState2;
                }
            }
        }
        if (result && condition instanceof PhpEmpty && (expression = (PhpExpression)ContainerUtil.find((Object[])((PhpEmpty)condition).getVariables(), x$0 -> this.needToProcessElement((PsiElement)x$0))) != null) {
            PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState phpVariableDfaState = this.createState((PsiElement)expression, EMPTY_CHECK_STATE);
            if (phpVariableDfaState == null) {
                PhpPreviousDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(1);
            }
            return phpVariableDfaState;
        }
        PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState phpVariableDfaState = super.performDFA(condition, result);
        if (phpVariableDfaState == null) {
            PhpPreviousDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(2);
        }
        return phpVariableDfaState;
    }

    @NotNull
    protected static PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState createUnknownState() {
        return new PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState((CharSequence)"", PhpDfaBasedTypeState.UNKNOWN);
    }

    @Override
    @Nullable
    protected PhpDfaBasedTypeState getInstanceofTypeState(BinaryExpression binaryExpression, boolean result) {
        PhpDfaBasedTypeState instanceofTypeState = super.getInstanceofTypeState(binaryExpression, true);
        if (result) {
            return instanceofTypeState;
        }
        if (instanceofTypeState instanceof PhpDfaDelegateBasedTypeState.PhpInstanceofTypeState) {
            return new PhpNotInstanceofTypeState((PhpDfaDelegateBasedTypeState.PhpInstanceofTypeState)instanceofTypeState);
        }
        return null;
    }

    private boolean canInvalidateDependency(PsiElement element) {
        if (this.myStateDependenciesCheckers.isEmpty()) {
            return false;
        }
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder(element);
        if (scopeHolder == null) {
            return false;
        }
        PhpControlFlow flow = scopeHolder.getControlFlow();
        PhpInstruction instruction = flow.getInstruction(element, PhpInstruction.class);
        if (PhpPreviousDfaAnalyzerProcessor.dependenciesMayBeInvalidated(instruction, this.myStateDependenciesCheckers, this.myGlobal)) {
            return true;
        }
        for (PsiElement psiElement : PsiTreeUtil.findChildrenOfType((PsiElement)element, PhpPsiElement.class)) {
            for (PhpInstruction childInstruction : flow.getInstructions(psiElement, PhpInstruction.class)) {
                if (!PhpPreviousDfaAnalyzerProcessor.dependenciesMayBeInvalidated(childInstruction, this.myStateDependenciesCheckers, this.myGlobal)) continue;
                return true;
            }
        }
        return false;
    }

    public void addDependencyCheckers(Collection<Function<PhpInstruction, Boolean>> checkers) {
        this.myStateDependenciesCheckers.addAll(checkers);
    }

    @NotNull
    public static IElementType invertNonSymmetricOperands(IElementType operationType) {
        IElementType iElementType = operationType == PhpTokenTypes.opGREATER || operationType == PhpTokenTypes.opGREATER_OR_EQUAL || operationType == PhpTokenTypes.opLESS_OR_EQUAL || operationType == PhpTokenTypes.opLESS ? PhpPreviousDfaBaseStateConditionDFAnalyzer.strictInvert(operationType) : operationType;
        if (iElementType == null) {
            PhpPreviousDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @Override
    protected PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState computeStateFromConditionalGuard(PsiElement left, PsiElement right, IElementType operationType, boolean result) {
        return this.myReverseBinaryExpression ? super.computeStateFromConditionalGuard(right, left, PhpPreviousDfaBaseStateConditionDFAnalyzer.invertNonSymmetricOperands(operationType), result) : super.computeStateFromConditionalGuard(left, right, operationType, result);
    }

    @Nullable
    public PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState tryCreateRangeState(boolean result, IElementType operationType, PsiElement left, PsiElement right) {
        PhpRangeCheckDfaBasedTypeState rangeState;
        PhpRangeCheckDfaBasedTypeState phpRangeCheckDfaBasedTypeState = rangeState = this.needToProcessElement(left) ? PhpRangeCheckDfaBasedTypeState.tryToCreate(right, operationType, result, this.myGlobal) : null;
        if (rangeState != null) {
            return this.createState(left, rangeState);
        }
        PhpRangeCheckDfaBasedTypeState rangeStateRight = this.needToProcessElement(right) ? PhpRangeCheckDfaBasedTypeState.tryToCreate(left, PhpPreviousDfaBaseStateConditionDFAnalyzer.strictInvert(operationType), result, this.myGlobal) : null;
        return rangeStateRight != null ? this.createState(right, rangeStateRight) : null;
    }

    @Override
    @Nullable
    protected PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState createFalseComparisonState(PsiElement left, boolean negatedCheck, boolean strict) {
        if (!negatedCheck) {
            PhpDfaBasedTypeState state = strict ? PhpDfaBasedTypeState.ALWAYS_FALSE : PROBABLY_FALSE;
            return PhpPreviousDfaBaseStateConditionDFAnalyzer.updateStrict(this.createState(left, state), strict);
        }
        return super.createFalseComparisonState(left, negatedCheck, strict);
    }

    @Override
    @Nullable
    public PhpDfaBasedTypeState getPrimitiveTypeCheckState(PsiElement right, boolean negatedCheck, boolean strict) {
        ArrayList<PhpDfaBasedTypeState> states = new ArrayList<PhpDfaBasedTypeState>();
        right = PhpPsiUtil.unparenthesize(right);
        while (right instanceof AssignmentExpression) {
            PhpPsiElement intermediateVariable = ((AssignmentExpression)right).getVariable();
            if (intermediateVariable != null) {
                ContainerUtil.addIfNotNull(states, (Object)this.doGetPrimitiveTypeCheckState((PsiElement)intermediateVariable, negatedCheck, strict));
            }
            right = PhpPsiUtil.unparenthesize((PsiElement)((AssignmentExpression)right).getValue());
        }
        if (right != null) {
            ContainerUtil.addIfNotNull(states, (Object)this.doGetPrimitiveTypeCheckState(right, negatedCheck, strict));
        }
        return PhpPreviousDfaBaseStateConditionDFAnalyzer.composeStates(states);
    }

    @Nullable
    private static PhpDfaBasedTypeState composeStates(Collection<PhpDfaBasedTypeState> states) {
        if (states.isEmpty()) {
            return null;
        }
        PhpDfaBasedTypeState onlyState = (PhpDfaBasedTypeState)ContainerUtil.getOnlyItem(states);
        return (PhpDfaBasedTypeState)ObjectUtils.notNull((Object)onlyState, () -> new PhpExhaustiveDelegateState("CHAINED ASSIGNMENT", states.toArray(PhpDfaBasedTypeState.EMPTY_ARRAY)));
    }

    @Nullable
    private PhpDfaBasedTypeState doGetPrimitiveTypeCheckState(PsiElement right, boolean negatedCheck, boolean strict) {
        right = PhpPsiUtil.unparenthesize(right);
        PhpDfaBasedTypeState rangesState = this.myTryToCreateIntRangeState && !negatedCheck && strict ? PhpPreviousDfaBaseStateConditionDFAnalyzer.getIntBoundRangesState(right, this.myGlobal) : null;
        PhpDfaBasedTypeState state = this.getTypeState(right, negatedCheck, strict);
        return rangesState == null ? state : (state == null ? rangesState : new PhpExhaustiveDelegateState("State with int range", rangesState, state));
    }

    @Nullable
    private PhpDfaBasedTypeState getTypeState(PsiElement right, boolean negatedCheck, boolean strict) {
        PhpDfaBasedTypeState primitiveTypeCheckState = super.getPrimitiveTypeCheckState(right, negatedCheck, strict);
        if (primitiveTypeCheckState != null) {
            return primitiveTypeCheckState;
        }
        return PhpVariableCheckDfaBasedTypeState.tryToCreateState(right, negatedCheck, strict, this.myGlobal);
    }

    @Override
    protected PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState createState(PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState merge, boolean ambiguousResult) {
        return ambiguousResult && this.myPreserveStatesInAmbiguousStates ? new PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState(merge.getVariableName(), new PhpAmbiguousCompositeTypeState((PhpDfaBasedTypeState)merge.getState(), new PhpDummyDfaState())) : super.createState(merge, ambiguousResult);
    }

    public void preserveStatesInAmbiguousStates() {
        this.myPreserveStatesInAmbiguousStates = true;
    }

    private static IElementType strictInvert(IElementType type) {
        if (type == PhpTokenTypes.opGREATER) {
            return PhpTokenTypes.opLESS;
        }
        if (type == PhpTokenTypes.opLESS) {
            return PhpTokenTypes.opGREATER;
        }
        if (type == PhpTokenTypes.opGREATER_OR_EQUAL) {
            return PhpTokenTypes.opLESS_OR_EQUAL;
        }
        if (type == PhpTokenTypes.opLESS_OR_EQUAL) {
            return PhpTokenTypes.opGREATER_OR_EQUAL;
        }
        throw new IllegalArgumentException(type.getDebugName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpPreviousDfaBaseStateConditionDFAnalyzer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "performDFA";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "invertNonSymmetricOperands";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class PhpNotInstanceofTypeState
    extends PhpDfaBasedTypeState {
        public final PhpDfaDelegateBasedTypeState.PhpInstanceofTypeState myState;

        public PhpNotInstanceofTypeState(PhpDfaDelegateBasedTypeState.PhpInstanceofTypeState state) {
            super("NOT " + state.toString());
            this.myState = state;
        }

        @Override
        public int getCustomHashCode() {
            return this.myState.getCustomHashCode();
        }

        @Override
        public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpNotInstanceofTypeState.$$$reportNull$$$0(0);
            }
            if (state instanceof PhpNotInstanceofTypeState) {
                return ((PhpNotInstanceofTypeState)state).myState.coveredBy(project, this.myState, global);
            }
            return super.coveredBy(project, state, global, skippedStates);
        }

        @Override
        public boolean excludedBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpNotInstanceofTypeState.$$$reportNull$$$0(1);
            }
            if (state instanceof PhpDfaDelegateBasedTypeState.PhpInstanceofTypeState) {
                return state.coveredBy(project, this.myState, global);
            }
            return super.excludedBy(project, state, global, skippedStates);
        }

        @Override
        public boolean is(PhpDfaBasedTypeState state) {
            return state instanceof PhpNotInstanceofTypeState && this.myState.is(((PhpNotInstanceofTypeState)state).myState);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "state";
            objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpPreviousDfaBaseStateConditionDFAnalyzer$PhpNotInstanceofTypeState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coveredBy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "excludedBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpDummyDfaState
    extends PhpDfaBasedTypeState {
        private PhpDummyDfaState() {
            super("Preservation state");
        }
    }
}

