/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.options.OptCustom;
import com.intellij.codeInspection.ui.CustomComponentExtensionWithSwingRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.AddEditRemovePanel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.reference.PhpClassPatternsPanel;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManager;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManagerImpl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInspectionButtons
extends CustomComponentExtensionWithSwingRenderer<ButtonKind> {
    public PhpInspectionButtons() {
        super("php.inspection.buttons");
    }

    public static OptCustom inspectionButton(ButtonKind kind) {
        return new PhpInspectionButtons().component((Object)kind);
    }

    @NotNull
    public JComponent render(ButtonKind data, final @NotNull Project project) {
        if (project == null) {
            PhpInspectionButtons.$$$reportNull$$$0(0);
        }
        JButton jButton = switch (data.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                JButton button = new JButton(PhpBundle.message("inspection.unusedd.description.code.patterns.button.label", new Object[0]));
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PhpInspectionButtons.this.showCodePatternsDialog(project);
                    }
                });
                yield button;
            }
            case 1 -> {
                JButton button = new JButton(PhpBundle.message("inspection.unused.description.code.suppressed.annotations", new Object[0]));
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PhpInspectionButtons.this.showSuppressedAnnotationsDialog(project);
                    }
                });
                yield button;
            }
        };
        if (jButton == null) {
            PhpInspectionButtons.$$$reportNull$$$0(1);
        }
        return jButton;
    }

    private void showCodePatternsDialog(final Project project) {
        final PhpEntryPointsManagerImpl entryPointsManager = (PhpEntryPointsManagerImpl)PhpEntryPointsManager.getProjectInstance((Project)project);
        final PhpClassPatternsPanel panel = new PhpClassPatternsPanel(entryPointsManager.getModifiablePatterns());
        new DialogWrapper(this, project){
            {
                super(arg0);
                this.init();
                this.setTitle(PhpBundle.message("dialog.title.configure.code.patterns", new Object[0]));
            }

            protected JComponent createCenterPanel() {
                return panel;
            }

            protected void doOKAction() {
                String error = panel.getValidationError();
                if (error != null) {
                    Messages.showErrorDialog((Component)panel, (String)error);
                    return;
                }
                entryPointsManager.updatePatterns(panel.getPatterns());
                DaemonCodeAnalyzer.getInstance((Project)project).restart((Object)this);
                super.doOKAction();
            }
        }.show();
    }

    private void showSuppressedAnnotationsDialog(final Project project) {
        ArrayList<String> annotationsList = new ArrayList<String>(((PhpEntryPointsManagerImpl)PhpEntryPointsManager.getProjectInstance((Project)project)).getSuppressedAnnotations());
        AddEditRemovePanel<String> panel = new AddEditRemovePanel<String>((AddEditRemovePanel.TableModel)new MySuppressedAnnotationModel(), annotationsList){

            @Nullable
            protected String addItem() {
                return Messages.showInputDialog((Project)project, (String)PhpBundle.message("enter.annotation", new Object[0]), (String)PhpBundle.message("suppressed.annotation.title", new Object[0]), null);
            }

            protected boolean removeItem(String o) {
                return true;
            }

            @Nullable
            protected String editItem(String o) {
                return null;
            }
        };
        new DialogWrapper(this, project, (AddEditRemovePanel)panel, project){
            final /* synthetic */ AddEditRemovePanel val$panel;
            final /* synthetic */ Project val$project;
            {
                this.val$panel = addEditRemovePanel;
                this.val$project = project;
                super(arg0);
                this.init();
                this.setTitle(PhpBundle.message("configure.suppressed.annotations", new Object[0]));
            }

            protected JComponent createCenterPanel() {
                return this.val$panel;
            }

            protected void doOKAction() {
                ((PhpEntryPointsManagerImpl)PhpEntryPointsManager.getProjectInstance((Project)this.val$project)).updateSuppressedAnnotations(this.val$panel.getData());
                DaemonCodeAnalyzer.getInstance((Project)this.val$project).restart((Object)this);
                super.doOKAction();
            }
        }.show();
    }

    @NotNull
    public String serializeData(ButtonKind o) {
        String string = o.name();
        if (string == null) {
            PhpInspectionButtons.$$$reportNull$$$0(2);
        }
        return string;
    }

    public ButtonKind deserializeData(@NotNull String data) {
        if (data == null) {
            PhpInspectionButtons.$$$reportNull$$$0(3);
        }
        return ButtonKind.valueOf(data);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/PhpInspectionButtons";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpInspectionButtons";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserializeData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    static enum ButtonKind {
        CODE_PATTERNS,
        SUPPRESSED_ANNOTATIONS;

    }

    private static class MySuppressedAnnotationModel
    extends AddEditRemovePanel.TableModel<String> {
        private MySuppressedAnnotationModel() {
        }

        public int getColumnCount() {
            return 1;
        }

        @Nullable
        public String getColumnName(int columnIndex) {
            return PhpBundle.message("column.name.annotation.name", new Object[0]);
        }

        public Object getField(String o, int columnIndex) {
            return o;
        }
    }
}

