/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode;

import com.google.common.base.Predicates;
import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.ui.DescriptionEditorPane;
import com.intellij.profile.codeInspection.ui.DescriptionEditorPaneKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.deadcode.PhpDeadHTMLComposer;
import com.jetbrains.php.lang.inspections.deadcode.PhpUnusedDeclarationInspection;
import com.jetbrains.php.lang.inspections.deadcode.filters.PhpCommonRefFilter;
import com.jetbrains.php.lang.inspections.deadcode.filters.PhpHierarchyUnreferencedFilter;
import com.jetbrains.php.lang.inspections.deadcode.filters.WeakUnreferencedFilter;
import com.jetbrains.php.lang.inspections.deadcode.local.PhpUnusedSymbolsInspection;
import com.jetbrains.php.lang.inspections.deadcode.ui.PhpDummyEntryPointsEP;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManager;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManagerImpl;
import com.jetbrains.php.lang.inspections.reference.PhpMembersToReportOptionsPanel;
import com.jetbrains.php.lang.inspections.reference.PhpRefManager;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefConstant;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElement;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElementImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefField;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.ui.EntryPointsRootNode;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpRefVisitor;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnusedDeclarationPresentation
extends DefaultInspectionToolPresentation {
    @NonNls
    @NotNull
    private static final String CLOSURE_POSTFIX = "::closure";
    @NonNls
    @NotNull
    private static final String ANONYMOUS_POSTFIX = "::anonymous";
    @NonNls
    @NotNull
    private static final String DELETE = "delete";
    @NonNls
    @NotNull
    private static final String COMMENT = "comment";
    @NotNull
    private final Map<RefEntity, UnusedDeclarationHint> myFixedElements;
    @NotNull
    private final Set<RefEntity> myExcludedElements;
    private final QuickFixAction @NotNull [] myQuickFixActions;
    @NotNull
    private final NotNullLazyValue<InspectionToolWrapper<?, ?>> myDummyWrapper;
    @NotNull
    private final NotNullLazyValue<PhpCommonRefFilter> myFilter;
    @NotNull
    private final NotNullLazyValue<PhpDeadHTMLComposer> myComposer;

    public PhpUnusedDeclarationPresentation(@NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        if (toolWrapper == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(1);
        }
        super(toolWrapper, context);
        this.myFixedElements = ConcurrentCollectionFactory.createConcurrentIdentityMap();
        this.myExcludedElements = ConcurrentCollectionFactory.createConcurrentIdentitySet();
        this.myDummyWrapper = NotNullLazyValue.atomicLazy(() -> {
            GlobalInspectionToolWrapper toolWrapper = new GlobalInspectionToolWrapper((InspectionEP)new PhpDummyEntryPointsEP());
            toolWrapper.initialize((GlobalInspectionContext)this.myContext);
            return toolWrapper;
        });
        this.myFilter = NotNullLazyValue.createValue(() -> {
            PhpUnusedDeclarationInspection tool = this.getTool();
            return tool.isShowUnusedByEntries() ? new WeakUnreferencedFilter(tool, this.getContext()) : new PhpHierarchyUnreferencedFilter(tool, this.getContext());
        });
        this.myComposer = NotNullLazyValue.createValue(() -> new PhpDeadHTMLComposer((InspectionToolPresentation)this));
        this.myQuickFixActions = new QuickFixAction[]{new PermanentDeleteAction(toolWrapper), new CommentOutBinAction(toolWrapper), new MoveToEntriesAction(toolWrapper)};
    }

    @NotNull
    public PhpCommonRefFilter getFilter() {
        PhpCommonRefFilter phpCommonRefFilter = (PhpCommonRefFilter)this.myFilter.getValue();
        if (phpCommonRefFilter == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(2);
        }
        return phpCommonRefFilter;
    }

    @NotNull
    public PhpDeadHTMLComposer getComposer() {
        PhpDeadHTMLComposer phpDeadHTMLComposer = (PhpDeadHTMLComposer)((Object)this.myComposer.getValue());
        if (phpDeadHTMLComposer == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(3);
        }
        return phpDeadHTMLComposer;
    }

    @NotNull
    private PhpUnusedDeclarationInspection getTool() {
        PhpUnusedDeclarationInspection phpUnusedDeclarationInspection = (PhpUnusedDeclarationInspection)this.getToolWrapper().getTool();
        if (phpUnusedDeclarationInspection == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(4);
        }
        return phpUnusedDeclarationInspection;
    }

    public boolean isExcluded(@NotNull RefEntity entity) {
        if (entity == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(5);
        }
        return this.myExcludedElements.contains(entity);
    }

    public void amnesty(@NotNull RefEntity element) {
        if (element == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(6);
        }
        this.myExcludedElements.remove(element);
    }

    public void exclude(@NotNull RefEntity element) {
        if (element == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(7);
        }
        this.myExcludedElements.add(element);
    }

    public void exportResults(@NotNull Consumer<? super org.jdom.Element> resultConsumer, @NotNull RefEntity refEntity, @NotNull Predicate<? super CommonProblemDescriptor> excludedDescriptions) {
        if (resultConsumer == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(8);
        }
        if (refEntity == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(9);
        }
        if (excludedDescriptions == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(10);
        }
        if (!(refEntity instanceof PhpRefElement)) {
            return;
        }
        PhpRefElement refElement = (PhpRefElement)refEntity;
        if (!this.myFixedElements.containsKey(refEntity) && this.getFilter().accepts(refElement)) {
            if (!refElement.isValid() || this.skipEntryPoints(refElement) || this.ignoreForPresentation(refElement)) {
                return;
            }
            org.jdom.Element element = refEntity.getRefManager().export(refEntity);
            if (element == null) {
                return;
            }
            element.addContent(this.getProblemClassElement(refElement));
            element.addContent(PhpUnusedDeclarationPresentation.getHintsElement());
            element.addContent(PhpUnusedDeclarationPresentation.getDescriptionElement((RefElement)refElement));
            resultConsumer.accept((org.jdom.Element)element);
        }
        super.exportResults(resultConsumer, refEntity, excludedDescriptions);
    }

    @NotNull
    private org.jdom.Element getProblemClassElement(@NotNull PhpRefElement refElement) {
        if (refElement == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(11);
        }
        @NonNls org.jdom.Element problemClassElement = new org.jdom.Element("problem_class");
        problemClassElement.setAttribute("id", this.myToolWrapper.getShortName());
        HighlightSeverity severity = this.getSeverity((RefElement)refElement);
        if (severity != null) {
            problemClassElement.setAttribute("severity", severity.myName);
            problemClassElement.setAttribute("attribute_key", HighlightInfoType.UNUSED_SYMBOL.getAttributesKey().getExternalName());
        }
        problemClassElement.addContent(AnalysisBundle.message((String)"inspection.export.results.dead.code", (Object[])new Object[0]));
        org.jdom.Element element = problemClassElement;
        if (element == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(12);
        }
        return element;
    }

    private boolean ignoreForPresentation(@NotNull PhpRefElement refElement) {
        if (refElement == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(13);
        }
        return refElement.isFromCommon() || !refElement.isInitialized() || refElement.isTraversable() && !refElement.isTraversed() || !PhpUnusedDeclarationPresentation.compareVisibilities((UserDataHolder)refElement, this.getTool().getMembersToReportPanel()) || PhpUnusedDeclarationPresentation.isSuppressedMethod((UserDataHolder)refElement, this.getTool());
    }

    public static boolean acceptedByPatterns(@NotNull PsiElement dataHolder, @NotNull PhpUnusedDeclarationInspection tool) {
        if (dataHolder == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(14);
        }
        if (tool == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(15);
        }
        if (dataHolder instanceof PhpRefElement || dataHolder instanceof PhpNamedElement) {
            Collection<String> annotations;
            Collection<String> collection = annotations = dataHolder instanceof PhpRefElement ? PhpUnusedDeclarationPresentation.getCustomDocTags((PhpRefElement)dataHolder) : PhpUnusedDeclarationPresentation.getCustomDocTags((PhpNamedElement)dataHolder);
            if (PhpUnusedDeclarationPresentation.isSuppressedMethod((UserDataHolder)dataHolder, tool)) {
                return true;
            }
            if (ContainerUtil.intersects(((PhpEntryPointsManagerImpl)PhpEntryPointsManager.getProjectInstance((Project)dataHolder.getProject())).getSuppressedAnnotations(), annotations)) {
                return true;
            }
            return dataHolder instanceof PhpRefElement ? tool.isSuitedForEntryPoint((RefElement)dataHolder) : tool.isSuitedForEntryPoint(dataHolder);
        }
        return false;
    }

    private static Collection<String> getCustomDocTags(PhpRefElement holder) {
        PhpNamedElement element = (PhpNamedElement)ObjectUtils.tryCast((Object)holder.getPhpElement(), PhpNamedElement.class);
        return element != null ? PhpUnusedDeclarationPresentation.getCustomDocTags(element) : Collections.emptySet();
    }

    @NotNull
    public static Collection<String> getCustomDocTags(@NotNull PhpNamedElement element) {
        PhpDocComment comment;
        if (element == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(16);
        }
        if ((comment = element.getDocComment()) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpUnusedDeclarationPresentation.$$$reportNull$$$0(17);
            }
            return set;
        }
        HashSet<String> docTags = new HashSet<String>();
        PhpDocUtil.consumeTagElementsByName(comment, null, tag -> {
            String name = tag.getName();
            if (!PhpDocUtil.ALL_TAGS_SET.contains(name)) {
                docTags.add(name);
            }
        });
        HashSet<String> hashSet = docTags;
        if (hashSet == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    static boolean isSuppressedMethod(@NotNull UserDataHolder dataHolder, @NotNull PhpUnusedDeclarationInspection tool) {
        if (dataHolder == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(19);
        }
        if (tool == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(20);
        }
        if (tool.isSuppressedGettersSetters() && (dataHolder instanceof Method || dataHolder instanceof PhpRefMethod)) {
            String name = dataHolder instanceof PhpRefElement ? ((PhpRefElement)dataHolder).getName() : ((PhpNamedElement)dataHolder).getName();
            return PhpUnusedDeclarationPresentation.isAcceptedByGettersSetters(name);
        }
        return false;
    }

    private static boolean isAcceptedByGettersSetters(@NotNull String name) {
        if (name == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(21);
        }
        return StringUtil.startsWithIgnoreCase((String)name, (String)"get") || StringUtil.startsWithIgnoreCase((String)name, (String)"set");
    }

    public boolean containsInFixed(@NotNull RefEntity refEntity) {
        if (refEntity == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(22);
        }
        return this.myFixedElements.containsKey(refEntity);
    }

    public QuickFixAction @NotNull [] getQuickFixes(RefEntity ... refElements) {
        if (refElements == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(23);
        }
        PhpCommonRefFilter refFilter = this.getFilter();
        return Arrays.stream(refElements).anyMatch(element -> element instanceof PhpRefElement && refFilter.accepts((PhpRefElement)element) && !this.myFixedElements.containsKey(element) && element.isValid()) ? this.myQuickFixActions : this.getUndoQuickFixes(refElements);
    }

    private QuickFixAction @NotNull [] getUndoQuickFixes(RefEntity ... refEntities) {
        InspectionToolPresentation toolPresentation = this.myContext.getPresentation(this.getEntryPointsWrapperValue());
        QuickFixAction[] quickFixActionArray = toolPresentation.getQuickFixes(refEntities);
        if (quickFixActionArray == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(24);
        }
        return quickFixActionArray;
    }

    public void patchToolNode(@NotNull InspectionTreeNode node, @NotNull InspectionRVContentProvider provider, boolean showStructure, boolean groupByStructure) {
        if (node == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(25);
        }
        if (provider == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(26);
        }
        InspectionTreeModel model = this.myContext.getView().getTree().getInspectionTreeModel();
        InspectionTreeNode epNode = model.createCustomNode(this.getEntryPointsWrapperValue(), () -> new EntryPointsRootNode(this.getEntryPointsWrapperValue(), this.myContext, node), node);
        InspectionToolPresentation presentation = this.myContext.getPresentation(this.getEntryPointsWrapperValue());
        presentation.updateContent();
        provider.appendToolNodeContent(this.myContext, this.getEntryPointsWrapperValue(), epNode, true, groupByStructure);
    }

    @NotNull
    public InspectionToolWrapper<?, ?> getEntryPointsWrapperValue() {
        InspectionToolWrapper inspectionToolWrapper = (InspectionToolWrapper)this.myDummyWrapper.getValue();
        if (inspectionToolWrapper == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(27);
        }
        return inspectionToolWrapper;
    }

    @Nullable
    public HighlightSeverity getSeverity(@NotNull RefElement element) {
        PsiFile psiFile;
        if (element == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(28);
        }
        if ((psiFile = ((RefElement)element.getRefManager().getRefinedElement((RefEntity)element)).getPointer().getContainingFile()) != null) {
            return PhpUnusedSymbolsInspection.getPhpDeadCodeSeverity(psiFile.getProject(), (PsiElement)psiFile);
        }
        return super.getSeverity(element);
    }

    @NotNull
    public RefElementNode createRefNode(final @Nullable RefEntity entity, @NotNull InspectionTreeModel model, @NotNull InspectionTreeNode parent) {
        if (model == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(29);
        }
        if (parent == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(30);
        }
        final PhpCommonRefFilter refFilter = this.getFilter();
        return new RefElementNode(entity, (InspectionToolPresentation)this, parent){

            @Nullable
            public String getTailText() {
                RefEntity element = this.getElement();
                UnusedDeclarationHint hint = element == null ? null : PhpUnusedDeclarationPresentation.this.myFixedElements.get(element);
                return hint != null ? hint.getDescription() : super.getTailText();
            }

            protected String calculatePresentableName() {
                return PhpUnusedDeclarationPresentation.this.modifyPresentableNameForAnonymous(entity, super.calculatePresentableName());
            }

            public boolean isQuickFixAppliedFromView() {
                RefEntity element = this.getElement();
                return element != null && PhpUnusedDeclarationPresentation.this.myFixedElements.containsKey(element);
            }

            protected void visitProblemSeverities(@NotNull Object2IntMap<HighlightDisplayLevel> counter) {
                if (counter == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (entity instanceof PhpRefElementImpl && ((Boolean)ReadAction.compute(() -> {
                    try (AccessToken ignore = SlowOperations.knownIssue((String)"WI-79124");){
                        Boolean bl = refFilter.accepts((PhpRefElement)entity);
                        return bl;
                    }
                })).booleanValue()) {
                    HighlightSeverity severity = InspectionToolResultExporter.getSeverity((RefEntity)entity, null, (InspectionToolResultExporter)this.getPresentation());
                    HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
                    counter.mergeInt((Object)level, 1, Math::addExact);
                }
                super.visitProblemSeverities(counter);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation$1", "visitProblemSeverities"));
            }
        };
    }

    @NotNull
    @NlsSafe
    protected String modifyPresentableNameForAnonymous(@Nullable RefEntity entity, @NotNull String presentableName) {
        if (presentableName == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(31);
        }
        if (entity instanceof PhpRefClass && ((PhpRefClass)entity).isAnonymous()) {
            String string = PhpLangUtil.getParentQualifiedName(presentableName) + ANONYMOUS_POSTFIX;
            if (string == null) {
                PhpUnusedDeclarationPresentation.$$$reportNull$$$0(32);
            }
            return string;
        }
        if (entity instanceof PhpRefFunction && ((PhpRefFunction)entity).isClosure()) {
            String string = PhpLangUtil.getParentQualifiedName(presentableName) + CLOSURE_POSTFIX;
            if (string == null) {
                PhpUnusedDeclarationPresentation.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = presentableName;
        if (string == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(34);
        }
        return string;
    }

    public boolean isProblemResolved(@Nullable RefEntity entity) {
        return entity != null && this.myFixedElements.containsKey(entity);
    }

    public synchronized void updateContent() {
        this.getTool().checkForReachableRefs((GlobalInspectionContext)this.getContext());
        this.clearContents();
        this.getContext().getRefManager().iterate((RefVisitor)new PhpRefVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                PhpNamedElement psiElement;
                PhpRefElement refElement;
                if (refEntity == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((refElement = (PhpRefElement)ObjectUtils.tryCast((Object)refEntity, PhpRefElement.class)) == null || PhpUnusedDeclarationPresentation.this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS && (PhpUnusedDeclarationPresentation.this.myFixedElements.containsKey(refElement) || PhpUnusedDeclarationPresentation.this.isExcluded(refEntity) || PhpUnusedDeclarationPresentation.this.isSuppressed((RefEntity)refElement)) || PhpUnusedDeclarationPresentation.this.ignoreForPresentation(refElement)) {
                    return;
                }
                if (refElement.isValid() && PhpUnusedDeclarationPresentation.this.getFilter().accepts(refElement) && (psiElement = (PhpNamedElement)ObjectUtils.tryCast((Object)refElement.getPsiElement(), PhpNamedElement.class)) != null && !PhpUnusedDeclarationPresentation.this.skipEntryPoints(refElement)) {
                    PhpUnusedDeclarationPresentation.this.registerContentEntry(refEntity, psiElement.getNamespaceName());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation$2", "visitElement"));
            }
        });
        this.updateProblemElements();
    }

    protected boolean skipEntryPoints(PhpRefElement refElement) {
        return this.getTool().isSuitedForEntryPoint((RefElement)refElement);
    }

    public void ignoreElement(@NotNull RefEntity refEntity) {
        CommonProblemDescriptor[] descriptors;
        if (refEntity == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(35);
        }
        if (refEntity instanceof RefElement && (descriptors = (CommonProblemDescriptor[])this.getProblemElements().get((Object)refEntity)) != null) {
            ArrayList<CommonProblemDescriptor> foreignDescriptors = new ArrayList<CommonProblemDescriptor>();
            for (CommonProblemDescriptor descriptor : descriptors) {
                if (descriptor instanceof ProblemDescriptor) {
                    PsiElement psiElement = (PsiElement)ReadAction.compute(() -> ((RefElement)refEntity).getPsiElement());
                    PsiElement problemElement = (PsiElement)ReadAction.compute(() -> ((ProblemDescriptor)descriptor).getPsiElement());
                    if (problemElement == psiElement || problemElement instanceof Parameter && ReadAction.compute(() -> problemElement.getParent()) == psiElement) continue;
                }
                foreignDescriptors.add(descriptor);
            }
            if (foreignDescriptors.size() == descriptors.length) {
                return;
            }
        }
        super.ignoreElement(refEntity);
    }

    public void cleanup() {
        super.cleanup();
        this.myFixedElements.clear();
    }

    @Nullable
    public QuickFix<?> findQuickFixes(@NotNull CommonProblemDescriptor problemDescriptor, RefEntity entity, String hint) {
        if (problemDescriptor == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(36);
        }
        if (entity instanceof RefElement) {
            if (DELETE.equals(hint)) {
                return new PermanentDeleteOfflineFix((RefElement)entity);
            }
            if (COMMENT.equals(hint)) {
                return new CommentOutOfflineFix((RefElement)entity);
            }
            return super.findQuickFixes(problemDescriptor, entity, hint);
        }
        return null;
    }

    @NotNull
    public JComponent getCustomPreviewPanel(final @NotNull RefEntity entity) {
        if (entity == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(37);
        }
        DescriptionEditorPane htmlView = new DescriptionEditorPane(){

            public String getToolTipText(MouseEvent evt) {
                Element characterElementByPos;
                AttributeSet posAttributes;
                SimpleAttributeSet value;
                int pos = this.viewToModel(evt.getPoint());
                if (pos >= 0 && (value = (SimpleAttributeSet)(posAttributes = (characterElementByPos = ((HTMLDocument)this.getDocument()).getCharacterElement(pos)).getAttributes()).getAttribute(HTML.Tag.A)) != null) {
                    return (String)value.getAttribute("qualifiedname");
                }
                return null;
            }
        };
        htmlView.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(this){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                URL url;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((url = e.getURL()) == null) {
                    return;
                }
                int offset = Integer.parseInt(url.getRef());
                String fileURL = StringUtil.substringBeforeLast((String)url.toExternalForm(), (String)"#");
                VirtualFile vFile = (VirtualFile)ObjectUtils.chooseNotNull((Object)VirtualFileManager.getInstance().findFileByUrl(fileURL), (Object)VfsUtil.findFileByURL((URL)url));
                if (vFile != null) {
                    Project project = entity.getRefManager().getProject();
                    PsiNavigationSupport.getInstance().createNavigatable(project, vFile, offset).navigate(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation$4", "hyperlinkActivated"));
            }
        });
        PhpUnusedDeclarationPresentation.configureDeadCodeStyles(htmlView);
        StringBuilder buf = new StringBuilder();
        this.getComposer().compose(buf, entity, false);
        DescriptionEditorPaneKt.readHTML((JEditorPane)htmlView, (String)buf.toString());
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)htmlView, (boolean)true);
        if (jScrollPane == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(38);
        }
        return jScrollPane;
    }

    public boolean showProblemCount() {
        return false;
    }

    @NotNull
    private static org.jdom.Element getDescriptionElement(@NotNull RefElement refEntity) {
        if (refEntity == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(39);
        }
        org.jdom.Element descriptionElement = new org.jdom.Element("description");
        StringBuilder buf = new StringBuilder();
        PhpDeadHTMLComposer.appendProblemSynopsis(refEntity, buf);
        descriptionElement.addContent(buf.toString());
        org.jdom.Element element = descriptionElement;
        if (element == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(40);
        }
        return element;
    }

    private static void configureDeadCodeStyles(DescriptionEditorPane htmlView) {
        StyleSheet css = ((HTMLEditorKit)htmlView.getEditorKit()).getStyleSheet();
        css.addRule("p.problem-description-group {text-indent: " + JBUIScale.scale((int)9) + "px;font-weight:bold;}");
        css.addRule("div.problem-description {margin-left: " + JBUIScale.scale((int)9) + "px;}");
        css.addRule("ul {margin-left:" + JBUIScale.scale((int)10) + "px;text-indent: 0}");
        css.addRule("code {font-family:" + StartupUiUtil.getLabelFont().getFamily() + "}");
    }

    @NotNull
    private static org.jdom.Element getHintsElement() {
        @NonNls org.jdom.Element hintsElement = new org.jdom.Element("hints");
        StreamEx.of((Object[])UnusedDeclarationHint.values()).map(hint -> hint.getDescription()).map(StringUtil::toLowerCase).map(hint -> {
            @NonNls org.jdom.Element hintElement = new org.jdom.Element("hint");
            hintElement.setAttribute("value", hint);
            return hintElement;
        }).forEach(arg_0 -> ((org.jdom.Element)hintsElement).addContent(arg_0));
        org.jdom.Element element = hintsElement;
        if (element == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(41);
        }
        return element;
    }

    public static boolean compareVisibilities(@NotNull UserDataHolder listOwner, @NotNull PhpMembersToReportOptionsPanel membersToReportOptionsPanel) {
        if (listOwner == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(42);
        }
        if (membersToReportOptionsPanel == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(43);
        }
        if (!membersToReportOptionsPanel.isAccepted(listOwner)) {
            return false;
        }
        if (membersToReportOptionsPanel.isComparableByVisibility(listOwner)) {
            PhpModifier.Access declaredModifier = membersToReportOptionsPanel.getAcceptedVisibility(listOwner);
            return declaredModifier.isPublic() || PhpUnusedDeclarationPresentation.compareVisibilities(listOwner, declaredModifier);
        }
        return true;
    }

    protected static boolean compareVisibilitiesOfClosures(@NotNull UserDataHolder listOwner, @NotNull PhpModifier.Access declaredModifier) {
        if (listOwner == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(44);
        }
        if (declaredModifier == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(45);
        }
        if (listOwner instanceof Function) {
            listOwner = PhpPsiUtil.getParentByCondition((PsiElement)listOwner, (Condition<? super PsiElement>)Method.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        }
        while (!(listOwner instanceof PhpRefMethod) && listOwner instanceof RefEntity) {
            listOwner = ((RefEntity)listOwner).getOwner();
        }
        if (listOwner != null) {
            return PhpUnusedDeclarationPresentation.compareVisibilitiesOfClassMembers(listOwner, declaredModifier);
        }
        return true;
    }

    protected static boolean compareVisibilitiesOfClassMembers(@NotNull UserDataHolder listOwner, @NotNull PhpModifier.Access declaredModifier) {
        if (listOwner == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(46);
        }
        if (declaredModifier == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(47);
        }
        while (listOwner instanceof PhpRefClassMember) {
            PhpModifier.Access currentVisibilityModifier = ((PhpRefClassMember)listOwner).getAccessModifier().getAccess();
            if (declaredModifier.isEqualOrWeakerThan(currentVisibilityModifier)) {
                return true;
            }
            listOwner = ((PhpRefClassMember)listOwner).getOwner();
        }
        while (listOwner instanceof PhpClassMember) {
            if (declaredModifier.isEqualOrWeakerThan(((PhpClassMember)listOwner).getModifier().getAccess())) {
                return true;
            }
            listOwner = PhpPsiUtil.getParentByCondition((PsiElement)listOwner, (Condition<? super PsiElement>)Method.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        }
        return false;
    }

    protected static boolean compareVisibilities(@NotNull UserDataHolder listOwner, @NotNull PhpModifier.Access declaredModifier) {
        if (listOwner == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(48);
        }
        if (declaredModifier == null) {
            PhpUnusedDeclarationPresentation.$$$reportNull$$$0(49);
        }
        if (listOwner instanceof PhpRefClassMember || listOwner instanceof PhpClassMember) {
            return PhpUnusedDeclarationPresentation.compareVisibilitiesOfClassMembers(listOwner, declaredModifier);
        }
        if (listOwner instanceof PhpRefFunction || listOwner instanceof Function) {
            boolean isClosure;
            boolean bl = isClosure = listOwner instanceof PhpRefFunction ? ((PhpRefFunction)listOwner).isClosure() : ((Function)listOwner).isClosure();
            if (isClosure) {
                return PhpUnusedDeclarationPresentation.compareVisibilitiesOfClosures(listOwner, declaredModifier);
            }
        }
        return false;
    }

    @IntentionFamilyName
    public static String getDeleteQuickFix() {
        return AnalysisBundle.message((String)"inspection.dead.code.safe.delete.quickfix", (Object[])new Object[0]);
    }

    @IntentionFamilyName
    public static String getCommentOutQuickFix() {
        return AnalysisBundle.message((String)"inspection.dead.code.comment.quickfix", (Object[])new Object[0]);
    }

    @NlsActions.ActionText
    public static String getMoveToEntriesQuickFix() {
        return AnalysisBundle.message((String)"inspection.dead.code.entry.point.quickfix", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 12, 17, 18, 24, 27, 32, 33, 34, 38, 40, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 17: 
            case 18: 
            case 24: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation";
                break;
            }
            case 5: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 6: 
            case 7: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultConsumer";
                break;
            }
            case 9: 
            case 22: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedDescriptions";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElements";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 42: 
            case 44: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToReportOptionsPanel";
                break;
            }
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredModifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTool";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemClassElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomDocTags";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoQuickFixes";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryPointsWrapperValue";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "modifyPresentableNameForAnonymous";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomPreviewPanel";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionElement";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getHintsElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 17: 
            case 18: 
            case 24: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 40: 
            case 41: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "amnesty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "exportResults";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProblemClassElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ignoreForPresentation";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByPatterns";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocTags";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedMethod";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedByGettersSetters";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "containsInFixed";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "patchToolNode";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createRefNode";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "modifyPresentableNameForAnonymous";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "ignoreElement";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findQuickFixes";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCustomPreviewPanel";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionElement";
                break;
            }
            case 42: 
            case 43: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "compareVisibilities";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "compareVisibilitiesOfClosures";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "compareVisibilitiesOfClassMembers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 12, 17, 18, 24, 27, 32, 33, 34, 38, 40, 41 -> new IllegalStateException(string);
        };
    }

    private class PermanentDeleteAction
    extends QuickFixAction {
        PermanentDeleteAction(InspectionToolWrapper<?, ?> toolWrapper) {
            if (toolWrapper == null) {
                PermanentDeleteAction.$$$reportNull$$$0(0);
            }
            super(PhpUnusedDeclarationPresentation.getDeleteQuickFix(), AllIcons.Actions.Cancel, null, toolWrapper);
            this.setShortcutOfSafeDeleteAction();
        }

        private void setShortcutOfSafeDeleteAction() {
            AnAction safeDeleteAction = PermanentDeleteAction.getSafeDeleteAction();
            if (safeDeleteAction == null) {
                return;
            }
            this.copyShortcutFrom(safeDeleteAction);
        }

        @Nullable
        private static AnAction getSafeDeleteAction() {
            ActionManager actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class);
            return actionManager != null ? actionManager.getAction("SafeDelete") : null;
        }

        protected boolean applyFix(RefEntity @NotNull [] refElements) {
            if (refElements == null) {
                PermanentDeleteAction.$$$reportNull$$$0(1);
            }
            if (!super.applyFix(refElements)) {
                return false;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = PhpUnusedDeclarationPresentation.this.getContext().getProject();
                if (PhpUnusedDeclarationPresentation.this.isDisposed() || project.isDisposed()) {
                    return;
                }
                PhpCommonRefFilter refFilter = PhpUnusedDeclarationPresentation.this.getFilter();
                Set filteredOwners = ((StreamEx)StreamEx.of((Object[])refElements).select(PhpRefElementImpl.class).filter(refFilter::accepts)).toSet();
                PhpRefElementImpl[] elementsWithoutChildren = (PhpRefElementImpl[])((StreamEx)StreamEx.of((Object[])refElements).select(PhpRefElementImpl.class).filter(refElement -> !filteredOwners.contains(refElement.getOwner()))).toArray(PhpRefElementImpl.class);
                PsiElement[] elements = (PsiElement[])StreamEx.of((Object[])elementsWithoutChildren).map(PhpRefElement::getPhpElement).nonNull().toArray(PsiElement.class);
                SafeDeleteHandler.invoke((Project)project, (PsiElement[])elements, (boolean)false, () -> {
                    PermanentDeleteAction.removeElements((RefEntity[])elementsWithoutChildren, (Project)project, (InspectionToolWrapper)this.myToolWrapper);
                    StreamEx.of((Object[])elementsWithoutChildren).forEach(ref -> PhpUnusedDeclarationPresentation.this.myFixedElements.put((RefEntity)ref, UnusedDeclarationHint.DELETE));
                });
            });
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElements";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation$PermanentDeleteAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CommentOutBinAction
    extends QuickFixAction {
        CommentOutBinAction(InspectionToolWrapper<?, ?> toolWrapper) {
            if (toolWrapper == null) {
                CommentOutBinAction.$$$reportNull$$$0(0);
            }
            super(PhpUnusedDeclarationPresentation.getCommentOutQuickFix(), null, KeyStroke.getKeyStroke(47, ClientSystemInfo.isMac() ? 4 : 2), toolWrapper);
        }

        protected boolean applyFix(RefEntity @NotNull [] refElements) {
            if (refElements == null) {
                CommentOutBinAction.$$$reportNull$$$0(1);
            }
            if (!super.applyFix(refElements)) {
                return false;
            }
            PhpCommonRefFilter filter = PhpUnusedDeclarationPresentation.this.getFilter();
            ArrayList deletedRefs = new ArrayList();
            MultiMap textRangesToComment = new MultiMap();
            for (RefEntity refEntity : refElements) {
                PhpRefElement phpRefElement;
                PsiElement psiElement;
                if (refEntity instanceof RefElement) {
                    RefElement refElement = (RefElement)refEntity;
                    v0 = refElement.getPsiElement();
                } else {
                    v0 = psiElement = null;
                }
                if (psiElement == null || !(refEntity instanceof PhpRefElement) || filter.getElementProblemCount(phpRefElement = (PhpRefElement)refEntity) == 0) continue;
                RefEntity owner = refEntity.getOwner();
                if (!(owner instanceof PhpRefElement) || filter.getElementProblemCount((PhpRefElement)owner) == 0 || ArrayUtil.find((Object[])refElements, (Object)owner) <= -1) {
                    CommentOutOfflineFix.attachTextRangeToComment(psiElement, textRangesToComment);
                }
                if (deletedRefs.contains(refEntity)) continue;
                refEntity.getRefManager().removeRefElement((RefElement)refEntity, deletedRefs);
            }
            CommentOutOfflineFix.insertCommentsLazy(textRangesToComment);
            PhpEntryPointsManager entryPointsManager = PhpRefManager.getEntryPointsManager((RefManager)PhpUnusedDeclarationPresentation.this.getRefManager());
            for (RefElement refElement : deletedRefs) {
                entryPointsManager.removeEntryPoint(refElement);
                PhpUnusedDeclarationPresentation.this.myFixedElements.put((RefEntity)refElement, UnusedDeclarationHint.COMMENT);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElements";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation$CommentOutBinAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MoveToEntriesAction
    extends QuickFixAction {
        MoveToEntriesAction(InspectionToolWrapper<?, ?> toolWrapper) {
            if (toolWrapper == null) {
                MoveToEntriesAction.$$$reportNull$$$0(0);
            }
            super(PhpUnusedDeclarationPresentation.getMoveToEntriesQuickFix(), null, null, toolWrapper);
        }

        public void update(@NotNull AnActionEvent e) {
            boolean withoutCandidatesToMove;
            if (e == null) {
                MoveToEntriesAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            if (e.getPresentation().isEnabledAndVisible() && (withoutCandidatesToMove = ((StreamEx)StreamEx.of((Object[])InspectionTree.getSelectedRefElements((AnActionEvent)e)).select(RefElement.class).filter((Predicate)Predicates.not(MoveToEntriesAction::notAllowedToMove))).noneMatch((Predicate)Predicates.not(RefElement::isEntry)))) {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        private static boolean notAllowedToMove(RefElement ref) {
            return ref instanceof PhpRefConstant || ref instanceof PhpRefField;
        }

        protected boolean applyFix(RefEntity @NotNull [] refElements) {
            if (refElements == null) {
                MoveToEntriesAction.$$$reportNull$$$0(2);
            }
            PhpEntryPointsManager entryPointsManager = PhpRefManager.getEntryPointsManager((RefManager)PhpUnusedDeclarationPresentation.this.getRefManager());
            ((StreamEx)StreamEx.of((Object[])refElements).select(RefElement.class).filter((Predicate)Predicates.not(MoveToEntriesAction::notAllowedToMove))).forEach(arg_0 -> MoveToEntriesAction.lambda$applyFix$0((EntryPointsManager)entryPointsManager, arg_0));
            return true;
        }

        private static /* synthetic */ void lambda$applyFix$0(EntryPointsManager entryPointsManager, RefElement refElement) {
            entryPointsManager.addEntryPoint(refElement, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refElements";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation$MoveToEntriesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PermanentDeleteOfflineFix
    implements QuickFix {
        @NotNull
        final RefElement myElement;

        PermanentDeleteOfflineFix(@NotNull RefElement element) {
            if (element == null) {
                PermanentDeleteOfflineFix.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpUnusedDeclarationPresentation.getDeleteQuickFix();
            if (string == null) {
                PermanentDeleteOfflineFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            if (project == null) {
                PermanentDeleteOfflineFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PermanentDeleteOfflineFix.$$$reportNull$$$0(3);
            }
            if (this.myElement.isValid()) {
                ApplicationManager.getApplication().invokeLater(() -> SafeDeleteHandler.invoke((Project)project, (PsiElement[])new PsiElement[]{this.myElement.getPsiElement()}, (boolean)false), project.getDisposed());
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation$PermanentDeleteOfflineFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation$PermanentDeleteOfflineFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class CommentOutOfflineFix
    implements QuickFix {
        @NotNull
        final RefElement myElement;

        CommentOutOfflineFix(@NotNull RefElement element) {
            if (element == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpUnusedDeclarationPresentation.getCommentOutQuickFix();
            if (string == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            if (project == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(3);
            }
            PsiElement psiElement = this.myElement.getPsiElement();
            if (this.myElement.isValid() && psiElement != null) {
                CommentOutOfflineFix.commentOutDead(psiElement);
            }
        }

        static void commentOutDead(@NotNull PsiElement psiElement) {
            Document doc;
            PsiFile psiFile;
            if (psiElement == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(4);
            }
            if ((psiFile = psiElement.getContainingFile()) != null && (doc = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(psiFile)) != null) {
                TextRange textRange = psiElement.getTextRange();
                CommentOutOfflineFix.insertOutDeadComment(doc, (Segment)TextRange.create((int)CommentOutOfflineFix.getStartOffset(doc, textRange.getStartOffset()), (int)textRange.getEndOffset()));
            }
        }

        static void attachTextRangeToComment(@NotNull PsiElement psiElement, @NotNull MultiMap<Document, SmartPsiElementPointer<?>> map) {
            Document doc;
            PsiFile psiFile;
            if (psiElement == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(5);
            }
            if (map == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(6);
            }
            if ((psiFile = psiElement.getContainingFile()) != null && (doc = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(psiFile)) != null) {
                map.putValue((Object)doc, (Object)SmartPointerManager.createPointer((PsiElement)psiElement));
            }
        }

        @Nullable
        static PsiElement getElementToComment(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(7);
            }
            if (psiElement instanceof Field || psiElement instanceof Constant) {
                return psiElement.getParent();
            }
            return psiElement;
        }

        static int getStartOffset(@NotNull Document doc, int startOffset) {
            if (doc == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(8);
            }
            CharSequence chars = doc.getCharsSequence();
            while (CharArrayUtil.regionMatches((CharSequence)chars, (int)startOffset, (CharSequence)AnalysisBundle.message((String)"inspection.dead.code.comment", (Object[])new Object[0]))) {
                int line = doc.getLineNumber(startOffset) + 1;
                if (line >= doc.getLineCount()) continue;
                startOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)doc.getLineStartOffset(line), (String)" \t");
            }
            return startOffset;
        }

        static void insertOutDeadComment(@NotNull Document doc, @NotNull Segment textRange) {
            int line2;
            if (doc == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(9);
            }
            if (textRange == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(10);
            }
            String date = ApplicationManager.getApplication().isUnitTestMode() ? "" : DateFormatUtil.formatDateTime((Date)new Date()).replaceAll("\\P{Graph}", " ");
            int startOffset = CommentOutOfflineFix.getStartOffset(doc, textRange.getStartOffset());
            int line1 = doc.getLineNumber(startOffset);
            if (line1 == (line2 = doc.getLineNumber(textRange.getEndOffset() - 1))) {
                doc.insertString(startOffset, (CharSequence)AnalysisBundle.message((String)"inspection.dead.code.date.comment", (Object[])new Object[]{date}));
            } else {
                for (int i = line1; i <= line2; ++i) {
                    doc.insertString(doc.getLineStartOffset(i), (CharSequence)"//");
                }
                doc.insertString(doc.getLineStartOffset(line1), (CharSequence)AnalysisBundle.message((String)"inspection.dead.code.start.comment", (Object[])new Object[]{date}));
                doc.insertString(doc.getLineEndOffset(Math.min(line2 + 1, doc.getLineCount() - 1)), (CharSequence)"\n");
                doc.insertString(doc.getLineEndOffset(Math.min(line2 + 2, doc.getLineCount() - 1)), (CharSequence)AnalysisBundle.message((String)"inspection.dead.code.stop.comment", (Object[])new Object[]{date}));
            }
        }

        private static void insertCommentsLazy(@NotNull MultiMap<Document, SmartPsiElementPointer<?>> textRangesToCommentMap) {
            if (textRangesToCommentMap == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(11);
            }
            for (Document document : textRangesToCommentMap.keySet()) {
                Collection textRangesToComment = textRangesToCommentMap.get((Object)document);
                SmartList pointersWithoutOverlaps = new SmartList();
                for (SmartPsiElementPointer elementPointer : textRangesToComment) {
                    PsiElement element;
                    boolean notContainsInOtherRanges;
                    Segment currentRange = elementPointer.getPsiRange();
                    if (currentRange == null || !(notContainsInOtherRanges = textRangesToComment.stream().map(SmartPsiElementPointer::getPsiRange).filter(Objects::nonNull).filter(range -> currentRange.getStartOffset() != range.getStartOffset() && currentRange.getEndOffset() != range.getEndOffset()).noneMatch(textRange -> textRange.getStartOffset() <= currentRange.getStartOffset() && textRange.getEndOffset() >= currentRange.getEndOffset())) || !((element = elementPointer.getElement()) instanceof PhpPsiElement)) continue;
                    pointersWithoutOverlaps.add(CommentOutOfflineFix.getRangeWithPhpDoc(elementPointer, element));
                }
                for (SmartPsiElementPointer pointer : pointersWithoutOverlaps) {
                    Segment currentSegment = pointer.getRange();
                    if (currentSegment == null) continue;
                    CommentOutOfflineFix.insertOutDeadComment(document, currentSegment);
                }
            }
        }

        @NotNull
        private static SmartPsiElementPointer<?> getRangeWithPhpDoc(@NotNull SmartPsiElementPointer<?> elementPointer, @NotNull PsiElement element) {
            PsiElement originalElement;
            if (elementPointer == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(12);
            }
            if (element == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(13);
            }
            if ((originalElement = CommentOutOfflineFix.getElementToComment(element)) != null) {
                PhpDocComment docComment;
                if (element instanceof PhpNamedElement && (docComment = ((PhpNamedElement)element).getDocComment()) != null) {
                    int startOffset = Math.min(docComment.getTextRange().getStartOffset(), originalElement.getTextRange().getStartOffset());
                    int endOffset = Math.max(docComment.getTextRange().getEndOffset(), originalElement.getTextRange().getEndOffset());
                    TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
                    SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiFileRangePointer(element.getContainingFile(), textRange);
                    if (smartPsiFileRange == null) {
                        CommentOutOfflineFix.$$$reportNull$$$0(14);
                    }
                    return smartPsiFileRange;
                }
                if (originalElement != element) {
                    SmartPsiFileRange smartPsiFileRange = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiFileRangePointer(element.getContainingFile(), originalElement.getTextRange());
                    if (smartPsiFileRange == null) {
                        CommentOutOfflineFix.$$$reportNull$$$0(15);
                    }
                    return smartPsiFileRange;
                }
            }
            SmartPsiElementPointer<?> smartPsiElementPointer = elementPointer;
            if (smartPsiElementPointer == null) {
                CommentOutOfflineFix.$$$reportNull$$$0(16);
            }
            return smartPsiElementPointer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 14, 15, 16 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation$CommentOutOfflineFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "doc";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRangesToCommentMap";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementPointer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation$CommentOutOfflineFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeWithPhpDoc";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "commentOutDead";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "attachTextRangeToComment";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToComment";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartOffset";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "insertOutDeadComment";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "insertCommentsLazy";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getRangeWithPhpDoc";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 14, 15, 16 -> new IllegalStateException(string);
            };
        }
    }

    private static enum UnusedDeclarationHint {
        COMMENT{

            @Override
            @NotNull
            @Nls
            public String getDescription() {
                String string = PhpBundle.message("dead.code.commented.out", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation$UnusedDeclarationHint$1", "getDescription"));
            }
        }
        ,
        DELETE{

            @Override
            @NotNull
            @Nls
            public String getDescription() {
                String string = PhpBundle.message("dead.code.deleted", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/deadcode/PhpUnusedDeclarationPresentation$UnusedDeclarationHint$2", "getDescription"));
            }
        };


        @Nls
        @NotNull
        public abstract String getDescription();
    }
}

