/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.coreDeclaration;

import com.jetbrains.php.lang.inspections.deadcode.coreDeclaration.PhpCoreHandler;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpCoreReferenceHashProvider
implements PhpCoreHandler {
    public static final String COUNT = "count";
    private static final String COUNTABLE = "Countable";
    private static final int[] ALLOWED_REF_HASHES = new int[]{16};
    private static final Set<String> ROOT_INTERFACES = Set.of("Countable");

    @Override
    public boolean accepts(@NotNull PhpPsiElement psiElement, @NotNull PhpPsiElement context) {
        if (psiElement == null) {
            PhpCoreReferenceHashProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpCoreReferenceHashProvider.$$$reportNull$$$0(1);
        }
        return (context instanceof FunctionReference || context instanceof PhpIsset || context instanceof PhpUnset) && this.getFunctionReferenceHash(context) > 0;
    }

    @Override
    public int getHash(@NotNull PhpPsiElement psiElement, @NotNull PhpPsiElement context) {
        if (psiElement == null) {
            PhpCoreReferenceHashProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PhpCoreReferenceHashProvider.$$$reportNull$$$0(3);
        }
        return this.getFunctionReferenceHash(context);
    }

    @Override
    public boolean inferImplicitlyUsages(@NotNull PhpRefClass refClass, @NotNull String methodName) {
        if (refClass == null) {
            PhpCoreReferenceHashProvider.$$$reportNull$$$0(4);
        }
        if (methodName == null) {
            PhpCoreReferenceHashProvider.$$$reportNull$$$0(5);
        }
        return this.isAllowed(refClass, ALLOWED_REF_HASHES) && refClass.isCoreInterfacesImplemented(16) && PhpCoreReferenceHashProvider.inferCountableHashUsages(methodName, refClass.getCoreMethodsReferencedFlag());
    }

    @Override
    public boolean acceptsClass(@NotNull PhpRefClass refClass) {
        if (refClass == null) {
            PhpCoreReferenceHashProvider.$$$reportNull$$$0(6);
        }
        return ROOT_INTERFACES.contains(refClass.getName());
    }

    @Override
    public int getClassHash(@NotNull PhpRefClass refClass) {
        if (refClass == null) {
            PhpCoreReferenceHashProvider.$$$reportNull$$$0(7);
        }
        return COUNTABLE.equals(refClass.getName()) ? 16 : 0;
    }

    @Override
    public boolean accepts(@NotNull PhpRefClass refClass, @NotNull PhpRefMethod refMethod) {
        if (refClass == null) {
            PhpCoreReferenceHashProvider.$$$reportNull$$$0(8);
        }
        if (refMethod == null) {
            PhpCoreReferenceHashProvider.$$$reportNull$$$0(9);
        }
        return this.isAllowed(refClass, ALLOWED_REF_HASHES) && COUNT.equals(refMethod.getName());
    }

    public static boolean inferCountableHashUsages(@NotNull String methodName, int referencesHash) {
        if (methodName == null) {
            PhpCoreReferenceHashProvider.$$$reportNull$$$0(10);
        }
        return COUNT.equals(methodName) && PhpCoreHandler.isMethodUsed(referencesHash, 8);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refMethod";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/coreDeclaration/PhpCoreReferenceHashProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accepts";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getHash";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "inferImplicitlyUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassHash";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "inferCountableHashUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

