/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.filters;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.jetbrains.php.lang.inspections.deadcode.PhpUnusedDeclarationInspection;
import com.jetbrains.php.lang.inspections.deadcode.filters.PhpStrictUnreferencedFilter;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PhpHierarchyUnreferencedFilter
extends PhpStrictUnreferencedFilter {
    @NotNull
    private static final Set<PhpRefElement> EMPTY_REF_ELEMENTS = new HashSet<PhpRefElement>();

    public PhpHierarchyUnreferencedFilter(@NotNull PhpUnusedDeclarationInspection tool, @NotNull GlobalInspectionContextImpl context) {
        if (tool == null) {
            PhpHierarchyUnreferencedFilter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpHierarchyUnreferencedFilter.$$$reportNull$$$0(1);
        }
        super(tool, (GlobalInspectionContext)context);
    }

    @Override
    public int getElementProblemCount(@NotNull PhpRefElement refElement) {
        int problemCount;
        if (refElement == null) {
            PhpHierarchyUnreferencedFilter.$$$reportNull$$$0(2);
        }
        if ((problemCount = super.getElementProblemCount(refElement)) > 0 && (refElement instanceof PhpRefClassMember || refElement instanceof PhpRefClass)) {
            Collection duplicates = refElement instanceof PhpRefClass ? ((PhpRefClass)refElement).getDuplicates() : ((PhpRefClassMember)refElement).getDuplicates();
            for (PhpRefElement duplicate : duplicates) {
                if (!PhpHierarchyUnreferencedFilter.isUsed(duplicate)) continue;
                return 0;
            }
            if (PhpHierarchyUnreferencedFilter.hasReferencedElementInHierarchy(refElement, new HashSet<PhpRefElement>())) {
                return 0;
            }
        }
        return problemCount;
    }

    private static boolean isUsed(@NotNull PhpRefElement element) {
        if (element == null) {
            PhpHierarchyUnreferencedFilter.$$$reportNull$$$0(3);
        }
        return element.isReferenced() || element.isReachable() || element.isEntry();
    }

    private static boolean hasReferencedElementInHierarchy(@NotNull PhpRefElement element, @NotNull Set<PhpRefElement> usedMembers) {
        if (element == null) {
            PhpHierarchyUnreferencedFilter.$$$reportNull$$$0(4);
        }
        if (usedMembers == null) {
            PhpHierarchyUnreferencedFilter.$$$reportNull$$$0(5);
        }
        if (usedMembers.add(element)) {
            if (PhpHierarchyUnreferencedFilter.isUsed(element)) {
                return true;
            }
            for (PhpRefElement phpRefElement : PhpHierarchyUnreferencedFilter.getHierarchyElements(element)) {
                if (!PhpHierarchyUnreferencedFilter.hasReferencedElementInHierarchy(phpRefElement, usedMembers)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Collection<? extends PhpRefElement> getHierarchyElements(@NotNull PhpRefElement element) {
        if (element == null) {
            PhpHierarchyUnreferencedFilter.$$$reportNull$$$0(6);
        }
        if (element instanceof PhpRefClassMember) {
            Collection collection = ((PhpRefClassMember)element).getSuperMembers();
            if (collection == null) {
                PhpHierarchyUnreferencedFilter.$$$reportNull$$$0(7);
            }
            return collection;
        }
        if (element instanceof PhpRefClass) {
            Set set = ((PhpRefClass)element).getSubClasses();
            if (set == null) {
                PhpHierarchyUnreferencedFilter.$$$reportNull$$$0(8);
            }
            return set;
        }
        Set<PhpRefElement> set = EMPTY_REF_ELEMENTS;
        if (set == null) {
            PhpHierarchyUnreferencedFilter.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedMembers";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/filters/PhpHierarchyUnreferencedFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/filters/PhpHierarchyUnreferencedFilter";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementProblemCount";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUsed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasReferencedElementInHierarchy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchyElements";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

