/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.exception;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConstructorCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpIncludeInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpThrowInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpEvalInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpIncludeInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInterruptibleInstructionImpl;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionDFAnalyzer;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.config.PhpAnalysisConfiguration;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpSimpleFunctionDefinedDFAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpUnitMockBuilderTP;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionsWithNotCatchedDynamicPassedCallsIndex;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExceptionAnalysisService {
    private static final Logger LOG = Logger.getInstance(PhpExceptionAnalysisService.class);
    private static final Key<ParameterizedCachedValue<Map<String, SignatureList>, PsiFile>> GIST_KEY = Key.create((String)"PhpExceptionAnalysisService.GIST_KEY");
    private static final DataExternalizer<Map<String, SignatureList>> EXTERNALIZER = new DataExternalizer<Map<String, SignatureList>>(){

        public void save(@NotNull DataOutput out, Map<String, SignatureList> value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (Map.Entry<String, SignatureList> entry : value.entrySet()) {
                out.writeUTF(entry.getKey());
                SignatureList list = entry.getValue();
                String[] exceptions = list.exceptions;
                out.writeInt(exceptions.length);
                for (String exception : exceptions) {
                    try {
                        out.writeUTF(exception);
                    }
                    catch (UTFDataFormatException e) {
                        out.writeUTF("");
                        LOG.error("Signature is too long to analyze", (Throwable)e, new Attachment[]{new Attachment("signature.txt", exception)});
                    }
                }
                Signature[] signatures = list.signatures;
                out.writeInt(signatures.length);
                for (Signature signature : signatures) {
                    1.writeTextRange(out, signature.thrownRange);
                    int[] thrownExceptions = signature.thrownExceptions;
                    out.writeInt(thrownExceptions.length);
                    for (int thrownException : thrownExceptions) {
                        out.writeInt(thrownException);
                    }
                    RangeCode[] coughExceptions = signature.coughExceptions;
                    out.writeInt(coughExceptions.length);
                    for (RangeCode coughException : coughExceptions) {
                        1.writeTextRange(out, coughException.range);
                        out.writeInt(coughException.code);
                    }
                    out.writeUTF(StringUtil.notNullize((String)signature.myData));
                    out.writeBoolean(signature.myThrownInConstructorWithConstantParameters);
                }
            }
        }

        private static void writeTextRange(@NotNull DataOutput out, @NotNull TextRange thrownRange) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(1);
            }
            if (thrownRange == null) {
                1.$$$reportNull$$$0(2);
            }
            out.writeInt(thrownRange.getStartOffset());
            out.writeInt(thrownRange.getEndOffset());
        }

        public Map<String, SignatureList> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(3);
            }
            ImmutableMap.Builder builder2 = ImmutableMap.builder();
            int valueSize = in.readInt();
            for (int i = 0; i < valueSize; ++i) {
                String name = in.readUTF();
                int exceptionsLength = in.readInt();
                String[] exceptions = ArrayUtil.newStringArray((int)exceptionsLength);
                for (int j = 0; j < exceptionsLength; ++j) {
                    exceptions[j] = in.readUTF();
                }
                int signaturesSize = in.readInt();
                Signature[] signatures = (Signature[])Signature.ARRAY_FACTORY.create(signaturesSize);
                for (int j = 0; j < signaturesSize; ++j) {
                    TextRange thrownRange = 1.readTextRange(in);
                    int thrownExceptionsLength = in.readInt();
                    int[] thrownExceptions = ArrayUtil.newIntArray((int)thrownExceptionsLength);
                    for (int k = 0; k < thrownExceptionsLength; ++k) {
                        thrownExceptions[k] = in.readInt();
                    }
                    int coughExceptionsSize = in.readInt();
                    RangeCode[] coughExceptions = (RangeCode[])RangeCode.ARRAY_FACTORY.create(coughExceptionsSize);
                    for (int k = 0; k < coughExceptionsSize; ++k) {
                        coughExceptions[k] = new RangeCode(1.readTextRange(in), in.readInt());
                    }
                    String checkedReflectionCallData = StringUtil.nullize((String)in.readUTF());
                    boolean isThrownInConstructorWithConstantParameters = in.readBoolean();
                    signatures[j] = new Signature(thrownRange, thrownExceptions, coughExceptions, checkedReflectionCallData, false, isThrownInConstructorWithConstantParameters);
                }
                builder2.put((Object)name, (Object)new SignatureList(exceptions, signatures));
            }
            return builder2.build();
        }

        @NotNull
        private static TextRange readTextRange(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(4);
            }
            TextRange textRange = TextRange.create((int)in.readInt(), (int)in.readInt());
            if (textRange == null) {
                1.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thrownRange";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$1";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readTextRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "writeTextRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readTextRange";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    };
    private static final NullableFunction<PsiFile, Map<String, SignatureList>> PROVIDER = file -> {
        HashMap<String, SignatureList> map = new HashMap<String, SignatureList>();
        if (file instanceof PhpFile) {
            map.put(file.getName(), LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)((PhpFile)file)));
            for (PhpNamedElement element : ((PhpFile)file).getTopLevelDefs().values()) {
                if (element instanceof PhpNamespace || element instanceof Function) {
                    map.put(element.getFQN(), LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)element));
                    continue;
                }
                if (!(element instanceof PhpClass)) continue;
                for (Method method : ((PhpClass)element).getOwnMethods()) {
                    if (method instanceof PhpDocMethod) continue;
                    map.put(method.getFQN(), LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)method));
                }
                StreamEx.of((Object[])((PhpClass)element).getOwnFields()).flatMap(f -> StreamEx.of((Collection)f.getPropertyHooksList())).forEach(hook -> map.put(hook.getFQN(), LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)hook)));
            }
        }
        return map;
    };
    private static final PsiFileGist<Map<String, SignatureList>> GIST = GistManager.getInstance().newPsiFileGist("PhpExceptionAnalysisService.GIST", 16, EXTERNALIZER, PROVIDER);
    private static final RecursionGuard<PhpScopeHolder> GUARD = RecursionManager.createGuard((String)"PhpExceptionAnalysisService.GUARD");
    private static final Int2ObjectMap<Key<CachedValue<Set<PhpThrownExceptionItem>>>> KEY_MAP;
    private static final String DEPTH_EXCEEDED = "#DEPTH_EXCEEDED#";
    private static final String REFLECTION_CLASS_FQN = "\\ReflectionClass";

    @NotNull
    public static Set<Pair<TextRange, String>> getThrownExceptionsWithRanges(@NotNull PhpScopeHolder scope, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(0);
        }
        HashSet<Pair<TextRange, String>> exceptions = new HashSet<Pair<TextRange, String>>();
        PhpThrownExceptionItemCollector collector = PhpThrownExceptionItemCollector.create((range, exception) -> exceptions.add(Pair.create((Object)range, (Object)exception)));
        PhpExceptionAnalysisService.collectThrownExceptions(collector, scope, 0, thrownRange, coughRange, strictThrownRangeComparison);
        HashSet<Pair<TextRange, String>> hashSet = exceptions;
        if (hashSet == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public static Set<PhpThrownExceptionItem> getThrownExceptions(@NotNull PhpScopeHolder scope, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(2);
        }
        return PhpExceptionAnalysisService.getThrownExceptions(scope, 0, thrownRange, coughRange, strictThrownRangeComparison);
    }

    @NotNull
    private static Set<PhpThrownExceptionItem> getThrownExceptions(@NotNull PhpScopeHolder scopeHolder, int level, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scopeHolder == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(3);
        }
        if (scopeHolder instanceof PhpDocMethod || GUARD.currentStack().contains(scopeHolder)) {
            Set<PhpThrownExceptionItem> set = Collections.emptySet();
            if (set == null) {
                PhpExceptionAnalysisService.$$$reportNull$$$0(4);
            }
            return set;
        }
        if (thrownRange != null || coughRange != null) {
            return PhpExceptionAnalysisService.getPreventingRecursion(scopeHolder, level, thrownRange, coughRange, strictThrownRangeComparison);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)scopeHolder.getProject()).getCachedValue((UserDataHolder)scopeHolder, (Key)KEY_MAP.get(level), () -> {
            Set<PhpThrownExceptionItem> exceptions = PhpExceptionAnalysisService.getPreventingRecursion(scopeHolder, level, null, null, false);
            return CachedValueProvider.Result.create(exceptions, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, PhpAnalysisConfiguration.getInstance(scopeHolder.getProject()).getTreeAnalysisDepthModificationTracker()});
        }, false);
        if (set == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    private static Set<PhpThrownExceptionItem> getPreventingRecursion(@NotNull PhpScopeHolder scope, int level, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(6);
        }
        Set set = (Set)GUARD.doPreventingRecursion((Object)scope, false, () -> {
            final HashSet exceptions = new HashSet();
            PhpThrownExceptionItemCollector collector = new PhpThrownExceptionItemCollector(){

                @Override
                public void accept(TextRange range, String exception, boolean ambiguous, boolean isThrownInConstructorWithConstantParameters) {
                    exceptions.add(ambiguous ? new PhpThrownExceptionItem(PhpType.EMPTY, range, true, isThrownInConstructorWithConstantParameters) : new PhpThrownExceptionItem(exception, range, false, isThrownInConstructorWithConstantParameters));
                }
            };
            PhpExceptionAnalysisService.collectThrownExceptions(collector, scope, level, thrownRange, coughRange, strictThrownRangeComparison);
            return !exceptions.isEmpty() ? exceptions : Collections.emptySet();
        });
        if (set == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static void collectThrownExceptions(PhpThrownExceptionItemCollector collector, @NotNull PhpScopeHolder scope, int level, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(8);
        }
        int depth = PhpAnalysisConfiguration.getInstance(scope.getProject()).getCallTreeAnalysisDepth();
        SignatureList list = PhpExceptionAnalysisService.loadSignatures(scope);
        Project project = scope.getProject();
        PhpIndex index = PhpIndex.getInstance((Project)project);
        for (Signature signature : list.signatures) {
            if (thrownRange != null && (strictThrownRangeComparison && !thrownRange.equals((Object)signature.thrownRange) || !strictThrownRangeComparison && !thrownRange.contains(signature.thrownRange))) continue;
            boolean resolved = false;
            for (int thrownExceptionCode : signature.thrownExceptions) {
                boolean isRethrownException;
                String thrownException = list.exceptions[thrownExceptionCode];
                if (StringUtil.endsWith((CharSequence)thrownException, (CharSequence)".__construct")) {
                    resolved = true;
                }
                if (thrownException.length() < 5 || thrownException.charAt(2) != '?') {
                    resolved = true;
                    PhpExceptionAnalysisService.addIfNotCaught(collector, thrownException, signature, project, coughRange, list);
                    continue;
                }
                String kind = thrownException.substring(0, 2);
                String reference = thrownException.substring(3);
                boolean bl = isRethrownException = LocalControlFlowProcessor.SignatureKind.getKindFromData(signature.myData) == LocalControlFlowProcessor.SignatureKind.RETHROWN_EXCEPTION;
                if (level < depth || !"#C".equals(kind) || isRethrownException) {
                    Collection<? extends PhpNamedElement> elements = PhpExceptionAnalysisService.getBySignature(reference, index);
                    if (isRethrownException && (level >= depth || elements.isEmpty())) {
                        elements = LocalControlFlowProcessor.SignatureKind.exceptionsFromCatchClause(list, signature.myData).flatMap(s -> index.getAnyByFQN(s).stream()).toList();
                    }
                    for (PhpNamedElement phpNamedElement : elements) {
                        resolved = true;
                        if (phpNamedElement instanceof PhpClass) {
                            PhpExceptionAnalysisService.addIfNotCaught(collector, phpNamedElement.getFQN(), signature, project, coughRange, list);
                        }
                        if (!(phpNamedElement instanceof Function)) continue;
                        if ("#T".equals(kind)) {
                            for (String type : new PhpType().add(reference).global(project).getTypes()) {
                                PhpExceptionAnalysisService.addIfNotCaught(collector, type, signature, project, coughRange, list);
                            }
                            continue;
                        }
                        if (!"#C".equals(kind)) continue;
                        List<PhpDocTag> tags = PhpDocUtil.collectTagsConsideringInheritance((Function)phpNamedElement, "@throws");
                        Set docExceptions = StreamEx.of(tags).map(PhpTypedElement::getType).flatCollection(PhpType::getTypes).toSet();
                        if (!docExceptions.isEmpty()) {
                            for (String type : docExceptions) {
                                for (String globalType : PhpExceptionAnalysisService.global(type, (PsiElement)phpNamedElement)) {
                                    PhpExceptionAnalysisService.addIfNotCaught(collector, globalType, signature, project, coughRange, list);
                                }
                            }
                            continue;
                        }
                        PhpScopeHolder newScope = (PhpScopeHolder)phpNamedElement;
                        for (PhpThrownExceptionItem e : PhpExceptionAnalysisService.getThrownExceptions(newScope, level + 1, null, null, strictThrownRangeComparison)) {
                            for (String type : e.getException().getTypes()) {
                                if (type.equals(DEPTH_EXCEEDED)) {
                                    if (!isRethrownException) continue;
                                    LocalControlFlowProcessor.SignatureKind.exceptionsFromCatchClause(list, signature.myData).forEach(s -> PhpExceptionAnalysisService.addIfNotCaught(collector, s, signature, project, coughRange, list));
                                    continue;
                                }
                                PhpExceptionAnalysisService.addIfNotCaught(collector, type, signature, project, coughRange, list);
                            }
                        }
                    }
                    continue;
                }
                PhpExceptionAnalysisService.addIfNotCaught(collector, DEPTH_EXCEEDED, signature, project, coughRange, list);
            }
            if (resolved && !signature.isAmbiguous()) continue;
            RangeCode[] exceptions = signature.coughExceptions;
            if (thrownRange == null || exceptions.length == 0) {
                collector.accept(signature.thrownRange, null, true, signature.myThrownInConstructorWithConstantParameters);
            }
            if (thrownRange == null) continue;
            for (RangeCode coughException : exceptions) {
                if (coughRange == null || !thrownRange.equals((Object)coughRange)) continue;
                collector.accept(signature.thrownRange, list.exceptions[coughException.code], false, signature.myThrownInConstructorWithConstantParameters);
            }
        }
    }

    @NotNull
    private static Collection<? extends PhpNamedElement> getBySignature(@NotNull String reference, @NotNull PhpIndex index) {
        if (reference == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(9);
        }
        if (index == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(10);
        }
        if (reference.indexOf(124) > 0) {
            HashSet result = new HashSet();
            for (String signature : reference.split("\\|")) {
                result.addAll(index.getBySignature(signature));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                PhpExceptionAnalysisService.$$$reportNull$$$0(11);
            }
            return hashSet;
        }
        Collection collection = index.getBySignature(reference);
        if (collection == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    private static Set<String> global(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(14);
        }
        Set set = new PhpType().add(type).globalLocationAware(context).getTypes();
        if (set == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(15);
        }
        return set;
    }

    private static void addIfNotCaught(@NotNull PhpThrownExceptionItemCollector collector, @NotNull String exception, @NotNull Signature signature, @NotNull Project project, @Nullable TextRange coughRange, @NotNull SignatureList list) {
        LocalControlFlowProcessor.SignatureKind kind;
        if (collector == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(16);
        }
        if (exception == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(17);
        }
        if (signature == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(18);
        }
        if (project == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(19);
        }
        if (list == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(20);
        }
        if (signature.myData != null && (kind = LocalControlFlowProcessor.SignatureKind.getKindFromData(signature.myData)) != null && (exception = kind.completeException(project, signature, list, exception)) == null) {
            return;
        }
        PhpIndex index = PhpIndex.getInstance((Project)project);
        for (RangeCode coughException : signature.coughExceptions) {
            if (coughRange != null && !coughRange.contains(coughException.range) || !PhpType.findSuper((String)list.exceptions[coughException.code], (String)exception, (PhpIndex)index)) continue;
            return;
        }
        collector.accept(signature.thrownRange, exception, false, signature.myThrownInConstructorWithConstantParameters);
    }

    private static SignatureList loadSignatures(@NotNull PhpScopeHolder scope) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(21);
        }
        if (scope instanceof Function && ((Function)scope).isClosure()) {
            return LocalControlFlowProcessor.calculateSignatures(scope);
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)scope.getProject());
        PsiFile containingFile = scope.getContainingFile();
        Map data = (Map)manager.getParameterizedCachedValue((UserDataHolder)containingFile, GIST_KEY, file -> CachedValueProvider.Result.create((Object)((Map)GIST.getFileData(file)), (Object[])new Object[]{file}), false, (Object)containingFile);
        return data.getOrDefault(scope instanceof PhpNamedElement ? ((PhpNamedElement)scope).getFQN() : scope.getName(), SignatureList.EMPTY);
    }

    public static boolean shouldSkipConstructorWithConstantArguments(NewExpression newExpression) {
        return PhpExceptionAnalysisService.getSkipConstantParams((PsiElement)newExpression) && PhpExceptionAnalysisService.isConstructorHaveConstantArguments(newExpression);
    }

    public static boolean getSkipConstantParams(PsiElement element) {
        return PhpAnalysisConfiguration.getInstance(element.getProject()).getSkipConstantParams();
    }

    public static boolean isConstructorHaveConstantArguments(NewExpression newExpression) {
        return ContainerUtil.and((Object[])newExpression.getParameters(), it -> it instanceof StringLiteralExpression || it instanceof ClassConstantReference || it instanceof ConstantReference);
    }

    private static boolean processReachabilityWithArgumentInfos(PhpInstruction instruction, final List<@NotNull PhpStateArgumentInfo> argumentInfos, final PhpReachingDefinitionsDFAnalyzer analyzer) {
        final Set dependencies = argumentInfos.stream().flatMap(i -> i.getStateDependenciesCheckers(false).stream()).collect(Collectors.toSet());
        final Ref canBeDefined = new Ref((Object)false);
        final Ref canBeUndefined = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors(instruction, false, new PhpInstructionProcessor(){

            public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                return ((PhpReachingDefinitionsDFAnalyzer.Result)analyzer.performDFA(instruction)).apply(PhpExceptionAnalysisService.joinArgumentsNames(argumentInfos), (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
            }

            public boolean processInstruction(PhpInstruction instruction) {
                if (PhpPreviousDfaAnalyzerProcessor.dependenciesMayBeInvalidated(instruction, dependencies, false)) {
                    canBeUndefined.set((Object)true);
                }
                return super.processInstruction(instruction);
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                canBeUndefined.set((Object)true);
                return super.processEntryPointInstruction(instruction);
            }
        });
        return (Boolean)canBeDefined.get() != false && (Boolean)canBeUndefined.get() == false;
    }

    @NotNull
    private static String joinArgumentsNames(List<@NotNull PhpStateArgumentInfo> info) {
        String string = StringUtil.join(info, PhpStateArgumentInfo::getArgumentName, (String)"|");
        if (string == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(22);
        }
        return string;
    }

    static {
        int depth = 3;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap(depth);
        for (int i = 0; i <= depth; ++i) {
            map.put(i, (Object)Key.create((String)("PhpExceptionAnalysisService.KEY.LEVEL" + i)));
        }
        KEY_MAP = map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 7, 11, 12, 15, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptionsWithRanges";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreventingRecursion";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBySignature";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "global";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "joinArgumentsNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptionsWithRanges";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 22: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPreventingRecursion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectThrownExceptions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBySignature";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "global";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotCaught";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadSignatures";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 7, 11, 12, 15, 22 -> new IllegalStateException(string);
        };
    }

    private static abstract class PhpThrownExceptionItemCollector
    implements BiConsumer<TextRange, String> {
        private PhpThrownExceptionItemCollector() {
        }

        @Override
        public void accept(TextRange range, String exception) {
            this.accept(range, exception, false, false);
        }

        public abstract void accept(TextRange var1, String var2, boolean var3, boolean var4);

        public static PhpThrownExceptionItemCollector create(final BiConsumer<TextRange, String> consumer) {
            return new PhpThrownExceptionItemCollector(){

                @Override
                public void accept(TextRange range, String exception, boolean ambiguous, boolean isThrownInConstructorWithConstantParameters) {
                    consumer.accept(range, exception);
                }
            };
        }
    }

    private static final class SignatureList {
        private static final SignatureList EMPTY = new SignatureList(ArrayUtilRt.EMPTY_STRING_ARRAY, Signature.EMPTY_ARRAY);
        private final String[] exceptions;
        private final Signature[] signatures;

        private SignatureList(String @NotNull [] exceptions, Signature @NotNull [] signatures) {
            if (exceptions == null) {
                SignatureList.$$$reportNull$$$0(0);
            }
            if (signatures == null) {
                SignatureList.$$$reportNull$$$0(1);
            }
            this.exceptions = exceptions;
            this.signatures = signatures;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exceptions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "signatures";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$SignatureList";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Signature {
        private static final Signature[] EMPTY_ARRAY = new Signature[0];
        private static final ArrayFactory<Signature> ARRAY_FACTORY = size -> size == 0 ? EMPTY_ARRAY : new Signature[size];
        private final TextRange thrownRange;
        private final int[] thrownExceptions;
        private final RangeCode[] coughExceptions;
        @Nullable
        private final String myData;
        private final boolean myAbmiguous;
        private final boolean myThrownInConstructorWithConstantParameters;

        private Signature(@NotNull TextRange thrownRange, int @NotNull [] thrownExceptions, RangeCode @NotNull [] coughExceptions, @Nullable String data) {
            if (thrownRange == null) {
                Signature.$$$reportNull$$$0(0);
            }
            if (thrownExceptions == null) {
                Signature.$$$reportNull$$$0(1);
            }
            if (coughExceptions == null) {
                Signature.$$$reportNull$$$0(2);
            }
            this(thrownRange, thrownExceptions, coughExceptions, data, false);
        }

        private Signature(@NotNull TextRange thrownRange, int @NotNull [] thrownExceptions, RangeCode @NotNull [] coughExceptions, @Nullable String data, boolean ambiguous) {
            if (thrownRange == null) {
                Signature.$$$reportNull$$$0(3);
            }
            if (thrownExceptions == null) {
                Signature.$$$reportNull$$$0(4);
            }
            if (coughExceptions == null) {
                Signature.$$$reportNull$$$0(5);
            }
            this(thrownRange, thrownExceptions, coughExceptions, data, ambiguous, false);
        }

        private Signature(@NotNull TextRange thrownRange, int @NotNull [] thrownExceptions, RangeCode @NotNull [] coughExceptions, @Nullable String data, boolean ambiguous, boolean thrownInConstructorWithConstantParameters) {
            if (thrownRange == null) {
                Signature.$$$reportNull$$$0(6);
            }
            if (thrownExceptions == null) {
                Signature.$$$reportNull$$$0(7);
            }
            if (coughExceptions == null) {
                Signature.$$$reportNull$$$0(8);
            }
            this.thrownRange = thrownRange;
            this.thrownExceptions = thrownExceptions;
            this.coughExceptions = coughExceptions;
            this.myData = data;
            this.myAbmiguous = ambiguous;
            this.myThrownInConstructorWithConstantParameters = thrownInConstructorWithConstantParameters;
        }

        private Signature(@NotNull TextRange thrownRange, int @NotNull [] thrownExceptions, RangeCode @NotNull [] coughExceptions) {
            if (thrownRange == null) {
                Signature.$$$reportNull$$$0(9);
            }
            if (thrownExceptions == null) {
                Signature.$$$reportNull$$$0(10);
            }
            if (coughExceptions == null) {
                Signature.$$$reportNull$$$0(11);
            }
            this(thrownRange, thrownExceptions, coughExceptions, null);
        }

        public boolean isAmbiguous() {
            return this.myAbmiguous;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thrownRange";
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thrownExceptions";
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[0] = "coughExceptions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$Signature";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static final class LocalControlFlowProcessor
    extends PhpInstructionProcessor {
        private static final String THROW = "#T";
        private static final String CALL = "#C";
        private static final char SEPARATOR = '?';
        private static final String RETHROWN_EXCEPTIONS_SEPARATOR = ",";
        private static final int[] EMPTY_EXCEPTION = new int[0];
        private final Object2IntMap<String> exceptions;
        private final List<Signature> signatures = new ArrayList<Signature>();
        private final Collection<PhpRethrownException> myRethrownExceptions = new ArrayList<PhpRethrownException>();
        private static final Map<String, String[]> REFLECTION_EXISTENCE_CHECKERS = Map.of("\\ReflectionClass", new String[]{"class_exists", "trait_exists", "interface_exists", "enum_exists"}, "\\ReflectionEnum", new String[]{"enum_exists"}, "\\ReflectionMethod", new String[]{"method_exists"}, "\\ReflectionProperty", new String[]{"property_exists"}, "\\ReflectionException", new String[]{"class_exists"}, "\\ReflectionFunction", new String[]{"function_exists"}, "\\ReflectionClassConstant", new String[]{"defined"});

        private LocalControlFlowProcessor(Object2IntMap<String> exceptions) {
            this.exceptions = exceptions;
        }

        @NotNull
        private static SignatureList calculateSignatures(@NotNull PhpScopeHolder scope) {
            if (scope == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(0);
            }
            return LocalControlFlowProcessor.calculateSignatures(scope, (Object2IntMap<String>)new Object2IntOpenHashMap());
        }

        @NotNull
        private static SignatureList calculateSignatures(@NotNull PhpScopeHolder scope, Object2IntMap<String> exceptions) {
            if (scope == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(1);
            }
            LocalControlFlowProcessor processor2 = new LocalControlFlowProcessor(exceptions);
            PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)scope.getControlFlow().getExitPoint(), false, processor2);
            processor2.signatures.addAll(LocalControlFlowProcessor.getRethrownExceptionsSignatures(processor2));
            return new SignatureList(LocalControlFlowProcessor.toArray(processor2.exceptions), (Signature[])ContainerUtil.toArray(processor2.signatures, Signature.ARRAY_FACTORY));
        }

        @NotNull
        private static Collection<Signature> getRethrownExceptionsSignatures(LocalControlFlowProcessor processor2) {
            ArrayList<Signature> rethrownExceptionsSignatures = new ArrayList<Signature>();
            for (PhpRethrownException rethrownException : processor2.myRethrownExceptions) {
                IntSet rethrownExceptions = LocalControlFlowProcessor.getRethrownExceptions(processor2, rethrownException);
                Signature originalSignature = rethrownException.mySignature;
                if (!rethrownExceptions.isEmpty()) {
                    rethrownExceptionsSignatures.add(new Signature(originalSignature.thrownRange, rethrownExceptions.toIntArray(), originalSignature.coughExceptions, SignatureKind.RETHROWN_EXCEPTION.sign(StringUtil.join((int[])originalSignature.thrownExceptions, (String)RETHROWN_EXCEPTIONS_SEPARATOR))));
                    continue;
                }
                rethrownExceptionsSignatures.add(originalSignature);
            }
            ArrayList<Signature> arrayList = rethrownExceptionsSignatures;
            if (arrayList == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @NotNull
        private static IntSet getRethrownExceptions(LocalControlFlowProcessor processor2, PhpRethrownException rethrownException) {
            IntOpenHashSet rethrownExceptions = new IntOpenHashSet();
            for (Signature signature : processor2.signatures) {
                if (!rethrownException.myTryRange.contains(signature.thrownRange)) continue;
                rethrownExceptions.addAll((IntCollection)IntArrayList.wrap((int[])signature.thrownExceptions));
            }
            IntOpenHashSet intOpenHashSet = rethrownExceptions;
            if (intOpenHashSet == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(3);
            }
            return intOpenHashSet;
        }

        private static String @NotNull [] toArray(@NotNull Object2IntMap<String> exceptions) {
            if (exceptions == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(4);
            }
            String[] array = ArrayUtil.newStringArray((int)exceptions.size());
            for (Object2IntMap.Entry entry : exceptions.object2IntEntrySet()) {
                array[entry.getIntValue()] = (String)entry.getKey();
            }
            if (array == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(5);
            }
            return array;
        }

        public boolean processThrowInstruction(PhpThrowInstruction instruction) {
            Set types;
            TextRange thrownRange = instruction.getThrowExpression().getTextRange();
            PhpExpression argument = (PhpExpression)instruction.getArgument();
            if (argument instanceof NewExpression) {
                ClassReference thrownException = ((NewExpression)argument).getClassReference();
                if (thrownException != null) {
                    PhpPsiElement firstChild = thrownException.getFirstPsiChild();
                    IntSet thrownExceptionsCodes = this.getThrownExceptionCodes((PsiElement)firstChild, thrownException.resolveLocalType().getTypes());
                    this.addSignatureRethrownAware(instruction, thrownRange, (PsiElement)firstChild, thrownExceptionsCodes);
                }
            } else if (argument instanceof FunctionReference || argument instanceof Variable) {
                Set<String> types2 = ((PhpReference)argument).resolveLocalType().getTypes().stream().filter(Predicates.not(PhpType::isNull)).collect(Collectors.toSet());
                if (types2.isEmpty()) {
                    Collection exceptions = ((PhpReference)argument).getSignatureParts();
                    int[] thrownExceptions = new int[exceptions.size()];
                    int i = 0;
                    for (String exception : exceptions) {
                        thrownExceptions[i++] = this.getCode("#T?" + exception);
                    }
                    this.signatures.add(new Signature(thrownRange, thrownExceptions, this.getCoughExceptions(instruction.getCatchTargets())));
                } else {
                    IntSet thrownExceptions = this.getThrownExceptionCodes((PsiElement)argument, types2);
                    if (!thrownExceptions.isEmpty()) {
                        this.addSignatureRethrownAware(instruction, thrownRange, (PsiElement)argument, thrownExceptions);
                    }
                }
            } else if (argument != null && !(types = argument.getType().getTypes()).isEmpty()) {
                IntOpenHashSet thrownExceptions = new IntOpenHashSet();
                for (String exception : types) {
                    if (PhpType.isUnresolved((String)exception)) {
                        thrownExceptions.add(this.getCode("#T?" + exception));
                        continue;
                    }
                    thrownExceptions.add(this.getCode(exception));
                }
                this.signatures.add(new Signature(thrownRange, thrownExceptions.toIntArray(), this.getCoughExceptions(instruction.getCatchTargets())));
            }
            return true;
        }

        @NotNull
        public IntSet getThrownExceptionCodes(PsiElement argument, Set<String> types) {
            IntOpenHashSet thrownExceptions = new IntOpenHashSet();
            for (String exception : types) {
                if (argument instanceof Variable && types.size() > 1 && "\\Exception".equals(exception) && ((Variable)argument).resolveLocal().stream().anyMatch(v -> v.getParent() instanceof Catch)) continue;
                if (PhpType.isUnresolved((String)exception)) {
                    thrownExceptions.add(this.getCode("#T?" + exception));
                    continue;
                }
                thrownExceptions.add(this.getCode(exception));
            }
            IntOpenHashSet intOpenHashSet = thrownExceptions;
            if (intOpenHashSet == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(6);
            }
            return intOpenHashSet;
        }

        public void addSignatureRethrownAware(PhpThrowInstruction instruction, TextRange thrownRange, PsiElement argument, IntSet thrownExceptions) {
            Signature signature = new Signature(thrownRange, thrownExceptions.toIntArray(), this.getCoughExceptions(instruction.getCatchTargets()));
            PhpRethrownException rethrownException = LocalControlFlowProcessor.getRethrownException(argument, signature);
            if (rethrownException != null) {
                this.myRethrownExceptions.add(rethrownException);
            } else {
                this.signatures.add(signature);
            }
        }

        private static PhpRethrownException getRethrownException(PsiElement throwExceptionArgument, Signature originalSignature) {
            Try aTry;
            Collection resolvedElements;
            if (throwExceptionArgument instanceof Variable && !(resolvedElements = ((Variable)throwExceptionArgument).resolveLocal()).isEmpty() && resolvedElements.stream().allMatch(v -> v.getParent() instanceof Catch) && (aTry = (Try)ObjectUtils.tryCast((Object)((PhpNamedElement)ContainerUtil.getFirstItem((Collection)resolvedElements)).getParent().getParent(), Try.class)) != null) {
                return new PhpRethrownException(originalSignature, aTry.getTextRange());
            }
            return null;
        }

        public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
            Function closure;
            if (!instruction.getAccess().isWrite()) {
                return true;
            }
            PsiElement value = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
            Function function = closure = PhpPsiUtil.isOfType(value, PhpElementTypes.CLOSURE) ? (Function)PhpPsiUtil.getChildByCondition(value, (Condition<? super PsiElement>)Function.INSTANCEOF) : null;
            if (closure == null) {
                return true;
            }
            Signature[] closureSignatures = LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)closure, this.exceptions).signatures;
            if (closureSignatures.length == 0) {
                return true;
            }
            this.processSuccessorUsagesOfVariable(instruction, closureSignatures, this.signatures);
            return super.processAccessVariableInstruction(instruction);
        }

        public void processSuccessorUsagesOfVariable(PhpAccessVariableInstruction instruction, final Signature[] closureSignatures, final List<Signature> originalSignatures) {
            final CharSequence variableName = instruction.getVariableName();
            PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                    FunctionReference functionReference = instruction.getFunctionReference();
                    RangeCode[] coughExceptionsOnUsageCallSite = this.getCoughExceptions(instruction.getCatchTargets());
                    if (functionReference.getNameNode() == null) {
                        this.processDynamicCall(functionReference, coughExceptionsOnUsageCallSite);
                        return true;
                    }
                    this.processPassedFunctionAcceptingClosure(functionReference, coughExceptionsOnUsageCallSite);
                    return super.processPhpCallInstruction(instruction);
                }

                public void processDynamicCall(FunctionReference functionReference, RangeCode[] coughExceptions) {
                    Variable variable = (Variable)ObjectUtils.tryCast((Object)functionReference.getFirstPsiChild(), Variable.class);
                    if (variable != null && PhpLangUtil.equalsVariableNames(variable.getName(), variableName)) {
                        for (Signature signature : closureSignatures) {
                            originalSignatures.add(new Signature(signature.thrownRange, signature.thrownExceptions, coughExceptions, signature.myData));
                        }
                    }
                }

                public void processPassedFunctionAcceptingClosure(FunctionReference functionReference, RangeCode[] coughExceptions) {
                    int paramIndex = LocalControlFlowProcessor.findParameterIndexWithName(functionReference, variableName);
                    if (paramIndex >= 0) {
                        for (Signature signature : closureSignatures) {
                            originalSignatures.add(LocalControlFlowProcessor.createFunctionAcceptingClosureSignature(coughExceptions, functionReference.getSignature(), paramIndex, signature));
                        }
                    }
                }

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName)) {
                        return true;
                    }
                    return !instruction.getAccess().isWrite();
                }
            });
        }

        private static int findParameterIndexWithName(FunctionReference functionReference, CharSequence variableName) {
            PsiElement[] parameters = functionReference.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (!(parameters[i] instanceof Variable) || !PhpLangUtil.equalsVariableNames(((Variable)parameters[i]).getName(), variableName)) continue;
                return i;
            }
            return -1;
        }

        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
            FunctionReference functionReference = instruction.getFunctionReference();
            if (PhpLangUtil.equalsFunctionNames(functionReference.getName(), "call_user_func")) {
                this.addAmbiguousInstruction((PhpInstruction)instruction, instruction.getCatchTargets());
                return true;
            }
            TextRange thrownRange = functionReference.getTextRange();
            Collection exceptions = functionReference.getSignatureParts();
            int size = exceptions.size();
            List<String> customException = LocalControlFlowProcessor.getCustomExceptions(functionReference);
            int[] thrownExceptions = new int[size + customException.size()];
            int i = 0;
            for (String exception : exceptions) {
                thrownExceptions[i++] = this.getCode("#C?" + exception);
            }
            for (i = size; i < thrownExceptions.length; ++i) {
                thrownExceptions[i] = this.getCode(customException.get(i - size));
            }
            RangeCode[] coughExceptions = this.getCoughExceptions(instruction.getCatchTargets());
            String checkedReflectionData = LocalControlFlowProcessor.getClassSignatureIfCheckedReflectionCall(instruction, functionReference);
            this.signatures.add(new Signature(thrownRange, thrownExceptions, coughExceptions, checkedReflectionData));
            this.signaturesFromClosureArguments(functionReference, functionReference.getSignature(), coughExceptions).forEach(this.signatures::add);
            return true;
        }

        public boolean processIncludeInstruction(PhpIncludeInstruction instruction) {
            this.addAmbiguousInstruction((PhpIncludeInstructionImpl)instruction);
            return super.processIncludeInstruction(instruction);
        }

        public boolean processInstruction(PhpInstruction instruction) {
            if (instruction instanceof PhpEvalInstructionImpl) {
                this.addAmbiguousInstruction((PhpEvalInstructionImpl)instruction);
            }
            return super.processInstruction(instruction);
        }

        private void addAmbiguousInstruction(PhpInterruptibleInstructionImpl instruction) {
            this.addAmbiguousInstruction(instruction, instruction.getCatchTargets());
        }

        private void addAmbiguousInstruction(PhpInstruction instruction, @NotNull List<PhpHostInstruction> targets) {
            PsiElement anchor;
            if (targets == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(7);
            }
            if ((anchor = instruction.getAnchor()) != null) {
                this.signatures.add(new Signature(anchor.getTextRange(), EMPTY_EXCEPTION, this.getCoughExceptions(targets), null, true));
            }
        }

        @NotNull
        private StreamEx<Signature> signaturesFromClosureArguments(FunctionReference functionReference, String functionSignature, RangeCode[] coughExceptions) {
            StreamEx streamEx = ((StreamEx)StreamEx.of((Object[])functionReference.getParameters()).filter(parameter -> parameter instanceof PhpExpression && PhpPsiUtil.isOfType(parameter, PhpElementTypes.CLOSURE))).flatMap(parameter -> this.signaturesFromPassedClosures((PsiElement)parameter, coughExceptions, functionSignature));
            if (streamEx == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(8);
            }
            return streamEx;
        }

        private Stream<Signature> signaturesFromPassedClosures(PsiElement parameter, RangeCode[] coughExceptions, String functionSignature) {
            Function closure = (Function)ObjectUtils.tryCast((Object)((PhpExpression)parameter).getFirstPsiChild(), Function.class);
            if (closure == null) {
                return Stream.empty();
            }
            int index = PhpCodeInsightUtil.getParameterIndex(parameter);
            if (index < 0) {
                return Stream.empty();
            }
            return Arrays.stream(LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)closure, this.exceptions).signatures).map(signature -> LocalControlFlowProcessor.createFunctionAcceptingClosureSignature(coughExceptions, functionSignature, index, signature));
        }

        @NotNull
        private static Signature createFunctionAcceptingClosureSignature(RangeCode[] coughExceptions, String functionSignature, int parameterIndex, Signature originalSignature) {
            return new Signature(originalSignature.thrownRange, originalSignature.thrownExceptions, (RangeCode[])ArrayUtil.mergeArrays((Object[])originalSignature.coughExceptions, (Object[])coughExceptions), SignatureKind.FUNCTION_ACCEPTING_CLOSURE.sign(functionSignature + "." + parameterIndex));
        }

        @Nullable
        private static String getClassSignatureIfCheckedReflectionCall(PhpCallInstruction instruction, FunctionReference functionReference) {
            if (functionReference instanceof MethodReference) {
                PhpExpression classReference = ((MethodReference)functionReference).getClassReference();
                String name = functionReference.getName();
                if (classReference instanceof Variable && (PhpLangUtil.equalsMethodNames(name, "getMethod") || PhpLangUtil.equalsMethodNames(name, "getProperty"))) {
                    String classTypes;
                    String memberName;
                    if (LocalControlFlowProcessor.isCheckerReflectionCall(instruction, functionReference, (Variable)classReference)) {
                        return SignatureKind.CHECKED_REFLECTION_CALL.sign(((PhpReference)classReference).getSignature());
                    }
                    StringLiteralExpression memberNamePSI = (StringLiteralExpression)ObjectUtils.tryCast((Object)functionReference.getParameter(0), StringLiteralExpression.class);
                    String string = memberName = memberNamePSI != null ? memberNamePSI.getContents() : null;
                    if (memberName != null && !(classTypes = StreamEx.of((Collection)((Variable)classReference).resolveLocal()).map(PsiElement::getParent).select(AssignmentExpression.class).map(AssignmentExpression::getValue).select(NewExpression.class).map(ctor -> ctor.getParameter(0)).select(PhpTypedElement.class).flatMap(LocalControlFlowProcessor::classFqns).joining((CharSequence)"@@")).isEmpty()) {
                        String classReferenceSignature = SignatureKind.CHECKED_REFLECTION_CALL.sign(((PhpReference)classReference).getSignature());
                        String signature = memberName + "." + classTypes + classReferenceSignature;
                        if (PhpLangUtil.equalsMethodNames(name, "getMethod")) {
                            return SignatureKind.REFLECTION_GET_METHOD_FROM_REAL_CLASS.sign(signature);
                        }
                        return SignatureKind.REFLECTION_GET_PROPERTY_FROM_REAL_CLASS.sign(signature);
                    }
                } else if (classReference instanceof Variable && PhpLangUtil.equalsMethodNames(name, "getDefaultValue") && LocalControlFlowProcessor.isOptionalCheckReachable(instruction, (Variable)classReference)) {
                    return SignatureKind.CHECKED_PARAMETER_REFLECTION_CALL.sign(((Variable)classReference).getSignature());
                }
            }
            return null;
        }

        private static boolean isOptionalCheckReachable(PhpCallInstruction instruction, Variable reference) {
            PhpStateArgumentInfo info = PhpStateArgumentInfo.tryCreateInfo((PsiElement)reference, false);
            if (info == null) {
                return false;
            }
            return PhpExceptionAnalysisService.processReachabilityWithArgumentInfos((PhpInstruction)instruction, Collections.singletonList(info), new PhpReflectorExistenceDFAnalyzer(new String[]{"isDefaultValueAvailable"}){

                @Override
                protected boolean isSuitableFunctionReference(@NotNull FunctionReference condition) {
                    if (condition == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return condition instanceof MethodReference;
                }

                @Override
                @Nullable
                protected String getParameterStringRepresentation(@NotNull FunctionReference functionReference) {
                    if (functionReference == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return this.toString((PsiElement)((MethodReference)functionReference).getClassReference());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "condition";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "functionReference";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSuitableFunctionReference";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getParameterStringRepresentation";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static Stream<String> classFqns(PhpTypedElement p) {
            String signature = PhpUnitMockBuilderTP.getParameterSignature((PsiElement)p);
            return signature != null ? Stream.of(signature) : p.getType().getTypes().stream();
        }

        @Nullable
        private static String getClassSignatureIfCheckedReflectionCall(NewExpression expression) {
            PhpType type;
            ClassReference reference = expression.getClassReference();
            if (reference == null || !PhpLangUtil.equalsClassNames(reference.getFQN(), PhpExceptionAnalysisService.REFLECTION_CLASS_FQN)) {
                return null;
            }
            PhpTypedElement typedElement = (PhpTypedElement)ObjectUtils.tryCast((Object)expression.getParameter(0), PhpTypedElement.class);
            PhpType phpType = type = typedElement != null ? typedElement.getType() : PhpType.EMPTY;
            if (type.isEmpty() || type.getTypes().stream().anyMatch(PhpType::isNotExtendablePrimitiveType)) {
                return null;
            }
            return SignatureKind.SAFE_REFLECTION_CTOR.sign(StringUtil.join((Collection)type.getTypes(), (String)"@@"));
        }

        private static boolean isCheckerReflectionCall(PhpCallInstruction instruction, FunctionReference functionReference, Variable classReference) {
            String name = functionReference.getName();
            if (PhpLangUtil.equalsMethodNames(name, "getMethod")) {
                PsiElement methodNameParameter = functionReference.getParameter(0);
                return methodNameParameter != null && LocalControlFlowProcessor.isReflectionMethodCheckerReachable(instruction, classReference, methodNameParameter, "hasMethod");
            }
            if (PhpLangUtil.equalsMethodNames(name, "getProperty")) {
                PsiElement propertyNameParameter = functionReference.getParameter(0);
                return propertyNameParameter != null && LocalControlFlowProcessor.isReflectionMethodCheckerReachable(instruction, classReference, propertyNameParameter, "hasProperty");
            }
            return false;
        }

        private static boolean isReflectionMethodCheckerReachable(PhpCallInstruction instruction, final @NotNull Variable classReference, final @NotNull PsiElement parameter, final @NotNull String reflectionCheckerName) {
            if (classReference == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(9);
            }
            if (parameter == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(10);
            }
            if (reflectionCheckerName == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(11);
            }
            final Ref defined = new Ref((Object)Boolean.FALSE);
            final Ref undefined = new Ref((Object)Boolean.FALSE);
            PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                public boolean processConditionInstruction(PhpConditionInstruction conditionInstruction) {
                    return conditionInstruction.getCondition() == null || this.performDFA(conditionInstruction).apply((Ref<Boolean>)defined, (Ref<Boolean>)undefined);
                }

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    Variable targetParameterVariable;
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if ((((PhpAccessInstructionImpl)instruction).isReadOrReadRefAccessLocalAware() || access.isWrite()) && PhpLangUtil.equalsVariableNames(instruction.getVariableName(), classReference.getName())) {
                        return false;
                    }
                    Variable variable = targetParameterVariable = parameter instanceof Variable ? (Variable)parameter : LocalControlFlowProcessor.getParameterVariableClassReference(parameter);
                    if (targetParameterVariable != null && access.isWrite() && PhpLangUtil.equalsVariableNames(instruction.getVariableName(), targetParameterVariable.getName())) {
                        undefined.set((Object)true);
                        return false;
                    }
                    return true;
                }

                public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                    if (!this.checkMemberReferenceIsActualAfterAccess((MemberReference)ObjectUtils.tryCast((Object)instruction.getFunctionReference(), MethodReference.class))) {
                        return false;
                    }
                    return super.processPhpCallInstruction(instruction);
                }

                public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                    if (instruction.getAccess().isWrite() && !this.checkMemberReferenceIsActualAfterAccess((MemberReference)ObjectUtils.tryCast((Object)instruction.getAnchor(), FieldReference.class))) {
                        return false;
                    }
                    return super.processAccessFieldByVariableInstruction(instruction);
                }

                private boolean checkMemberReferenceIsActualAfterAccess(MemberReference memberReference) {
                    Variable variableClassReference;
                    Variable parameterVariableClassReference = LocalControlFlowProcessor.getParameterVariableClassReference(parameter);
                    if (parameterVariableClassReference != null && memberReference != null && (variableClassReference = (Variable)ObjectUtils.tryCast((Object)memberReference.getClassReference(), Variable.class)) != null && PhpLangUtil.equalsVariableNames(variableClassReference.getName(), parameterVariableClassReference.getName())) {
                        undefined.set((Object)true);
                        return false;
                    }
                    return true;
                }

                @NotNull
                private PhpReachingDefinitionDFAnalyzer.Result performDFA(PhpConditionInstruction instruction) {
                    PhpReachingDefinitionDFAnalyzer.Result result = (PhpReachingDefinitionDFAnalyzer.Result)new PhpReachingDefinitionDFAnalyzer(){

                        @Override
                        @NotNull
                        public PhpReachingDefinitionDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
                            if (condition instanceof MethodReference && PhpLangUtil.equalsMethodNames(((MethodReference)condition).getName(), reflectionCheckerName) && this.sameClassReferences((PsiElement)((MethodReference)condition).getClassReference()) && PhpPsiUtil.areElementsEquivalent(parameter, ((MethodReference)condition).getParameter(0))) {
                                PhpReachingDefinitionDFAnalyzer.Result dfaResult = new PhpReachingDefinitionDFAnalyzer.Result();
                                if (result) {
                                    dfaResult.setDefined(Boolean.TRUE);
                                } else {
                                    dfaResult.setUndefined(Boolean.TRUE);
                                }
                                PhpReachingDefinitionDFAnalyzer.Result result2 = dfaResult;
                                if (result2 == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return result2;
                            }
                            PhpReachingDefinitionDFAnalyzer.Result result3 = (PhpReachingDefinitionDFAnalyzer.Result)super.performDFA(condition, result);
                            if (result3 == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return result3;
                        }

                        private boolean sameClassReferences(PsiElement checkerClassReference) {
                            return checkerClassReference instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)checkerClassReference).getName(), classReference.getName());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor$3$1", "performDFA"));
                        }
                    }.performDFA(instruction);
                    if (result == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return result;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor$3", "performDFA"));
                }
            });
            return (Boolean)defined.get() != false && (Boolean)undefined.get() == false;
        }

        private static Variable getParameterVariableClassReference(@NotNull PsiElement parameter) {
            if (parameter == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(12);
            }
            if (parameter instanceof MemberReference) {
                return (Variable)ObjectUtils.tryCast((Object)((MemberReference)parameter).getClassReference(), Variable.class);
            }
            return null;
        }

        private static List<String> getCustomExceptions(@NotNull FunctionReference functionReference) {
            if (functionReference == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(13);
            }
            if (!(functionReference instanceof MethodReference)) {
                Collection<PsiElement> unwrappedOperands;
                PsiElement parameter;
                int jsonThrowOnErrorParameterIndex = LocalControlFlowProcessor.getJsonThrowOnErrorParameterIndex(functionReference.getName());
                if (jsonThrowOnErrorParameterIndex < 0) {
                    return ContainerUtil.emptyList();
                }
                ParameterList parameterList = functionReference.getParameterList();
                PsiElement psiElement = parameter = parameterList != null ? parameterList.getParameter("flags", jsonThrowOnErrorParameterIndex) : null;
                if (parameter == null) {
                    return ContainerUtil.emptyList();
                }
                Collection<PsiElement> collection = unwrappedOperands = parameter instanceof BinaryExpression ? PhpCompletionContributor.unwrapOperands((BinaryExpression)parameter) : Collections.singletonList(PhpPsiUtil.unparenthesize(parameter));
                if (unwrappedOperands.stream().anyMatch(LocalControlFlowProcessor::isJsonThrowOnErrorArgument)) {
                    return Collections.singletonList("\\JsonException");
                }
            }
            return ContainerUtil.emptyList();
        }

        private static boolean isJsonThrowOnErrorArgument(PsiElement argument) {
            return argument instanceof ConstantReference && PhpLangUtil.equalsClassNames("JSON_THROW_ON_ERROR", ((ConstantReference)argument).getName());
        }

        private static int getJsonThrowOnErrorParameterIndex(String functionName) {
            if (PhpLangUtil.equalsClassNames("json_decode", functionName)) {
                return 3;
            }
            if (PhpLangUtil.equalsClassNames("json_encode", functionName)) {
                return 1;
            }
            return -1;
        }

        public boolean processConstructorCallInstruction(PhpConstructorCallInstruction instruction) {
            NewExpression newExpression = instruction.getNewExpression();
            PsiElement parent = newExpression.getParent();
            if (parent instanceof PhpThrowExpression && ((PhpThrowExpression)parent).getArgument() == newExpression) {
                return true;
            }
            TextRange thrownRange = newExpression.getTextRange();
            RangeCode[] coughExceptions = this.getCoughExceptions(instruction.getCatchTargets());
            ClassReference classReference = newExpression.getClassReference();
            if (classReference != null) {
                String signature = PhpTypeSignatureKey.METHOD.sign((CharSequence)(classReference.getSignature() + ".__construct"));
                int[] thrownExceptions = new int[]{this.getCode("#C?" + signature)};
                if (!(PhpExceptionAnalysisService.REFLECTION_CLASS_FQN.equals(classReference.getFQN()) && LocalControlFlowProcessor.isExistingClassFqnProvider(newExpression.getParameter(0)) || LocalControlFlowProcessor.isReflectorWithCheckedArgumentExistence(newExpression, instruction))) {
                    this.signatures.add(new Signature(thrownRange, thrownExceptions, coughExceptions, LocalControlFlowProcessor.getClassSignatureIfCheckedReflectionCall(newExpression), false, PhpExceptionAnalysisService.isConstructorHaveConstantArguments(newExpression)));
                }
            } else {
                String signature = PhpTypeSignatureKey.FUNCTION.sign((CharSequence)"__construct");
                int[] thrownExceptions = new int[]{this.getCode("#C?" + signature)};
                this.signatures.add(new Signature(thrownRange, thrownExceptions, coughExceptions, LocalControlFlowProcessor.getClassSignatureIfCheckedReflectionCall(newExpression), false, PhpExceptionAnalysisService.isConstructorHaveConstantArguments(newExpression)));
            }
            return true;
        }

        private static boolean isExistingClassFqnProvider(PsiElement element) {
            return !(element instanceof MethodReference) && element instanceof FunctionReference && ("get_class".equals(((FunctionReference)element).getName()) || "get_called_class".equals(((FunctionReference)element).getName()) || "get_parent_class".equals(((FunctionReference)element).getName()));
        }

        private static boolean isReflectorWithCheckedArgumentExistence(NewExpression expression, PhpConstructorCallInstruction instruction) {
            String[] existenceCheckerFunctionNames;
            ClassReference classReference = expression.getClassReference();
            String[] stringArray = existenceCheckerFunctionNames = classReference != null ? REFLECTION_EXISTENCE_CHECKERS.get(StringUtil.notNullize((String)classReference.getFQN())) : null;
            if (existenceCheckerFunctionNames == null) {
                return false;
            }
            List<PhpStateArgumentInfo> argumentsInfos = LocalControlFlowProcessor.getArgumentsInfos((ParameterListOwner)expression);
            if (argumentsInfos.isEmpty() || argumentsInfos.contains(null)) {
                return false;
            }
            return LocalControlFlowProcessor.isReflectorCheckDfaReachable(instruction, existenceCheckerFunctionNames, argumentsInfos);
        }

        private static boolean isReflectorCheckDfaReachable(PhpConstructorCallInstruction instruction, String[] existenceCheckerFunctionNames, List<@NotNull PhpStateArgumentInfo> argumentInfos) {
            PhpReflectorExistenceDFAnalyzer analyzer = new PhpReflectorExistenceDFAnalyzer(existenceCheckerFunctionNames);
            return PhpExceptionAnalysisService.processReachabilityWithArgumentInfos((PhpInstruction)instruction, argumentInfos, analyzer);
        }

        private static @NotNull List<@Nullable PhpStateArgumentInfo> getArgumentsInfos(ParameterListOwner expression) {
            List list = ContainerUtil.map((Object[])expression.getParameters(), p -> {
                String scalarRepresentation = PhpCodeInsightUtil.toString(p, false);
                if (scalarRepresentation != null) {
                    return new PhpScalarStateArgumentInfo(scalarRepresentation);
                }
                return PhpStateArgumentInfo.tryCreateInfo(p, false);
            });
            if (list == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(14);
            }
            return list;
        }

        private RangeCode[] getCoughExceptions(@NotNull Collection<PhpHostInstruction> catchTargets) {
            if (catchTargets == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(15);
            }
            SmartList coughExceptions = new SmartList();
            for (PhpHostInstruction catchTarget : catchTargets) {
                for (PhpInstruction successor : catchTarget.getSuccessors()) {
                    if (!(successor instanceof PhpCatchConditionInstruction)) continue;
                    PhpCatchConditionInstruction catchCondition = (PhpCatchConditionInstruction)successor;
                    Variable variable = catchCondition.getException();
                    TextRange coughRange = variable != null ? variable.getTextRange() : null;
                    for (ClassReference coughException : catchCondition.getExceptionTypes()) {
                        String fqn = coughException.getFQN();
                        if (fqn == null) continue;
                        coughExceptions.add(new RangeCode(coughRange != null ? coughRange : coughException.getTextRange(), this.getCode(fqn)));
                    }
                }
            }
            return (RangeCode[])ContainerUtil.toArray((Collection)coughExceptions, RangeCode.ARRAY_FACTORY);
        }

        private int getCode(@NotNull String exception) {
            if (exception == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(16);
            }
            if (this.exceptions.containsKey((Object)exception)) {
                return this.exceptions.get((Object)exception);
            }
            int i = this.exceptions.size();
            this.exceptions.put((Object)exception, i);
            return i;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5, 6, 8, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptions";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classReference";
                    break;
                }
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reflectionCheckerName";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionReference";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "catchTargets";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exception";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRethrownExceptionsSignatures";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRethrownExceptions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThrownExceptionCodes";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "signaturesFromClosureArguments";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgumentsInfos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "calculateSignatures";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 14: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addAmbiguousInstruction";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isReflectionMethodCheckerReachable";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getParameterVariableClassReference";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getCustomExceptions";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getCoughExceptions";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getCode";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5, 6, 8, 14 -> new IllegalStateException(string);
            };
        }

        private static final class PhpRethrownException
        extends Exception {
            private final Signature mySignature;
            private final TextRange myTryRange;

            private PhpRethrownException(Signature originalSignature, TextRange tryRange) {
                this.mySignature = originalSignature;
                this.myTryRange = tryRange;
            }
        }

        protected static abstract sealed class SignatureKind
        extends Enum<SignatureKind> {
            public static final /* enum */ SignatureKind CHECKED_REFLECTION_CALL = new SignatureKind("@R"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception) {
                    String data = signature.myData;
                    assert (data != null);
                    return this.isReflectionClass(project, data) ? null : exception;
                }
            };
            public static final /* enum */ SignatureKind SAFE_REFLECTION_CTOR = new SignatureKind("@CTOR"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception) {
                    String data = signature.myData;
                    assert (data != null);
                    PhpType type = new PhpType();
                    for (String s : StringUtil.split((String)this.unsignData(signature), (String)SignatureKind.SEPARATOR)) {
                        type.add(s);
                    }
                    PhpType reflectionClassCtorType = type.global(project);
                    return !reflectionClassCtorType.hasUnknown() && !ContainerUtil.exists((Iterable)reflectionClassCtorType.getTypes(), PhpType::isNotExtendablePrimitiveType) ? null : exception;
                }
            };
            public static final /* enum */ SignatureKind REFLECTION_GET_METHOD_FROM_REAL_CLASS = new SignatureKind("@GM"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception) {
                    return this.realClassContainsEntry(project, signature, true) ? null : exception;
                }
            };
            public static final /* enum */ SignatureKind REFLECTION_GET_PROPERTY_FROM_REAL_CLASS = new SignatureKind("@GP"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception) {
                    return this.realClassContainsEntry(project, signature, false) ? null : exception;
                }
            };
            public static final /* enum */ SignatureKind FUNCTION_ACCEPTING_CLOSURE = new SignatureKind("@C"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception) {
                    int argumentIndex;
                    String data = signature.myData;
                    assert (data != null);
                    int separator = data.lastIndexOf(".");
                    assert (separator > 0);
                    PhpIndex index = PhpIndex.getInstance((Project)project);
                    Collection elements = StringUtil.split((String)data.substring(2, separator), (String)"|").stream().flatMap(s -> PhpExceptionAnalysisService.getBySignature(s, index).stream()).collect(Collectors.toSet());
                    return ContainerUtil.all((Collection)elements, arg_0 -> 5.lambda$completeException$1(argumentIndex = Integer.parseInt(data.substring(separator + 1)), arg_0)) ? exception : null;
                }

                private static boolean isCallingPassedClosureWithoutCatch(PhpNamedElement function, int index) {
                    Ref callsPassedClosureWithoutCatch = new Ref((Object)Boolean.FALSE);
                    FileBasedIndex.getInstance().processValues(PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.KEY, (Object)function.getFQN(), null, (file, value) -> {
                        if (value.contains(index)) {
                            callsPassedClosureWithoutCatch.set((Object)Boolean.TRUE);
                            return false;
                        }
                        return true;
                    }, GlobalSearchScope.allScope((Project)function.getProject()));
                    return (Boolean)callsPassedClosureWithoutCatch.get();
                }

                private static /* synthetic */ boolean lambda$completeException$1(int argumentIndex, PhpNamedElement f) {
                    return f instanceof Function && (!(f instanceof Method) && PhpLangUtil.isGlobalNamespaceFQN(f.getNamespaceName()) || 5.isCallingPassedClosureWithoutCatch(f, argumentIndex));
                }
            };
            public static final /* enum */ SignatureKind RETHROWN_EXCEPTION = new SignatureKind("@T"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception) {
                    String data = signature.myData;
                    assert (data != null);
                    return 6.getExceptionsFromCatchClause(list, data).isConvertibleFrom(new PhpType().add(exception), PhpIndex.getInstance((Project)project)) ? exception : null;
                }

                @NotNull
                private static PhpType getExceptionsFromCatchClause(SignatureList list, String data) {
                    PhpType exceptionsFromCatch = new PhpType();
                    SignatureKind.exceptionsFromCatchClause(list, data).forEach(arg_0 -> ((PhpType)exceptionsFromCatch).add(arg_0));
                    PhpType phpType = exceptionsFromCatch;
                    if (phpType == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    return phpType;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor$SignatureKind$6", "getExceptionsFromCatchClause"));
                }
            };
            public static final /* enum */ SignatureKind CHECKED_PARAMETER_REFLECTION_CALL = new SignatureKind("@P"){

                @Override
                public String completeException(Project project, Signature signature, SignatureList list, String exception) {
                    String data = signature.myData;
                    assert (data != null);
                    return REFLECTION_PARAMETER.isConvertibleFromGlobal(project, new PhpType().add(data.substring(2))) ? null : exception;
                }
            };
            static final String SEPARATOR = "@@";
            @NotNull
            private static final PhpType REFLECTION_CLASS;
            @NotNull
            private static final PhpType REFLECTION_PARAMETER;
            protected final String myPrefix;
            private static final /* synthetic */ SignatureKind[] $VALUES;

            public static SignatureKind[] values() {
                return (SignatureKind[])$VALUES.clone();
            }

            public static SignatureKind valueOf(String name) {
                return Enum.valueOf(SignatureKind.class, name);
            }

            @NotNull
            private static Stream<String> exceptionsFromCatchClause(SignatureList list, String data) {
                Stream<String> stream = Arrays.stream(data.substring(2).split(LocalControlFlowProcessor.RETHROWN_EXCEPTIONS_SEPARATOR)).mapToInt(Integer::parseInt).mapToObj(code -> list.exceptions[code]);
                if (stream == null) {
                    SignatureKind.$$$reportNull$$$0(0);
                }
                return stream;
            }

            private SignatureKind(String prefix) {
                this.myPrefix = prefix;
            }

            @NotNull
            protected String unsignData(Signature signature) {
                assert (signature.myData != null);
                String string = signature.myData.substring(this.myPrefix.length());
                if (string == null) {
                    SignatureKind.$$$reportNull$$$0(1);
                }
                return string;
            }

            protected boolean realClassContainsEntry(Project project, Signature signature, boolean method) {
                String data = this.unsignData(signature);
                int dot = data.indexOf(46);
                String entryName = data.substring(0, dot);
                int classReferenceIndex = data.indexOf(SignatureKind.CHECKED_REFLECTION_CALL.myPrefix);
                if (!this.isReflectionClass(project, data.substring(classReferenceIndex))) {
                    return false;
                }
                PhpIndex index = PhpIndex.getInstance((Project)project);
                String classTypes = data.substring(dot + 1, classReferenceIndex);
                return StreamEx.of((Collection)StringUtil.split((String)classTypes, (String)SEPARATOR)).flatMap(s -> s.startsWith("#") ? index.getBySignature(s).stream() : index.getAnyByFQN(s).stream()).select(PhpClass.class).anyMatch(c -> (method ? c.findMethodByName((CharSequence)entryName) : c.findFieldByName((CharSequence)entryName, false)) != null);
            }

            public boolean isReflectionClass(Project project, String data) {
                return REFLECTION_CLASS.isConvertibleFromGlobal(project, new PhpType().add(data.substring(2)));
            }

            private String sign(String signature) {
                return this.myPrefix + signature;
            }

            public abstract String completeException(Project var1, Signature var2, SignatureList var3, String var4);

            @Nullable
            private static SignatureKind getKindFromData(String data) {
                if (data == null) {
                    return null;
                }
                return (SignatureKind)((Object)ContainerUtil.find((Object[])SignatureKind.values(), kind -> StringUtil.startsWith((CharSequence)data, (CharSequence)kind.myPrefix)));
            }

            private static /* synthetic */ SignatureKind[] $values() {
                return new SignatureKind[]{CHECKED_REFLECTION_CALL, SAFE_REFLECTION_CTOR, REFLECTION_GET_METHOD_FROM_REAL_CLASS, REFLECTION_GET_PROPERTY_FROM_REAL_CLASS, FUNCTION_ACCEPTING_CLOSURE, RETHROWN_EXCEPTION, CHECKED_PARAMETER_REFLECTION_CALL};
            }

            static {
                $VALUES = SignatureKind.$values();
                REFLECTION_CLASS = new PhpType().add(PhpExceptionAnalysisService.REFLECTION_CLASS_FQN);
                REFLECTION_PARAMETER = new PhpType().add("\\ReflectionParameter");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor$SignatureKind";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "exceptionsFromCatchClause";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "unsignData";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        private static class PhpReflectorExistenceDFAnalyzer
        extends PhpSimpleFunctionDefinedDFAnalyzer {
            private PhpReflectorExistenceDFAnalyzer(String ... existenceCheckerFunctionName) {
                super(existenceCheckerFunctionName);
            }

            @Override
            @Nullable
            protected String toString(PsiElement parameter) {
                PhpStateArgumentInfo argumentInfo = PhpStateArgumentInfo.tryCreateInfo(parameter, false);
                return argumentInfo != null ? argumentInfo.getArgumentName() : null;
            }

            @Override
            @Nullable
            protected String getParameterStringRepresentation(@NotNull FunctionReference functionReference) {
                List<PhpStateArgumentInfo> infos;
                if (functionReference == null) {
                    PhpReflectorExistenceDFAnalyzer.$$$reportNull$$$0(0);
                }
                return (infos = LocalControlFlowProcessor.getArgumentsInfos((ParameterListOwner)functionReference)).contains(null) ? null : StringUtil.nullize((String)PhpExceptionAnalysisService.joinArgumentsNames(infos));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor$PhpReflectorExistenceDFAnalyzer", "getParameterStringRepresentation"));
            }
        }

        private static class PhpScalarStateArgumentInfo
        implements PhpStateArgumentInfo {
            private final String myRepresentation;

            private PhpScalarStateArgumentInfo(String representation) {
                this.myRepresentation = representation;
            }

            @Override
            @NotNull
            public String getArgumentName() {
                String string = this.myRepresentation;
                if (string == null) {
                    PhpScalarStateArgumentInfo.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @Nullable
            public PhpStateArgumentInfo getBaseInfo() {
                return null;
            }

            @Override
            public Collection<java.util.function.Function<PhpInstruction, Boolean>> doGetStateDependenciesCheckers(boolean global) {
                return Collections.emptyList();
            }

            @Override
            public Predicate<PsiElement> getElementPredicate() {
                return Predicates.alwaysTrue();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PhpScalarStateArgumentInfo info = (PhpScalarStateArgumentInfo)o;
                return Objects.equals(this.myRepresentation, info.myRepresentation);
            }

            public int hashCode() {
                return Objects.hash(this.myRepresentation);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor$PhpScalarStateArgumentInfo", "getArgumentName"));
            }
        }
    }

    public static class PhpThrownExceptionItem
    extends Pair<PhpType, TextRange> {
        private final boolean myAmbiguous;
        private final boolean myThrownInConstructorWithConstantParameters;

        public PhpThrownExceptionItem(@NotNull String exceptionFQN, @NotNull TextRange range) {
            if (exceptionFQN == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(0);
            }
            if (range == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(1);
            }
            this(new PhpType().add(exceptionFQN), range, false);
        }

        public PhpThrownExceptionItem(@NotNull PhpType exceptionType, @NotNull TextRange range, boolean ambiguous) {
            if (exceptionType == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(2);
            }
            if (range == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(3);
            }
            this(exceptionType, range, ambiguous, false);
        }

        public PhpThrownExceptionItem(@NotNull PhpType exceptionType, @NotNull TextRange range, boolean ambiguous, boolean thrownInConstructorWithConstantParameters) {
            if (exceptionType == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(4);
            }
            if (range == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(5);
            }
            super((Object)exceptionType, (Object)range);
            this.myAmbiguous = ambiguous;
            this.myThrownInConstructorWithConstantParameters = thrownInConstructorWithConstantParameters;
        }

        public PhpThrownExceptionItem(@NotNull String exceptionFQN, @NotNull TextRange range, boolean ambiguous, boolean thrownInConstructorWithConstantParameters) {
            if (exceptionFQN == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(6);
            }
            if (range == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(7);
            }
            this(new PhpType().add(exceptionFQN), range, ambiguous, thrownInConstructorWithConstantParameters);
        }

        @NotNull
        public PhpType getException() {
            PhpType phpType = (PhpType)this.first;
            if (phpType == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(8);
            }
            return phpType;
        }

        @NotNull
        public TextRange getThrownRange() {
            TextRange textRange = (TextRange)this.second;
            if (textRange == null) {
                PhpThrownExceptionItem.$$$reportNull$$$0(9);
            }
            return textRange;
        }

        public boolean isAmbiguous() {
            return this.myAmbiguous;
        }

        public boolean isThrownInConstructorWithConstantParameters() {
            return this.myThrownInConstructorWithConstantParameters;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionFQN";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionType";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$PhpThrownExceptionItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$PhpThrownExceptionItem";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getException";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThrownRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    private static final class RangeCode {
        private static final RangeCode[] EMPTY_ARRAY = new RangeCode[0];
        private static final ArrayFactory<RangeCode> ARRAY_FACTORY = size -> size == 0 ? EMPTY_ARRAY : new RangeCode[size];
        private final TextRange range;
        private final int code;

        private RangeCode(@NotNull TextRange range, int code) {
            if (range == null) {
                RangeCode.$$$reportNull$$$0(0);
            }
            this.range = range;
            this.code = code;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$RangeCode", "<init>"));
        }
    }
}

