/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocPropertyTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpDocDuplicateTypeInspection
extends PhpInspection {
    static final LocalQuickFix REMOVE_PHP_DOC_REDUNDANT_TYPE_FIX = new RemovePhpDocRedundantTypeQuickFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDocDuplicateTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpDocTag(PhpDocTag tag) {
                if (tag instanceof PhpDocParamTag || tag instanceof PhpDocReturnTag || tag instanceof PhpDocPropertyTag) {
                    PhpDocDuplicateTypeInspection.checkTag(tag, holder);
                }
            }
        };
    }

    private static void checkTag(PhpDocTag tag, ProblemsHolder holder) {
        @NotNull List<T> children = PhpPsiUtil.getChildren((PsiElement)tag, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF);
        block0: for (int i = children.size() - 1; i > 0; --i) {
            PhpDocType f = (PhpDocType)children.get(i);
            PhpType fType = f.getType();
            for (int j = i - 1; j >= 0; --j) {
                PhpDocType s = (PhpDocType)children.get(j);
                PhpType sType = s.getType();
                if (!fType.equals((Object)sType) || !PhpDocDuplicateTypeInspection.getAttributeListText(f).equals(PhpDocDuplicateTypeInspection.getAttributeListText(s)) || !PhpDocDuplicateTypeInspection.getStringLiteralText(f).equals(PhpDocDuplicateTypeInspection.getStringLiteralText(s))) continue;
                holder.registerProblem((PsiElement)f, PhpBundle.message("inspection.duplicate.phpdoc.type.problem", f.getText()), new LocalQuickFix[]{REMOVE_PHP_DOC_REDUNDANT_TYPE_FIX});
                continue block0;
            }
        }
    }

    @NotNull
    private static String getStringLiteralText(PhpDocType type) {
        String text = type.getText();
        return StringUtil.isQuotedString((String)text) ? text : "";
    }

    @NotNull
    private static String getAttributeListText(PhpDocType docType) {
        PsiElement attributeList = PhpPsiUtil.getChildOfType((PsiElement)docType, (IElementType)PhpDocElementTypes.phpDocAttributeList);
        return attributeList != null ? attributeList.getText() : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/phpdoc/PhpDocDuplicateTypeInspection", "buildVisitor"));
    }

    public static class RemovePhpDocRedundantTypeQuickFix
    extends PsiUpdateModCommandQuickFix {
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.duplicate.phpdoc.type.fix", new Object[0]);
            if (string == null) {
                RemovePhpDocRedundantTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement phpDocTag, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                RemovePhpDocRedundantTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (phpDocTag == null) {
                RemovePhpDocRedundantTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemovePhpDocRedundantTypeQuickFix.$$$reportNull$$$0(3);
            }
            PhpCodeEditUtil.removeStatementWithDelivery(phpDocTag, PhpDocTokenTypes.DOC_PIPE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocDuplicateTypeInspection$RemovePhpDocRedundantTypeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpDocTag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocDuplicateTypeInspection$RemovePhpDocRedundantTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

