/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpAnnotationToAttributeInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAnnotationToAttributeInspectionKt;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitDeprecatedDataProviderSignatureInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkVersionCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006!"}, d2={"Lcom/jetbrains/php/lang/inspections/phpunit/PhpUnitAnnotationToAttributeInspection;", "Lcom/jetbrains/php/lang/inspections/PhpAnnotationToAttributeInspection;", "<init>", "()V", "isAttributeDeprecated", "", "attributeName", "", "createAttributeText", "tag", "Lcom/jetbrains/php/lang/documentation/phpdoc/psi/tags/PhpDocTag;", "getFrameworkName", "getProblemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProblemDescription", "problemHighlightType", "getSettings", "", "Lcom/jetbrains/php/phpunit/PhpUnitSettings;", "getArrayParameter", "tagValue", "getParameters", "getSimpleReferenceParameter", "getReferenceParameter", "getClassNameToMethodName", "Lkotlin/Pair;", "checkToolVersion", "getAttributeFqn", "Companion", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpUnitAnnotationToAttributeInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpUnitAnnotationToAttributeInspection.kt\ncom/jetbrains/php/lang/inspections/phpunit/PhpUnitAnnotationToAttributeInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n37#2,2:188\n1563#3:190\n1634#3,3:191\n774#3:194\n865#3,2:195\n1563#3:197\n1634#3,3:198\n*S KotlinDebug\n*F\n+ 1 PhpUnitAnnotationToAttributeInspection.kt\ncom/jetbrains/php/lang/inspections/phpunit/PhpUnitAnnotationToAttributeInspection\n*L\n116#1:188,2\n123#1:190\n123#1:191,3\n124#1:194\n124#1:195,2\n139#1:197\n139#1:198,3\n*E\n"})
public final class PhpUnitAnnotationToAttributeInspection
extends PhpAnnotationToAttributeInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SEPARATOR = "::";

    @Override
    public boolean isAttributeDeprecated(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        return PhpUnitAnnotationToAttributeInspectionKt.access$getDEPRECATED_ATTRIBUTES$p().contains(attributeName);
    }

    @Override
    @Nullable
    public String createAttributeText(@NotNull PhpDocTag tag, @NotNull String attributeName) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        if (PhpUnitAnnotationToAttributeInspectionKt.access$getATTRIBUTES_WITHOUT_PARAMETERS$p().contains(attributeName)) {
            pair = TuplesKt.to((Object)"", (Object)attributeName);
        } else if (PhpUnitAnnotationToAttributeInspectionKt.access$getATTRIBUTES_WITH_PARAMETER$p().containsKey(attributeName)) {
            pair = TuplesKt.to((Object)("(\"" + tag.getTagValue() + "\")"), PhpUnitAnnotationToAttributeInspectionKt.access$getATTRIBUTES_WITH_PARAMETER$p().get(attributeName));
        } else if (PhpUnitAnnotationToAttributeInspectionKt.access$getATTRIBUTES_WITH_ENABLED_PARAMETER$p().containsKey(attributeName)) {
            pair = TuplesKt.to((Object)(Intrinsics.areEqual((Object)tag.getTagValue(), (Object)"enabled") ? "(true)" : "(false)"), PhpUnitAnnotationToAttributeInspectionKt.access$getATTRIBUTES_WITH_ENABLED_PARAMETER$p().get(attributeName));
        } else if (PhpUnitAnnotationToAttributeInspectionKt.access$getATTRIBUTES_WITH_ARRAY_PARAMETER$p().contains(attributeName)) {
            String string = tag.getTagValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTagValue(...)");
            pair = TuplesKt.to((Object)this.getArrayParameter(string), (Object)attributeName);
        } else {
            pair = PhpUnitAnnotationToAttributeInspectionKt.access$getATTRIBUTES_WITH_PARAMETERS$p().contains(attributeName) ? TuplesKt.to((Object)this.getParameters(tag), (Object)attributeName) : (PhpUnitAnnotationToAttributeInspectionKt.access$getATTRIBUTES_WITH_SIMPLE_REF_PARAMETER$p().contains(attributeName) ? TuplesKt.to((Object)this.getSimpleReferenceParameter(tag), (Object)attributeName) : (PhpUnitAnnotationToAttributeInspectionKt.access$getATTRIBUTES_WITH_REF_PARAMETER$p().contains(attributeName) ? TuplesKt.to((Object)this.getReferenceParameter(tag), (Object)attributeName) : TuplesKt.to(null, null)));
        }
        Pair pair2 = pair;
        String params = (String)pair2.component1();
        String attribute = (String)pair2.component2();
        if (params == null || attribute == null) {
            return null;
        }
        return attribute + params;
    }

    @Override
    @NotNull
    protected String getFrameworkName() {
        return "PHPUnit";
    }

    @Override
    @NotNull
    public ProblemHighlightType getProblemHighlightType(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List<PhpUnitSettings> settings = this.getSettings(project, file);
        for (PhpUnitSettings s : settings) {
            String version = PhpTestFrameworkVersionCache.getCache(project, s);
            if (!StringUtil.isNotEmpty((String)version) || PhpTestFrameworkVersionDetector.versionCompare(version, "11.0.0") < 0) continue;
            boolean isPhpMetadataSupported = PhpTestFrameworkVersionDetector.versionCompare(version, "12.0.0") < 0;
            return isPhpMetadataSupported ? ProblemHighlightType.LIKE_DEPRECATED : ProblemHighlightType.ERROR;
        }
        return ProblemHighlightType.INFORMATION;
    }

    @Override
    @NotNull
    public String getProblemDescription(@NotNull ProblemHighlightType problemHighlightType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)problemHighlightType, (String)"problemHighlightType");
        if (WhenMappings.$EnumSwitchMapping$0[problemHighlightType.ordinal()] == 1) {
            Object[] objectArray = new Object[]{this.getFrameworkName()};
            String string2 = PhpBundle.message("inspection.php.annotation.must.be.replaced.with.attribute", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            string = super.getProblemDescription(problemHighlightType);
        }
        return string;
    }

    private final List<PhpUnitSettings> getSettings(Project project, VirtualFile file) {
        PhpUnitSettingsManager manager = PhpUnitSettingsManager.getInstance(project);
        boolean bl = false;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)manager.getLocalSettings(file));
        List<PhpUnitSettings> list = manager.getAllSettings();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllSettings(...)");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new PhpUnitSettings[0]));
        return CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray((Object[])new PhpUnitSettings[spreadBuilder.size()]));
    }

    /*
     * WARNING - void declaration
     */
    private final String getArrayParameter(String tagValue) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        String[] stringArray = new String[]{"[", "]", ","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)tagValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!(((CharSequence)it).length() == 0))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", (CharSequence)"([", (CharSequence)"])", (int)0, null, null, (int)56, null), (String)":", (String)"=>", (boolean)false, (int)4, null), (String)"{", (String)"[", (boolean)false, (int)4, null), (String)"}", (String)"]", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String getParameters(PhpDocTag tag) {
        String property;
        List values;
        Map properties;
        block8: {
            block7: {
                void $this$mapTo$iv$iv;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"PHP", (Object)TuplesKt.to((Object)"Php", (Object)1)), TuplesKt.to((Object)"extension", (Object)TuplesKt.to((Object)"PhpExtension", (Object)2)), TuplesKt.to((Object)"function", (Object)TuplesKt.to((Object)"Function", (Object)1)), TuplesKt.to((Object)"PHPUnit", (Object)TuplesKt.to((Object)"Phpunit", (Object)1)), TuplesKt.to((Object)"OS", (Object)TuplesKt.to((Object)"OperatingSystem", (Object)1)), TuplesKt.to((Object)"OSFAMILY", (Object)TuplesKt.to((Object)"OperatingSystemFamily", (Object)1)), TuplesKt.to((Object)"setting", (Object)TuplesKt.to((Object)"Setting", (Object)2))};
                properties = MapsKt.mapOf((Pair[])pairArray);
                String string = tag.getTagValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTagValue(...)");
                String[] stringArray = new String[]{" "};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(StringUtil.unquoteString((String)it));
                }
                values = (List)destination$iv$iv;
                if (values.isEmpty()) {
                    return null;
                }
                property = (String)values.get(0);
                if (!properties.containsKey(property)) break block7;
                int n = values.size();
                Object v = properties.get(property);
                Intrinsics.checkNotNull(v);
                if (n >= ((Number)((Pair)v).getSecond()).intValue() + 1) break block8;
            }
            return null;
        }
        List list = CollectionsKt.drop((Iterable)values, (int)1);
        int n = values.size();
        Object v = properties.get(property);
        Intrinsics.checkNotNull(v);
        String firstArguments = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)list, (int)(n - ((Number)((Pair)v).getSecond()).intValue())), null, null, null, (int)0, null, null, (int)63, null);
        Iterable iterable = values;
        Object v2 = properties.get(property);
        Intrinsics.checkNotNull(v2);
        String lastArgument = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)iterable, (int)((Number)((Pair)v2).getSecond()).intValue()), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        if (Intrinsics.areEqual((Object)property, (Object)"function")) {
            Pair<String, String> pair = this.getClassNameToMethodName(tag);
            String className = (String)pair.component1();
            String methodName = (String)pair.component2();
            if (!(((CharSequence)className).length() == 0) && !Intrinsics.areEqual((Object)methodName, (Object)className)) {
                return "Method(" + PhpLangUtil.toName(className) + "::class, '" + methodName + "')";
            }
        }
        Object v3 = properties.get(property);
        Intrinsics.checkNotNull(v3);
        return ((Pair)v3).getFirst() + (((CharSequence)firstArguments).length() == 0 ? "('" + lastArgument + "')" : "('" + firstArguments + "', '" + lastArgument + "')");
    }

    private final String getSimpleReferenceParameter(PhpDocTag tag) {
        Pair<String, String> pair = this.getClassNameToMethodName(tag);
        String className = (String)pair.component1();
        String methodName = (String)pair.component2();
        if (((CharSequence)className).length() == 0 && ((CharSequence)methodName).length() == 0) {
            return null;
        }
        if (Intrinsics.areEqual((Object)className, (Object)methodName)) {
            return "Class(" + className + "::class)";
        }
        return "Function('" + methodName + "')";
    }

    private final String getReferenceParameter(PhpDocTag tag) {
        String property;
        Pair<String, String> pair = this.getClassNameToMethodName(tag);
        String className = (String)pair.component1();
        String methodName = (String)pair.component2();
        if (((CharSequence)className).length() == 0 && ((CharSequence)methodName).length() == 0) {
            return null;
        }
        Pair pair2 = Intrinsics.areEqual((Object)className, (Object)methodName) ? TuplesKt.to((Object)"", (Object)("('" + methodName + "')")) : (Intrinsics.areEqual((Object)methodName, (Object)"class") ? TuplesKt.to((Object)"OnClass", (Object)("(" + className + "::class)")) : TuplesKt.to((Object)"External", (Object)("(" + className + "::class, '" + methodName + "')")));
        String place = (String)pair2.component1();
        String parameters = (String)pair2.component2();
        PsiElement psiElement = PhpPsiUtil.getNextSiblingIgnoreWhitespace(tag.getFirstChild(), true);
        String string = property = psiElement != null ? psiElement.getText() : null;
        if (property == null) {
            return place + parameters;
        }
        if (Intrinsics.areEqual((Object)property, (Object)"clone")) {
            return place + "UsingDeepClone" + parameters;
        }
        if (Intrinsics.areEqual((Object)property, (Object)"shallowClone")) {
            return place + "UsingShallowClone" + parameters;
        }
        return place + parameters;
    }

    private final Pair<String, String> getClassNameToMethodName(PhpDocTag tag) {
        Object ref = PhpPsiUtil.getChildByCondition((PsiElement)tag, (Condition<? super PsiElement>)((Condition)PhpUnitAnnotationToAttributeInspection::getClassNameToMethodName$lambda$0));
        if (ref == null) {
            ref = tag.getLastChild();
        }
        if (ref == null) {
            return TuplesKt.to((Object)"", (Object)"");
        }
        String string = ref.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String refText = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"function"), (CharSequence)"()"))).toString();
        return TuplesKt.to((Object)StringsKt.substringBefore$default((String)refText, (String)SEPARATOR, null, (int)2, null), (Object)StringsKt.substringAfter$default((String)refText, (String)SEPARATOR, null, (int)2, null));
    }

    @Override
    protected boolean checkToolVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PhpUnitDeprecatedDataProviderSignatureInspection.atLeastPhpUnit10(project);
    }

    @Override
    @NotNull
    protected String getAttributeFqn(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        return "\\PHPUnit\\Framework\\Attributes\\";
    }

    private static final boolean getClassNameToMethodName$lambda$0(PsiElement e) {
        return e instanceof PhpDocRef;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/php/lang/inspections/phpunit/PhpUnitAnnotationToAttributeInspection$Companion;", "", "<init>", "()V", "SEPARATOR", "", "intellij.php.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProblemHighlightType.values().length];
            try {
                nArray[ProblemHighlightType.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

