/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpUnitDataProviderInspectionBase
extends PhpInspection {
    public static final String DATA_PROVIDER_TAG = "@dataProvider";
    public static final String DATA_PROVIDER_ATTRIBUTE_FQN = "\\PHPUnit\\Framework\\Attributes\\DataProvider";
    public static final String DATA_PROVIDER_EXTERNAL_ATTRIBUTE_FQN = "\\PHPUnit\\Framework\\Attributes\\DataProviderExternal";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitDataProviderInspectionBase.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                Object[] dataProvidersTags = PhpUnitDataProviderInspectionBase.getDataProvidersTags(method);
                if (!ArrayUtil.isEmpty((Object[])dataProvidersTags)) {
                    PhpClass containingClass = method.getContainingClass();
                    if (containingClass == null || !PhpUnitUtil.isTestMethod(containingClass, method)) {
                        return;
                    }
                    for (Object dataProviderTag : dataProvidersTags) {
                        this.check((PhpDocRef)PsiTreeUtil.getChildOfType((PsiElement)dataProviderTag, PhpDocRef.class), containingClass);
                    }
                }
                for (PhpAttribute attribute : method.getAttributes(PhpUnitDataProviderInspectionBase.DATA_PROVIDER_ATTRIBUTE_FQN)) {
                    this.doCheckDataProviderAttribute(attribute);
                }
                for (PhpAttribute attribute : method.getAttributes(PhpUnitDataProviderInspectionBase.DATA_PROVIDER_EXTERNAL_ATTRIBUTE_FQN)) {
                    this.doCheckDataProviderAttribute(attribute);
                }
            }

            private void doCheckDataProviderAttribute(PhpAttribute attribute) {
                PsiElement lastElement = (PsiElement)ArrayUtil.getLastElement((Object[])attribute.getParameters());
                if (lastElement instanceof StringLiteralExpression) {
                    for (PsiReference reference : lastElement.getReferences()) {
                        if (!(reference instanceof PhpCallbackReferenceBase.PhpClassMemberCallbackReferenceBase)) continue;
                        PhpClass phpClass = (PhpClass)ContainerUtil.getOnlyItem(((PhpCallbackReferenceBase.PhpClassMemberCallbackReferenceBase)reference).resolveClassReference());
                        Method resolvedMethod = (Method)ObjectUtils.tryCast((Object)reference.resolve(), Method.class);
                        String name = ((PhpCallbackReferenceBase.PhpClassMemberCallbackReferenceBase)reference).getClassMemberName();
                        if (name == null || phpClass == null) continue;
                        PhpUnitDataProviderInspectionBase.this.doCheck(lastElement, (Pair<String, String>)Pair.create((Object)phpClass.getFQN(), (Object)name), (Pair<PhpClass, Method>)Pair.create((Object)phpClass, (Object)resolvedMethod), holder);
                    }
                }
            }

            private void check(@Nullable PhpDocRef dataProvider, @NotNull PhpClass testClass) {
                if (testClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dataProvider == null) {
                    return;
                }
                Pair<String, String> classFqnAndMethodName = PhpUnitUtil.getClassFqnAndMethodName(dataProvider, testClass.getNamespaceName());
                if (classFqnAndMethodName.getSecond() == null) {
                    return;
                }
                Pair<PhpClass, Method> classAndMethod = PhpUnitDataProviderInspectionBase.resolveClassAndMethod((String)classFqnAndMethodName.getFirst(), (String)classFqnAndMethodName.getSecond(), dataProvider, testClass);
                PhpUnitDataProviderInspectionBase.this.doCheck((PsiElement)dataProvider, classFqnAndMethodName, classAndMethod, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testClass", "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDataProviderInspectionBase$1", "check"));
            }
        };
    }

    protected abstract void doCheck(@NotNull PsiElement var1, Pair<String, String> var2, Pair<PhpClass, Method> var3, @NotNull ProblemsHolder var4);

    @NotNull
    protected static Pair<PhpClass, Method> resolveClassAndMethod(@Nullable String classFqn, @NotNull String methodName, @NotNull PhpDocRef docRef, @NotNull PhpClass containingClass) {
        if (methodName == null) {
            PhpUnitDataProviderInspectionBase.$$$reportNull$$$0(1);
        }
        if (docRef == null) {
            PhpUnitDataProviderInspectionBase.$$$reportNull$$$0(2);
        }
        if (containingClass == null) {
            PhpUnitDataProviderInspectionBase.$$$reportNull$$$0(3);
        }
        if (classFqn != null) {
            List classes = StreamEx.of((Object[])docRef.getReferences()).map(PsiReference::resolve).select(PhpClass.class).toList();
            PhpClass clazz = classes.size() == 1 ? (PhpClass)classes.get(0) : null;
            Pair pair = clazz != null && (PhpLangUtil.isFqn(docRef.getText()) || PhpLangUtil.equalsNamespaceNames(containingClass.getNamespaceName(), clazz.getNamespaceName())) ? Pair.create((Object)clazz, (Object)clazz.findMethodByName((CharSequence)methodName)) : Pair.empty();
            if (pair == null) {
                PhpUnitDataProviderInspectionBase.$$$reportNull$$$0(4);
            }
            return pair;
        }
        Pair pair = Pair.create(null, (Object)containingClass.findMethodByName((CharSequence)methodName));
        if (pair == null) {
            PhpUnitDataProviderInspectionBase.$$$reportNull$$$0(5);
        }
        return pair;
    }

    public static PhpDocTag @NotNull [] getDataProvidersTags(@NotNull Method method) {
        if (method == null) {
            PhpUnitDataProviderInspectionBase.$$$reportNull$$$0(6);
        }
        if (method instanceof PhpDocMethod) {
            if (PhpDocTag.EMPTY_ARRAY == null) {
                PhpUnitDataProviderInspectionBase.$$$reportNull$$$0(7);
            }
            return PhpDocTag.EMPTY_ARRAY;
        }
        PhpDocComment docComment = method.getDocComment();
        PhpDocTag[] phpDocTagArray = docComment != null ? docComment.getTagElementsByName(DATA_PROVIDER_TAG) : PhpDocTag.EMPTY_ARRAY;
        if (phpDocTagArray == null) {
            PhpUnitDataProviderInspectionBase.$$$reportNull$$$0(8);
        }
        return phpDocTagArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDataProviderInspectionBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDataProviderInspectionBase";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveClassAndMethod";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProvidersTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveClassAndMethod";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDataProvidersTags";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

