/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpRemoveDocTagQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitExpectedExceptionDocTagIsDeprecatedInspection
extends PhpInspection {
    public static final String EXPECTED_EXCEPTION = "@expectedException";
    public static final String EXPECTED_EXCEPTION_CODE = "@expectedExceptionCode";
    public static final String EXPECTED_EXCEPTION_MESSAGE = "@expectedExceptionMessage";
    public static final String EXCEPTION_MESSAGE_REG_EXP = "@expectedExceptionMessageRegExp";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpMethod(Method method) {
                PhpDocComment comment = method.getDocComment();
                Collection<PhpDocTag> expectedExceptionDocTags = PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.getExpectedExceptionDocTags(comment);
                if (expectedExceptionDocTags.isEmpty()) {
                    return;
                }
                PhpClass containingClass = method.getContainingClass();
                if (containingClass == null || !PhpUnitUtil.extendsRootTestClass(containingClass)) {
                    return;
                }
                boolean expectedMethodsAreAccessible = PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.expectedMethodsAreAccessible(method);
                for (PhpDocTag tag : expectedExceptionDocTags) {
                    LocalQuickFix[] localQuickFixArray;
                    Pair<String, String> methodTextAndComment = PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.getMethodReferenceTextAndComment(method, tag);
                    if (expectedMethodsAreAccessible && methodTextAndComment != null) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = new PhpReplaceTagWithExceptedExceptionMethod((String)methodTextAndComment.first);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    PsiElement nameNode = PhpPsiUtil.getChildOfType((PsiElement)tag, PhpDocTokenTypes.DOC_TAG_NAME);
                    assert (nameNode != null);
                    holder.registerProblem((PsiElement)tag, PhpBundle.message("php.tag.is.deprecated", tag.getName()), ProblemHighlightType.LIKE_DEPRECATED, nameNode.getTextRangeInParent(), fixes);
                }
            }
        };
    }

    private static boolean expectedMethodsAreAccessible(@NotNull Method method) {
        if (method == null) {
            PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.$$$reportNull$$$0(1);
        }
        return PhpUnitUtil.getTestCaseClasses(method.getProject()).stream().anyMatch(c -> c.findMethodByName((CharSequence)"expectException") != null);
    }

    @Nullable
    private static Pair<String, String> getMethodReferenceTextAndComment(@NotNull Method method, @NotNull PhpDocTag tag) {
        if (method == null) {
            PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.$$$reportNull$$$0(2);
        }
        if (tag == null) {
            PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.$$$reportNull$$$0(3);
        }
        String prefix = method.isStatic() ? "self::" : "$this->";
        String value = tag.getTagValue();
        switch (tag.getName()) {
            case "@expectedException": {
                PhpDocType exceptionFQN = (PhpDocType)PhpPsiUtil.getChildByCondition((PsiElement)tag, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF);
                if (exceptionFQN != null) {
                    return PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.createExpectExceptionCall(prefix, value, exceptionFQN.getText());
                }
                TextRange word = PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.getFirstWord(value);
                if (word != null) {
                    return PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.createExpectExceptionCall(prefix, value.substring(word.getEndOffset()), word.substring(value));
                }
            }
            case "@expectedExceptionMessage": {
                return Pair.create((Object)String.format("%s%s(\"%s\")", prefix, "expectExceptionMessage", StringUtil.escapeQuotes((String)value)), null);
            }
            case "@expectedExceptionMessageRegExp": {
                return Pair.create((Object)String.format("%s%s(\"%s\")", prefix, "expectExceptionMessageMatches", StringUtil.escapeQuotes((String)value)), null);
            }
            case "@expectedExceptionCode": {
                PhpDocRef constantReference = (PhpDocRef)PhpPsiUtil.getChildByCondition((PsiElement)tag, (Condition<? super PsiElement>)((Condition)PhpDocRef.class::isInstance));
                if (constantReference != null) {
                    return PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.createExpectExceptionCodeCall(prefix, constantReference.getText(), value);
                }
                TextRange firstWord = PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.getFirstWord(value);
                if (firstWord == null) break;
                return PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.createExpectExceptionCodeCall(prefix, firstWord.substring(value), value.substring(firstWord.getEndOffset()));
            }
        }
        return null;
    }

    @NotNull
    private static Pair<String, String> createExpectExceptionCall(String prefix, String value, String argument) {
        Pair pair = Pair.create((Object)String.format("%s%s(%s::class)", prefix, "expectException", argument), (Object)value);
        if (pair == null) {
            PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @NotNull
    private static Pair<String, String> createExpectExceptionCodeCall(String prefix, String argument, String comment) {
        Pair pair = Pair.create((Object)String.format("%s%s(%s)", prefix, "expectExceptionCode", argument), (Object)comment);
        if (pair == null) {
            PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.$$$reportNull$$$0(5);
        }
        return pair;
    }

    private static TextRange getFirstWord(String tagValue) {
        return (TextRange)ContainerUtil.getFirstItem((List)StringUtil.getWordIndicesIn((String)tagValue, Set.of(Character.valueOf(' '), Character.valueOf('\n'))));
    }

    @NotNull
    private static Collection<PhpDocTag> getExpectedExceptionDocTags(PhpDocComment comment) {
        if (comment == null) {
            List<PhpDocTag> list = Collections.emptyList();
            if (list == null) {
                PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<PhpDocTag> result = new ArrayList<PhpDocTag>();
        ContainerUtil.addAll(result, (Object[])comment.getTagElementsByName(EXPECTED_EXCEPTION));
        ContainerUtil.addAll(result, (Object[])comment.getTagElementsByName(EXPECTED_EXCEPTION_MESSAGE));
        ContainerUtil.addAll(result, (Object[])comment.getTagElementsByName(EXPECTED_EXCEPTION_CODE));
        ContainerUtil.addAll(result, (Object[])comment.getTagElementsByName(EXCEPTION_MESSAGE_REG_EXP));
        ArrayList<PhpDocTag> arrayList = result;
        if (arrayList == null) {
            PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitExpectedExceptionDocTagIsDeprecatedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitExpectedExceptionDocTagIsDeprecatedInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpectExceptionCall";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpectExceptionCodeCall";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedExceptionDocTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "expectedMethodsAreAccessible";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMethodReferenceTextAndComment";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static final class PhpReplaceTagWithExceptedExceptionMethod
    extends PsiUpdateModCommandQuickFix {
        private final String myMethodReferenceText;

        private PhpReplaceTagWithExceptedExceptionMethod(String methodReferenceText) {
            this.myMethodReferenceText = methodReferenceText;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with", this.myMethodReferenceText);
            if (string == null) {
                PhpReplaceTagWithExceptedExceptionMethod.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiComment c;
            PhpDocTag docTag;
            if (project == null) {
                PhpReplaceTagWithExceptedExceptionMethod.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceTagWithExceptedExceptionMethod.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceTagWithExceptedExceptionMethod.$$$reportNull$$$0(3);
            }
            if ((docTag = (PhpDocTag)ObjectUtils.tryCast((Object)element, PhpDocTag.class)) == null) {
                return;
            }
            PhpDocComment comment = PhpPsiUtil.getParentOfClass(element, PhpDocComment.class);
            if (comment == null) {
                return;
            }
            Method method = (Method)ObjectUtils.tryCast((Object)comment.getOwner(), Method.class);
            if (method == null) {
                return;
            }
            Pair<String, String> methodTextAndComment = PhpUnitExpectedExceptionDocTagIsDeprecatedInspection.getMethodReferenceTextAndComment(method, docTag);
            if (methodTextAndComment == null) {
                return;
            }
            Statement methodCallStatement = PhpPsiElementFactory.createStatement(project, (String)methodTextAndComment.first + ";");
            Object methodBody = PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
            if (methodBody == null) {
                return;
            }
            PsiElement addedMethodCall = methodBody.addAfter((PsiElement)methodCallStatement, methodBody.getFirstChild());
            if (!StringUtil.isEmptyOrSpaces((String)((String)methodTextAndComment.second)) && (c = PhpPsiElementFactory.createFromText(project, PsiComment.class, "<?php\n // " + (String)methodTextAndComment.second)) != null) {
                methodBody.addAfter((PsiElement)c, addedMethodCall);
            }
            PhpRemoveDocTagQuickFix.remove(docTag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitExpectedExceptionDocTagIsDeprecatedInspection$PhpReplaceTagWithExceptedExceptionMethod";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitExpectedExceptionDocTagIsDeprecatedInspection$PhpReplaceTagWithExceptedExceptionMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

