/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.inspections.PhpDeprecationQuickFixesProvider;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertUtil;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitReplaceAssertMethodReferenceQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitAssertInternalTypeQuickFixProvider
implements PhpDeprecationQuickFixesProvider {
    private static final String PHPUNIT_ASSERT_INTERNAL_TYPE_FQN = "\\PHPUnit\\Framework\\Assert.assertInternalType";
    private static final String PHPUNIT_ASSERT_NOT_INTERNAL_TYPE_FQN = "\\PHPUnit\\Framework\\Assert.assertNotInternalType";
    private static final Set<String> KNOWN_PHPUNIT_ASSERT_INTERNAL_TYPES = Set.of("array", "bool", "callable", "float", "int", "iterable", "numeric", "object", "resource", "scalar", "string");

    @Override
    @NotNull
    public Collection<? extends LocalQuickFix> createFixes(@NotNull PsiElement deprecatedReference, @NotNull PhpNamedElement deprecatedElement) {
        String methodNamePrefix;
        String deprecatedElementFQN;
        if (deprecatedReference == null) {
            PhpUnitAssertInternalTypeQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (deprecatedElement == null) {
            PhpUnitAssertInternalTypeQuickFixProvider.$$$reportNull$$$0(1);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)PHPUNIT_ASSERT_INTERNAL_TYPE_FQN, (CharSequence)(deprecatedElementFQN = deprecatedElement.getFQN()))) {
            methodNamePrefix = "assertIs";
        } else if (StringUtil.equalsIgnoreCase((CharSequence)PHPUNIT_ASSERT_NOT_INTERNAL_TYPE_FQN, (CharSequence)deprecatedElementFQN)) {
            methodNamePrefix = "assertIsNot";
        } else {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpUnitAssertInternalTypeQuickFixProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (!PhpUnitAssertUtil.isInsideTestClass(deprecatedReference)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpUnitAssertInternalTypeQuickFixProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        LocalQuickFix quickFix = PhpUnitAssertInternalTypeQuickFixProvider.getAlternativeAssertMethodQuickFix(deprecatedReference, methodNamePrefix);
        if (quickFix == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpUnitAssertInternalTypeQuickFixProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<LocalQuickFix> list = List.of(quickFix);
        if (list == null) {
            PhpUnitAssertInternalTypeQuickFixProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    private static LocalQuickFix getAlternativeAssertMethodQuickFix(@NotNull PsiElement deprecatedReference, @NotNull String methodNamePrefix) {
        MethodReference methodReference;
        if (deprecatedReference == null) {
            PhpUnitAssertInternalTypeQuickFixProvider.$$$reportNull$$$0(6);
        }
        if (methodNamePrefix == null) {
            PhpUnitAssertInternalTypeQuickFixProvider.$$$reportNull$$$0(7);
        }
        if ((methodReference = (MethodReference)ObjectUtils.tryCast((Object)deprecatedReference, MethodReference.class)) == null) {
            return null;
        }
        PsiElement[] parameters = methodReference.getParameters();
        int parametersNumber = parameters.length;
        if (parametersNumber != 2 && parametersNumber != 3) {
            return null;
        }
        StringLiteralExpression firstStringParameter = (StringLiteralExpression)ObjectUtils.tryCast((Object)parameters[0], StringLiteralExpression.class);
        if (firstStringParameter == null) {
            return null;
        }
        String expectedType = firstStringParameter.getContents();
        if (!KNOWN_PHPUNIT_ASSERT_INTERNAL_TYPES.contains(expectedType)) {
            return null;
        }
        return new PhpUnitAssertInternalTypeQuickFix(methodNamePrefix + StringUtil.capitalize((String)expectedType), parametersNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/quickfix/PhpUnitAssertInternalTypeQuickFixProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNamePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/quickfix/PhpUnitAssertInternalTypeQuickFixProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFixes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeAssertMethodQuickFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class PhpUnitAssertInternalTypeQuickFix
    extends PhpUnitReplaceAssertMethodReferenceQuickFix {
        private PhpUnitAssertInternalTypeQuickFix(@NotNull String newMethodName, int parametersNumber) {
            if (newMethodName == null) {
                PhpUnitAssertInternalTypeQuickFix.$$$reportNull$$$0(0);
            }
            super(newMethodName, parametersNumber);
        }

        @Override
        @Nullable
        protected PsiElement getMethodIdentifierFromProblemDescriptor(@NotNull PsiElement startElement) {
            if (startElement == null) {
                PhpUnitAssertInternalTypeQuickFix.$$$reportNull$$$0(1);
            }
            return PhpPsiUtil.getChildOfType(startElement, PhpTokenTypes.IDENTIFIER);
        }

        @Override
        protected PsiElement @Nullable [] createNewParameters(PsiElement @NotNull [] parameters) {
            PsiElement[] newParametersArray;
            if (parameters == null) {
                PhpUnitAssertInternalTypeQuickFix.$$$reportNull$$$0(2);
            }
            if ((newParametersArray = super.createNewParameters(parameters)) == null) {
                return null;
            }
            return Arrays.copyOfRange(newParametersArray, 1, newParametersArray.length);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newMethodName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/quickfix/PhpUnitAssertInternalTypeQuickFixProvider$PhpUnitAssertInternalTypeQuickFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getMethodIdentifierFromProblemDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createNewParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

