/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpUnusedAliasInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitDeprecatedExpectExceptionInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveStatementQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix
extends PsiUpdateModCommandQuickFix {
    private final String myNewMethodName;

    public PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix(@NotNull String newMethodName) {
        if (newMethodName == null) {
            PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.$$$reportNull$$$0(0);
        }
        this.myNewMethodName = newMethodName;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.phpunit.replace.current.method.with.alternative", this.myNewMethodName);
        if (string == null) {
            PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement methodIdentifier, @NotNull ModPsiUpdater updater) {
        MethodReference reference;
        if (project == null) {
            PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.$$$reportNull$$$0(2);
        }
        if (methodIdentifier == null) {
            PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.$$$reportNull$$$0(4);
        }
        if ((reference = PhpPsiUtil.getParentOfClass(methodIdentifier, MethodReference.class)) == null) {
            return;
        }
        ParameterList parametersList = reference.getParameterList();
        if (parametersList == null) {
            return;
        }
        String removedParameterFqn = PhpUnitDeprecatedExpectExceptionInspection.getClassFqnOfDeprecatedParameter(reference);
        if (removedParameterFqn == null) {
            return;
        }
        PsiElement anchor = methodIdentifier.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, this.myNewMethodName));
        parametersList.replace((PsiElement)PhpPsiElementFactory.createParameterList(project, ""));
        PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.removeUnusedStatements(removedParameterFqn, anchor);
    }

    private static void removeUnusedStatements(@NotNull String removedParameterFqn, PsiElement anchor) {
        PhpPsiElement scope;
        if (removedParameterFqn == null) {
            PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix.$$$reportNull$$$0(5);
        }
        if ((scope = PhpCodeInsightUtil.findScopeForUseOperator(anchor)) == null) {
            return;
        }
        List<PhpUse> phpUses = PhpCodeInsightUtil.collectImports(scope).stream().flatMap(useList -> Arrays.stream(useList.getDeclarations())).toList();
        for (PhpUse use : PhpUnusedAliasInspection.filterUnused((PsiElement)scope, phpUses)) {
            if (use.getTargetReference() == null || !removedParameterFqn.equalsIgnoreCase(use.getTargetReference().getFQN())) continue;
            PhpRemoveStatementQuickFix.REMOVE_USE.remove((PsiElement)use);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMethodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/quickfix/PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodIdentifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedParameterFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/quickfix/PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeUnusedStatements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

