/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpArrayIndexImmediatelyRewrittenInspection;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpObjectFieldsAreOnlyWrittenInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpObjectFieldsAreOnlyWrittenInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpNewExpression(NewExpression expression) {
                PsiElement parent = expression.getParent();
                if (parent instanceof AssignmentExpression && !(parent instanceof SelfAssignmentExpression) && ((AssignmentExpression)parent).getValue() == expression) {
                    final Variable variable = (Variable)ObjectUtils.tryCast((Object)((AssignmentExpression)parent).getVariable(), Variable.class);
                    if (variable == null) {
                        return;
                    }
                    PhpType variableType = variable.getGlobalType();
                    PhpIndex index = PhpIndex.getInstance((Project)holder.getProject());
                    final boolean hasFieldSetMethod = PhpCodeInsightUtil.hasMagicMethod(variableType, index, "__set");
                    final boolean hasArraySetMethod = PhpCodeInsightUtil.hasMagicMethod(variableType, index, "offsetSet");
                    PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
                    if (instruction == null) {
                        return;
                    }
                    PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable);
                    if (scopeHolder != null && PhpControlFlowUtil.isReferenced(scopeHolder, instruction)) {
                        return;
                    }
                    final Ref readExists = new Ref((Object)false);
                    final Ref fieldWriteExists = new Ref((Object)false);
                    PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(this){

                        public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                            if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName())) {
                                PhpPsiElement anchor = instruction.getAnchor();
                                if (anchor.getParent() instanceof MemberReference || anchor.getParent() instanceof ArrayAccessExpression) {
                                    return true;
                                }
                                if (!PhpArrayIndexImmediatelyRewrittenInspection.isPlainWriteAccess((PsiElement)anchor)) {
                                    readExists.set((Object)true);
                                }
                                return false;
                            }
                            return super.processAccessVariableInstruction(instruction);
                        }

                        public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                            if (this.doCheckTopmostClassReference((PsiElement)instruction.getFieldReference())) {
                                return false;
                            }
                            return super.processAccessFieldByVariableInstruction(instruction);
                        }

                        public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                            if (this.doCheckTopmostClassReference((PsiElement)instruction.getAnchor())) {
                                return false;
                            }
                            return super.processArrayAccessInstruction(instruction);
                        }

                        private boolean doCheckTopmostClassReference(PsiElement reference) {
                            if (reference == null) {
                                return false;
                            }
                            PsiElement parent = reference.getParent();
                            if (parent instanceof MemberReference || parent instanceof ArrayAccessExpression) {
                                return false;
                            }
                            PhpExpression classReference = PhpObjectFieldsAreOnlyWrittenInspection.getTopmostClassReference(reference);
                            if (classReference instanceof Variable && PhpLangUtil.equalsVariableNames(classReference.getName(), variable.getName())) {
                                if (!PhpArrayIndexImmediatelyRewrittenInspection.isPlainWriteAccess(reference) || this.mayContainSideEffect(reference)) {
                                    readExists.set((Object)true);
                                    return true;
                                }
                                fieldWriteExists.set((Object)true);
                            }
                            return false;
                        }

                        private boolean mayContainSideEffect(PsiElement reference) {
                            if (hasArraySetMethod && reference instanceof ArrayAccessExpression && ((ArrayAccessExpression)reference).getValue() instanceof Variable) {
                                return true;
                            }
                            return hasFieldSetMethod && reference instanceof FieldReference && ((FieldReference)reference).getClassReference() instanceof Variable;
                        }

                        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                            PhpExpression classReference;
                            FunctionReference functionReference = instruction.getFunctionReference();
                            if (functionReference instanceof MethodReference && (classReference = PhpObjectFieldsAreOnlyWrittenInspection.getTopmostClassReference((PsiElement)functionReference)) instanceof Variable && PhpLangUtil.equalsVariableNames(classReference.getName(), variable.getName())) {
                                readExists.set((Object)true);
                                return false;
                            }
                            return super.processPhpCallInstruction(instruction);
                        }
                    });
                    if (((Boolean)fieldWriteExists.get()).booleanValue() && !((Boolean)readExists.get()).booleanValue()) {
                        holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.message.local.object.used.only.for.writing.properties", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    @Nullable
    private static PhpExpression getTopmostClassReference(@Nullable PsiElement memberReference) {
        PsiElement classReference = memberReference;
        while (true) {
            if (classReference instanceof MemberReference) {
                classReference = ((MemberReference)classReference).getClassReference();
                continue;
            }
            if (!(classReference instanceof ArrayAccessExpression)) break;
            classReference = ((ArrayAccessExpression)classReference).getValue();
        }
        return (PhpExpression)ObjectUtils.tryCast((Object)classReference, PhpExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpObjectFieldsAreOnlyWrittenInspection", "buildVisitor"));
    }
}

