/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpToStringReturnInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpToStringReturnInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpMethod(Method method) {
                PhpClass aClass;
                if (PhpLangUtil.equalsMethodNames(method.getNameCS(), "__toString") && (aClass = method.getContainingClass()) != null && !aClass.isAbstract() && !aClass.isTrait()) {
                    PhpType type = method.getGlobalType();
                    if (type.isAmbiguous() || PhpType.isSubType((PhpType)PhpType.STRING, (PhpType)type) || PhpType.isSubType((PhpType)PhpType.NEVER, (PhpType)type)) {
                        return;
                    }
                    PsiElement namePsiElement = method.getNameIdentifier();
                    if (namePsiElement == null) {
                        return;
                    }
                    holder.registerProblem(namePsiElement, PhpBundle.message("inspection.message.tostring.method.must.return.string", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpToStringReturnInspection", "buildVisitor"));
    }
}

