/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethodTag;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddTagBaseQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpParameterInfo;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpAddMethodTagQuickFix
extends PhpAddTagBaseQuickFix<PhpClass>
implements LowPriorityAction {
    public static final PhpAddMethodTagQuickFix INSTANCE = new PhpAddMethodTagQuickFix();

    private PhpAddMethodTagQuickFix() {
    }

    @Override
    @NotNull
    protected String getTagName() {
        return "@method";
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        MemberReference memberReference;
        if (project == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(1);
        }
        if ((memberReference = PhpPsiUtil.getParentOfClass(element = descriptor.getPsiElement(), MemberReference.class)) == null) {
            return;
        }
        if (PhpAddMethodDeclarationQuickFix.findClassWithValidation(project, element, memberReference) == null) {
            return;
        }
        WriteAction.run(() -> super.applyFix(project, descriptor));
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        PsiElement element;
        MemberReference memberReference;
        if (project == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(2);
        }
        if (previewDescriptor == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(3);
        }
        if ((memberReference = PhpPsiUtil.getParentOfClass(element = previewDescriptor.getPsiElement(), MemberReference.class)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpAddMethodTagQuickFix.$$$reportNull$$$0(4);
            }
            return intentionPreviewInfo;
        }
        PhpClass clazz = PhpAddMethodDeclarationQuickFix.findClassWithValidation(project, element, memberReference);
        if (clazz == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpAddMethodTagQuickFix.$$$reportNull$$$0(5);
            }
            return intentionPreviewInfo;
        }
        String addedTag = PhpAddMethodTagQuickFix.createTagText(project, clazz, element);
        return new IntentionPreviewInfo.CustomDiff((FileType)PhpFileType.INSTANCE, clazz.getContainingFile().getName(), "", addedTag);
    }

    @Override
    @NotNull
    public PhpClass getOwner(@NotNull PsiElement element) {
        if (element == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(6);
        }
        PhpClass phpClass = PhpAddMethodTagQuickFix.findClass(element);
        if (phpClass == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(7);
        }
        return phpClass;
    }

    @Override
    @NotNull
    protected PhpDocComment getDocComment(@NotNull PsiElement element) {
        if (element == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(8);
        }
        PhpClass phpClass = PhpAddMethodTagQuickFix.findClass(element);
        assert (phpClass != null);
        PhpDocComment docComment = phpClass.getDocComment();
        if (docComment == null) {
            docComment = PhpPsiElementFactory.createPhpPsiFromText(element.getProject(), PhpDocComment.class, "/**\n */");
            docComment = (PhpDocComment)phpClass.getParent().addBefore((PsiElement)docComment, (PsiElement)phpClass);
        }
        PhpDocComment phpDocComment = docComment;
        if (phpDocComment == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(9);
        }
        return phpDocComment;
    }

    @Nullable
    private static PhpClass findClass(@NotNull PsiElement element) {
        if (element == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(10);
        }
        return PhpQuickFixBase.resolveClass(PhpPsiUtil.getParentOfClass(element, MemberReference.class), false);
    }

    @Override
    @NotNull
    public PsiElement getTag(@NotNull Project project, @NotNull PhpClass phpClass, @NotNull PsiElement element) {
        if (project == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(11);
        }
        if (phpClass == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(12);
        }
        if (element == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(13);
        }
        PhpDocMethodTag phpDocMethodTag = PhpPsiElementFactory.createPhpPsiFromText(project, PhpDocMethodTag.class, PhpAddMethodTagQuickFix.createTagText(project, phpClass, element));
        if (phpDocMethodTag == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(14);
        }
        return phpDocMethodTag;
    }

    @NotNull
    private static String createTagText(@NotNull Project project, @NotNull PhpClass phpClass, @NotNull PsiElement element) {
        if (project == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(15);
        }
        if (phpClass == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(16);
        }
        if (element == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(17);
        }
        StringBuilder builder2 = new StringBuilder("/**\n * @method ");
        MemberReference memberReference = PhpPsiUtil.getParentOfClass(element, MemberReference.class);
        assert (memberReference != null);
        if (memberReference.getReferenceType().isStatic()) {
            builder2.append("static ");
        }
        builder2.append(element.getText());
        Collection<PhpParameterInfo> infos = PhpAddMethodDeclarationQuickFix.getParametersInfos((PhpExpression)memberReference);
        builder2.append(PhpAddMethodDeclarationQuickFix.makeParameterList(project, infos, (PsiElement)phpClass, true, true));
        builder2.append("\n */");
        String string = builder2.toString();
        if (string == null) {
            PhpAddMethodTagQuickFix.$$$reportNull$$$0(18);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 9, 14, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodTagQuickFix";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddMethodTagQuickFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocComment";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTag";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 14: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOwner";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDocComment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTag";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createTagText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 9, 14, 18 -> new IllegalStateException(string);
        };
    }
}

