/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.type;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddInferredTypeAsPropertyTypeQuickFix
extends PhpQuickFixBase {
    private final PhpType myInferredType;
    private final String myTypeStr;
    private final boolean myIsOnTheFly;

    public PhpAddInferredTypeAsPropertyTypeQuickFix(@NotNull PhpType type, @NotNull String typeStr, boolean isOnTheFly) {
        if (type == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (typeStr == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(1);
        }
        this.myTypeStr = typeStr;
        this.myInferredType = type;
        this.myIsOnTheFly = isOnTheFly;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = PhpBundle.message("quickfix.change.field.type.add.inferred.type.name", this.myTypeStr);
        if (string == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.change.field.type.add.inferred.type.family.name", new Object[0]);
        if (string == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Field field;
        if (project == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(5);
        }
        if ((field = PhpChangeFieldTypeToMatchSuperQuickFix.getTargetField(descriptor.getStartElement())) != null) {
            if (field.getDeclaredType().equals((Object)this.myInferredType)) {
                return;
            }
            List<Field> fieldsInHierarchy = PhpAddInferredTypeAsPropertyTypeQuickFix.getFieldsInHierarchy(field);
            String error = PhpAddInferredTypeAsPropertyTypeQuickFix.validateElementsChange(fieldsInHierarchy);
            if (error == null) {
                fieldsInHierarchy.forEach(f -> f.updateType(this.myInferredType));
            } else if (this.myIsOnTheFly) {
                PhpAddInferredTypeAsPropertyTypeQuickFix.showErrorMessage(project, error, (PsiElement)field);
            }
        }
    }

    @NotNull
    private static List<Field> getFieldsInHierarchy(Field field) {
        SmartList fieldsInHierarchy = new SmartList();
        fieldsInHierarchy.add(field);
        if (!field.getModifier().isPrivate()) {
            PhpClassHierarchyUtils.processOverridingFields((Field)field, (arg_0, arg_1, arg_2) -> PhpAddInferredTypeAsPropertyTypeQuickFix.lambda$getFieldsInHierarchy$1((List)fieldsInHierarchy, arg_0, arg_1, arg_2));
            PhpClassHierarchyUtils.processSuperFields((Field)field, (arg_0, arg_1, arg_2) -> PhpAddInferredTypeAsPropertyTypeQuickFix.lambda$getFieldsInHierarchy$2((List)fieldsInHierarchy, arg_0, arg_1, arg_2));
        }
        SmartList smartList = fieldsInHierarchy;
        if (smartList == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    public static boolean canApplyFix(@NotNull Field field) {
        if (field == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(7);
        }
        return ContainerUtil.all(PhpAddInferredTypeAsPropertyTypeQuickFix.getFieldsInHierarchy(field), f -> f.getManager().isInProject((PsiElement)f));
    }

    @NlsContexts.HintText
    @Nullable
    private static String validateElementsChange(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(8);
        }
        for (PsiElement psiElement : elements) {
            if (!psiElement.isWritable()) {
                return PhpBundle.message("quickfix.change.field.type.add.inferred.type.error.read.only", psiElement.getContainingFile().getName());
            }
            if (IntentionPreviewUtils.isPreviewElement((PsiElement)psiElement) || psiElement.getManager().isInProject(psiElement)) continue;
            return PhpBundle.message("quickfix.change.field.type.add.inferred.type.error.non.project", psiElement.getContainingFile().getName());
        }
        return null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Field field;
        if (project == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(9);
        }
        if (previewDescriptor == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(10);
        }
        if ((field = PhpChangeFieldTypeToMatchSuperQuickFix.getTargetField(previewDescriptor.getStartElement())) == null || field.getDeclaredType().equals((Object)this.myInferredType)) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(11);
            }
            return intentionPreviewInfo;
        }
        field.updateType(this.myInferredType);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            PhpAddInferredTypeAsPropertyTypeQuickFix.$$$reportNull$$$0(12);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ boolean lambda$getFieldsInHierarchy$2(List fieldsInHierarchy, Field member, PhpClass subClass, PhpClass baseClass) {
        fieldsInHierarchy.add(member);
        return true;
    }

    private static /* synthetic */ boolean lambda$getFieldsInHierarchy$1(List fieldsInHierarchy, Field superMember, PhpClass subClass, PhpClass baseClass) {
        fieldsInHierarchy.add(superMember);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeStr";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpAddInferredTypeAsPropertyTypeQuickFix";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpAddInferredTypeAsPropertyTypeQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsInHierarchy";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canApplyFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateElementsChange";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 11, 12 -> new IllegalStateException(string);
        };
    }
}

