/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.TreeChooser;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpTreeClassChooserDialog;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManagerImpl;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassPatternsPanel
extends JPanel {
    @NotNull
    private final List<PhpEntryPointsManagerImpl.ClassPattern> myPatterns;
    @NotNull
    private final JBTable myTable;

    public PhpClassPatternsPanel(@NotNull List<PhpEntryPointsManagerImpl.ClassPattern> patterns) {
        if (patterns == null) {
            PhpClassPatternsPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myPatterns = patterns;
        this.myTable = this.createTableForPatterns();
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(button -> this.chooseClass()).setAddActionName(PhpBundle.message("add.class1", new Object[0])).setRemoveAction(button -> {
            TableUtil.removeSelectedItems((JTable)this.myTable);
            this.myTable.repaint();
        }).setRemoveActionUpdater(e -> this.myTable.getSelectedRow() >= 0);
        this.add((Component)SeparatorFactory.createSeparator((String)PhpBundle.message("inspection.code.patterns.panel.description.label", new Object[0]), null), "North");
        this.add((Component)toolbarDecorator.createPanel(), "Center");
        this.add((Component)new MultiLineLabel(PhpBundle.message("inspection.code.patterns.panel.description.text", new Object[0])), "South");
        this.setPreferredSize((Dimension)new JBDimension(-1, 250));
    }

    @NotNull
    public List<PhpEntryPointsManagerImpl.ClassPattern> getPatterns() {
        List<PhpEntryPointsManagerImpl.ClassPattern> list = this.myPatterns;
        if (list == null) {
            PhpClassPatternsPanel.$$$reportNull$$$0(1);
        }
        return list;
    }

    private void chooseClass() {
        PhpTreeClassChooserDialog chooserDialog;
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myTable));
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        if ((chooserDialog = new PhpTreeClassChooserDialog(PhpBundle.message("add.class1", new Object[0]), project, (TreeChooser.Filter<PhpClass>)((TreeChooser.Filter)phpClass -> true))).showAndGet()) {
            this.addSelectedClass(chooserDialog);
        }
    }

    private void addSelectedClass(@NotNull PhpTreeClassChooserDialog chooserDialog) {
        PhpClass selectedClass;
        if (chooserDialog == null) {
            PhpClassPatternsPanel.$$$reportNull$$$0(2);
        }
        if ((selectedClass = (PhpClass)chooserDialog.getSelected()) != null) {
            this.insertRow(selectedClass.getFQN());
        }
    }

    private void insertRow(@NotNull String pattern) {
        if (pattern == null) {
            PhpClassPatternsPanel.$$$reportNull$$$0(3);
        }
        PhpEntryPointsManagerImpl.ClassPattern classPattern = new PhpEntryPointsManagerImpl.ClassPattern();
        classPattern.pattern = pattern;
        this.myPatterns.add(classPattern);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        int row = this.myPatterns.size() - 1;
        model.fireTableRowsInserted(row, row);
        this.myTable.setRowSelectionInterval(row, row);
    }

    @NotNull
    private JBTable createTableForPatterns() {
        JBTable result = new JBTable((TableModel)new MyTableModel());
        result.getSelectionModel().setSelectionMode(0);
        result.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof String && ((String)value).isEmpty()) {
                    this.setText(PhpBundle.message("constructors", new Object[0]));
                    this.setForeground(NamedColorUtil.getInactiveTextColor());
                } else if (value instanceof String) {
                    this.setText((String)value);
                    this.setForeground(UIUtil.getTableForeground((boolean)isSelected, (boolean)hasFocus));
                }
                return component;
            }
        });
        TableCellEditor editor = result.getDefaultEditor(String.class);
        if (editor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(1);
        }
        JBTable jBTable = result;
        if (jBTable == null) {
            PhpClassPatternsPanel.$$$reportNull$$$0(4);
        }
        return jBTable;
    }

    @NlsContexts.DialogMessage
    @Nullable
    public String getValidationError() {
        TableUtil.stopEditing((JTable)this.myTable);
        ClassPatternValidator validator = new ClassPatternValidator();
        for (PhpEntryPointsManagerImpl.ClassPattern pattern : this.myPatterns) {
            String errorText = validator.getErrorText(pattern.pattern);
            if (errorText != null) {
                return errorText;
            }
            String subst = pattern.member.replace("*", "");
            if (!StringUtil.containsWhitespaces((CharSequence)subst)) continue;
            return PhpBundle.message("inspection.code.patterns.panel.errors.member", pattern.member);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/PhpClassPatternsPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooserDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/PhpClassPatternsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatterns";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableForPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSelectedClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "insertRow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }

    private class MyTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        private final String @NotNull [] myNames = new String[]{"Class", "Member"};

        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return PhpClassPatternsPanel.this.myPatterns.size();
        }

        @Override
        @Nullable
        public Object getValueAt(int row, int col) {
            if (row < 0 || row > PhpClassPatternsPanel.this.myPatterns.size() - 1) {
                return null;
            }
            PhpEntryPointsManagerImpl.ClassPattern classPattern = PhpClassPatternsPanel.this.myPatterns.get(row);
            if (classPattern == null) {
                return null;
            }
            if (col == 0) {
                return classPattern.pattern;
            }
            return classPattern.member;
        }

        @Override
        public String getColumnName(int column) {
            return this.myNames[column];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(col));
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            PhpEntryPointsManagerImpl.ClassPattern classPattern = PhpClassPatternsPanel.this.myPatterns.get(row);
            if (classPattern == null) {
                return;
            }
            if (col == 0) {
                classPattern.pattern = (String)aValue;
            } else {
                classPattern.member = (String)aValue;
            }
            this.fireTableRowsUpdated(row, row);
        }

        public void removeRow(int idx) {
            PhpClassPatternsPanel.this.myPatterns.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }
    }

    private static class ClassPatternValidator
    implements InputValidatorEx {
        private ClassPatternValidator() {
        }

        @Nullable
        @Nls
        public String getErrorText(String inputString) {
            if (!PhpLangUtil.isFqn(inputString)) {
                return PhpBundle.message("inspection.code.patterns.panel.errors.class", new Object[0]);
            }
            String fqn = inputString.replace("*", "").replaceFirst("\\\\", "");
            return StringUtil.isEmpty((String)fqn) || StringUtil.containsWhitespaces((CharSequence)fqn) ? PhpBundle.message("inspection.code.patterns.panel.errors.class", new Object[0]) : null;
        }

        public boolean canClose(String inputString) {
            return this.getErrorText(inputString) == null;
        }
    }
}

