/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefConstant;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefField;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMembersToReportOptionsPanel
extends LocalInspectionTool
implements UnfairLocalInspectionTool {
    @NotNull
    @NonNls
    public static final String DEFAULT_VISIBILITY = PhpModifier.Access.PUBLIC.toString();
    public boolean FIELD = true;
    public boolean CONST = true;
    public boolean METHOD = true;
    public boolean CLASS = true;
    public boolean FUNCTION = true;
    public boolean MAGIC_METHOD = true;
    private String myConstVisibility = DEFAULT_VISIBILITY;
    private String myFieldVisibility = DEFAULT_VISIBILITY;
    private String myMethodVisibility = DEFAULT_VISIBILITY;

    public boolean isAccepted(@NotNull UserDataHolder element) {
        if (element == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(0);
        }
        if (element instanceof PhpClass || element instanceof PhpRefClass) {
            return this.CLASS;
        }
        if (element instanceof Method || element instanceof PhpRefMethod) {
            String name = element instanceof Method ? ((Method)element).getName() : ((PhpRefMethod)element).getName();
            return PhpLangUtil.isMagicMethod(name) ? this.MAGIC_METHOD : this.METHOD;
        }
        if (element instanceof Function || element instanceof PhpRefFunction) {
            return this.FUNCTION;
        }
        if (element instanceof Field || element instanceof PhpRefField) {
            boolean isConstant = element instanceof Field ? ((Field)element).isConstant() : ((PhpRefField)element).isConstant();
            return isConstant ? this.CONST : this.FIELD;
        }
        if (element instanceof Constant || element instanceof PhpRefConstant) {
            return this.CONST;
        }
        return true;
    }

    public boolean isComparableByVisibility(@Nullable UserDataHolder element) {
        return element instanceof Function || element instanceof PhpRefFunction || element instanceof Field || element instanceof PhpRefField;
    }

    @NotNull
    public PhpModifier.Access getAcceptedVisibility(@Nullable UserDataHolder element) {
        if (element instanceof Field || element instanceof PhpRefField) {
            boolean isConstant = element instanceof Field ? ((Field)element).isConstant() : ((PhpRefField)element).isConstant();
            PhpModifier.Access access = isConstant ? this.getConstVisibility() : this.getFieldVisibility();
            if (access == null) {
                PhpMembersToReportOptionsPanel.$$$reportNull$$$0(1);
            }
            return access;
        }
        if (element instanceof Method || element instanceof PhpRefMethod) {
            PhpModifier.Access access = this.getMethodVisibility();
            if (access == null) {
                PhpMembersToReportOptionsPanel.$$$reportNull$$$0(2);
            }
            return access;
        }
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        if (access == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(3);
        }
        return access;
    }

    @NotNull
    public PhpModifier.Access getFieldVisibility() {
        PhpModifier.Access access = PhpChangeSignatureUsageProcessor.accessFromString(this.myFieldVisibility);
        if (access == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(4);
        }
        return access;
    }

    public void setFieldVisibility(@NotNull String fieldVisibility) {
        if (fieldVisibility == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(5);
        }
        this.myFieldVisibility = fieldVisibility;
    }

    @NotNull
    public PhpModifier.Access getMethodVisibility() {
        PhpModifier.Access access = PhpChangeSignatureUsageProcessor.accessFromString(this.myMethodVisibility);
        if (access == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(6);
        }
        return access;
    }

    public void setMethodVisibility(@NotNull String methodVisibility) {
        if (methodVisibility == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(7);
        }
        this.myMethodVisibility = methodVisibility;
    }

    @NotNull
    public PhpModifier.Access getConstVisibility() {
        PhpModifier.Access access = PhpChangeSignatureUsageProcessor.accessFromString(this.myConstVisibility);
        if (access == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(8);
        }
        return access;
    }

    public void setConstVisibility(@NotNull String constVisibility) {
        if (constVisibility == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(9);
        }
        this.myConstVisibility = constVisibility;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptDropdown.Option[] options = (OptDropdown.Option[])StreamEx.of((Object[])PhpModifier.Access.values()).map(val -> OptPane.option((String)val.toString(), (String)val.toString())).toArray(OptDropdown.Option.class);
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"FIELD", (String)PhpBundle.message("inspection.unused.symbol.check.fields", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.dropdown((String)"myFieldVisibility", (String)"", (OptDropdown.Option[])options)}), OptPane.checkbox((String)"METHOD", (String)PhpBundle.message("inspection.unused.symbol.check.methods", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.dropdown((String)"myMethodVisibility", (String)"", (OptDropdown.Option[])options)}), OptPane.checkbox((String)"CONST", (String)PhpBundle.message("inspection.unused.symbol.check.constants", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.dropdown((String)"myConstVisibility", (String)"", (OptDropdown.Option[])options)}), OptPane.checkbox((String)"CLASS", (String)PhpBundle.message("inspection.unused.symbol.check.classes", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"FUNCTION", (String)PhpBundle.message("inspection.unused.symbol.check.functions", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"MAGIC_METHOD", (String)PhpBundle.message("inspection.unused.symbol.check.magic_method", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(10);
        }
        return optPane;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "PhpUnused";
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "PhpUnused";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(11);
        }
        PhpMembersToReportOptionsPanel.writeVisibility(node, this.myFieldVisibility, "field_visibility");
        PhpMembersToReportOptionsPanel.writeVisibility(node, this.myMethodVisibility, "method_visibility");
        PhpMembersToReportOptionsPanel.writeVisibility(node, this.myConstVisibility, "const_visibility");
        super.writeSettings(node);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(12);
        }
        super.readSettings(node);
        this.myFieldVisibility = PhpMembersToReportOptionsPanel.readVisibility(node, "field_visibility");
        this.myMethodVisibility = PhpMembersToReportOptionsPanel.readVisibility(node, "method_visibility");
        this.myConstVisibility = PhpMembersToReportOptionsPanel.readVisibility(node, "const_visibility");
    }

    private static void writeVisibility(Element node, String visibility, String type) {
        if (!DEFAULT_VISIBILITY.equals(visibility)) {
            node.setAttribute(type, visibility);
        }
    }

    private static String readVisibility(@NotNull Element node, String type) {
        String visibility;
        if (node == null) {
            PhpMembersToReportOptionsPanel.$$$reportNull$$$0(13);
        }
        if ((visibility = node.getAttributeValue(type)) == null) {
            return DEFAULT_VISIBILITY;
        }
        return visibility;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/PhpMembersToReportOptionsPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldVisibility";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodVisibility";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constVisibility";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/PhpMembersToReportOptionsPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedVisibility";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldVisibility";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodVisibility";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstVisibility";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAccepted";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFieldVisibility";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMethodVisibility";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setConstVisibility";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readVisibility";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 8, 10 -> new IllegalStateException(string);
        };
    }
}

