/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.strictStandards;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpAbstractStaticMethodInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpAbstractStaticMethodInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpMethod(Method method) {
                if (PhpProjectConfigurationFacade.getInstance(holder.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP700)) {
                    return;
                }
                if (!method.getContainingClass().isInterface() && method.isAbstract() && method.isStatic()) {
                    PsiElement namePsiElement = method.getNameIdentifier();
                    if (namePsiElement == null) {
                        return;
                    }
                    holder.registerProblem(namePsiElement, PhpBundle.message("inspection.php.abstract.static.method.description", new Object[0]), new LocalQuickFix[0]);
                } else {
                    super.visitPhpMethod(method);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/strictStandards/PhpAbstractStaticMethodInspection", "buildVisitor"));
    }
}

