/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.stubs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.config.PhpExtensionsManager;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurableForm;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpSimpleFunctionDefinedDFAnalyzer;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedConstantInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedFunctionInspection;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpComposerExtensionStubsInspection
extends PhpInspection {
    public boolean REQUIRE_BUNDLED_EXTENSIONS = true;

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"REQUIRE_BUNDLED_EXTENSIONS", (String)PhpBundle.message("inspection.missing.ext.require.bundled", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpComposerExtensionStubsInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpComposerExtensionStubsInspection.$$$reportNull$$$0(1);
        }
        HashSet excludedCategories = this.REQUIRE_BUNDLED_EXTENSIONS ? ContainerUtil.newHashSet((Object[])new PhpExtensionsManager.ExtensionCategory[]{PhpExtensionsManager.ExtensionCategory.CORE}) : ContainerUtil.newHashSet((Object[])new PhpExtensionsManager.ExtensionCategory[]{PhpExtensionsManager.ExtensionCategory.CORE, PhpExtensionsManager.ExtensionCategory.BUNDLED});
        ComposerDataService dataService = ComposerDataService.getInstance(holder.getProject());
        if (dataService == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerExtensionStubsInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        VirtualFile config = ComposerConfigManager.getInstance(holder.getProject()).getConfig((PsiElement)holder.getFile());
        if (config == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerExtensionStubsInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        PhpComposerExtensionStubsInspection.saveLaterIfNeeded(config);
        final EnumMap<DependencyContext, Set<String>> extensions = PhpComposerExtensionStubsInspection.getExtensions(holder.getProject(), config);
        if (extensions == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerExtensionStubsInspection.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        Map<String, PhpExtensionsManager.ExtensionCategory> extensionToCategory = PhpProjectConfigurableForm.getExtensionToCategory();
        final Map extensionMap = PhpRuntimeLibraryRootsProvider.getLibraryRoots(holder.getProject()).stream().filter(ext -> !excludedCategories.contains(extensionToCategory.get(ext.getName()))).collect(Collectors.toMap(ext -> "ext-" + StringUtil.toLowerCase((String)ext.getName()).replace(' ', '-'), Function.identity()));
        return new PhpElementVisitor(this){

            public void visitPhpClassReference(ClassReference classReference) {
                this.inspect((PhpReference)classReference);
            }

            public void visitPhpDocType(PhpDocType phpDocType) {
                this.inspect((PhpReference)phpDocType);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.inspect((PhpReference)reference);
            }

            public void visitPhpCallableFunction(PhpCallableFunction reference) {
                this.inspect((PhpReference)reference);
            }

            public void visitPhpConstantReference(ConstantReference reference) {
                this.inspect((PhpReference)reference);
            }

            private void inspect(@NotNull PhpReference reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PhpComposerExtensionStubsInspection.isDfaReachable((PsiElement)reference)) {
                    return;
                }
                MultiMap missedExtensions = MultiMap.create();
                boolean dev = ProjectRootManager.getInstance((Project)reference.getProject()).getFileIndex().isInTestSourceContent(reference.getContainingFile().getVirtualFile());
                for (ResolveResult result : reference.multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (element == null) {
                        return;
                    }
                    VirtualFile file = element.getContainingFile().getVirtualFile();
                    String missedExtension = (String)ContainerUtil.find(extensionMap.keySet(), ext -> this.missedExtension((String)ext, file, dev ? DependencyContext.DEV : DependencyContext.ALL));
                    if (missedExtension == null) {
                        return;
                    }
                    missedExtensions.putValue((Object)missedExtension, (Object)file);
                }
                if (missedExtensions.size() == 0) {
                    return;
                }
                assert (missedExtensions.size() == 1);
                String missedExtension = (String)ContainerUtil.getFirstItem((Collection)missedExtensions.keySet());
                if (missedExtensions.get((Object)missedExtension).size() != 1) {
                    return;
                }
                if (PhpComposerExtensionStubsInspection.isExtensionDfaReachable(missedExtension, reference)) {
                    return;
                }
                VirtualFile missedExtensionFile = (VirtualFile)ContainerUtil.getFirstItem((Collection)missedExtensions.get((Object)missedExtension));
                if (!this.missedExtension(missedExtension, missedExtensionFile, DependencyContext.DEV)) {
                    String message = PhpBundle.message("inspection.ext.is.specified.in.require.dev.but.used.outside.tests", missedExtension);
                    moveToRequireFix = MoveFromDevToRequireQuickFix.getInstance(missedExtension, DependencyContext.DEV, DependencyContext.ALL);
                    holder.registerProblem((PsiElement)reference, message, ProblemHighlightType.WEAK_WARNING, reference.getRangeInElement(), new LocalQuickFix[]{moveToRequireFix});
                } else if (!this.missedExtension(missedExtension, missedExtensionFile, DependencyContext.SUGGEST)) {
                    LocalQuickFix[] localQuickFixArray;
                    String message = PhpBundle.message("inspection.ext.is.specified.in.suggest", missedExtension);
                    moveToRequireFix = MoveFromDevToRequireQuickFix.getInstance(missedExtension, DependencyContext.SUGGEST, DependencyContext.ALL);
                    LocalQuickFix moveToDevFix = MoveFromDevToRequireQuickFix.getInstance(missedExtension, DependencyContext.SUGGEST, DependencyContext.DEV);
                    if (dev) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
                        localQuickFixArray2[0] = moveToRequireFix;
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[1] = moveToDevFix;
                    } else {
                        LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray3;
                        localQuickFixArray3[0] = moveToRequireFix;
                    }
                    LocalQuickFix[] fixes = localQuickFixArray;
                    holder.registerProblem((PsiElement)reference, message, ProblemHighlightType.WEAK_WARNING, reference.getRangeInElement(), fixes);
                } else {
                    String message = PhpBundle.message("inspection.missing.ext.composer.json", missedExtension);
                    holder.registerProblem((PsiElement)reference, reference.getRangeInElement(), message, new LocalQuickFix[]{AddToComposerJsonQuickFix.getInstance(missedExtension, isOnTheFly, dev)});
                }
            }

            private boolean missedExtension(String ext, VirtualFile file, DependencyContext context) {
                if ("ext-json".equals(ext) && PhpLanguageLevel.current((Project)holder.getProject()).isAtLeast(PhpLanguageLevel.PHP800)) {
                    return false;
                }
                return !((Set)extensions.get((Object)DependencyContext.ALL)).contains(ext) && !((Set)extensions.get((Object)context)).contains(ext) && VfsUtilCore.isAncestor((VirtualFile)((VirtualFile)extensionMap.get(ext)), (VirtualFile)file, (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$1", "inspect"));
            }
        };
    }

    @Nullable
    private static EnumMap<DependencyContext, Set<String>> getExtensions(@NotNull Project project, @NotNull VirtualFile config) {
        if (project == null) {
            PhpComposerExtensionStubsInspection.$$$reportNull$$$0(5);
        }
        if (config == null) {
            PhpComposerExtensionStubsInspection.$$$reportNull$$$0(6);
        }
        EnumMap<DependencyContext, Set<String>> res = new EnumMap<DependencyContext, Set<String>>(DependencyContext.class);
        VirtualFile mainConfig = ComposerConfigManager.getInstance(project).getMainConfig();
        for (DependencyContext context : DependencyContext.values()) {
            Set<String> currentConfigExtensions;
            Set<String> extensionsFromMain;
            HashSet<String> extensions = new HashSet<String>();
            if (mainConfig != null && !mainConfig.equals(config) && (extensionsFromMain = ComposerConfigUtils.getExtensions(mainConfig, context)) != null) {
                extensions.addAll(extensionsFromMain);
            }
            if ((currentConfigExtensions = ComposerConfigUtils.getExtensions(config, context)) == null) {
                return null;
            }
            extensions.addAll(currentConfigExtensions);
            res.put(context, extensions);
        }
        return res;
    }

    private static boolean isExtensionDfaReachable(String extensionName, PhpReference reference) {
        PhpInstruction instruction = PhpUndefinedClassInspection.findNearestInstruction((PsiElement)reference);
        Ref canBeDefined = Ref.create((Object)false);
        Ref canBeUndefined = Ref.create((Object)false);
        if (instruction != null) {
            PhpDFAUtil.performReachingDefinitions(instruction, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, StringUtil.trimStart((String)extensionName, (String)"ext-"), new PhpSimpleFunctionDefinedDFAnalyzer("extension_loaded"));
        }
        return (Boolean)canBeDefined.get() != false && (Boolean)canBeUndefined.get() == false;
    }

    private static boolean isDfaReachable(PsiElement reference) {
        if (reference instanceof ClassReference) {
            Ref canBeDefined = Ref.create((Object)false);
            Ref canBeUndefined = Ref.create((Object)false);
            PhpUndefinedClassInspection.processDfaReachability((ClassReference)reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
            return (Boolean)canBeDefined.get() != false && (Boolean)canBeUndefined.get() == false;
        }
        if (reference instanceof FunctionReference || reference instanceof PhpCallableFunction) {
            return PhpUndefinedFunctionInspection.isDfaReachable((PhpReference)reference) == Boolean.TRUE;
        }
        if (reference instanceof ConstantReference) {
            return PhpUndefinedConstantInspection.isDfaReachable((ConstantReference)reference) == Boolean.TRUE;
        }
        return false;
    }

    private static void saveLaterIfNeeded(@NotNull VirtualFile config) {
        FileDocumentManager documentManager;
        Document document;
        if (config == null) {
            PhpComposerExtensionStubsInspection.$$$reportNull$$$0(7);
        }
        if ((document = (documentManager = FileDocumentManager.getInstance()).getDocument(config)) != null && documentManager.isDocumentUnsaved(document)) {
            ApplicationManager.getApplication().invokeLater(() -> documentManager.saveDocument(document));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveLaterIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    public static enum DependencyContext {
        ALL{

            @Override
            public String getSectionName() {
                return "require";
            }
        }
        ,
        DEV{

            @Override
            public String getSectionName() {
                return "require-dev";
            }
        }
        ,
        SUGGEST{

            @Override
            public String getSectionName() {
                return "suggest";
            }
        };


        public abstract String getSectionName();
    }

    private static final class AddToComposerJsonQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final Set<AddToComposerJsonQuickFix> fixCache = ConcurrentCollectionFactory.createConcurrentSet();
        private final String myExtension;
        private final boolean myOnTheFly;
        private final boolean myDev;

        private AddToComposerJsonQuickFix(@NotNull String extension, boolean onTheFly, boolean dev) {
            if (extension == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(0);
            }
            this.myExtension = extension;
            this.myOnTheFly = onTheFly;
            this.myDev = dev;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("add.to.composer.json.quick.fix", this.myExtension);
            if (string == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            VirtualFile file;
            if (project == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(4);
            }
            if ((file = AddToComposerJsonQuickFix.getComposerJsonFile(element)) == null) {
                return;
            }
            JsonObject requireSectionValue = AddToComposerJsonQuickFix.findRequireSectionValue(project, updater, PsiManager.getInstance((Project)project).findFile(file), this.myDev ? DependencyContext.DEV : DependencyContext.ALL);
            if (requireSectionValue == null) {
                return;
            }
            requireSectionValue = (JsonObject)updater.getWritable((PsiElement)requireSectionValue);
            JsonProperty property = AddToComposerJsonQuickFix.findOrCreateProperty(project, requireSectionValue, this.myExtension, "\"*\"");
            updater.moveCaretTo((PsiElement)property);
        }

        @Nullable
        static VirtualFile getComposerJsonFile(@NotNull PsiElement context) {
            String path;
            if (context == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(5);
            }
            return (path = ComposerConfigManager.getInstance(context.getProject()).getConfigPath(context)) != null ? LocalFileSystem.getInstance().refreshAndFindFileByPath(path) : null;
        }

        @Nullable
        private static JsonObject findRequireSectionValue(@NotNull Project project, @NotNull ModPsiUpdater updater, PsiFile psiFile, DependencyContext context) {
            JsonObject topObject;
            if (project == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(6);
            }
            if (updater == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(7);
            }
            String path = ComposerDataService.getInstance(project).getConfigPath();
            if (psiFile == null) {
                updater.cancel(PhpBundle.message("action.detect.composer.json.not.found", path));
                return null;
            }
            JsonFile jsonFile = (JsonFile)updater.getWritable((PsiElement)((JsonFile)ObjectUtils.tryCast((Object)psiFile, JsonFile.class)));
            if (jsonFile == null) {
                return null;
            }
            JsonValue value = jsonFile.getTopLevelValue();
            if (value == null) {
                jsonFile.add((PsiElement)new JsonElementGenerator(project).createValue("{}"));
            }
            if ((topObject = (JsonObject)ObjectUtils.tryCast((Object)jsonFile.getTopLevelValue(), JsonObject.class)) == null) {
                return null;
            }
            JsonProperty requireSection = AddToComposerJsonQuickFix.findOrCreateProperty(project, topObject, context.getSectionName(), "{}");
            return (JsonObject)requireSection.getValue();
        }

        private static JsonProperty findOrCreateProperty(@NotNull Project project, @NotNull JsonObject parent, @NotNull String propertyName, @NotNull String propertyValue) {
            JsonProperty property;
            if (project == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(8);
            }
            if (parent == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(9);
            }
            if (propertyName == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(10);
            }
            if (propertyValue == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(11);
            }
            if ((property = parent.findProperty(propertyName)) != null) {
                return property;
            }
            JsonElementGenerator generator = new JsonElementGenerator(project);
            property = generator.createProperty(propertyName, propertyValue);
            List list = parent.getPropertyList();
            if (list.isEmpty()) {
                parent = (JsonObject)parent.replace((PsiElement)generator.createObject(property.getText()));
                return parent.findProperty(propertyName);
            }
            PsiElement comma = parent.addAfter(generator.createComma(), (PsiElement)ContainerUtil.getLastItem((List)list));
            return (JsonProperty)parent.addAfter((PsiElement)property, comma);
        }

        public static LocalQuickFix getInstance(@NotNull String extension, boolean onTheFly, boolean dev) {
            AddToComposerJsonQuickFix fix;
            if (extension == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(12);
            }
            if ((fix = (AddToComposerJsonQuickFix)((Object)ContainerUtil.find(fixCache, i -> i.myExtension.equals(extension) && i.myDev == dev && i.myOnTheFly == onTheFly))) == null) {
                fix = new AddToComposerJsonQuickFix(extension, onTheFly, dev);
                fixCache.add(fix);
            }
            return fix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$AddToComposerJsonQuickFix";
                    break;
                }
                case 2: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$AddToComposerJsonQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getComposerJsonFile";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findRequireSectionValue";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreateProperty";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MoveFromDevToRequireQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myExtension;
        private final DependencyContext myFrom;
        private final DependencyContext myTo;

        private MoveFromDevToRequireQuickFix(String extension, DependencyContext from, DependencyContext to) {
            this.myExtension = extension;
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.move.from.to.composer.json.section", this.myExtension, this.myFrom.getSectionName(), this.myTo.getSectionName());
            if (string == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            VirtualFile file;
            if (project == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(3);
            }
            if ((file = AddToComposerJsonQuickFix.getComposerJsonFile(element)) == null) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            JsonProperty extensionFrom = this.findExtensionToMoveFrom(project, updater, psiFile);
            if (extensionFrom == null) {
                return;
            }
            JsonValue extensionInDevValue = (extensionFrom = (JsonProperty)updater.getWritable((PsiElement)extensionFrom)).getValue();
            if (extensionInDevValue == null) {
                return;
            }
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)extensionFrom, TokenSet.create((IElementType[])new IElementType[]{PsiUtilCore.getElementType((PsiElement)new JsonElementGenerator(project).createComma())}), false);
            JsonProperty property = this.moveExtensionTo(project, updater, psiFile, extensionFrom, extensionInDevValue);
            if (property != null) {
                updater.moveCaretTo((PsiElement)property);
            }
        }

        @Nullable
        private JsonProperty moveExtensionTo(@NotNull Project project, @NotNull ModPsiUpdater updater, @Nullable PsiFile file, JsonProperty extensionInDev, JsonValue extensionInDevValue) {
            if (project == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(5);
            }
            if (file == null) {
                return null;
            }
            JsonObject requireSection = AddToComposerJsonQuickFix.findRequireSectionValue(project, updater, file, this.myTo);
            return requireSection != null ? AddToComposerJsonQuickFix.findOrCreateProperty(project, requireSection, extensionInDev.getName(), extensionInDevValue.getText()) : null;
        }

        @Nullable
        private JsonProperty findExtensionToMoveFrom(@NotNull Project project, @NotNull ModPsiUpdater updater, @Nullable PsiFile file) {
            if (project == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(6);
            }
            if (updater == null) {
                MoveFromDevToRequireQuickFix.$$$reportNull$$$0(7);
            }
            if (file == null) {
                return null;
            }
            JsonObject requireDevSection = AddToComposerJsonQuickFix.findRequireSectionValue(project, updater, file, this.myFrom);
            return requireDevSection != null ? requireDevSection.findProperty(this.myExtension) : null;
        }

        private static LocalQuickFix getInstance(String extension, DependencyContext from, DependencyContext to) {
            return new MoveFromDevToRequireQuickFix(extension, from, to);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$MoveFromDevToRequireQuickFix";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$MoveFromDevToRequireQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "moveExtensionTo";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findExtensionToMoveFrom";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

