/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpUpdateTypeDeclarationQuickFix;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRedundantTypeInUnionTypeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantTypeInUnionTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpTypeDeclaration(PhpTypeDeclaration typeDeclaration) {
                Project project = typeDeclaration.getProject();
                PhpType declaredType = typeDeclaration.getGlobalType();
                LinkedHashMap<PhpType, Set<PhpType>> equivalenceClasses = new LinkedHashMap<PhpType, Set<PhpType>>();
                for (String type : declaredType.getTypesSorted()) {
                    PhpType typePart = new PhpType().add(type);
                    PhpType original = PhpHierarchyChecksInspection.unwrapAlias(typePart, project);
                    equivalenceClasses.computeIfAbsent(original, t -> new LinkedHashSet()).add(typePart);
                }
                if (equivalenceClasses.size() != declaredType.size()) {
                    PhpType reducedType = PhpRedundantTypeInUnionTypeInspection.composeReducedType(equivalenceClasses);
                    String reducedTypeString = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, reducedType, (PsiElement)typeDeclaration);
                    assert (reducedTypeString != null);
                    holder.problem((PsiElement)typeDeclaration, PhpBundle.message("inspection.php.redundant.type.in.union.type.template", reducedTypeString)).fix((ModCommandAction)new PhpUpdateTypeDeclarationQuickFix(typeDeclaration, reducedType)).register();
                }
            }
        };
    }

    @NotNull
    private static PhpType composeReducedType(@NotNull Map<PhpType, Set<PhpType>> equivalenceClasses) {
        if (equivalenceClasses == null) {
            PhpRedundantTypeInUnionTypeInspection.$$$reportNull$$$0(1);
        }
        PhpType reducedType = new PhpType();
        for (Map.Entry<PhpType, Set<PhpType>> entry : equivalenceClasses.entrySet()) {
            PhpType original = entry.getKey();
            Set<PhpType> equivalentTypes = entry.getValue();
            reducedType.add(equivalentTypes.contains(original) ? original : (PhpType)ContainerUtil.getFirstItem(equivalentTypes));
        }
        PhpType phpType = reducedType;
        if (phpType == null) {
            PhpRedundantTypeInUnionTypeInspection.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equivalenceClasses";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpRedundantTypeInUnionTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpRedundantTypeInUnionTypeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "composeReducedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "composeReducedType";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

