/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.phpdoc.PhpRedundantDocCommentInspection;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorMethodData;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpAddFieldAccessorBase
extends PsiUpdateModCommandAction<Field> {
    PhpAddFieldAccessorBase() {
        super(Field.class);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull Field field) {
        if (context == null) {
            PhpAddFieldAccessorBase.$$$reportNull$$$0(0);
        }
        if (field == null) {
            PhpAddFieldAccessorBase.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable((PsiElement)field)) {
            return null;
        }
        if (PhpAddFieldAccessorBase.isApplicableToContainingClass(field) && !field.isConstant() && this.isAvailable(field)) {
            return Presentation.of((String)this.getFamilyName());
        }
        return null;
    }

    private static boolean isApplicableToContainingClass(@NotNull Field field) {
        PhpClass phpClass;
        if (field == null) {
            PhpAddFieldAccessorBase.$$$reportNull$$$0(2);
        }
        return (phpClass = field.getContainingClass()) != null && !phpClass.isInterface();
    }

    protected void invoke(@NotNull ActionContext context, @NotNull Field parent, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpAddFieldAccessorBase.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            PhpAddFieldAccessorBase.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            PhpAddFieldAccessorBase.$$$reportNull$$$0(5);
        }
        PhpAccessorMethodData[] accessors = this.createAccessors(parent);
        for (int i = 0; i < accessors.length; ++i) {
            PhpAccessorMethodData accessor = accessors[i];
            if (accessor == null) continue;
            PhpDocComment docComment = PhpAddFieldAccessorBase.isDocCommentRedundant(accessor) ? null : accessor.getDocComment();
            PsiElement addedAccessor = PhpCodeEditUtil.insertClassMemberWithPhpDoc(accessor.getTargetClass(), (PsiElement)accessor.getMethod(), docComment);
            if (i != 0) continue;
            updater.moveCaretTo(addedAccessor);
        }
    }

    private static boolean isDocCommentRedundant(PhpAccessorMethodData accessor) {
        Method method = accessor.getMethod();
        if (accessor.getDocComment() == null || method == null) {
            return true;
        }
        return PhpRedundantDocCommentInspection.isRedundantFunctionDocComment(method.getProject(), (Function)method, accessor.getDocComment());
    }

    protected abstract PhpAccessorMethodData[] createAccessors(Field var1);

    protected abstract boolean isAvailable(Field var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpAddFieldAccessorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableToContainingClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

