/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.type.PhpIllegalArrayKeyTypeInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFlipKeyValueIntention
extends PsiUpdateModCommandAction<PsiElement> {
    public PhpFlipKeyValueIntention() {
        super(PsiElement.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("flip.key.value.intention.family.name", new Object[0]);
        if (string == null) {
            PhpFlipKeyValueIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        Collection<Pair<PsiElement, PsiElement>> keyValuesToFlip;
        if (context == null) {
            PhpFlipKeyValueIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpFlipKeyValueIntention.$$$reportNull$$$0(2);
        }
        if (!(keyValuesToFlip = PhpFlipKeyValueIntention.getKeyValuePairsFromAnArray(element)).isEmpty()) {
            return Presentation.of((String)PhpBundle.message("flip.key.value.intention.message.all.in.array", new Object[0]));
        }
        keyValuesToFlip = PhpFlipKeyValueIntention.getSingleKeyValuePair(element);
        if (!keyValuesToFlip.isEmpty()) {
            return Presentation.of((String)PhpBundle.message("flip.key.value.intention.message.single", new Object[0]));
        }
        return null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Collection<Pair<PsiElement, PsiElement>> keyValuesToFlip;
        if (context == null) {
            PhpFlipKeyValueIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpFlipKeyValueIntention.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            PhpFlipKeyValueIntention.$$$reportNull$$$0(5);
        }
        if ((keyValuesToFlip = PhpFlipKeyValueIntention.getKeyValuePairsFromAnArray(element)).isEmpty()) {
            keyValuesToFlip = PhpFlipKeyValueIntention.getSingleKeyValuePair(element);
        }
        for (Pair<PsiElement, PsiElement> pair : keyValuesToFlip) {
            PhpFlipKeyValueIntention.flip((PsiElement)pair.first, (PsiElement)pair.second);
        }
    }

    @NotNull
    private static Collection<Pair<PsiElement, PsiElement>> getSingleKeyValuePair(@NotNull PsiElement element) {
        Collection<Pair<PsiElement, PsiElement>> keyValueToFlip;
        if (element == null) {
            PhpFlipKeyValueIntention.$$$reportNull$$$0(6);
        }
        if ((keyValueToFlip = PhpFlipKeyValueIntention.getKeyValuePairFromAnArrayElement(element)).isEmpty()) {
            keyValueToFlip = PhpFlipKeyValueIntention.getKeyValueFromForeach(element);
        }
        if (keyValueToFlip.isEmpty()) {
            keyValueToFlip = PhpFlipKeyValueIntention.getKeyValueFromForeachHash(element);
        }
        Collection<Pair<PsiElement, PsiElement>> collection = keyValueToFlip;
        if (collection == null) {
            PhpFlipKeyValueIntention.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private static Collection<Pair<PsiElement, PsiElement>> getKeyValuePairsFromAnArray(PsiElement element) {
        if ((element = PhpFlipKeyValueIntention.getCurrentOrPrevKwArrayOrSquareBracket(element)) == null) {
            return Collections.emptyList();
        }
        ArrayCreationExpressionImpl arrayCreationExpression = PhpPsiUtil.getParentOfClass(element, ArrayCreationExpressionImpl.class);
        if (arrayCreationExpression == null) {
            return Collections.emptyList();
        }
        PsiElement[] arrayElements = arrayCreationExpression.getChildren();
        if (arrayElements.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Pair<PsiElement, PsiElement>> results = new ArrayList<Pair<PsiElement, PsiElement>>();
        for (PsiElement arrayElement : arrayElements) {
            ArrayHashElement hashElement = (ArrayHashElement)ObjectUtils.tryCast((Object)arrayElement, ArrayHashElement.class);
            if (hashElement == null || !PhpFlipKeyValueIntention.canBeFlipped(hashElement)) {
                return Collections.emptyList();
            }
            results.add((Pair<PsiElement, PsiElement>)new Pair((Object)hashElement.getKey(), (Object)hashElement.getValue()));
        }
        return results;
    }

    private static boolean canBeFlipped(ArrayHashElement arrayHashElement) {
        PhpTypedElement value = (PhpTypedElement)ObjectUtils.tryCast((Object)arrayHashElement.getValue(), PhpTypedElement.class);
        return value != null && !PhpFlipKeyValueIntention.isValuePassedByReference((PsiElement)value) && PhpIllegalArrayKeyTypeInspection.isValidArrayKeyType(value);
    }

    @Nullable
    private static PsiElement getCurrentOrPrevKwArrayOrSquareBracket(PsiElement element) {
        if (PhpFlipKeyValueIntention.isKwArrayOrSquareBracket(element)) {
            return element;
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element);
        if (PhpFlipKeyValueIntention.isKwArrayOrSquareBracket(prevLeaf)) {
            return prevLeaf;
        }
        return null;
    }

    private static boolean isKwArrayOrSquareBracket(PsiElement element) {
        return PhpPsiUtil.isOfType(element, PhpTokenTypes.kwARRAY, PhpTokenTypes.chLBRACKET, PhpTokenTypes.chRBRACKET);
    }

    private static Collection<Pair<PsiElement, PsiElement>> getKeyValuePairFromAnArrayElement(PsiElement element) {
        ArrayHashElement arrayHashElement = PhpPsiUtil.getParentOfClass(element, ArrayHashElement.class);
        if (arrayHashElement == null || !(arrayHashElement.getParent() instanceof ArrayCreationExpression)) {
            return Collections.emptyList();
        }
        return PhpFlipKeyValueIntention.canBeFlipped(arrayHashElement) ? Collections.singletonList(new Pair((Object)arrayHashElement.getKey(), (Object)arrayHashElement.getValue())) : Collections.emptyList();
    }

    private static boolean isValuePassedByReference(PsiElement element) {
        return element instanceof PhpReference && PhpCodeInsightUtil.isForeachKeyOrValueAssignedByReference((PhpReference)element);
    }

    private static Collection<Pair<PsiElement, PsiElement>> getKeyValueFromForeach(PsiElement element) {
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.kwFOREACH)) {
            return Collections.emptyList();
        }
        ForeachStatement foreachStatement = PhpPsiUtil.getParentOfClass(element, ForeachStatement.class);
        if (foreachStatement == null) {
            return Collections.emptyList();
        }
        return foreachStatement.getKey() != null && foreachStatement.getValue() != null ? Collections.singletonList(new Pair((Object)foreachStatement.getKey(), (Object)foreachStatement.getValue())) : Collections.emptyList();
    }

    private static Collection<Pair<PsiElement, PsiElement>> getKeyValueFromForeachHash(PsiElement element) {
        ForeachStatement foreachStatement;
        if (element instanceof PsiWhiteSpace) {
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        if ((foreachStatement = (ForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)element, ForeachStatement.class, (boolean)true, (Class[])new Class[]{GroupStatement.class})) == null) {
            return Collections.emptyList();
        }
        Variable value = foreachStatement.getValue();
        Variable key = foreachStatement.getKey();
        return value != null && key != null && (PhpPsiUtil.isOfType(element, PhpTokenTypes.opHASH_ARRAY) || PhpPsiUtil.areElementsEquivalent(element.getParent(), (PsiElement)value) || PhpPsiUtil.areElementsEquivalent(element.getParent(), (PsiElement)key)) ? Collections.singletonList(new Pair((Object)foreachStatement.getKey(), (Object)foreachStatement.getValue())) : Collections.emptyList();
    }

    private static void flip(@Nullable PsiElement key, @Nullable PsiElement value) {
        if (key == null || value == null) {
            return;
        }
        PsiElement keyCopy = key.copy();
        key.replace(value);
        value.replace(keyCopy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpFlipKeyValueIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpFlipKeyValueIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleKeyValuePair";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSingleKeyValuePair";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

