/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.findUsages.PhpGotoTargetRendererProvider;
import com.jetbrains.php.lang.inspections.classes.PhpAddMethodStubsQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpImplementMethodIntention
extends BaseElementAtCaretIntentionAction {
    public static final @NlsContexts.Command @Nls String ACTION_NAME = PhpBundle.message("implement.method", new Object[0]);
    private static final Condition<PsiElement> METHOD_CONDITION = Conditions.and((Condition)Method.INSTANCEOF, (Condition)Conditions.not(PhpDocMethod.class::isInstance));

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        Method method;
        Collection classes;
        if (project == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(2);
        }
        if ((classes = (Collection)PhpImplementMethodIntention.subClassesWithoutImplementation(project, method = PhpImplementMethodIntention.getMethodAtCaret(element)).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        if (classes.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            PhpImplementMethodIntention.doImplementMethod(project, classes, method);
        } else {
            PhpImplementMethodIntention.createClassesChooserBuilder(project, classes, method).createPopup().showInBestPositionFor(editor);
        }
    }

    @NotNull
    private static IPopupChooserBuilder<PhpClass> createClassesChooserBuilder(Project project, Collection<PhpClass> classes, Method method) {
        PhpGotoTargetRendererProvider.PhpNamedElementPsiElementListCellRenderer renderer = new PhpGotoTargetRendererProvider.PhpNamedElementPsiElementListCellRenderer(false);
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(new ArrayList<PhpClass>(classes)).setSelectionMode(2).setRenderer((ListCellRenderer)((Object)renderer)).setTitle(CodeInsightBundle.message((String)"intention.implement.abstract.method.class.chooser.title", (Object[])new Object[0])).setItemsChosenCallback(selectedClasses -> {
            if (!selectedClasses.isEmpty()) {
                CommandProcessor.getInstance().executeCommand(project, () -> PhpImplementMethodIntention.doImplementMethod(project, selectedClasses, method), ACTION_NAME, null);
            }
        });
        renderer.installSpeedSearch(builder2);
        IPopupChooserBuilder iPopupChooserBuilder = builder2;
        if (iPopupChooserBuilder == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(3);
        }
        return iPopupChooserBuilder;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void doImplementMethod(Project project, Collection<? extends PhpClass> values, Method method) {
        Method lastAddedMethod;
        Ref lastClass = new Ref();
        List writableClasses = ContainerUtil.filter(values, e -> PhpQuickFixBase.ensureFileWritableInQuickFix(project, e.getContainingFile().getVirtualFile()));
        WriteAction.run(() -> {
            for (PhpClass phpClass : writableClasses) {
                lastClass.set((Object)phpClass);
                PhpAddMethodStubsQuickFix.addMethodStubs(project, phpClass, Collections.singleton(method));
            }
        });
        if (!lastClass.isNull() && (lastAddedMethod = ((PhpClass)lastClass.get()).findOwnMethodByName((CharSequence)method.getName())) != null) {
            PhpCodeUtil.openRelatedFile(project, (PsiElement)lastAddedMethod);
        }
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(6);
        }
        return PhpImplementMethodIntention.subClassesWithoutImplementation(project, PhpImplementMethodIntention.getMethodAtCaret(element)).limit(1L).count() > 0L;
    }

    private static Method getMethodAtCaret(@NotNull PsiElement element) {
        if (element == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(7);
        }
        return (Method)PhpPsiUtil.getParentByCondition(element, false, METHOD_CONDITION, (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    private static Stream<PhpClass> subClassesWithoutImplementation(@NotNull Project project, @Nullable Method method) {
        if (project == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(8);
        }
        if (method == null) {
            return Stream.empty();
        }
        PhpClass containingClass = method.getContainingClass();
        if (containingClass == null || !containingClass.isInterface()) {
            return Stream.empty();
        }
        return PhpIndex.getInstance((Project)project).getAllSubclasses(containingClass.getFQN()).stream().filter(e -> !e.isInterface()).filter(e -> e.findOwnMethodByName((CharSequence)method.getName()) == null);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = ACTION_NAME;
        if (string == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpImplementMethodIntention.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpImplementMethodIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpImplementMethodIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassesChooserBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMethodAtCaret";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "subClassesWithoutImplementation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 10 -> new IllegalStateException(string);
        };
    }
}

