/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.actions.PhpNamedElementNode;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInitializeFieldsIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getText() {
        String string = PhpBundle.message("intention.family.name.initialize.properties", new Object[0]);
        if (string == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.initialize.properties", new Object[0]);
        if (string == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(3);
        }
        PhpClass containingClass = PhpPsiUtil.getParentOfClass(element, true, PhpClass.class);
        Collection<Parameter> parameters = PhpInitializeFieldsIntention.getUnsavedParameters(element);
        if (containingClass != null && !parameters.isEmpty()) {
            Object selected;
            Object selectedElements = new ArrayList<PhpNamedElementNode>();
            for (Parameter parameter : parameters) {
                if (!StringUtil.isNotEmpty((String)parameter.getName()) || parameter.isPromotedField()) continue;
                selectedElements.add(new PhpNamedElementNode((PhpNamedElement)parameter));
            }
            if (!ApplicationManager.getApplication().isHeadlessEnvironment() && parameters.size() > 1) {
                MemberChooser<PhpNamedElementNode> chooser = new MemberChooser<PhpNamedElementNode>(this, selectedElements.toArray(new PhpNamedElementNode[0]), false, true, project){
                    private MemberChooser.ShowContainersAction myShowContainersAction;
                    {
                        this.setTitle(PhpBundle.message("dialog.title.select.properties.to.initialize", new Object[0]));
                        this.setCopyJavadocVisible(false);
                    }

                    protected void fillToolbarActions(DefaultActionGroup group) {
                        super.fillToolbarActions(group);
                        this.setShowClasses(true);
                        group.remove((AnAction)this.myShowContainersAction);
                    }

                    protected MemberChooser.ShowContainersAction getShowContainersAction() {
                        this.myShowContainersAction = super.getShowContainersAction();
                        return this.myShowContainersAction;
                    }

                    public void dispose() {
                        super.dispose();
                        this.myShowContainersAction = null;
                    }
                };
                chooser.show();
                if (chooser.getExitCode() != 0) {
                    return;
                }
                selected = chooser.getSelectedElements();
                selectedElements = selected == null ? Collections.emptyList() : selected;
            }
            ArrayList<Parameter> toInitialize = new ArrayList<Parameter>();
            selected = selectedElements.iterator();
            while (selected.hasNext()) {
                PhpNamedElementNode selectedElement = (PhpNamedElementNode)((Object)selected.next());
                PsiElement parameter = selectedElement.getPsiElement();
                if (!(parameter instanceof Parameter)) continue;
                toInitialize.add((Parameter)parameter);
            }
            PsiFile file = containingClass.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
            PhpModifier.Access visibilityModifier = phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY;
            ApplicationManager.getApplication().runWriteAction(() -> PhpRefactoringUtil.initializeFieldsByParameters(containingClass, toInitialize, visibilityModifier));
        }
    }

    @Nullable
    private static Method getConstructor(@NotNull PsiElement element) {
        PhpClass containingClass;
        if (element == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(4);
        }
        return (containingClass = PhpPsiUtil.getParentOfClass(element, true, PhpClass.class)) == null ? null : containingClass.getConstructor();
    }

    @NotNull
    private static Collection<Parameter> getUnsavedParameters(@NotNull PsiElement element) {
        Method constructor;
        Parameter[] parameters;
        if (element == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(5);
        }
        Parameter[] parameterArray = parameters = (constructor = PhpInitializeFieldsIntention.getConstructor(element)) == null ? null : constructor.getParameters();
        if (constructor == null || parameters.length == 0) {
            List<Parameter> list = Collections.emptyList();
            if (list == null) {
                PhpInitializeFieldsIntention.$$$reportNull$$$0(6);
            }
            return list;
        }
        final HashSet savedParameters = new HashSet();
        constructor.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element instanceof AssignmentExpression) {
                    this.visitPhpAssignmentExpression((AssignmentExpression)element);
                } else {
                    super.visitElement(element);
                }
            }

            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                PhpPsiElement value = assignmentExpression.getValue();
                if (value instanceof Variable && assignmentExpression.getVariable() instanceof FieldReference) {
                    savedParameters.add(((Variable)value).getNameCS());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/intentions/PhpInitializeFieldsIntention$2", "visitElement"));
            }
        });
        ArrayList<Parameter> unsavedParameters = new ArrayList<Parameter>();
        for (Parameter parameter : parameters) {
            if (savedParameters.contains(parameter.getNameCS())) continue;
            unsavedParameters.add(parameter);
        }
        ArrayList<Parameter> arrayList = unsavedParameters;
        if (arrayList == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiFile file;
        if (project == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(8);
        }
        if (element == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(9);
        }
        if (!((file = element.getContainingFile()) instanceof PhpFile)) {
            return false;
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        if (!PhpInitializeFieldsIntention.isInvokedOnConstructor(element)) {
            return false;
        }
        Parameter parameter = PhpPsiUtil.getParentOfClass(element, Parameter.class);
        if (parameter != null && parameter.isPromotedField()) {
            return false;
        }
        Method constructor = PhpPsiUtil.getParentOfClass(element, true, Method.class);
        Object groupStatement = PhpPsiUtil.getChildByCondition((PsiElement)constructor, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (groupStatement == null) {
            return false;
        }
        return !PhpInitializeFieldsIntention.getUnsavedParameters(element).isEmpty();
    }

    private static boolean isInvokedOnConstructor(@NotNull PsiElement element) {
        ParameterList parameters;
        if (element == null) {
            PhpInitializeFieldsIntention.$$$reportNull$$$0(10);
        }
        if ((parameters = PhpPsiUtil.getParentOfClass(element, false, ParameterList.class)) != null) {
            return PhpRefactoringUtil.isElementConstructor(parameters.getParent());
        }
        PsiElement parent = element.getParent();
        if (PhpRefactoringUtil.isElementConstructor(parent)) {
            return ((Function)parent).getNameIdentifier() == element || PhpPsiUtil.isOfType(element, PhpTokenTypes.kwFUNCTION) || PhpPsiUtil.isOfType(element, PhpTokenTypes.chLPAREN) || PhpPsiUtil.isOfType(element, PhpTokenTypes.chRPAREN) || PhpPsiUtil.isOfType(element, TokenSet.WHITE_SPACE) && PhpPsiUtil.isOfType(element.getNextSibling(), PhpTokenTypes.chRPAREN);
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpInitializeFieldsIntention";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpInitializeFieldsIntention";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedParameters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConstructor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUnsavedParameters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isInvokedOnConstructor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

