/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.strings.converters;

import com.intellij.modcommand.ActionContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.intentions.PhpReplaceQuotesIntention;
import com.jetbrains.php.lang.intentions.strings.converters.PhpLazyStringPartDescriptor;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringLiteralLazyStringPartDescriptor;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptor;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptorImpl;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringRepresentationConverter;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.List;
import java.util.Optional;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInterpolationStringRepresentationConverter
implements PhpStringRepresentationConverter<StringLiteralExpression> {
    public static final PhpInterpolationStringRepresentationConverter INSTANCE = new PhpInterpolationStringRepresentationConverter();

    @Override
    @NotNull
    public List<PhpStringPartDescriptor> getStringParts(@NotNull StringLiteralExpression string, @NotNull ActionContext context) {
        if (string == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(1);
        }
        List<PhpStringPartDescriptor> list = this.getStringParts(string);
        if (list == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<PhpStringPartDescriptor> getStringParts(@NotNull StringLiteralExpression string) {
        if (string == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(3);
        }
        SmartList result = new SmartList();
        boolean singleQuote = string.isSingleQuote();
        for (PsiElement child = string.getFirstChild(); child != null; child = child.getNextSibling()) {
            Project project = string.getProject();
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.STRING_LITERAL, PhpTokenTypes.HEREDOC_CONTENTS)) {
                String childText = child.getText();
                result.add(new PhpStringLiteralLazyStringPartDescriptor(project, childText, singleQuote));
                continue;
            }
            if (!(child instanceof Variable)) continue;
            PhpPsiElement innerExpression = ((Variable)child).getFirstPsiChild();
            if (innerExpression != null) {
                if (PhpPsiUtil.isOfType(child.getFirstChild(), PhpTokenTypes.DOLLAR_LBRACE) && innerExpression instanceof ArrayAccessExpression) {
                    result.add(new PhpLazyStringPartDescriptor(() -> PhpPsiElementFactory.createPhpPsiFromText(project, ArrayAccessExpression.class, "$" + innerExpression.getText()), ArrayAccessExpression.class, PhpElementTypes.ARRAY_ACCESS_EXPRESSION));
                    continue;
                }
                result.add(new PhpStringPartDescriptorImpl((PsiElement)innerExpression));
                continue;
            }
            String name = ((Variable)child).getName();
            result.add(new PhpLazyStringPartDescriptor(() -> PhpPsiElementFactory.createVariable(project, name, true), Variable.class, (IElementType)PhpStubElementTypes.VARIABLE));
        }
        SmartList smartList = result;
        if (smartList == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @Override
    public boolean isAvailable(@NotNull StringLiteralExpression string, @NotNull ActionContext context) {
        if (string == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(6);
        }
        return !string.isSingleQuote() && PhpPsiUtil.getChildByCondition((PsiElement)string, (Condition<? super PsiElement>)Variable.INSTANCEOF) != null;
    }

    @Override
    @NotNull
    public StringLiteralExpression createExpression(@NotNull Project project, @NotNull List<PsiElement> parts) {
        if (project == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(7);
        }
        if (parts == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(8);
        }
        boolean useSingleQuote = PhpInterpolationStringRepresentationConverter.allLiteralsAreSingleQuoted(parts);
        StringLiteralExpression stringLiteralExpression = PhpPsiElementFactory.createStringLiteralExpression(project, PhpInterpolationStringRepresentationConverter.createExpressionContent(parts, useSingleQuote), useSingleQuote);
        if (stringLiteralExpression == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(9);
        }
        return stringLiteralExpression;
    }

    @NotNull
    public static String createExpressionContent(@NotNull List<? extends PsiElement> parts) {
        if (parts == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(10);
        }
        return PhpInterpolationStringRepresentationConverter.createExpressionContent(parts, PhpInterpolationStringRepresentationConverter.allLiteralsAreSingleQuoted(parts));
    }

    @NotNull
    private static String createExpressionContent(@NotNull List<? extends PsiElement> parts, boolean useSingleQuote) {
        if (parts == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(11);
        }
        String string = StreamEx.of(parts).map(e -> PhpInterpolationStringRepresentationConverter.getContentForInterpolation(e, useSingleQuote)).joining();
        if (string == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static boolean allLiteralsAreSingleQuoted(@NotNull List<? extends PsiElement> parts) {
        if (parts == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(13);
        }
        if (!ContainerUtil.and(parts, StringLiteralExpression.class::isInstance)) {
            return false;
        }
        return ((Optional)((StreamEx)StreamEx.of(parts).select(StringLiteralExpression.class).map(StringLiteralExpression::isSingleQuote).distinct()).collect(MoreCollectors.onlyOne())).orElse(false);
    }

    @Override
    @Nullable
    public StringLiteralExpression getTargetElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(14);
        }
        return PhpPsiUtil.getParentOfClass(element, false, StringLiteralExpression.class);
    }

    @NotNull
    private static String getContentForInterpolation(@NotNull PsiElement e, boolean useSingleQuote) {
        if (e == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(15);
        }
        if (e instanceof StringLiteralExpression) {
            if (!useSingleQuote && ((StringLiteralExpression)e).isSingleQuote()) {
                String string = PhpReplaceQuotesIntention.createLiteralWithChangedQuotes((StringLiteralExpression)e).getContents();
                if (string == null) {
                    PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(16);
                }
                return string;
            }
            String string = ((StringLiteralExpression)e).getContents();
            if (string == null) {
                PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (PhpPsiUtil.isOfType(e, PhpElementTypes.NUMBER)) {
            String string = PhpPsiUtil.getLiteralText(e);
            if (string == null) {
                PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = String.format("{%s}", e.getText());
        if (string == null) {
            PhpInterpolationStringRepresentationConverter.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 9, 12, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/strings/converters/PhpInterpolationStringRepresentationConverter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/strings/converters/PhpInterpolationStringRepresentationConverter";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringParts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionContent";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentForInterpolation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringParts";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionContent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "allLiteralsAreSingleQuoted";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTargetElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContentForInterpolation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 9, 12, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

