/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpASTElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPsiElementImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpModifierListImpl
extends PhpASTElementImpl
implements PhpModifierList {
    public PhpModifierListImpl(ASTNode node) {
        super(node);
    }

    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpModifierListImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpModifierList((PhpModifierList)this);
    }

    public boolean hasPublic() {
        return this.getVisibilityModifier(PhpTokenTypes.kwPUBLIC) != null;
    }

    public boolean hasProtected() {
        return this.getVisibilityModifier(PhpTokenTypes.kwPROTECTED) != null;
    }

    public boolean hasPrivate() {
        return this.getVisibilityModifier(PhpTokenTypes.kwPRIVATE) != null;
    }

    @Nullable
    private ASTNode getVisibilityModifier(IElementType kw) {
        return (ASTNode)ContainerUtil.find((Object[])this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{kw})), it -> !PhpModifierListImpl.isSetOperationModifier(it));
    }

    public boolean hasFinal() {
        return this.getNode().findChildByType(PhpTokenTypes.kwFINAL) != null;
    }

    public boolean hasAbstract() {
        return this.getNode().findChildByType(PhpTokenTypes.kwABSTRACT) != null;
    }

    public boolean hasStatic() {
        return this.getNode().findChildByType(PhpTokenTypes.kwSTATIC) != null;
    }

    public boolean hasReadonly() {
        return FieldImpl.getReadonlyKeyword((PsiElement)this) != null;
    }

    public String toString() {
        return PhpPsiElementImpl.toStringWithValue((PsiElement)this, this.getText());
    }

    public static boolean isSetOperationModifier(@Nullable PsiElement modifier) {
        return modifier != null && PhpModifierListImpl.isSetOperationModifier(modifier.getNode());
    }

    public static boolean isSetOperationModifier(@Nullable ASTNode node) {
        ASTNode sibling;
        if (!PhpPsiUtil.isOfType(node, PhpTokenTypes.tsVISIBILITY_MODIFIERS)) {
            return false;
        }
        for (sibling = node.getTreeNext(); sibling != null && PhpPsiUtil.isOfType(sibling, TokenType.WHITE_SPACE, PhpTokenTypes.chRPAREN, PhpTokenTypes.chLPAREN); sibling = sibling.getTreeNext()) {
        }
        return sibling != null && sibling.getElementType() == PhpTokenTypes.kwSET;
    }

    @Nullable
    public static PsiElement getSetOperationModifierPsiElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PhpModifierList) {
            ASTNode sibling;
            PhpModifierList list = (PhpModifierList)element;
            ASTNode operation = list.getNode().findChildByType(PhpTokenTypes.kwSET);
            if (operation == null) {
                return null;
            }
            for (sibling = operation.getTreePrev(); sibling != null && PhpPsiUtil.isOfType(sibling, TokenType.WHITE_SPACE, PhpTokenTypes.chRPAREN, PhpTokenTypes.chLPAREN); sibling = sibling.getTreePrev()) {
            }
            return PhpPsiUtil.isOfType(sibling, PhpTokenTypes.tsVISIBILITY_MODIFIERS) ? sibling.getPsi() : null;
        }
        if (element instanceof PhpPromotedFieldParameterImpl) {
            PhpPromotedFieldParameterImpl promotedParameter = (PhpPromotedFieldParameterImpl)element;
            return (PsiElement)ContainerUtil.find(PhpPsiUtil.getChildrenOfType((PsiElement)promotedParameter, PhpTokenTypes.tsVISIBILITY_MODIFIERS), it -> PhpModifierListImpl.isSetOperationModifier(it));
        }
        if (element instanceof FieldImpl) {
            FieldImpl field = (FieldImpl)element;
            PhpClassFieldsList list = field.getParentList();
            if (list == null) {
                return null;
            }
            return PhpModifierListImpl.getSetOperationModifierPsiElement((PsiElement)list.getModifierList());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phpElementVisitor", "com/jetbrains/php/lang/psi/elements/impl/PhpModifierListImpl", "accept"));
    }
}

