/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpPsiElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNamespaceReferenceImpl
extends PhpPsiElementImpl
implements PhpNamespaceReference {
    private final NotNullLazyValue<CachedValue<String>> myFullName = NotNullLazyValue.createValue(() -> CachedValuesManager.getManager((Project)this.getManager().getProject()).createCachedValue(() -> {
        String result = StringUtil.collapseWhiteSpace((CharSequence)this.getFullNameImpl()).replace(" ", "");
        return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    }, false));

    public PhpNamespaceReferenceImpl(ASTNode node) {
        super(node);
    }

    public String getFullName() {
        return (String)((CachedValue)this.myFullName.getValue()).getValue();
    }

    private String getFullNameImpl() {
        PsiReference[] references = this.getReferences();
        if (references.length == 0) {
            return "\\";
        }
        if (this.getParent() instanceof PhpNamespace) {
            return this.getText();
        }
        if (PhpNamespaceReferenceImpl.isReferenceInsideUseStatement((PsiElement)this)) {
            return this.getText();
        }
        if (this.getFirstChild().getText().startsWith("\\")) {
            return this.getText();
        }
        String first = ((PhpNamespaceReferenceSegment)references[0]).resolveLocal();
        if (first == null) {
            return this.getText();
        }
        StringBuilder b = new StringBuilder();
        b.append(first);
        for (int i = 1; i < references.length; ++i) {
            PsiReference reference = references[i];
            b.append(reference.getCanonicalText());
            b.append('\\');
        }
        return b.toString();
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpNamespaceReferenceImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpNamespaceReference((PhpNamespaceReference)this);
    }

    public PsiReference @NotNull [] getReferences() {
        ArrayList<PhpNamespaceReferenceSegment> refs = new ArrayList<PhpNamespaceReferenceSegment>();
        PhpNamespaceReferenceImpl reference = this;
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement element = child;
            if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.IDENTIFIER, PhpDocTokenTypes.DOC_IDENTIFIER)) continue;
            refs.add(new PhpNamespaceReferenceSegment(reference, element));
        }
        PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            PhpNamespaceReferenceImpl.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    private static boolean isReferenceInsideUseStatement(@NotNull PsiElement element) {
        if (element == null) {
            PhpNamespaceReferenceImpl.$$$reportNull$$$0(2);
        }
        return PhpPsiUtil.isOfType(element.getParent(), PhpElementTypes.USE_BRACES) || PhpPsiUtil.getParentOfClass(element, true, PhpUse.class) != null && PhpPsiUtil.getParentOfClass(element, true, PhpClass.class) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpNamespaceReferenceImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpNamespaceReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceInsideUseStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class PhpNamespaceReferenceSegment
    implements PsiPolyVariantReference {
        private final PhpNamespaceReferenceImpl myReference;
        private final PsiElement myElement;

        PhpNamespaceReferenceSegment(PhpNamespaceReferenceImpl reference, PsiElement element) {
            this.myReference = reference;
            this.myElement = element;
        }

        @NotNull
        public PsiElement getElement() {
            PhpNamespaceReferenceImpl phpNamespaceReferenceImpl = this.myReference;
            if (phpNamespaceReferenceImpl == null) {
                PhpNamespaceReferenceSegment.$$$reportNull$$$0(0);
            }
            return phpNamespaceReferenceImpl;
        }

        @NotNull
        public TextRange getRangeInElement() {
            int s = this.myElement.getStartOffsetInParent();
            return new TextRange(s, s + this.myElement.getTextLength());
        }

        @Nullable
        public String resolveLocal() {
            PhpNamespace scope = PhpPsiUtil.getParentOfClass(this.getElement(), PhpNamespace.class);
            if (scope == null) {
                scope = this.getElement().getContainingFile();
            }
            return PhpCodeInsightUtil.collectImports((PhpPsiElement)scope).stream().flatMap(list -> Arrays.stream(list.getDeclarations())).map(use -> {
                String referenceText;
                int i;
                String name = use.getName();
                if (!name.isEmpty() && !PhpUseImpl.isOfFunction(use) && !PhpUseImpl.isOfConst(use) && PhpLangUtil.equalsNamespaceNames(name, (i = (referenceText = this.myReference.getText()).indexOf("\\")) == -1 ? referenceText : referenceText.substring(0, i))) {
                    int identifierEndOffset = this.myElement.getStartOffsetInParent() + this.getCanonicalText().length();
                    String parent = i == -1 || i > identifierEndOffset ? "" : referenceText.substring(i, identifierEndOffset);
                    return use.getFQN() + parent + "\\";
                }
                return null;
            }).filter(Objects::nonNull).findFirst().orElse(null);
        }

        private String getCurrentNamespaceName() {
            if (this.myReference.getParent() instanceof PhpNamespace) {
                return "\\";
            }
            PhpNamespace parentNamespace = PhpPsiUtil.getParentOfClass((PsiElement)this.myReference, true, PhpNamespace.class);
            return parentNamespace == null || PhpLangUtil.isGlobalNamespaceName(parentNamespace.getName()) ? "\\" : parentNamespace.getFQN() + "\\";
        }

        public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getElement().getProject());
            Object parent = this.myReference.getText().substring(0, this.myElement.getStartOffsetInParent());
            if (!((String)parent).startsWith("\\")) {
                if (!PhpNamespaceReferenceImpl.isReferenceInsideUseStatement(this.getElement())) {
                    Collection namespaces;
                    String local = this.resolveLocal();
                    if (local != null && !(namespaces = phpIndex.getNamespacesByName(local = local.substring(0, local.length() - 1))).isEmpty()) {
                        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)namespaces);
                        if (resolveResultArray == null) {
                            PhpNamespaceReferenceSegment.$$$reportNull$$$0(1);
                        }
                        return resolveResultArray;
                    }
                    parent = this.getCurrentNamespaceName() + (String)parent;
                } else {
                    parent = "\\" + this.getGroupUseNamespaceReferenceName() + (String)parent;
                }
            }
            Collection phpNamespaces = phpIndex.getChildNamespacesByParentName((String)parent);
            for (String namespace : phpNamespaces) {
                if (!namespace.equalsIgnoreCase(this.myElement.getText())) continue;
                Collection namespaces = phpIndex.getNamespacesByName((String)parent + namespace);
                ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)namespaces);
                if (resolveResultArray == null) {
                    PhpNamespaceReferenceSegment.$$$reportNull$$$0(2);
                }
                return resolveResultArray;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                PhpNamespaceReferenceSegment.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        private String getGroupUseNamespaceReferenceName() {
            PhpUseList useList = PhpUseImpl.getUseList((PsiElement)this.myReference);
            if (useList != null) {
                PhpUse use = (PhpUse)PhpPsiUtil.getParentByCondition((PsiElement)this.myReference, (Condition<? super PsiElement>)PhpUse.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
                PhpNamespaceReference namespaceReference = useList.getNamespaceReference();
                if (use != null && namespaceReference != null) {
                    return namespaceReference.getFullName();
                }
            }
            return "";
        }

        public PsiElement resolve() {
            ResolveResult[] results = this.multiResolve(false);
            if (results.length == 1) {
                return results[0].getElement();
            }
            return null;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myElement.getText();
            if (string == null) {
                PhpNamespaceReferenceSegment.$$$reportNull$$$0(4);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String name) throws IncorrectOperationException {
            ASTNode astNode;
            if (name == null) {
                PhpNamespaceReferenceSegment.$$$reportNull$$$0(5);
            }
            if ((astNode = this.myElement.getNode()) != null) {
                PhpNamespaceReferenceImpl ns = PhpPsiElementFactory.createFromText(this.getElement().getProject(), PhpNamespaceReferenceImpl.class, "namespace " + name + "\\X");
                assert (ns != null) : name;
                PsiElement child = ns.getFirstChild();
                assert (child != null);
                this.myElement.getNode().getTreeParent().replaceChild(astNode, child.getNode());
            }
            return this.myElement;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                PhpNamespaceReferenceSegment.$$$reportNull$$$0(6);
            }
            return this.getElement();
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                PhpNamespaceReferenceSegment.$$$reportNull$$$0(7);
            }
            if (element instanceof PhpNamespace) {
                ResolveResult[] results;
                for (ResolveResult result : results = this.multiResolve(false)) {
                    if (!result.isValidResult() || result.getElement() != element) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isSoft() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpNamespaceReferenceImpl$PhpNamespaceReferenceSegment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpNamespaceReferenceImpl$PhpNamespaceReferenceSegment";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

