/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.google.common.collect.Iterables;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclarationOwner;
import com.jetbrains.php.lang.psi.elements.impl.PhpASTElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTypeDeclarationImpl
extends PhpASTElementImpl
implements PhpTypeDeclaration {
    private static final TokenSet ALL_POSSIBLE_SEPARATORS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opBIT_AND, PhpTokenTypes.opBIT_OR, PhpDocTokenTypes.DOC_PIPE, PhpDocTokenTypes.DOC_AMPERSAND});

    public PhpTypeDeclarationImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public Collection<ClassReference> getClassReferences() {
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)this, ClassReference.class);
        if (collection == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public boolean isNullable() {
        return PhpPsiUtil.isOfType(this.getFirstChild(), PhpTokenTypes.opQUEST);
    }

    public boolean isIntersection() {
        return PhpPsiUtil.getChildOfType((PsiElement)this, PhpTokenTypes.opBIT_AND) != null;
    }

    @NotNull
    public PhpType getType() {
        Collection<ClassReference> types = PhpTypeDeclarationImpl.getDirectClassReferences((PsiElement)this);
        PhpType result = new PhpType();
        if (!types.isEmpty()) {
            for (ClassReference child : types) {
                result.add(child.resolveLocalType());
            }
            result = this.updateTypeWithIntersection(result);
            if (this.isNullable()) {
                result.add(PhpType.NULL);
            }
        }
        for (PsiElement group : PhpTypeDeclarationImpl.getClassReferenceGroups(this)) {
            result.add(PhpTypeDeclarationImpl.getTypeDeclarationPartType(group));
        }
        PhpType phpType = result.isEmpty() ? PhpType.EMPTY : result.createImmutableType();
        if (phpType == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(1);
        }
        return phpType;
    }

    public abstract PhpTypeDeclaration createWithText(String var1);

    @NotNull
    public static PhpType getTypeDeclarationPartType(PsiElement typeDeclarationPart) {
        if (typeDeclarationPart instanceof ClassReference) {
            PhpType phpType = ((ClassReference)typeDeclarationPart).resolveLocalType();
            if (phpType == null) {
                PhpTypeDeclarationImpl.$$$reportNull$$$0(2);
            }
            return phpType;
        }
        if (PhpPsiUtil.isOfType(typeDeclarationPart, PhpElementTypes.CLASS_REFERENCES_GROUP)) {
            PhpType res = new PhpType();
            for (ClassReference reference : PhpTypeDeclarationImpl.getDirectClassReferences(typeDeclarationPart)) {
                res.add(reference.resolveLocalType());
            }
            return PhpTypeDeclarationImpl.updateTypeWithIntersection(res, true);
        }
        PhpType phpType = PhpType.from((PsiElement[])new PsiElement[]{typeDeclarationPart});
        if (phpType == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    @NotNull
    public static List<PsiElement> getClassReferenceGroups(PhpTypeDeclaration declaration) {
        List<PsiElement> list = PhpPsiUtil.getChildren((PsiElement)declaration, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpElementTypes.CLASS_REFERENCES_GROUP)));
        if (list == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static Collection<ClassReference> getDirectClassReferences(@Nullable PsiElement element) {
        List<ClassReference> list = PhpPsiUtil.getChildren(element, (Condition<? super PsiElement>)((Condition)ClassReference.class::isInstance));
        if (list == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    public PhpType updateTypeWithIntersection(PhpType result) {
        return PhpTypeDeclarationImpl.updateTypeWithIntersection(result, this.isIntersection());
    }

    @NotNull
    public static PhpType updateTypeWithIntersection(@NotNull PhpType result, boolean intersection) {
        if (result == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(6);
        }
        if (intersection) {
            PhpType phpType = new PhpType().add(StringUtil.join((Collection)result.getTypes(), (String)"&"));
            if (phpType == null) {
                PhpTypeDeclarationImpl.$$$reportNull$$$0(7);
            }
            return phpType;
        }
        PhpType phpType = result;
        if (phpType == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(8);
        }
        return phpType;
    }

    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(9);
        }
        phpElementVisitor.visitPhpTypeDeclaration((PhpTypeDeclaration)this);
    }

    public ClassReference findNullReference() {
        return (ClassReference)ContainerUtil.find(this.getClassReferences(), c -> c.textMatches((CharSequence)"null"));
    }

    public void addTypeReference(@NotNull String typeReferenceText) {
        if (typeReferenceText == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(10);
        }
        PsiElement child = this.getLastChild();
        String textToAdd = PhpTypeDeclarationImpl.createTextToAdd((PsiElement)this, typeReferenceText);
        if (PhpPsiUtil.isOfType(child, PhpTokenTypes.opQUEST) || PhpPsiUtil.isOfType(child, PhpTokenTypes.opBIT_OR)) {
            this.addAfter((PsiElement)PhpPsiElementFactory.createClassReference(this.getProject(), textToAdd), child);
        } else {
            PsiElement pipe = this.addAfter(PhpPsiElementFactory.createFromText(this.getProject(), PhpTokenTypes.opBIT_OR, "function f():string|int {}"), child);
            this.addAfter((PsiElement)PhpPsiElementFactory.createClassReference(this.getProject(), textToAdd), pipe);
        }
    }

    @Nullable
    public abstract PhpDocTag getDocTag();

    @NotNull
    private static String createTextToAdd(PsiElement point, @NotNull String typeReferenceText) {
        PsiElement anchor;
        PhpScopeHolder scope;
        if (typeReferenceText == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(11);
        }
        if ((scope = PhpPsiUtil.getScopeHolder(anchor = (PsiElement)ObjectUtils.notNull((Object)PhpPsiUtil.getParentOfClass(point, Function.class), (Object)point))) == null) {
            String string = typeReferenceText;
            if (string == null) {
                PhpTypeDeclarationImpl.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = PhpCodeInsightUtil.createQualifiedName((PhpPsiElement)scope, PhpLangUtil.toFQN(typeReferenceText));
        if (string == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void updateElementsFromNewType(Project project, PhpType newType, PhpType oldType, List<? extends PsiElement> elementsToUpdate, BiFunction<PhpType, Boolean, PsiElement> elementCreator, boolean phpDoc) {
        boolean shouldReplaceTypeCompletely = phpDoc && newType.hasIntersectionType() && newType.size() > 1 || newType.hasIntersectionType() != oldType.hasIntersectionType() && (newType.hasIntersectionType() || newType.size() > 1);
        boolean onlyIntersection = newType.size() == 1 && newType.hasIntersectionType();
        PhpType unwrappedNewType = phpDoc || PhpLanguageFeature.INTERSECTION_AND_UNION_IN_SAME_TYPE.isSupported(project) && !onlyIntersection ? newType : PhpTypeDeclarationImpl.unwrapIntersectionTypes(newType);
        List elementsToRemove = shouldReplaceTypeCompletely ? elementsToUpdate : ContainerUtil.filter(elementsToUpdate, e -> !PhpTypeDeclarationImpl.intersects(PhpTypeDeclarationImpl.getTypeDeclarationPartType(e).global(e.getProject()), unwrappedNewType, phpDoc));
        List<PhpType> typesToAdd = unwrappedNewType.getTypes().stream().filter(t -> shouldReplaceTypeCompletely || PhpTypeDeclarationImpl.typeIntersects(oldType, t, phpDoc) || PhpTypeDeclarationImpl.shouldAddBooleanTypeInsteadOfTrueFalse(t, elementsToUpdate)).map(xva$0 -> PhpType.from((String[])new String[]{xva$0})).toList();
        boolean isUnionType = typesToAdd.size() + (elementsToUpdate.size() - elementsToRemove.size()) > 1;
        PsiElement lastItem = (PsiElement)ContainerUtil.getLastItem((List)elementsToUpdate);
        if (lastItem == null) {
            return;
        }
        HashSet<String> addedElementTexts = new HashSet<String>();
        for (PhpType typeToAdd : typesToAdd) {
            PsiElement createdElement = elementCreator.apply(typeToAdd, isUnionType);
            if (!addedElementTexts.add(createdElement.getText())) continue;
            PsiElement docPipe = PhpPsiUtil.isOfType(lastItem.getNextSibling(), ALL_POSSIBLE_SEPARATORS) ? lastItem.getNextSibling() : lastItem.getParent().addAfter(PhpTypeDeclarationImpl.createTypeSeparator(lastItem.getProject(), PhpTypeDeclarationImpl.getNewSeparatorType(newType, phpDoc), PhpTypeDeclarationImpl.getNewSeparatorText(newType)), lastItem);
            lastItem = docPipe.getParent().addAfter(createdElement, docPipe);
        }
        for (PsiElement elementToRemove : elementsToRemove) {
            PhpCodeEditUtil.removeStatementWithDelivery(elementToRemove, ALL_POSSIBLE_SEPARATORS);
        }
    }

    private static boolean typeIntersects(PhpType oldType, String t, boolean phpDoc) {
        return PhpType.isIntersectionType((String)t) ? !PhpTypeDeclarationImpl.intersects(oldType, PhpType.from((String[])new String[]{t}), phpDoc) : !PhpTypeDeclarationImpl.intersects(PhpTypeDeclarationImpl.unwrapIntersectionTypes(oldType), PhpType.from((String[])new String[]{t}), phpDoc);
    }

    private static boolean shouldAddBooleanTypeInsteadOfTrueFalse(String newType, List<? extends PsiElement> elementsToUpdate) {
        return newType.equals("\\bool") && ContainerUtil.exists(elementsToUpdate, e -> PhpTypeDeclarationImpl.getTypeDeclarationPartType(e).equals((Object)PhpType.TRUE) || PhpTypeDeclarationImpl.getTypeDeclarationPartType(e).equals((Object)PhpType.FALSE));
    }

    private static IElementType getNewSeparatorType(PhpType type, boolean phpDoc) {
        if (type.size() == 1 && type.hasIntersectionType()) {
            return phpDoc ? PhpDocTokenTypes.DOC_AMPERSAND : PhpTokenTypes.opBIT_AND;
        }
        return phpDoc ? PhpDocTokenTypes.DOC_PIPE : PhpTokenTypes.opBIT_OR;
    }

    private static PhpType unwrapIntersectionTypes(PhpType type) {
        if (!type.hasIntersectionType()) {
            return type;
        }
        PhpType res = new PhpType();
        for (Collection intersection : type.getTypesIntersections()) {
            for (String s : intersection) {
                res.add(s);
            }
        }
        return res;
    }

    public static String createTypeToAdd(PsiElement point, boolean isUnionType, PhpType typeToAdd) {
        if (PhpLanguageLevel.current((Project)point.getProject()).isLessThan(PhpLanguageLevel.PHP820) && (typeToAdd.equals((Object)PhpType.TRUE) || !isUnionType && typeToAdd.equals((Object)PhpType.FALSE))) {
            return PhpTypeDeclarationImpl.getTypePresentation(point, PhpType.BOOLEAN);
        }
        if (typeToAdd.equals((Object)PhpType.NULL)) {
            return "null";
        }
        return PhpTypeDeclarationImpl.getTypePresentation(point, typeToAdd);
    }

    @NotNull
    private static String getTypePresentation(PsiElement point, PhpType typeToAdd) {
        String string = StringUtil.notNullize((String)PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(point.getProject(), typeToAdd, point));
        if (string == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void update() {
        PhpTypeDeclarationImpl.update(this.getDocTag(), this.getType().global(this.getProject()));
    }

    public void update(@NotNull PhpType type) {
        Collection<ClassReference> references;
        if (type == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(15);
        }
        type = type.global(this.getProject());
        PhpDocTag docTag = this.getDocTag();
        PhpType oldType = this.getType().global(this.getProject());
        boolean oldDeclarationUsesFullNullabilityForm = this.getClassReferences().size() == 2 && this.findNullReference() != null;
        PhpTypeDeclarationImpl.updateElementsFromNewType(this.getProject(), type, oldType, Arrays.asList(this.getChildren()), (t, isUnionType) -> this.createTypeToAdd((PhpType)t, (boolean)isUnionType), false);
        PhpTypeDeclarationImpl.update(docTag, type);
        if (oldType.isNullable() && !type.isNullable() && this.isNullable()) {
            this.getFirstChild().delete();
        } else if (!oldDeclarationUsesFullNullabilityForm && type.isNullable() && !this.isNullable() && this.findNullReference() != null && (references = this.getClassReferences()).size() == 2) {
            ClassReference item = (ClassReference)ContainerUtil.getFirstItem(references);
            assert (item != null);
            item.getParent().addBefore(PhpPsiElementFactory.createQuest(this.getProject()), (PsiElement)item);
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)this.findNullReference(), PhpTokenTypes.opBIT_OR);
        }
        if (this.isNullable() && type.size() > 2) {
            this.getFirstChild().delete();
            PsiElement lastChild = this.getLastChild();
            PsiElement pipe = lastChild.getParent().addAfter(PhpTypeDeclarationImpl.createTypeSeparator(this.getProject(), PhpTokenTypes.opBIT_OR, "|"), lastChild);
            lastChild.getParent().addAfter((PsiElement)PhpPsiElementFactory.createClassReference(this.getProject(), PhpType.NULL.toString()), pipe);
        }
    }

    @NotNull
    private PsiElement createTypeToAdd(PhpType t, boolean isUnionType) {
        String type = PhpTypeDeclarationImpl.createTypeToAdd((PsiElement)this, isUnionType, t);
        if (isUnionType && PhpType.isIntersectionType((String)type)) {
            Project project = this.getProject();
            PhpPsiElement phpPsiElement = PhpPsiElementFactory.createClassReferenceGroup(type, project);
            if (phpPsiElement == null) {
                PhpTypeDeclarationImpl.$$$reportNull$$$0(16);
            }
            return phpPsiElement;
        }
        ClassReference classReference = PhpPsiElementFactory.createClassReference(this.getProject(), type);
        if (classReference == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(17);
        }
        return classReference;
    }

    @NotNull
    private static String getNewSeparatorText(@NotNull PhpType type) {
        if (type == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(18);
        }
        return type.size() == 1 && type.hasIntersectionType() ? "&" : "|";
    }

    public static void update(@Nullable PhpDocTag docTag, @NotNull PhpType newType) {
        if (newType == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(19);
        }
        if (docTag == null) {
            return;
        }
        List docTypes = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)docTag, PhpDocType.class);
        PhpType resolvedNewType = newType.global(docTag.getProject());
        if (docTypes.isEmpty()) {
            if (resolvedNewType.isEmpty()) {
                return;
            }
            PhpTypeDeclarationImpl.createNewDocType(docTag, resolvedNewType);
        } else {
            PhpType docType = docTag.getType().global(docTag.getProject());
            boolean isVariadic = docTag instanceof PhpDocParamTag && ((PhpDocParamTag)docTag).isVariadic();
            PhpTypeDeclarationImpl.updateElementsFromNewType(docTag.getProject(), resolvedNewType, isVariadic ? docType.unpluralize() : docType, docTypes, (t, isUnionType) -> PhpTypeDeclarationImpl.createDocType((PsiElement)docTag, t, isUnionType), true);
        }
        PhpTypeDeclarationImpl.reorderDocType(docTag);
    }

    private static void createNewDocType(@NotNull PhpDocTag docTag, PhpType resolvedNewType) {
        PsiElement docTagName;
        if (docTag == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(20);
        }
        if ((docTagName = PhpPsiUtil.getChildOfType((PsiElement)docTag, PhpDocTokenTypes.DOC_TAG_NAME)) == null) {
            return;
        }
        Collection<PhpDocType> newDocTypes = PhpTypeDeclarationImpl.createDocTypes((PsiElement)docTag, resolvedNewType);
        PhpDocType first = (PhpDocType)Iterables.getFirst(newDocTypes, null);
        if (first == null) {
            return;
        }
        docTag.addRangeAfter(first.getPrevSibling(), (PsiElement)Iterables.getLast(newDocTypes), docTagName);
    }

    @NotNull
    private static PhpDocType createDocType(PsiElement point, PhpType t, boolean isUnionType) {
        String presentation = PhpDocUtil.getTypePresentation(point.getProject(), t, (PhpPsiElement)PhpPsiUtil.getScopeHolder(point));
        PhpDocType phpDocType = PhpPsiElementFactory.createPhpDocType(point.getProject(), (String)(isUnionType && PhpType.isIntersectionType((String)presentation) ? "(" + presentation + ")" : presentation));
        if (phpDocType == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(21);
        }
        return phpDocType;
    }

    @NotNull
    private static Collection<PhpDocType> createDocTypes(PsiElement point, PhpType t) {
        Collection<PhpDocType> collection = PhpPsiElementFactory.createPhpDocTypes(point.getProject(), PhpDocUtil.getTypePresentation(point.getProject(), t, (PhpPsiElement)PhpPsiUtil.getScopeHolder(point)));
        if (collection == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(22);
        }
        return collection;
    }

    public static PsiElement createTypeSeparator(Project project, IElementType separator, String separatorText) {
        return PhpPsiElementFactory.createFromText(project, separator, String.format("class a {/** @var int%sfloat */ private int%1$sfloat $a; }", separatorText));
    }

    private static boolean intersects(PhpType oldType, PhpType newType, boolean phpDoc) {
        if (PhpType.hasTypedArray((PhpType)oldType) && PhpType.hasTypedArray((PhpType)newType)) {
            return ContainerUtil.intersects((Collection)oldType.unpluralize().getTypes(), (Collection)newType.unpluralize().getTypes());
        }
        return PhpType.hasArray((PhpType)oldType) && PhpType.hasArray((PhpType)newType) || ContainerUtil.intersects((Collection)oldType.getTypes(), (Collection)newType.getTypes()) || phpDoc && PhpType.intersects((PhpType)newType, (PhpType)PhpType.STRING) && PhpType.intersects((PhpType)oldType, (PhpType)PhpType.CLASS_STRING);
    }

    private static Comparator<PhpDocType> phpDocTypeComparator(@Nullable PhpTypeDeclaration sortBy, @Nullable PhpCodeStyleSettings codeStyleSettings) {
        Comparator<String> docTypesComparator = PhpDocUtil.docTypesComparator(sortBy, codeStyleSettings);
        return (o1, o2) -> docTypesComparator.compare(PhpTypeDeclarationImpl.extractSingleType(o1), PhpTypeDeclarationImpl.extractSingleType(o2));
    }

    @NotNull
    private static String extractSingleType(@NotNull PhpDocType type) {
        if (type == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(23);
        }
        String string = (String)type.getGlobalType().getTypes().iterator().next();
        if (string == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    public static PhpTypeDeclarationOwner<?> getTagOwner(@NotNull PhpDocTag tag) {
        Function function;
        PhpDocComment docComment;
        if (tag == null) {
            PhpTypeDeclarationImpl.$$$reportNull$$$0(25);
        }
        if ((docComment = PhpPsiUtil.getParentOfClass((PsiElement)tag, PhpDocComment.class)) == null) {
            return null;
        }
        PsiElement commentOwner = docComment.getOwner();
        PhpDocParamTag paramTag = (PhpDocParamTag)ObjectUtils.tryCast((Object)tag, PhpDocParamTag.class);
        if (paramTag != null && (function = (Function)ObjectUtils.tryCast((Object)commentOwner, Function.class)) != null) {
            return (PhpTypeDeclarationOwner)ContainerUtil.find((Object[])function.getParameters(), p -> p.getDocTag() == paramTag);
        }
        return (PhpTypeDeclarationOwner)ObjectUtils.tryCast((Object)commentOwner, PhpTypeDeclarationOwner.class);
    }

    private static void reorderDocType(PhpDocTag docTag) {
        PhpTypeDeclaration ownerTypeDeclaration = Optional.ofNullable(PhpTypeDeclarationImpl.getTagOwner(docTag)).map(o -> o.getTypeDeclaration()).orElse(null);
        PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)docTag.getContainingFile(), PhpCodeStyleSettings.class);
        Comparator<PhpDocType> comparator = PhpTypeDeclarationImpl.phpDocTypeComparator(ownerTypeDeclaration, settings);
        List updatedDocTypes = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)docTag.copy(), PhpDocType.class);
        List newOrder = ContainerUtil.sorted((Collection)updatedDocTypes, comparator);
        EntryStream.of((List)newOrder).mapToKey((newIndex, type) -> (PhpDocType)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)docTag, PhpDocType.class).get((int)newIndex)).forKeyValue((oldType, newType) -> oldType.replace((PsiElement)newType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 9, 10, 11, 15, 18, 19, 20, 23, 25 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpTypeDeclarationImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeReferenceText";
                break;
            }
            case 15: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassReferences";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDeclarationPartType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassReferenceGroups";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectClassReferences";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpTypeDeclarationImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "updateTypeWithIntersection";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextToAdd";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypePresentation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeToAdd";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocTypes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSingleType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateTypeWithIntersection";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addTypeReference";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTextToAdd";
                break;
            }
            case 15: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNewSeparatorText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createNewDocType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "extractSingleType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTagOwner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 9, 10, 11, 15, 18, 19, 20, 23, 25 -> new IllegalArgumentException(string);
        };
    }
}

