/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayMapTypeFromClosureTP
implements PhpTypeProvider4 {
    public char getKey() {
        return '\u042a';
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof FunctionReference && !(element instanceof MethodReference) && StringUtil.equals((CharSequence)((FunctionReference)element).getName(), (CharSequence)"array_map")) {
            PhpTypedElement closureArgument = (PhpTypedElement)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize(((FunctionReference)element).getParameter(0)), PhpTypedElement.class);
            PhpType closureReturnType = PhpArrayMapTypeFromClosureTP.getClosureReturnType(closureArgument);
            if (closureReturnType != null) {
                PhpType res = new PhpType();
                closureReturnType.getTypes().stream().map(type -> "#" + this.getKey() + type).forEach(arg_0 -> ((PhpType)res).add(arg_0));
                return res;
            }
            return PhpType.ARRAY;
        }
        return null;
    }

    @Nullable
    private static PhpType getClosureReturnType(PhpTypedElement argument) {
        if (PhpPsiUtil.isOfType((PsiElement)argument, PhpElementTypes.CLOSURE) && argument.getFirstPsiChild() instanceof Function) {
            return ((Function)argument.getFirstPsiChild()).getType();
        }
        if (argument instanceof Variable) {
            HashSet result = new HashSet();
            FunctionReferenceImpl.addAssignedClosures((Variable)argument, result);
            PhpType type = new PhpType();
            result.forEach(arg_0 -> ((PhpType)type).add(arg_0));
            return type;
        }
        return null;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        PhpType global = new PhpType().add(expression.substring(2)).global(project);
        if (global.isEmpty()) {
            return PhpType.ARRAY;
        }
        return global.pluralise();
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }
}

