/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.util.Pair;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpMetaTypeMappingsTable {
    public static final DataExternalizer<PhpMetaTypeMappingsTable> EXTERNALIZER = new MyValueExternalizer();
    static final PhpMetaTypeMappingsTable EMPTY = new PhpMetaTypeMappingsTable();
    private final Map<String, Collection<String>> myKeyToTypeMappings;
    private final Collection<Pair<Integer, String>> myDirectTypesKeysToParameterIndices;

    public PhpMetaTypeMappingsTable() {
        this(new HashMap<String, Collection<String>>(), new HashSet<Pair<Integer, String>>());
    }

    private PhpMetaTypeMappingsTable(Map<String, Collection<String>> mappings, Set<Pair<Integer, String>> directTypesKeysToParameterIndices) {
        this.myKeyToTypeMappings = mappings;
        this.myDirectTypesKeysToParameterIndices = directTypesKeysToParameterIndices;
    }

    public void putAll(PhpMetaTypeMappingsTable value) {
        for (Map.Entry<String, Collection<String>> entry : value.myKeyToTypeMappings.entrySet()) {
            this.myKeyToTypeMappings.computeIfAbsent(entry.getKey(), s -> new HashSet()).addAll(entry.getValue());
        }
        this.myDirectTypesKeysToParameterIndices.addAll(value.myDirectTypesKeysToParameterIndices);
    }

    @NotNull
    public Collection<String> get(String key) {
        Collection collection = this.myKeyToTypeMappings.getOrDefault(key, Collections.emptySet());
        if (collection == null) {
            PhpMetaTypeMappingsTable.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public Collection<String> getKeys() {
        return this.myKeyToTypeMappings.keySet();
    }

    public boolean isEmpty() {
        return this.myKeyToTypeMappings.isEmpty() && this.myDirectTypesKeysToParameterIndices.isEmpty();
    }

    public void put(String key, String type) {
        this.myKeyToTypeMappings.computeIfAbsent(key, t -> new HashSet()).add(type);
    }

    public void put(String key, String type, int parameterIndex) {
        this.put(key, type);
        this.myDirectTypesKeysToParameterIndices.add((Pair<Integer, String>)Pair.create((Object)parameterIndex, (Object)key));
    }

    @NotNull
    public Collection<String> get(String key, int parameterIndex) {
        if (!this.myDirectTypesKeysToParameterIndices.contains(Pair.create((Object)parameterIndex, (Object)key))) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpMetaTypeMappingsTable.$$$reportNull$$$0(1);
            }
            return set;
        }
        Collection<String> collection = this.get(key);
        if (collection == null) {
            PhpMetaTypeMappingsTable.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhpMetaTypeMappingsTable table = (PhpMetaTypeMappingsTable)o;
        return this.myKeyToTypeMappings.equals(table.myKeyToTypeMappings) && this.myDirectTypesKeysToParameterIndices.equals(table.myDirectTypesKeysToParameterIndices);
    }

    public int hashCode() {
        return Objects.hash(this.myKeyToTypeMappings, this.myDirectTypesKeysToParameterIndices);
    }

    public String toString() {
        return new LinkedHashMap<String, Collection<String>>(this.myKeyToTypeMappings).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpMetaTypeMappingsTable", "get"));
    }

    public static class MyValueExternalizer
    implements DataExternalizer<PhpMetaTypeMappingsTable> {
        public void save(@NotNull DataOutput out, PhpMetaTypeMappingsTable value) throws IOException {
            if (out == null) {
                MyValueExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.myKeyToTypeMappings.size());
            for (Map.Entry<String, Collection<String>> entry : value.myKeyToTypeMappings.entrySet()) {
                out.writeUTF(entry.getKey());
                Collection<String> types = entry.getValue();
                out.writeInt(types.size());
                for (String type : types) {
                    out.writeUTF(type);
                }
            }
            out.writeInt(value.myDirectTypesKeysToParameterIndices.size());
            for (Pair pair : value.myDirectTypesKeysToParameterIndices) {
                out.writeInt((Integer)pair.first);
                out.writeUTF((String)pair.second);
            }
        }

        public PhpMetaTypeMappingsTable read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyValueExternalizer.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            HashMap<String, Collection<String>> res = new HashMap<String, Collection<String>>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readUTF();
                int typesSize = in.readInt();
                HashSet<String> types = new HashSet<String>(typesSize);
                for (int j = 0; j < typesSize; ++j) {
                    types.add(in.readUTF());
                }
                res.put(key, types);
            }
            int directTypeKeysToParameterIndicesSize = in.readInt();
            HashSet<Pair<Integer, String>> map = new HashSet<Pair<Integer, String>>(directTypeKeysToParameterIndicesSize);
            for (int i = 0; i < directTypeKeysToParameterIndicesSize; ++i) {
                map.add((Pair<Integer, String>)Pair.create((Object)in.readInt(), (Object)in.readUTF()));
            }
            return new PhpMetaTypeMappingsTable(res, map);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpMetaTypeMappingsTable$MyValueExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

