/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpCaches;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpIntermediateTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpMetaSignatureResolver;
import com.jetbrains.php.lang.psi.resolve.types.PhpMetaTypeMappingsTable;
import com.jetbrains.php.lang.psi.resolve.types.PhpPotentialGlobalEntryTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpTypeProviderEx;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMetaTypeInferenceMappingIndex;
import com.jetbrains.php.mockery.PhpMockeryTypeInferenceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpParameterBasedTypeProvider
extends PhpTypeProviderEx
implements PhpIntermediateTypeProvider {
    private static final Logger LOG = Logger.getInstance(PhpParameterBasedTypeProvider.class);
    private static final Key<CachedValue<Map<String, PhpMetaTypeMappingsTable>>> STATIC_FACTORY_TYPE_MAP = new Key("STATIC_FACTORY_TYPE_MAP");
    public static final String PHPSTORM_META_PHP = ".phpstorm.meta.php";
    public static final String PATTERN_KEY = "\u03c0";
    public static final String INFERRED_PATTERN_KEY = "\u03c1";
    public static final String TYPE_KEY = "\u03c0\u2020";
    public static final String ELEMENT_TYPE_KEY = "\u03c0e\u2020";
    public static final String ARRAY_WRAPPER_TYPE_KEY = "\u2020e";
    private static final String ONE_ARG_PATTERN = "@";
    public static final String ARG_PATTERN = "$";
    private static final char NAMED_ARGUMENT_SEPARATOR = '\u1932';
    private static final java.util.function.Function<String, String> QUOTED_ARG_TO_STRING = type -> StringUtil.isQuotedString((String)type) ? "\\string" : type;
    private static final int ABSOLUTE_PARAMETER_COMPLEXITY_LIMIT = 200;
    private static final int MAX_STRING_ARGUMENT_LENGTH_LIMIT = 3000;
    public static final char KEY = '\u03c0';

    public char getKey() {
        return '\u03c0';
    }

    @Nullable
    public PhpType getType(PsiElement e) {
        String subject = null;
        PsiElement[] parameters = null;
        if (e instanceof FunctionReference) {
            String name = ((FunctionReference)e).getName();
            if (StringUtil.isEmpty((String)name)) {
                return null;
            }
            parameters = ((FunctionReference)e).getParameters();
            if (!(e instanceof MethodReference) && parameters.length == 0) {
                return null;
            }
            subject = ((FunctionReference)e).getSignature();
        } else if (e instanceof ArrayAccessExpression) {
            PhpPsiElement value = ((ArrayAccessExpression)e).getValue();
            if (value instanceof PhpReference) {
                subject = ((PhpReference)value).getSignature();
                PsiElement[] types = ((PhpReference)value).getSignatureParts();
                if (types.stream().anyMatch(PhpType::isPluralType)) {
                    PhpType type = new PhpType();
                    types.forEach(arg_0 -> ((PhpType)type).add(arg_0));
                    return type.elementType();
                }
                ArrayIndex index = ((ArrayAccessExpression)e).getIndex();
                if (index != null) {
                    parameters = new PsiElement[]{index.getValue()};
                }
            }
        } else if (e instanceof FieldReference) {
            subject = ((FieldReference)e).getSignature();
            parameters = PsiElement.EMPTY_ARRAY;
        }
        if (parameters == null || StringUtil.isEmpty((String)subject) || PhpType.isPrimitiveClassAccess((String)subject)) {
            return null;
        }
        if (PhpParameterBasedTypeProvider.estimateComplexity(subject) > PhpParameterBasedTypeProvider.getMaxInferenceComplexityLimit()) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>();
        for (PsiElement parameter : parameters) {
            boolean isUnpackedArgument = e instanceof FunctionReference && PhpCodeInsightUtil.isUnpackedArgument(parameter);
            List parameterSignature = ContainerUtil.map(PhpParameterBasedTypeProvider.getParameterSignature(parameter, e), s -> isUnpackedArgument ? StringUtil.trimEnd((String)s, (String)"[]") : s);
            Object signature = parameterSignature.size() > 1 ? PhpParameterBasedTypeProvider.wrapTypes(parameterSignature) : (String)ContainerUtil.getFirstItem((Collection)parameterSignature, (Object)"");
            PsiElement identifier = ParameterListImpl.getNameIdentifier(parameter);
            if (identifier != null) {
                signature = (String)signature + "\u1932" + identifier.getText();
            }
            params.add((String)signature);
        }
        String param = PhpParameterBasedTypeProvider.replaceTooLongWithEmptyParams(params).stream().map(PhpParameterBasedTypeProvider::wrap).collect(Collectors.joining());
        PhpType result = new PhpType();
        StringUtil.split((String)subject, (String)"|").stream().map(s -> "#" + this.getKey() + PhpParameterBasedTypeProvider.wrap(s) + param).forEach(arg_0 -> ((PhpType)result).add(arg_0));
        return result;
    }

    private static int getMaxInferenceComplexityLimit() {
        return Math.min(200, AdvancedSettings.getInt((String)"php.type.inference.complexity.limit"));
    }

    public static int estimateComplexity(String subject) {
        return StringUtil.countChars((CharSequence)subject, (char)'#');
    }

    public static List<String> replaceTooLongWithEmptyParams(List<String> params) {
        List<Integer> indicesByParamLength = IntStream.range(0, params.size()).boxed().sorted(Comparator.comparingInt(i -> PhpParameterBasedTypeProvider.estimateComplexity((String)params.get((int)i)))).collect(Collectors.toList());
        return PhpParameterBasedTypeProvider.replaceTooLongWithEmptyParams(indicesByParamLength, new ArrayList<String>(params));
    }

    private static ArrayList<String> replaceTooLongWithEmptyParams(List<Integer> indicesByParamLength, ArrayList<String> params) {
        int totalLength = 0;
        for (Integer idx : indicesByParamLength) {
            if ((totalLength += PhpParameterBasedTypeProvider.estimateComplexity(params.get(idx))) < PhpParameterBasedTypeProvider.getMaxInferenceComplexityLimit()) continue;
            params.set(idx, "");
        }
        return params;
    }

    @NotNull
    public static String wrap(String s) {
        String string = "(" + s + ")";
        if (string == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String wrapTypes(Collection<String> signature) {
        String string = signature.stream().map(PhpParameterBasedTypeProvider::wrap).collect(Collectors.joining());
        if (string == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static Collection<String> getParameterSignature(PsiElement parameter, PsiElement originalReference) {
        if (parameter instanceof StringLiteralExpression) {
            String contents = ((StringLiteralExpression)parameter).getContents();
            if (contents.length() > 3000) {
                List<String> list = Collections.singletonList("");
                if (list == null) {
                    PhpParameterBasedTypeProvider.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<String> list = Collections.singletonList(StringUtil.wrapWithDoubleQuote((String)contents));
            if (list == null) {
                PhpParameterBasedTypeProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (parameter instanceof NewExpression) {
            ClassReference reference = ((NewExpression)parameter).getClassReference();
            if (reference != null) {
                List<String> list = Collections.singletonList(StringUtil.notNullize((String)reference.getFQN()));
                if (list == null) {
                    PhpParameterBasedTypeProvider.$$$reportNull$$$0(4);
                }
                return list;
            }
        } else {
            if (parameter instanceof PhpExpressionImpl && PhpPsiUtil.isOfType(parameter, PhpElementTypes.NUMBER)) {
                List<String> list = Collections.singletonList(originalReference instanceof ArrayAccessExpression ? PhpPsiUtil.getLiteralText(parameter) : ((PhpExpressionImpl)parameter).getNumberType());
                if (list == null) {
                    PhpParameterBasedTypeProvider.$$$reportNull$$$0(5);
                }
                return list;
            }
            if (parameter instanceof ClassConstantReference && StringUtil.equals((CharSequence)"class", (CharSequence)((ClassConstantReference)parameter).getNameCS())) {
                ClassReference reference = (ClassReference)((ClassConstantReference)parameter).getClassReference();
                if (reference != null) {
                    List<String> list = Collections.singletonList(StringUtil.notNullize((String)reference.getFQN()));
                    if (list == null) {
                        PhpParameterBasedTypeProvider.$$$reportNull$$$0(6);
                    }
                    return list;
                }
            } else {
                if (parameter instanceof ConstantReference || parameter instanceof ClassConstantReference) {
                    Collection collection = ((PhpReference)parameter).getSignatureParts();
                    if (collection == null) {
                        PhpParameterBasedTypeProvider.$$$reportNull$$$0(7);
                    }
                    return collection;
                }
                if (parameter instanceof Variable) {
                    Collection collection = PhpParameterBasedTypeProvider.signatures((Variable)parameter).collect(Collectors.toList());
                    if (collection == null) {
                        PhpParameterBasedTypeProvider.$$$reportNull$$$0(8);
                    }
                    return collection;
                }
                if (parameter instanceof ArrayCreationExpression) {
                    HashSet<String> signatures = new HashSet<String>();
                    FluentIterable values = ArrayCreationExpressionImpl.children((ArrayCreationExpression)parameter).limit(PhpTypeAnalyserVisitor.MAX_ARRAY_VALUES);
                    for (PhpPsiElement child : values) {
                        PhpTypedElement element = (PhpTypedElement)ObjectUtils.tryCast((Object)(child instanceof ArrayHashElement ? ((ArrayHashElement)child).getValue() : child.getFirstPsiChild()), PhpTypedElement.class);
                        if (element instanceof Variable) {
                            PhpParameterBasedTypeProvider.signatures((Variable)element).forEach(signatures::add);
                            continue;
                        }
                        if (element instanceof StringLiteralExpression || PhpPsiUtil.isOfType(parameter, PhpElementTypes.NUMBER)) {
                            signatures.addAll(new PhpType().add((PsiElement)element).getTypes());
                            continue;
                        }
                        signatures.addAll(PhpParameterBasedTypeProvider.getParameterSignature((PsiElement)element, parameter));
                    }
                    List list = ContainerUtil.map(signatures, s -> PhpType.pluralise((String)s, (int)1));
                    if (list == null) {
                        PhpParameterBasedTypeProvider.$$$reportNull$$$0(9);
                    }
                    return list;
                }
                if (PhpPsiUtil.isOfType(parameter, PhpElementTypes.CLOSURE)) {
                    Set set = PhpType.from((PsiElement[])new PsiElement[]{parameter}).getTypesWithParametrisedParts();
                    if (set == null) {
                        PhpParameterBasedTypeProvider.$$$reportNull$$$0(10);
                    }
                    return set;
                }
                if (parameter instanceof PhpReference) {
                    Collection collection = ((PhpReference)parameter).getSignatureParts();
                    if (collection == null) {
                        PhpParameterBasedTypeProvider.$$$reportNull$$$0(11);
                    }
                    return collection;
                }
            }
        }
        List<String> list = Collections.singletonList("");
        if (list == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static Stream<String> signatures(Variable parameter) {
        List types = ContainerUtil.filter((Collection)PhpParameterBasedTypeProvider.inferTypeIgnoreInitialBackEdges(parameter, new HashSet<Variable>()).getTypesWithParametrisedParts(), type -> {
            String sanitizedType = PhpType.removeParametrisedType((String)type);
            return PhpType.isPrimitiveType((String)sanitizedType) || !PhpType.isUnresolved((String)sanitizedType) && PhpType.isPluralType((String)sanitizedType);
        });
        return StreamEx.of((Collection)types).append(parameter.getSignatureParts());
    }

    static boolean hasMethodCandidates(Map<String, PhpMetaTypeMappingsTable> methods, String name) {
        String finalName = "." + name;
        return methods.keySet().stream().noneMatch(s -> s.startsWith("#M") && s.endsWith(finalName));
    }

    private static boolean hasNoFunctionOverride(Map<String, PhpMetaTypeMappingsTable> methods, String subject) {
        return StringUtil.split((String)subject, (String)"|").stream().noneMatch(methods::containsKey);
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        Collection<String> type;
        List<String> signatures = PhpParameterBasedTypeProvider.extractSignatures(expression, 0);
        if (signatures.isEmpty()) {
            return Collections.emptyList();
        }
        String refSignature = PhpParameterBasedTypeProvider.completeSubject(project, signatures.get(0));
        PhpNamedElement target = PhpParameterBasedTypeProvider.getTarget(refSignature, visited, depth, project);
        PhpMetaTypeMappingsTable types = PhpParameterBasedTypeProvider.getTargets(refSignature, project, target);
        PhpIndex index = PhpIndex.getInstance((Project)project);
        if (types == null) {
            return Collections.emptySet();
        }
        List<String> keys = PhpParameterBasedTypeProvider.getKeys(refSignature, target, signatures);
        Collection<PhpPassedArgument> passedArguments = PhpParameterBasedTypeProvider.convertFromNamedToPositional(keys, target);
        List<String> typesFromMappedArguments = PhpParameterBasedTypeProvider.getTypesFromMappedArguments(types, passedArguments).toList();
        Collection<String> collection = type = typesFromMappedArguments.isEmpty() ? Collections.emptyList() : Collections.singleton(StringUtil.join(typesFromMappedArguments, (String)"|"));
        if (type.isEmpty() && keys.size() == 1 && (keys.get(0).startsWith("#D") || keys.get(0).startsWith("#K"))) {
            Collection signature = index.getBySignature(keys.get(0));
            for (PhpNamedElement element : signature) {
                if (element instanceof Constant) {
                    type = types.get(StringUtil.unquoteString((String)StringUtil.defaultIfEmpty((String)((Constant)element).getValuePresentation(), (String)"")));
                }
                if (!(element instanceof Field)) continue;
                type = types.get(StringUtil.unquoteString((String)StringUtil.defaultIfEmpty((String)((Field)element).getDefaultValuePresentation(), (String)"")));
            }
        }
        Collection subjectFunctions = PhpIndex.getInstance((Project)project).getBySignature(refSignature);
        return PhpParameterBasedTypeProvider.computeMappedType(types, index, (String)ContainerUtil.getFirstItem(keys, (Object)""), passedArguments, type, visited, depth, subjectFunctions);
    }

    public static List<String> extractSignatures(String s, int pos) {
        ArrayList<String> res = new ArrayList<String>();
        int parens = 0;
        for (int i = pos; i < s.length(); ++i) {
            if (s.charAt(i) == '(') {
                ++parens;
                continue;
            }
            if (s.charAt(i) == ')') {
                --parens;
                continue;
            }
            if (parens != 0) continue;
            return Collections.singletonList(s.substring(pos));
        }
        if (pos < s.length()) {
            res.add(s.substring(pos));
        }
        return ContainerUtil.map(res, PhpParameterBasedTypeProvider::unwrap);
    }

    private static String unwrap(String s) {
        return StringUtil.trimEnd((String)StringUtil.trimStart((String)s, (String)"("), (String)")");
    }

    private static List<PhpNamedElement> computeMappedType(PhpMetaTypeMappingsTable types, PhpIndex index, String key, Collection<PhpPassedArgument> passedArguments, Collection<String> type, Set<String> visited, int depth, Collection<? extends PhpNamedElement> subjectFunctions) {
        if (type.isEmpty()) {
            type = new HashSet<String>();
            type.addAll(PhpParameterBasedTypeProvider.getTypeByPattern(types, passedArguments, subjectFunctions));
            type.addAll(PhpParameterBasedTypeProvider.getTypeByTypeOverride(types, passedArguments));
            type.addAll(PhpParameterBasedTypeProvider.getTypeByElementType(types, key));
            type.addAll(PhpParameterBasedTypeProvider.getTypeByArrayWrapperType(types, key));
            PhpParameterBasedTypeProvider.addTypesFromResolvers(types, index, passedArguments, type, depth);
        }
        if (type.isEmpty()) {
            type = Collections.singleton(PhpParameterBasedTypeProvider.findMappedParameter(passedArguments, 0));
        }
        return type.stream().map(StringUtil::unquoteString).flatMap(t -> PhpParameterBasedTypeProvider.computeMappedType(index, t, visited, depth)).collect(Collectors.toList());
    }

    private static void addTypesFromResolvers(PhpMetaTypeMappingsTable types, PhpIndex index, Collection<PhpPassedArgument> passedArguments, Collection<String> type, int depth) {
        for (PhpMetaSignatureResolver resolver : PhpMetaSignatureResolver.EP_NAME.getExtensionList()) {
            for (String signature : types.get(resolver.getKey())) {
                ContainerUtil.addIfNotNull(type, (Object)resolver.getTypeBySignature(index, signature, passedArguments, depth));
            }
        }
    }

    private static Collection<String> getTypeByPattern(PhpMetaTypeMappingsTable types, Collection<PhpPassedArgument> passedArguments, Collection<? extends PhpNamedElement> subjectFunctions) {
        Pair<Boolean, Collection<String>> patternTypesIntersectionAware = PhpParameterBasedTypeProvider.getPatternTypes(types);
        return ((Collection)patternTypesIntersectionAware.second).stream().flatMap(s -> StringUtil.split((String)s, (String)"|").stream()).flatMap(target -> PhpParameterBasedTypeProvider.substituteOverrideMapType(passedArguments, target, types, subjectFunctions, (Boolean)patternTypesIntersectionAware.first).stream()).collect(Collectors.toList());
    }

    @NotNull
    private static Pair<Boolean, Collection<String>> getPatternTypes(PhpMetaTypeMappingsTable types) {
        Collection<String> inferredPattern = types.get(INFERRED_PATTERN_KEY);
        return !inferredPattern.isEmpty() && types.getKeys().size() == 1 ? Pair.create((Object)false, inferredPattern) : PhpParameterBasedTypeProvider.getTypeKeyIntersectionAware(types, PATTERN_KEY);
    }

    private static Collection<String> getTypeByTypeOverride(PhpMetaTypeMappingsTable types, Collection<PhpPassedArgument> passedArguments) {
        return ((Collection)PhpParameterBasedTypeProvider.getTypeKeyIntersectionAware((PhpMetaTypeMappingsTable)types, (String)TYPE_KEY).second).stream().map(s -> StringUtil.parseInt((String)s, (int)Integer.MAX_VALUE)).map(i -> PhpParameterBasedTypeProvider.findMappedParameter(passedArguments, i)).map(QUOTED_ARG_TO_STRING).collect(Collectors.toSet());
    }

    @NotNull
    private static Pair<Boolean, Collection<String>> getTypeKeyIntersectionAware(PhpMetaTypeMappingsTable types, String key) {
        Collection<String> r = types.get(key);
        if (!r.isEmpty()) {
            Pair pair = Pair.create((Object)false, r);
            if (pair == null) {
                PhpParameterBasedTypeProvider.$$$reportNull$$$0(13);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)true, types.get("&" + key));
        if (pair == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(14);
        }
        return pair;
    }

    private static Collection<String> getTypeByElementType(PhpMetaTypeMappingsTable types, String key) {
        return PhpParameterBasedTypeProvider.getTypeByKeyTransformation(types, key, ELEMENT_TYPE_KEY, PhpType::elementType);
    }

    private static Collection<String> getTypeByKeyTransformation(PhpMetaTypeMappingsTable types, String key, String patternKey, java.util.function.Function<PhpType, PhpType> transformation) {
        Collection<String> type = types.get(patternKey);
        if (!type.isEmpty()) {
            return Collections.singleton(transformation.apply(new PhpType().add(key).map(QUOTED_ARG_TO_STRING)).toString());
        }
        return Collections.emptyList();
    }

    private static Collection<String> getTypeByArrayWrapperType(PhpMetaTypeMappingsTable types, String key) {
        return PhpParameterBasedTypeProvider.getTypeByKeyTransformation(types, key, ARRAY_WRAPPER_TYPE_KEY, PhpType::pluralise);
    }

    private static Stream<PhpNamedElement> computeMappedType(PhpIndex index, String type, Set<String> visited, int depth) {
        return PhpParameterBasedTypeProvider.extractSignatures(type, 0).stream().flatMap(s -> s.startsWith("#") ? index.getBySignature(s, visited, depth + 1).stream() : index.getAnyByFQN(s).stream());
    }

    @NotNull
    private static List<String> getKeys(String refSignature, PhpNamedElement target, List<String> signatures) {
        if (signatures.size() <= 1 && target instanceof Method && refSignature.length() > 1 && PhpParameterBasedTypeProvider.isResolvedToMagicCallMethod(refSignature, (Method)target)) {
            int dotIndex = refSignature.lastIndexOf(".");
            assert (dotIndex >= 0);
            String entryName = refSignature.substring(dotIndex + 1);
            List<String> list = Collections.singletonList(entryName);
            if (list == null) {
                PhpParameterBasedTypeProvider.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<String> list = signatures.subList(1, signatures.size());
        if (list == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static boolean isResolvedToMagicCallMethod(String refSignature, Method targetMethod) {
        if (PhpTypeSignatureKey.FIELD.is(refSignature.charAt(1))) {
            return true;
        }
        return PhpTypeSignatureKey.METHOD.is(refSignature.charAt(1)) && !refSignature.endsWith("." + targetMethod.getName()) && (PhpLangUtil.equalsMethodNames("__call", targetMethod.getName()) || PhpLangUtil.equalsMethodNames("__callStatic", targetMethod.getName()));
    }

    private static Stream<String> getTypesFromMappedArguments(PhpMetaTypeMappingsTable mappings, Collection<PhpPassedArgument> arguments) {
        return arguments.stream().flatMap(a -> mappings.get(StringUtil.unquoteString((String)a.myArgument), a.myIndex).stream()).filter(Predicates.not(Objects::isNull));
    }

    @Nullable
    private static PhpMetaTypeMappingsTable getTargets(String refSignature, Project project, PhpNamedElement target) {
        PhpClass aClass;
        Map<String, PhpMetaTypeMappingsTable> methods = PhpParameterBasedTypeProvider.getStaticMethodTypesMap(project);
        if (methods == null) {
            return null;
        }
        Ref types = new Ref();
        if (target instanceof Method) {
            String name = target.getName();
            boolean methodNameExists = methods.keySet().stream().filter(s -> PhpTypeSignatureKey.METHOD.isSigned(s)).anyMatch(s -> {
                int dot = s.lastIndexOf(46);
                return StringUtil.endsWith((CharSequence)s, (int)(dot + 1), (int)s.length(), (CharSequence)name);
            });
            if (methodNameExists && PhpParameterBasedTypeProvider.fillMemberType(methods, (Ref<PhpMetaTypeMappingsTable>)types, (Method)target)) {
                PhpClassHierarchyUtils.processSuperMethods((Method)((Method)target), (classMember, subClass, baseClass) -> PhpParameterBasedTypeProvider.fillMemberType(methods, (Ref<PhpMetaTypeMappingsTable>)types, classMember));
            }
        } else if (target instanceof Function) {
            types.set((Object)methods.get(PhpTypeSignatureKey.getSignature((Function)((Function)target))));
        } else if (target instanceof PhpClass) {
            PhpMetaTypeMappingsTable value = methods.get(refSignature);
            if (value != null) {
                types.set((Object)value);
            } else {
                types.set((Object)PhpParameterBasedTypeProvider.getClassTargetWithinHierarchy(methods, (PhpClass)target));
            }
        } else if ((target instanceof Variable || target instanceof Field) && (aClass = (PhpClass)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)project).getBySignature("#C" + target.getType().toStringResolved()))) != null) {
            types.set((Object)PhpParameterBasedTypeProvider.getClassTargetWithinHierarchy(methods, aClass));
        }
        return (PhpMetaTypeMappingsTable)types.get();
    }

    private static boolean fillMemberType(Map<String, PhpMetaTypeMappingsTable> methods, Ref<PhpMetaTypeMappingsTable> types, Method method) {
        PhpMetaTypeMappingsTable value = methods.get(PhpTypeSignatureKey.getSignature((Function)method));
        if (value != null) {
            PhpMetaTypeMappingsTable mergedTable = new PhpMetaTypeMappingsTable();
            mergedTable.putAll(value);
            if (!types.isNull()) {
                mergedTable.putAll((PhpMetaTypeMappingsTable)types.get());
            }
            types.set((Object)mergedTable);
        }
        return types.isNull() || ContainerUtil.and(((PhpMetaTypeMappingsTable)types.get()).getKeys(), INFERRED_PATTERN_KEY::equals);
    }

    private static PhpNamedElement getTarget(String refSignature, Set<String> visited, int depth, Project project) {
        Optional<? extends PhpNamedElement> targets = PhpParameterBasedTypeProvider.doGetTarget(refSignature, visited, depth, project);
        if (targets.isEmpty() && PhpTypeSignatureKey.METHOD.isSigned(refSignature) && (targets = PhpParameterBasedTypeProvider.doGetMagicMethodCallTarget(refSignature, visited, depth, project, "__call")).isEmpty()) {
            targets = PhpParameterBasedTypeProvider.doGetMagicMethodCallTarget(refSignature, visited, depth, project, "__callStatic");
        }
        return targets.orElse(null);
    }

    @NotNull
    private static Optional<? extends PhpNamedElement> doGetMagicMethodCallTarget(String refSignature, Set<String> visited, int depth, Project project, String magicMethodName) {
        int i = refSignature.lastIndexOf(46);
        if (i < 0) {
            Optional optional = Optional.empty();
            if (optional == null) {
                PhpParameterBasedTypeProvider.$$$reportNull$$$0(17);
            }
            return optional;
        }
        return PhpParameterBasedTypeProvider.doGetTarget(refSignature.substring(0, i) + "." + magicMethodName, visited, depth, project);
    }

    @NotNull
    private static Optional<? extends PhpNamedElement> doGetTarget(String refSignature, Set<String> visited, int depth, Project project) {
        Optional optional = StringUtil.split((String)refSignature, (String)"|").stream().flatMap(s -> PhpIndex.getInstance((Project)project).getBySignature(s, visited, depth + 1).stream()).findFirst();
        if (optional == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(18);
        }
        return optional;
    }

    private static PhpMetaTypeMappingsTable getClassTargetWithinHierarchy(Map<String, PhpMetaTypeMappingsTable> methods, PhpClass aClass) {
        Ref types = new Ref();
        PhpClassHierarchyUtils.processSupers((PhpClass)aClass, (boolean)true, (boolean)false, aClass1 -> {
            types.set((Object)((PhpMetaTypeMappingsTable)methods.get("#C" + aClass1.getFQN())));
            return types.isNull();
        });
        return (PhpMetaTypeMappingsTable)types.get();
    }

    @Nullable
    public static Map<String, PhpMetaTypeMappingsTable> getStaticMethodTypesMap(Project project) {
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, STATIC_FACTORY_TYPE_MAP, () -> {
            LOG.debug("COMPUTING MethodTypesMap");
            Map<String, PhpMetaTypeMappingsTable> newMeta = PhpMetaTypeInferenceMappingIndex.getMap(project);
            HashMap<String, PhpMetaTypeMappingsTable> result = new HashMap<String, PhpMetaTypeMappingsTable>();
            for (Map.Entry<String, PhpMetaTypeMappingsTable> entry : newMeta.entrySet()) {
                PhpMetaTypeMappingsTable current = (PhpMetaTypeMappingsTable)result.get(entry.getKey());
                if (current != null) {
                    current.putAll(entry.getValue());
                    continue;
                }
                current = entry.getValue();
                result.put(entry.getKey(), current);
            }
            LOG.debug("DONE COMPUTING MethodTypesMap => " + result.size());
            return new CachedValueProvider.Result(Collections.unmodifiableMap(result), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public static boolean isMeta(@NotNull PsiElement element) {
        if (element == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(19);
        }
        return PhpParameterBasedTypeProvider.isMeta(element.getContainingFile());
    }

    public static boolean isMeta(@NotNull PsiFile file) {
        if (file == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(20);
        }
        if (!(file instanceof PhpFile) || file instanceof LightVirtualFile) {
            return false;
        }
        if (PhpLangUtil.equalsIgnoreCase(file.getName(), PHPSTORM_META_PHP)) {
            return true;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)PhpParameterBasedTypeProvider.isMeta(file.getVirtualFile()), (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
    }

    public static boolean isMeta(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (PhpLangUtil.equalsIgnoreCase(file.getNameSequence(), PHPSTORM_META_PHP)) {
            return true;
        }
        VirtualFile parent = file.getParent();
        return parent != null && PhpLangUtil.equalsIgnoreCase(parent.getNameSequence(), PHPSTORM_META_PHP);
    }

    @NotNull
    private static PhpType inferTypeIgnoreInitialBackEdges(@NotNull Variable variable, final Set<Variable> visited) {
        if (variable == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(21);
        }
        if (PhpLangUtil.isThisReference((PsiElement)variable)) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpParameterBasedTypeProvider.$$$reportNull$$$0(22);
            }
            return phpType;
        }
        if (!visited.add(variable)) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpParameterBasedTypeProvider.$$$reportNull$$$0(23);
            }
            return phpType;
        }
        PhpType phpType = PhpTypeInfo.getTypeCached((PsiElement)variable, new PhpTypeAnalyserVisitor(){

            @Override
            @NotNull
            public PhpType inferVariableType(Variable variable, CharSequence variableName, PhpInstruction instruction, PhpScopeHolder scopeHolder) {
                PhpVariableInferredTypeAnalyzerProcessor processor2 = new PhpVariableInferredTypeAnalyzerProcessor(variable, variableName, scopeHolder, instruction){

                    @Override
                    protected PhpType getType(PhpPsiElement curAnchor) {
                        if (curAnchor instanceof Variable) {
                            return PhpParameterBasedTypeProvider.inferTypeIgnoreInitialBackEdges((Variable)curAnchor, visited);
                        }
                        return super.getType(curAnchor);
                    }
                };
                PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges(instruction, false, processor2);
                PhpType phpType = PhpVariableInferredTypeAnalyzerProcessor.processDfaBasedTypeState(variable, variableName, instruction, ((PhpTypeAnalyzerProcessor)processor2).getType(), false, Collections.emptySet());
                if (phpType == null) {
                    1.$$$reportNull$$$0(0);
                }
                return phpType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpParameterBasedTypeProvider$1", "inferVariableType"));
            }
        }, PhpCaches.getInstance((Project)variable.getProject()).TYPE_WITHOUT_BACKEDGES_CACHE);
        if (phpType == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(24);
        }
        return phpType;
    }

    @Override
    @Nullable
    public PhpType complete(Project project, String expression, int depth) {
        PhpType type = PhpParameterBasedTypeProvider.getType(expression, project, depth);
        return type != null ? type.global(project) : null;
    }

    @Nullable
    private static PhpType getType(String expression, Project project, int depth) {
        Function matchedFunction;
        PhpMetaTypeMappingsTable map;
        Map<String, PhpMetaTypeMappingsTable> methods;
        List<String> signatures = PhpParameterBasedTypeProvider.extractSignatures(expression, 2);
        if (signatures.isEmpty()) {
            return null;
        }
        String subject = PhpType.removeParametrisedType((String)PhpParameterBasedTypeProvider.completeSubject(project, signatures.get(0)));
        PhpNamedElement target = PhpParameterBasedTypeProvider.getTarget(subject, new HashSet<String>(), depth, project);
        List<String> params = PhpParameterBasedTypeProvider.getKeys(subject, target, signatures);
        if (target instanceof Method && PhpParameterBasedTypeProvider.isResolvedToMagicCallMethod(subject, (Method)target)) {
            subject = PhpTypeSignatureKey.getSignature((Function)((Function)target));
        }
        if (PhpParameterBasedTypeProvider.hasNoOverrides(subject, methods = PhpParameterBasedTypeProvider.getStaticMethodTypesMap(project))) {
            return null;
        }
        String matchedSubject = methods == null ? null : (String)ContainerUtil.find((Iterable)StringUtil.split((String)subject, (String)"|"), m -> methods.get(m) != null);
        PhpMetaTypeMappingsTable phpMetaTypeMappingsTable = map = matchedSubject != null ? methods.get(matchedSubject) : null;
        if (map != null) {
            matchedFunction = (Function)ContainerUtil.find((Iterable)PhpIndex.getInstance((Project)project).getBySignature(matchedSubject), Function.class::isInstance);
        } else {
            map = PhpParameterBasedTypeProvider.getTargets(subject, project, target);
            matchedFunction = (Function)ObjectUtils.tryCast((Object)target, Function.class);
        }
        if (map != null) {
            PhpType subjectType;
            Collection<PhpPassedArgument> arguments = PhpParameterBasedTypeProvider.convertFromNamedToPositional(params, (PhpNamedElement)matchedFunction);
            PhpType mappedType = PhpParameterBasedTypeProvider.computeMappedParameterType(project, subject, map, arguments);
            if (!mappedType.isEmpty() && !(subjectType = PhpType.global((Project)project, (String[])new String[]{subject})).isEmpty()) {
                return PhpParameterBasedTypeProvider.addInterfacesFromSubjectAsIntersection(project, mappedType, subjectType);
            }
            return mappedType;
        }
        return null;
    }

    @NotNull
    private static PhpType addInterfacesFromSubjectAsIntersection(Project project, PhpType mappedType, PhpType subjectType) {
        PhpType intersectionType = new PhpType().add(mappedType);
        PhpIndex index = PhpIndex.getInstance((Project)project);
        for (String subjectT : subjectType.getTypes()) {
            if (index.getInterfacesByFQN(subjectT).isEmpty()) continue;
            intersectionType.add(mappedType.filterPrimitives().map(s -> s + "&" + subjectT));
        }
        PhpType phpType = intersectionType;
        if (phpType == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(25);
        }
        return phpType;
    }

    private static PhpType computeMappedParameterType(Project project, String subject, PhpMetaTypeMappingsTable map, Collection<PhpPassedArgument> arguments) {
        PhpType fromMappedArguments = PhpParameterBasedTypeProvider.getTypeFromMappedArguments(map, arguments);
        if (!fromMappedArguments.isEmpty()) {
            return fromMappedArguments;
        }
        return new PhpType().add(fromMappedArguments).add(PhpParameterBasedTypeProvider.getTypeFromPattern(project, map, subject, arguments)).add(PhpParameterBasedTypeProvider.getTypeFromTypeOverride(project, subject, map, arguments)).add(PhpParameterBasedTypeProvider.getTypeFromElementType(project, subject, map, arguments)).add(PhpParameterBasedTypeProvider.getTypeFromArrayWrapperType(project, subject, map, arguments));
    }

    @NotNull
    private static PhpType getTypeFromMappedArguments(PhpMetaTypeMappingsTable map, Collection<PhpPassedArgument> arguments) {
        PhpType type = new PhpType();
        PhpParameterBasedTypeProvider.getTypesFromMappedArguments(map, arguments).forEach(arg_0 -> ((PhpType)type).add(arg_0));
        PhpType phpType = type;
        if (phpType == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(26);
        }
        return phpType;
    }

    private static PhpType getTypeFromPatternKeyTransformation(Project project, String subject, PhpMetaTypeMappingsTable map, Collection<PhpPassedArgument> arguments, String patternKey, java.util.function.Function<PhpType, PhpType> transformation) {
        Collection subjectFunctions = PhpIndex.getInstance((Project)project).getBySignature(subject);
        String target = (String)ContainerUtil.getFirstItem(map.get(patternKey));
        if (target != null) {
            int idx = StringUtil.parseInt((String)target, (int)Integer.MAX_VALUE);
            String mappedParam = PhpParameterBasedTypeProvider.findMappedParameter(arguments, idx);
            PhpType paramTypeGlobal = transformation.apply(PhpParameterBasedTypeProvider.addParamType(mappedParam, QUOTED_ARG_TO_STRING).global(project).filterUnknown());
            if (paramTypeGlobal.isEmpty()) {
                PhpType type = new PhpType();
                PhpParameterBasedTypeProvider.getParameters(idx, subjectFunctions).forEach(arg_0 -> ((PhpType)type).add(arg_0));
                return type;
            }
            if (ContainerUtil.exists(PhpParameterBasedTypeProvider.extractSignatures(mappedParam, 0), t -> !PhpParameterBasedTypeProvider.isValidMappedParam(t))) {
                return null;
            }
            return paramTypeGlobal;
        }
        return PhpType.EMPTY;
    }

    private static PhpType getTypeFromElementType(Project project, String subject, PhpMetaTypeMappingsTable map, Collection<PhpPassedArgument> arguments) {
        return PhpParameterBasedTypeProvider.getTypeFromPatternKeyTransformation(project, subject, map, arguments, ELEMENT_TYPE_KEY, PhpType::elementType);
    }

    private static PhpType getTypeFromArrayWrapperType(Project project, String subject, PhpMetaTypeMappingsTable map, Collection<PhpPassedArgument> arguments) {
        return PhpParameterBasedTypeProvider.getTypeFromPatternKeyTransformation(project, subject, map, arguments, ARRAY_WRAPPER_TYPE_KEY, PhpType::pluralise);
    }

    @Nullable
    private static PhpType getTypeFromTypeOverride(Project project, String subject, PhpMetaTypeMappingsTable map, Collection<PhpPassedArgument> arguments) {
        block3: {
            Pair<Boolean, Collection<String>> targetsIntersectionAware = PhpParameterBasedTypeProvider.getTypeKeyIntersectionAware(map, TYPE_KEY);
            Collection targets = (Collection)targetsIntersectionAware.second;
            Collection subjectFunctions = PhpIndex.getInstance((Project)project).getBySignature(subject);
            if (targets.isEmpty()) break block3;
            PhpType t = new PhpType();
            for (String s : targets) {
                PhpType paramTypeGlobal;
                String mappedParam;
                block6: {
                    Collection<Parameter> parameters;
                    block4: {
                        block5: {
                            int idx = StringUtil.parseInt((String)s, (int)Integer.MAX_VALUE);
                            mappedParam = PhpParameterBasedTypeProvider.findMappedParameter(arguments, idx);
                            paramTypeGlobal = PhpParameterBasedTypeProvider.addParamType(mappedParam, QUOTED_ARG_TO_STRING).global(project).filterUnknown();
                            if (((Boolean)targetsIntersectionAware.first).booleanValue()) {
                                paramTypeGlobal = PhpParameterBasedTypeProvider.updateTypeWithIntersection(subjectFunctions, paramTypeGlobal);
                            }
                            if ((parameters = PhpParameterBasedTypeProvider.getParameters(idx, subjectFunctions)).isEmpty() || !ContainerUtil.all(parameters, Parameter::isVariadic)) break block4;
                            paramTypeGlobal = new PhpType();
                            if (StringUtil.isEmpty((String)mappedParam)) break block5;
                            if (PhpParameterBasedTypeProvider.addTypesFromVariadic(project, arguments, subjectFunctions, paramTypeGlobal)) break block6;
                        }
                        parameters.forEach(arg_0 -> ((PhpType)t).add(arg_0));
                        break block6;
                    }
                    if (paramTypeGlobal.isEmpty()) {
                        parameters.forEach(arg_0 -> ((PhpType)t).add(arg_0));
                        continue;
                    }
                }
                if (ContainerUtil.exists(PhpParameterBasedTypeProvider.extractSignatures(mappedParam, 0), p -> !PhpParameterBasedTypeProvider.isValidMappedParam(p))) continue;
                t.add(paramTypeGlobal);
            }
            return t;
        }
        return null;
    }

    @NotNull
    private static PhpType updateTypeWithIntersection(Collection<? extends PhpNamedElement> subjectFunctions, PhpType paramType) {
        PhpType phpType = subjectFunctions.stream().map(e -> PhpTypeDeclarationImpl.updateTypeWithIntersection(PhpType.or((PhpType)paramType, (PhpType)e.getDocType()), true)).reduce(new PhpType(), PhpType::add);
        if (phpType == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(27);
        }
        return phpType;
    }

    private static boolean isSignedType(String type) {
        if (type == null || type.length() < 2 || type.charAt(0) != '#') {
            return false;
        }
        if (type.charAt(1) == '-') {
            return true;
        }
        return ContainerUtil.exists((Object[])PhpTypeSignatureKey.values(), key -> key.isSigned(type)) || ContainerUtil.exists((Iterable)EP_NAME.getExtensionList(), provider -> provider.getKey() == type.charAt(1));
    }

    @Nullable
    private static PhpType getTypeFromPattern(Project project, PhpMetaTypeMappingsTable map, String subject, Collection<PhpPassedArgument> arguments) {
        Pair<Boolean, Collection<String>> patternTypesIntersectionAware = PhpParameterBasedTypeProvider.getPatternTypes(map);
        Collection patterns = (Collection)patternTypesIntersectionAware.second;
        if (!patterns.isEmpty()) {
            Collection subjectFunctions = PhpIndex.getInstance((Project)project).getBySignature(subject);
            PhpType patternType = new PhpType();
            for (String targets : patterns) {
                for (String target : StringUtil.split((String)targets, (String)"|")) {
                    for (String paramType : PhpParameterBasedTypeProvider.substituteOverrideMapType(arguments, target, map, subjectFunctions, (Boolean)patternTypesIntersectionAware.first)) {
                        patternType.add(PhpParameterBasedTypeProvider.addParamType(paramType, s -> {
                            @NotNull String unquoted = StringUtil.unquoteString((String)s);
                            return PhpParameterBasedTypeProvider.isSignedType(unquoted) ? unquoted : PhpLangUtil.toFQN(unquoted);
                        }));
                    }
                }
            }
            return patternType;
        }
        return null;
    }

    @NotNull
    private static Collection<String> substituteOverrideMapType(Collection<PhpPassedArgument> arguments, String target, PhpMetaTypeMappingsTable map, Collection<? extends PhpNamedElement> subjectFunctions, boolean isIntersection) {
        int indexToReplaceOneArg = -1;
        for (PhpPassedArgument argument : arguments) {
            target = StringUtil.replace((String)target, (String)(ARG_PATTERN + argument.myIndex), (String)StringUtil.unquoteString((String)argument.myArgument));
            if (map.get(PATTERN_KEY, argument.myIndex).isEmpty() && map.get("&\u03c0", argument.myIndex).isEmpty() || !map.get(INFERRED_PATTERN_KEY).isEmpty() || indexToReplaceOneArg >= 0) continue;
            indexToReplaceOneArg = argument.myIndex;
        }
        int finalIndexToReplaceOneArg = indexToReplaceOneArg;
        Set finalTarget = isIntersection ? PhpParameterBasedTypeProvider.updateTypeWithIntersection(subjectFunctions, PhpType.from((String[])new String[]{target})).getTypes() : Collections.singleton(target);
        Collection collection = finalTarget.stream().flatMap(t -> PhpParameterBasedTypeProvider.substituteOverrideMapType(arguments, subjectFunctions, finalIndexToReplaceOneArg, t).stream()).collect(Collectors.toList());
        if (collection == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(28);
        }
        return collection;
    }

    @NotNull
    private static List<String> substituteOverrideMapType(Collection<PhpPassedArgument> arguments, Collection<? extends PhpNamedElement> subjectFunctions, int indexToReplaceOneArg, String finalTarget) {
        List<String> list = PhpParameterBasedTypeProvider.getMappedType(subjectFunctions, arguments, Math.max(indexToReplaceOneArg, 0)).stream().flatMap(t -> PhpParameterBasedTypeProvider.unwrapMockeryTarget(subjectFunctions, StringUtil.replace((String)finalTarget, (String)ONE_ARG_PATTERN, (String)t))).collect(Collectors.toList());
        if (list == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(29);
        }
        return list;
    }

    private static Stream<String> unwrapMockeryTarget(Collection<? extends PhpNamedElement> subjectFunctions, String type) {
        if (type.contains(",") && ContainerUtil.all(subjectFunctions, PhpParameterBasedTypeProvider::isMockeryCreationMethod)) {
            return PhpParameterBasedTypeProvider.unwrapMockeryArguments(type);
        }
        return Stream.of(type);
    }

    @NotNull
    private static Collection<String> getMappedType(Collection<? extends PhpNamedElement> subjectFunctions, Collection<PhpPassedArgument> arguments, int parameterIndex) {
        if (PhpParameterBasedTypeProvider.allResolvedParametersAreVariadic(subjectFunctions, parameterIndex)) {
            List list = ContainerUtil.map(arguments, s -> StringUtil.unquoteString((String)s.myArgument));
            if (list == null) {
                PhpParameterBasedTypeProvider.$$$reportNull$$$0(30);
            }
            return list;
        }
        List<String> list = Collections.singletonList(StringUtil.unquoteString((String)PhpParameterBasedTypeProvider.findMappedParameter(arguments, parameterIndex)));
        if (list == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(31);
        }
        return list;
    }

    private static boolean isMockeryCreationMethod(PhpNamedElement f) {
        if (f instanceof Method && !PhpMockeryTypeInferenceUtil.isMockeryNamespace(f.getFQN())) {
            return false;
        }
        return PhpType.intersects((PhpType)f.getGlobalType(), (PhpType)PhpMockeryTypeInferenceUtil.MOCKERY_MOCK);
    }

    @NotNull
    private static Stream<String> unwrapMockeryArguments(@NotNull String s) {
        if (s == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(32);
        }
        Stream<String> stream = StringUtil.split((String)StringUtil.unquoteString((String)s), (String)",").stream().map(StringUtil::trim);
        if (stream == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(33);
        }
        return stream;
    }

    private static boolean isValidMappedParam(String mappedParam) {
        return mappedParam.isEmpty() || mappedParam.startsWith("#") || PhpLangUtil.isFqn(mappedParam) || StringUtil.isQuotedString((String)mappedParam);
    }

    private static boolean addTypesFromVariadic(Project project, Collection<PhpPassedArgument> arguments, Collection<? extends PhpNamedElement> subjectFunctions, PhpType type) {
        if (arguments.isEmpty()) {
            return false;
        }
        boolean noUnresolvedTypesFromArguments = true;
        for (PhpPassedArgument argument : arguments) {
            if (!PhpParameterBasedTypeProvider.allResolvedParametersAreVariadic(subjectFunctions, argument.myIndex)) continue;
            String mappedParam = PhpParameterBasedTypeProvider.findMappedParameter(arguments, argument.myIndex);
            PhpType res = new PhpType();
            if (ContainerUtil.all(subjectFunctions, PhpParameterBasedTypeProvider::isMockeryCreationMethod)) {
                PhpParameterBasedTypeProvider.unwrapMockeryArguments(mappedParam).forEach(s -> res.add(PhpParameterBasedTypeProvider.addParamType(s, QUOTED_ARG_TO_STRING)));
            } else {
                res.add(PhpParameterBasedTypeProvider.addParamType(mappedParam, QUOTED_ARG_TO_STRING));
            }
            PhpType paramTypeGlobal = res.global(project).filterUnknown().filterMixed();
            if (paramTypeGlobal.isEmpty()) {
                noUnresolvedTypesFromArguments = false;
                continue;
            }
            type.add(paramTypeGlobal);
        }
        return noUnresolvedTypesFromArguments;
    }

    private static boolean allResolvedParametersAreVariadic(Collection<? extends PhpNamedElement> subjectFunctions, int index) {
        Collection<Parameter> resolvedParameters = PhpParameterBasedTypeProvider.getParameters(index, subjectFunctions);
        return !resolvedParameters.isEmpty() && ContainerUtil.all(resolvedParameters, Parameter::isVariadic);
    }

    public static String findMappedParameter(Collection<PhpPassedArgument> arguments, int i) {
        PhpPassedArgument firstArgument = (PhpPassedArgument)ContainerUtil.find(arguments, a -> a.myIndex == i);
        return firstArgument != null ? firstArgument.myArgument : "";
    }

    public static Collection<PhpPassedArgument> convertFromNamedToPositional(List<String> arguments, PhpNamedElement matchedFunction) {
        List parameters = matchedFunction instanceof Function ? Arrays.asList(((Function)matchedFunction).getParameters()) : Collections.emptyList();
        ArrayList<PhpPassedArgument> passedArguments = new ArrayList<PhpPassedArgument>();
        Parameter lastParameter = (Parameter)ContainerUtil.getLastItem(parameters);
        boolean variadic = lastParameter != null && lastParameter.isVariadic();
        for (int i = 0; i < arguments.size(); ++i) {
            String argument = arguments.get(i);
            int namedArgumentSeparator = argument.lastIndexOf(6450);
            if (namedArgumentSeparator >= 0) {
                String argumentWithoutName = argument.substring(0, namedArgumentSeparator);
                String name = argument.substring(namedArgumentSeparator + 1);
                int parameterIndex = ContainerUtil.indexOf(parameters, p -> PhpLangUtil.equalsParameterNames(name, p.getName()));
                if (parameterIndex < 0 && variadic) {
                    parameterIndex = parameters.size() - 1;
                }
                if (parameterIndex >= 0) {
                    passedArguments.add(new PhpPassedArgument(argumentWithoutName, parameterIndex));
                    continue;
                }
            }
            passedArguments.add(new PhpPassedArgument(argument, i));
        }
        return passedArguments;
    }

    public static String completeSubject(Project project, String incompleteSubject) {
        if (incompleteSubject.startsWith("#") && PhpPotentialGlobalEntryTP.TYPE_KEY.is(incompleteSubject.charAt(1))) {
            PhpNamedElement item = (PhpNamedElement)ContainerUtil.getFirstItem((Collection)PhpIndex.getInstance((Project)project).getBySignature(incompleteSubject));
            if (item instanceof Function) {
                return PhpTypeSignatureKey.getSignature((Function)((Function)item));
            }
            if (item instanceof Constant) {
                return PhpTypeSignatureKey.CONSTANT.sign((CharSequence)item.getFQN());
            }
        }
        return incompleteSubject;
    }

    @NotNull
    private static PhpType addParamType(String mappedParam, java.util.function.Function<String, String> typeMapper) {
        PhpType type = new PhpType();
        PhpParameterBasedTypeProvider.extractSignatures(mappedParam, 0).stream().map(typeMapper).forEach(arg_0 -> ((PhpType)type).add(arg_0));
        PhpType phpType = type;
        if (phpType == null) {
            PhpParameterBasedTypeProvider.$$$reportNull$$$0(34);
        }
        return phpType;
    }

    private static Collection<Parameter> getParameters(int idx, Collection<? extends PhpNamedElement> functions) {
        HashSet<Parameter> parameters = new HashSet<Parameter>();
        for (PhpNamedElement phpNamedElement : functions) {
            if (!(phpNamedElement instanceof Function)) continue;
            ContainerUtil.addIfNotNull(parameters, (Object)PhpParameterBasedTypeProvider.getParameter(idx, (Function)phpNamedElement));
        }
        return parameters;
    }

    @Nullable
    private static Parameter getParameter(int idx, Function element) {
        Parameter parameter = element.getParameter(idx);
        Object[] parameters = element.getParameters();
        if (parameter != null) {
            return parameter;
        }
        Parameter lastParameter = (Parameter)ArrayUtil.getLastElement((Object[])parameters);
        return lastParameter != null && lastParameter.isVariadic() ? lastParameter : parameter;
    }

    private static boolean hasNoOverrides(String subject, Map<String, PhpMetaTypeMappingsTable> methods) {
        if (subject.startsWith("#M")) {
            int i;
            String firstType = (String)ContainerUtil.getFirstItem((List)StringUtil.split((String)subject, (String)"|"));
            if (firstType != null && (i = firstType.indexOf(".")) >= 0) {
                String methodName = firstType.substring(i);
                if (methods != null && !PhpParameterBasedTypeProvider.hasMethodCandidates(methods, methodName)) {
                    return true;
                }
            }
        } else if (subject.startsWith("#F") && methods != null && PhpParameterBasedTypeProvider.hasNoFunctionOverride(methods, subject)) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 19, 20, 21, 32 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpParameterBasedTypeProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapTypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterSignature";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeKeyIntersectionAware";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetMagicMethodCallTarget";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetTarget";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpParameterBasedTypeProvider";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeIgnoreInitialBackEdges";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "addInterfacesFromSubjectAsIntersection";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromMappedArguments";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "updateTypeWithIntersection";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteOverrideMapType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedType";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapMockeryArguments";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "addParamType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isMeta";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeIgnoreInitialBackEdges";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "unwrapMockeryArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 19, 20, 21, 32 -> new IllegalArgumentException(string);
        };
    }

    public static class PhpPassedArgument {
        public final String myArgument;
        public final int myIndex;

        private PhpPassedArgument(String argument, int parameterIndex) {
            this.myArgument = argument;
            this.myIndex = parameterIndex;
        }
    }

    static final class MyCompletionContributor
    extends CompletionContributor
    implements DumbAware {
        MyCompletionContributor() {
        }

        public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                MyCompletionContributor.$$$reportNull$$$0(0);
            }
            if (result == null) {
                MyCompletionContributor.$$$reportNull$$$0(1);
            }
            ProcessingContext context = new ProcessingContext();
            PsiElement position = parameters.getPosition();
            if (parameters.getCompletionType() == CompletionType.BASIC && ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(StringLiteralExpression.class)).accepts((Object)position, context)) {
                PhpMetaTypeMappingsTable metaMappings = MyCompletionContributor.getMetaMappings(position);
                PhpExpression expression = PhpPsiUtil.getParentOfClass(position, false, PhpExpression.class);
                int parameterIndex = expression != null ? Math.max(PhpWorkaroundUtil.resolveMappedParameterIndex((PsiElement)expression), 0) : 0;
                for (String s : metaMappings.getKeys()) {
                    if (metaMappings.get(s, parameterIndex).isEmpty()) continue;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)s).withTypeText(StringUtil.join(metaMappings.get(s), (String)"|"), true));
                }
                List inferredPattern = metaMappings.getKeys().size() == 1 ? metaMappings.get(PhpParameterBasedTypeProvider.INFERRED_PATTERN_KEY) : Collections.emptyList();
                Set definedPattern = ContainerUtil.union(metaMappings.get(PhpParameterBasedTypeProvider.PATTERN_KEY), metaMappings.get("&\u03c0"));
                if (parameterIndex == 0 && (definedPattern.contains(PhpParameterBasedTypeProvider.ONE_ARG_PATTERN) || definedPattern.isEmpty() && inferredPattern.contains(PhpParameterBasedTypeProvider.ONE_ARG_PATTERN)) || definedPattern.contains(PhpParameterBasedTypeProvider.ARG_PATTERN + parameterIndex) || definedPattern.isEmpty() && inferredPattern.contains(PhpParameterBasedTypeProvider.ARG_PATTERN + parameterIndex)) {
                    PhpCompletionContributor.PhpStringLiteralClassesCompletionProvider.addCompletions(parameters, result);
                }
            }
            super.fillCompletionVariants(parameters, result);
        }

        @NotNull
        private static PhpMetaTypeMappingsTable getMetaMappings(@NotNull PsiElement position) {
            ParameterListOwner parameterListOwner;
            ArrayIndex index;
            if (position == null) {
                MyCompletionContributor.$$$reportNull$$$0(2);
            }
            if ((index = (ArrayIndex)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)position, ArrayIndex.class)) != null) {
                PhpPsiElement value;
                ArrayAccessExpression accessExpression = (ArrayAccessExpression)ObjectUtils.tryCast((Object)index.getParent(), ArrayAccessExpression.class);
                PhpPsiElement phpPsiElement = value = accessExpression != null ? accessExpression.getValue() : null;
                if (value instanceof PhpReference) {
                    PhpNamedElement target = PhpParameterBasedTypeProvider.getTarget(((PhpReference)value).getSignature(), null, 0, position.getProject());
                    PhpMetaTypeMappingsTable map = PhpParameterBasedTypeProvider.getTargets(((PhpReference)value).getSignature(), position.getProject(), target);
                    PhpMetaTypeMappingsTable phpMetaTypeMappingsTable = (PhpMetaTypeMappingsTable)ObjectUtils.notNull((Object)map, (Object)PhpMetaTypeMappingsTable.EMPTY);
                    if (phpMetaTypeMappingsTable == null) {
                        MyCompletionContributor.$$$reportNull$$$0(3);
                    }
                    return phpMetaTypeMappingsTable;
                }
            }
            if ((parameterListOwner = (ParameterListOwner)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)position, ParameterListOwner.class)) instanceof FunctionReference) {
                PhpNamedElement target = PhpParameterBasedTypeProvider.getTarget(((FunctionReference)parameterListOwner).getSignature(), null, 0, position.getProject());
                PhpMetaTypeMappingsTable map = PhpParameterBasedTypeProvider.getTargets(((FunctionReference)parameterListOwner).getSignature(), position.getProject(), target);
                PhpMetaTypeMappingsTable phpMetaTypeMappingsTable = (PhpMetaTypeMappingsTable)ObjectUtils.notNull((Object)map, (Object)PhpMetaTypeMappingsTable.EMPTY);
                if (phpMetaTypeMappingsTable == null) {
                    MyCompletionContributor.$$$reportNull$$$0(4);
                }
                return phpMetaTypeMappingsTable;
            }
            PhpMetaTypeMappingsTable phpMetaTypeMappingsTable = PhpMetaTypeMappingsTable.EMPTY;
            if (phpMetaTypeMappingsTable == null) {
                MyCompletionContributor.$$$reportNull$$$0(5);
            }
            return phpMetaTypeMappingsTable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpParameterBasedTypeProvider$MyCompletionContributor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpParameterBasedTypeProvider$MyCompletionContributor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaMappings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fillCompletionVariants";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetaMappings";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

