/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Range;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocTagParser;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnaryInfixPostfixTP
implements PhpTypeProvider4 {
    private static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('\u2206');
    private static final char MULTIPLICATION_CODE = '*';
    private static final char ADDITION_CODE = '+';

    public char getKey() {
        return KEY.getKey();
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof UnaryExpression) {
            if (PhpPsiUtil.isOfType(((UnaryExpression)element).getOperation(), PhpTokenTypes.opMINUS, PhpTokenTypes.opPLUS)) {
                String text = PhpPsiUtil.getLiteralText(element);
                if (PhpDocTagParser.isIntRangeBound((String)text)) {
                    return PhpType.createParametrized((String)"\\int", (String[])new String[]{text, text});
                }
                PhpType valueType = PhpType.from((PsiElement[])new PsiElement[]{((UnaryExpression)element).getValue()});
                if (valueType.isEmpty()) {
                    return PhpType.FLOAT_INT;
                }
                if (!valueType.hasUnresolved()) {
                    PhpType updatedType = PhpUnaryInfixPostfixTP.getTypeFromInfixIntMultiplication(valueType);
                    if (PhpPsiUtil.isOfType(((UnaryExpression)element).getOperation(), PhpTokenTypes.opMINUS)) {
                        return updatedType.map(PhpUnaryInfixPostfixTP::invertIntRange);
                    }
                    return updatedType;
                }
                return valueType.map(s -> KEY.sign(s + "*"));
            }
            if (PhpPsiUtil.isOfType(element, PhpElementTypes.INFIX_WRITE_EXPRESSION)) {
                return PhpUnaryInfixPostfixTP.getType((UnaryExpression)element);
            }
        }
        return null;
    }

    @NotNull
    private static String invertIntRange(String type) {
        Range bounds = PhpType.getIntRangeBounds((String)type);
        if (bounds == null) {
            String string = type;
            if (string == null) {
                PhpUnaryInfixPostfixTP.$$$reportNull$$$0(0);
            }
            return string;
        }
        if ((Integer)bounds.getFrom() == Integer.MIN_VALUE) {
            return "\\int";
        }
        String string = PhpType.createParametrizedType((String)"\\int", (String[])new String[]{String.valueOf(Math.min(-((Integer)bounds.getFrom()).intValue(), -((Integer)bounds.getTo()).intValue())), String.valueOf(Math.max(-((Integer)bounds.getFrom()).intValue(), -((Integer)bounds.getTo()).intValue()))});
        if (string == null) {
            PhpUnaryInfixPostfixTP.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static PhpType getType(@NotNull UnaryExpression element) {
        PhpPsiElement value;
        if (element == null) {
            PhpUnaryInfixPostfixTP.$$$reportNull$$$0(2);
        }
        if ((value = element.getValue()) instanceof PhpTypedElement) {
            PhpType res = new PhpType();
            PhpType phpType = ((PhpTypedElement)value).getType();
            for (String type : phpType.getTypes()) {
                if (PhpType.isNull((String)type)) {
                    res.add(PhpType.INT);
                    continue;
                }
                if (!PhpType.isUnresolved((String)type)) {
                    res.add(type);
                    continue;
                }
                if (type.startsWith("#\u03c0")) continue;
                res.add(KEY.sign(type + "+"));
            }
            return PhpUnaryInfixPostfixTP.createInfixType(res);
        }
        return null;
    }

    @NotNull
    private static PhpType createInfixType(@NotNull PhpType type) {
        if (type == null) {
            PhpUnaryInfixPostfixTP.$$$reportNull$$$0(3);
        }
        PhpType phpType = type.isEmpty() || PhpType.intersects((PhpType)type, (PhpType)PhpType.STRING) ? PhpType.or((PhpType)type, (PhpType)PhpType.INT) : type;
        if (phpType == null) {
            PhpUnaryInfixPostfixTP.$$$reportNull$$$0(4);
        }
        return phpType;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        String ref = expression.substring(2, expression.length() - 1);
        PhpType valueType = new PhpType().add(ref).global(project).filterUnknown();
        char code = expression.charAt(expression.length() - 1);
        if (code == '+') {
            return PhpUnaryInfixPostfixTP.getTypeFromInfixAddition(valueType);
        }
        if (code == '*') {
            PhpType type = PhpUnaryInfixPostfixTP.getTypeFromInfixIntMultiplication(valueType);
            return type.isEmpty() && !PhpIndexImpl.incompleteSignatureCanBeOmitted(ref) ? PhpType.FLOAT_INT : type;
        }
        return null;
    }

    private static PhpType getTypeFromInfixIntMultiplication(PhpType valueType) {
        PhpType r = new PhpType();
        for (String type : valueType.getTypesWithParametrisedParts()) {
            if ("\\float".equals(type)) {
                r.add(type);
                continue;
            }
            if ("\\mixed".equals(type)) {
                r.add(PhpType.FLOAT_INT);
                continue;
            }
            if ("\\int".equals(PhpType.removeParametrisedType((String)type))) {
                r.add(type);
                continue;
            }
            r.add(PhpType.INT);
        }
        return r;
    }

    public boolean emptyResultIsComplete() {
        return true;
    }

    @NotNull
    private static PhpType getTypeFromInfixAddition(PhpType valueType) {
        if (valueType.isNullable()) {
            PhpType phpType = PhpType.or((PhpType)valueType.filterNull(), (PhpType)PhpType.INT);
            if (phpType == null) {
                PhpUnaryInfixPostfixTP.$$$reportNull$$$0(5);
            }
            return phpType;
        }
        return PhpUnaryInfixPostfixTP.createInfixType(valueType);
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpUnaryInfixPostfixTP";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "invertIntRange";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpUnaryInfixPostfixTP";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfixType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromInfixAddition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createInfixType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

