/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.StringRef;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpCustomIndexAwareStub;
import com.jetbrains.php.lang.psi.stubs.PhpLanguageTypeMap;
import com.jetbrains.php.lang.psi.stubs.PhpMethodStub;
import com.jetbrains.php.lang.psi.stubs.PhpMethodStubImpl;
import com.jetbrains.php.lang.psi.stubs.PhpStubElementType;
import com.jetbrains.php.lang.psi.stubs.PhpStubSerializer;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCustomFunctionIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodNeverReturnTypeIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodNonNeverReturnTypeIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodNonVoidReturnTypeIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodVoidReturnTypeIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodWithCustomIndexMapTypeIndex;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/php/lang/psi/stubs/PhpMethodStubSerializer;", "Lcom/jetbrains/php/lang/psi/stubs/PhpStubSerializer;", "Lcom/jetbrains/php/lang/psi/elements/Method;", "Lcom/jetbrains/php/lang/psi/stubs/PhpMethodStub;", "<init>", "()V", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "getElementType", "Lcom/intellij/psi/tree/IElementType;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "intellij.php.impl"})
public final class PhpMethodStubSerializer
extends PhpStubSerializer<Method, PhpMethodStub> {
    public void serialize(@NotNull PhpMethodStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getName());
        dataStream.writeShort((int)stub.getFlags());
        PhpType phpType = stub.getDeclaredType();
        Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getDeclaredType(...)");
        this.writePhpType(dataStream, phpType);
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)stub.getDocExceptions());
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
        this.writeStringArray(dataStream, stringArray);
        dataStream.writeName(stub.getDeprecatedSinceVersion());
        PhpDeprecationAttributeOwner.PhpDeprecationInfo.write((PhpDeprecationAttributeOwner.PhpDeprecationInfo)stub.getDeprecationInfo(), (StubOutputStream)dataStream);
        dataStream.writeName(((PhpMethodStubImpl)stub).getAvailableInLanguageLevelFrom());
        dataStream.writeName(((PhpMethodStubImpl)stub).getAvailableInLanguageLevelTo());
        this.writeLanguageTypeMap(((PhpMethodStubImpl)stub).getLanguageTypeMap(), dataStream);
        PhpCustomFunctionIndex.writeCustomIndexMap(dataStream, ((PhpMethodStubImpl)stub).getCustomIndexMap());
    }

    @NotNull
    public PhpMethodStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef name = dataStream.readName();
        short flags = dataStream.readShort();
        PhpType declType = this.readPhpType(dataStream);
        Object[] docExceptions = this.readStringArray(dataStream);
        StringRef deprecatedSinceRef = dataStream.readName();
        PhpDeprecationAttributeOwner.PhpDeprecationInfo deprecationInfo = PhpDeprecationAttributeOwner.PhpDeprecationInfo.read((StubInputStream)dataStream);
        StringRef availableFrom = dataStream.readName();
        StringRef availableTo = dataStream.readName();
        PhpLanguageTypeMap languageTypeMap = this.readLanguageTypeMap(dataStream);
        Int2ObjectMap<Object> int2ObjectMap = PhpCustomFunctionIndex.readCustomIndexMap(dataStream);
        Intrinsics.checkNotNullExpressionValue(int2ObjectMap, (String)"readCustomIndexMap(...)");
        Int2ObjectMap<Object> customIndexMap = int2ObjectMap;
        return new PhpMethodStubImpl(parentStub, (IElementType)PhpElementTypes.CLASS_METHOD, name, flags, ArraysKt.toList((Object[])docExceptions), deprecatedSinceRef, declType, deprecationInfo, availableFrom, availableTo, languageTypeMap, customIndexMap);
    }

    @Override
    @NotNull
    public IElementType getElementType() {
        PhpStubElementType phpStubElementType = PhpElementTypes.CLASS_METHOD;
        Intrinsics.checkNotNullExpressionValue((Object)phpStubElementType, (String)"CLASS_METHOD");
        return (IElementType)phpStubElementType;
    }

    @Override
    public void indexStub(@NotNull PhpMethodStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        String string = StringUtil.toLowerCase((String)stub.getName());
        if (string == null) {
            return;
        }
        String shortName = string;
        sink.occurrence(PhpMethodIndex.KEY, (Object)shortName);
        if (stub instanceof PhpCustomIndexAwareStub && !((PhpCustomIndexAwareStub)stub).getCustomIndexMap().isEmpty()) {
            sink.occurrence(PhpMethodWithCustomIndexMapTypeIndex.KEY, (Object)shortName);
        }
        PhpType phpType = stub.getDeclaredType();
        Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getDeclaredType(...)");
        PhpType declaredType = phpType;
        if (!declaredType.isAmbiguous()) {
            if (!PhpType.intersects((PhpType)declaredType, (PhpType)PhpType.NEVER)) {
                sink.occurrence(PhpMethodNonNeverReturnTypeIndex.KEY, (Object)shortName);
            }
            if (!PhpType.intersects((PhpType)declaredType, (PhpType)PhpType.VOID)) {
                sink.occurrence(PhpMethodNonVoidReturnTypeIndex.KEY, (Object)shortName);
            }
            if (Intrinsics.areEqual((Object)declaredType, (Object)PhpType.NEVER)) {
                sink.occurrence(PhpMethodNeverReturnTypeIndex.KEY, (Object)StringUtil.toLowerCase((String)shortName));
            } else if (Intrinsics.areEqual((Object)declaredType, (Object)PhpType.VOID)) {
                sink.occurrence(PhpMethodVoidReturnTypeIndex.KEY, (Object)shortName);
            }
        }
    }
}

