/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.util.PhpStringUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpParametersDefaultValueMatchersIndex
extends FileBasedIndexExtension<String, Map<String, PhpParameterDefaultValueMatcher>> {
    @NonNls
    private static final ID<String, Map<String, PhpParameterDefaultValueMatcher>> KEY = ID.create((String)"php.parameters.default.value.matchers");
    public static final MyDefaultValueMatcherExternalizer MATCHER_EXTERNALIZER = new MyDefaultValueMatcherExternalizer();
    public static final MyExternalizer EXTERNALIZER = new MyExternalizer();
    public static final int ARRAY_ELEMENTS_MATCHER_SIZE = 10;

    @NotNull
    public ID<String, Map<String, PhpParameterDefaultValueMatcher>> getName() {
        ID<String, Map<String, PhpParameterDefaultValueMatcher>> iD = KEY;
        if (iD == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Map<String, PhpParameterDefaultValueMatcher>, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> PhpFuncGetArgUsageProvider.findTopLevelFunctions(inputData.getPsiFile()).mapToEntry(PhpNamedElement::getFQN, e -> PhpParametersDefaultValueMatchersIndex.getDefaultValueMatchers(FunctionImpl.getParametersForAllLanguageLevels(e))).filterValues(e -> !e.isEmpty()).distinctKeys().toMap();
        if (dataIndexer == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    private static Map<String, PhpParameterDefaultValueMatcher> getDefaultValueMatchers(Parameter @NotNull [] parameters) {
        if (parameters == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(2);
        }
        HashMap<String, PhpParameterDefaultValueMatcher> res = new HashMap<String, PhpParameterDefaultValueMatcher>();
        for (Parameter parameter : parameters) {
            PsiElement defaultValue = parameter.isOptional() ? parameter.getDefaultValue() : null;
            PhpParameterDefaultValueMatcher matcher = PhpParametersDefaultValueMatchersIndex.createDefaultValueMatcher(defaultValue);
            if (matcher == null) continue;
            res.put(parameter.getName(), matcher);
        }
        HashMap<String, PhpParameterDefaultValueMatcher> hashMap = res;
        if (hashMap == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @Nullable
    static PhpParameterDefaultValueMatcher createDefaultValueMatcher(@Nullable PsiElement parameter) {
        List<Pair<PhpParameterDefaultValueMatcher, PhpParameterDefaultValueMatcher>> arrayElements;
        if (parameter instanceof StringLiteralExpression) {
            String text = PhpStringUtil.unescapeText((StringLiteralExpression)parameter);
            if (text.length() > 1000) {
                return null;
            }
            return new PhpParameterStringDefaultValueMatcher(text);
        }
        if (PhpLangUtil.isNull(parameter)) {
            return PhpParameterNullDefaultValueMatcher.INSTANCE;
        }
        if (PhpPsiUtil.isOfType(parameter, PhpElementTypes.NUMBER)) {
            return new PhpParameterNumberDefaultValueMatcher(parameter.getText());
        }
        if (parameter instanceof ConstantReference || parameter instanceof ClassConstantReference && ((ClassConstantReference)parameter).getClassReference() instanceof ClassReference) {
            return new PhpParameterConstantDefaultValueMatcher(((PhpReference)parameter).getSignature());
        }
        if (parameter instanceof ArrayCreationExpression && !ContainerUtil.exists(arrayElements = ArrayCreationExpressionImpl.children((ArrayCreationExpression)parameter).stream().map(PhpParametersDefaultValueMatchersIndex::createKeyValueMatchers).limit(11L).collect(Collectors.toList()), p -> p.getSecond() == null) && arrayElements.size() <= 10) {
            return new PhpParameterArrayDefaultValueMatcher(arrayElements);
        }
        return null;
    }

    @NotNull
    private static Pair<PhpParameterDefaultValueMatcher, PhpParameterDefaultValueMatcher> createKeyValueMatchers(PhpPsiElement e) {
        if (e instanceof ArrayHashElement) {
            Pair pair = Pair.create((Object)PhpParametersDefaultValueMatchersIndex.createDefaultValueMatcher((PsiElement)((ArrayHashElement)e).getKey()), (Object)PhpParametersDefaultValueMatchersIndex.createDefaultValueMatcher((PsiElement)((ArrayHashElement)e).getValue()));
            if (pair == null) {
                PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(4);
            }
            return pair;
        }
        Pair pair = Pair.create(null, (Object)PhpParametersDefaultValueMatchersIndex.createDefaultValueMatcher((PsiElement)e.getFirstPsiChild()));
        if (pair == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @NotNull
    private static Pair<PhpParameterDefaultValueMatcher, PhpParameterDefaultValueMatcher> createMatcherFromArrayHashElement(ArrayHashElement e) {
        Pair pair = Pair.create((Object)PhpParametersDefaultValueMatchersIndex.createDefaultValueMatcher((PsiElement)e.getKey()), (Object)PhpParametersDefaultValueMatchersIndex.createDefaultValueMatcher((PsiElement)e.getValue()));
        if (pair == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(7);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Map<String, PhpParameterDefaultValueMatcher>> getValueExternalizer() {
        MyExternalizer myExternalizer = EXTERNALIZER;
        if (myExternalizer == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(8);
        }
        return myExternalizer;
    }

    public int getVersion() {
        return 3;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(9);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public static List<Map<String, PhpParameterDefaultValueMatcher>> getParameterDefaultValuesMatchers(@NotNull Function function) {
        if (function == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(10);
        }
        Project project = function.getProject();
        List list = FileBasedIndex.getInstance().getValues(KEY, (Object)function.getFQN(), GlobalSearchScope.allScope((Project)project));
        if (list == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static boolean isReferenceToSameConstant(@NotNull Project project, @NotNull PhpReference defaultValue, @NotNull PhpParameterConstantDefaultValueMatcher matcher) {
        List constants;
        if (project == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(12);
        }
        if (defaultValue == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(13);
        }
        if (matcher == null) {
            PhpParametersDefaultValueMatchersIndex.$$$reportNull$$$0(14);
        }
        if ((constants = ContainerUtil.filter((Collection)PhpIndex.getInstance((Project)project).getBySignature(matcher.getValue()), e -> e instanceof Constant || e instanceof Field && ((Field)e).isConstant())).isEmpty()) {
            return false;
        }
        Collection resolved = defaultValue.multiResolveStrict(PhpNamedElement.class);
        if (resolved.isEmpty()) {
            return false;
        }
        return new HashSet(resolved).equals(new HashSet(constants));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 10, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueMatchers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyValueMatchers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatcherFromArrayHashElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterDefaultValuesMatchers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValueMatchers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParameterDefaultValuesMatchers";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToSameConstant";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 10, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }

    public static interface PhpParameterDefaultValueMatcher {
        default public boolean matches(@Nullable PsiElement argument) {
            PhpParameterDefaultValueMatcher matcher = PhpParametersDefaultValueMatchersIndex.createDefaultValueMatcher(argument);
            return matcher != null && matcher.equals(this);
        }

        @NotNull
        public String getValue();
    }

    private static class PhpParameterStringDefaultValueMatcher
    implements PhpParameterDefaultValueMatcher {
        @NotNull
        private final String myStringUnescapedText;

        private PhpParameterStringDefaultValueMatcher(@NotNull String text) {
            if (text == null) {
                PhpParameterStringDefaultValueMatcher.$$$reportNull$$$0(0);
            }
            this.myStringUnescapedText = text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpParameterStringDefaultValueMatcher matcher = (PhpParameterStringDefaultValueMatcher)o;
            return this.myStringUnescapedText.equals(matcher.myStringUnescapedText);
        }

        @Override
        @NotNull
        public String getValue() {
            String string = this.myStringUnescapedText;
            if (string == null) {
                PhpParameterStringDefaultValueMatcher.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int hashCode() {
            return Objects.hash(this.myStringUnescapedText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$PhpParameterStringDefaultValueMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$PhpParameterStringDefaultValueMatcher";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpParameterNullDefaultValueMatcher
    implements PhpParameterDefaultValueMatcher {
        private static final PhpParameterNullDefaultValueMatcher INSTANCE = new PhpParameterNullDefaultValueMatcher();

        private PhpParameterNullDefaultValueMatcher() {
        }

        @Override
        @NotNull
        public String getValue() {
            return "null";
        }
    }

    private static class PhpParameterNumberDefaultValueMatcher
    implements PhpParameterDefaultValueMatcher {
        @NotNull
        private final String myText;

        private PhpParameterNumberDefaultValueMatcher(@NotNull String text) {
            if (text == null) {
                PhpParameterNumberDefaultValueMatcher.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpParameterNumberDefaultValueMatcher matcher = (PhpParameterNumberDefaultValueMatcher)o;
            return this.myText.equals(matcher.myText);
        }

        @Override
        @NotNull
        public String getValue() {
            String string = this.myText;
            if (string == null) {
                PhpParameterNumberDefaultValueMatcher.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int hashCode() {
            return Objects.hash(this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$PhpParameterNumberDefaultValueMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$PhpParameterNumberDefaultValueMatcher";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpParameterConstantDefaultValueMatcher
    implements PhpParameterDefaultValueMatcher {
        @NotNull
        private final String mySignature;

        private PhpParameterConstantDefaultValueMatcher(@NotNull String signature) {
            if (signature == null) {
                PhpParameterConstantDefaultValueMatcher.$$$reportNull$$$0(0);
            }
            this.mySignature = signature;
        }

        @Override
        public boolean matches(@Nullable PsiElement argument) {
            if (PhpParameterDefaultValueMatcher.super.matches(argument)) {
                return true;
            }
            return argument instanceof PhpReference && PhpParametersDefaultValueMatchersIndex.isReferenceToSameConstant(argument.getProject(), (PhpReference)argument, this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpParameterConstantDefaultValueMatcher matcher = (PhpParameterConstantDefaultValueMatcher)o;
            return this.mySignature.equals(matcher.mySignature);
        }

        @Override
        @NotNull
        public String getValue() {
            String string = this.mySignature;
            if (string == null) {
                PhpParameterConstantDefaultValueMatcher.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int hashCode() {
            return Objects.hash(this.mySignature);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signature";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$PhpParameterConstantDefaultValueMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$PhpParameterConstantDefaultValueMatcher";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpParameterArrayDefaultValueMatcher
    implements PhpParameterDefaultValueMatcher {
        private final List<Pair<@Nullable PhpParameterDefaultValueMatcher, @NotNull PhpParameterDefaultValueMatcher>> myArrayElementMatchers;

        private PhpParameterArrayDefaultValueMatcher(List<Pair<@Nullable PhpParameterDefaultValueMatcher, @NotNull PhpParameterDefaultValueMatcher>> matchers) {
            this.myArrayElementMatchers = matchers;
        }

        @Override
        @NotNull
        public String getValue() {
            return "";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpParameterArrayDefaultValueMatcher matcher = (PhpParameterArrayDefaultValueMatcher)o;
            return this.myArrayElementMatchers.equals(matcher.myArrayElementMatchers);
        }

        public int hashCode() {
            return Objects.hash(this.myArrayElementMatchers);
        }
    }

    private static class MyExternalizer
    implements DataExternalizer<Map<String, PhpParameterDefaultValueMatcher>> {
        private MyExternalizer() {
        }

        public void save(@NotNull DataOutput out, Map<String, PhpParameterDefaultValueMatcher> value) throws IOException {
            if (out == null) {
                MyExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (Map.Entry<String, PhpParameterDefaultValueMatcher> e : value.entrySet()) {
                out.writeUTF(e.getKey());
                MATCHER_EXTERNALIZER.save(out, e.getValue());
            }
        }

        public Map<String, PhpParameterDefaultValueMatcher> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyExternalizer.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            HashMap<String, PhpParameterDefaultValueMatcher> map = new HashMap<String, PhpParameterDefaultValueMatcher>(size);
            for (int i = 0; i < size; ++i) {
                String name = in.readUTF();
                PhpParameterDefaultValueMatcher matcher = MATCHER_EXTERNALIZER.read(in);
                map.put(name, matcher);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$MyExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyDefaultValueMatcherExternalizer
    implements DataExternalizer<PhpParameterDefaultValueMatcher> {
        private MyDefaultValueMatcherExternalizer() {
        }

        public void save(@NotNull DataOutput out, PhpParameterDefaultValueMatcher value) throws IOException {
            if (out == null) {
                MyDefaultValueMatcherExternalizer.$$$reportNull$$$0(0);
            }
            if (value instanceof PhpParameterStringDefaultValueMatcher) {
                out.writeUTF("string");
                out.writeUTF(((PhpParameterStringDefaultValueMatcher)value).myStringUnescapedText);
                return;
            }
            if (value == PhpParameterNullDefaultValueMatcher.INSTANCE) {
                out.writeUTF("null");
                return;
            }
            if (value instanceof PhpParameterNumberDefaultValueMatcher) {
                out.writeUTF("num");
                out.writeUTF(((PhpParameterNumberDefaultValueMatcher)value).myText);
                return;
            }
            if (value instanceof PhpParameterConstantDefaultValueMatcher) {
                out.writeUTF("const");
                out.writeUTF(((PhpParameterConstantDefaultValueMatcher)value).mySignature);
                return;
            }
            if (value instanceof PhpParameterArrayDefaultValueMatcher) {
                out.writeUTF("array");
                List<Pair<@Nullable PhpParameterDefaultValueMatcher, @NotNull PhpParameterDefaultValueMatcher>> matchers = ((PhpParameterArrayDefaultValueMatcher)value).myArrayElementMatchers;
                int size = matchers.size();
                out.writeInt(size);
                for (int i = 0; i < size; ++i) {
                    Pair<PhpParameterDefaultValueMatcher, PhpParameterDefaultValueMatcher> p = matchers.get(i);
                    if (p.getFirst() != null) {
                        out.writeBoolean(true);
                        this.save(out, (PhpParameterDefaultValueMatcher)p.getFirst());
                    } else {
                        out.writeBoolean(false);
                    }
                    this.save(out, (PhpParameterDefaultValueMatcher)p.getSecond());
                }
                return;
            }
            throw new IllegalStateException(value.getClass().toString());
        }

        public PhpParameterDefaultValueMatcher read(@NotNull DataInput in) throws IOException {
            String s;
            if (in == null) {
                MyDefaultValueMatcherExternalizer.$$$reportNull$$$0(1);
            }
            if ("string".equals(s = in.readUTF())) {
                return new PhpParameterStringDefaultValueMatcher(in.readUTF());
            }
            if ("null".equals(s)) {
                return PhpParameterNullDefaultValueMatcher.INSTANCE;
            }
            if ("num".equals(s)) {
                return new PhpParameterNumberDefaultValueMatcher(in.readUTF());
            }
            if ("const".equals(s)) {
                return new PhpParameterConstantDefaultValueMatcher(in.readUTF());
            }
            if ("array".equals(s)) {
                int size = in.readInt();
                ArrayList<Pair<@Nullable PhpParameterDefaultValueMatcher, @NotNull PhpParameterDefaultValueMatcher>> elements = new ArrayList<Pair<PhpParameterDefaultValueMatcher, PhpParameterDefaultValueMatcher>>();
                for (int i = 0; i < size; ++i) {
                    PhpParameterDefaultValueMatcher key = in.readBoolean() ? this.read(in) : null;
                    PhpParameterDefaultValueMatcher value = this.read(in);
                    elements.add((Pair<PhpParameterDefaultValueMatcher, PhpParameterDefaultValueMatcher>)Pair.create((Object)key, (Object)value));
                }
                return new PhpParameterArrayDefaultValueMatcher(elements);
            }
            throw new IllegalStateException(s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpParametersDefaultValueMatchersIndex$MyDefaultValueMatcherExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

