/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.completion.PhpAnyExpressionArgument;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpReferenceBase;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionConstantsFromClassArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionValuesFromConstantArguments;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExpectedFunctionArgumentsCollector
extends PhpControlFlowUtil.PhpRecursiveInstructionProcessor {
    public static final String POSSIBLE_ARGUMENTS_NAME = "expectedArguments";
    public static final String ARGUMENTS_SET_FUNCTION_NAME = "argumentsSet";
    protected final Map<String, Collection<PhpExpectedFunctionArgument>> myMap;
    protected final Map<String, Collection<PhpExpectedFunctionArgument>> myRegisteredArguments;

    PhpExpectedFunctionArgumentsCollector(Map<String, Collection<PhpExpectedFunctionArgument>> map, Map<String, Collection<PhpExpectedFunctionArgument>> registeredArguments) {
        this.myMap = map;
        this.myRegisteredArguments = registeredArguments;
    }

    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
        String fqn;
        PsiElement targetFunctionReference = this.getMetaFunctionTargetWithName(instruction, POSSIBLE_ARGUMENTS_NAME);
        String string = fqn = targetFunctionReference instanceof FunctionReference ? PhpExpectedFunctionArgumentsCollector.getFQN(targetFunctionReference) : null;
        if (fqn == null) {
            return true;
        }
        PsiElement[] parameters = instruction.getFunctionReference().getParameters();
        if (parameters.length < 3) {
            return true;
        }
        int argumentIndex = PhpExpectedFunctionArgumentsCollector.getExpectedArgumentIndexValue(parameters[1]);
        Collection<PhpExpectedFunctionArgument> arguments = this.getExpectedArguments(Arrays.copyOfRange(parameters, 2, parameters.length), argumentIndex);
        this.myMap.computeIfAbsent(fqn, k -> new SmartList()).addAll(arguments);
        return super.processPhpCallInstruction(instruction);
    }

    protected PsiElement getMetaFunctionTargetWithName(PhpCallInstruction instruction, String name) {
        FunctionReference reference = instruction.getFunctionReference();
        if (!PhpExpectedFunctionArgumentsIndex.metaFunctionWithName(reference, name)) {
            return null;
        }
        return reference.getParameter(0);
    }

    @Nullable
    public static String getFQN(PsiElement targetFunctionReference) {
        PhpReference classReference;
        if (targetFunctionReference instanceof MethodReference && (classReference = (PhpReference)ObjectUtils.tryCast((Object)((MethodReference)targetFunctionReference).getClassReference(), PhpReference.class)) != null) {
            return PhpCodeInsightUtil.getImmediateFQN(classReference) + "." + ((MethodReference)targetFunctionReference).getName();
        }
        if (targetFunctionReference instanceof PhpReferenceBase) {
            String fqn = PhpCodeInsightUtil.getImmediateFQN((PhpReferenceBase)targetFunctionReference);
            return fqn != null && targetFunctionReference instanceof ConstantReference ? PhpTypeSignatureKey.CONSTANT.sign((CharSequence)fqn) : fqn;
        }
        return null;
    }

    protected Collection<PhpExpectedFunctionArgument> getExpectedArguments(PsiElement[] parameters, int argumentIndex) {
        if (argumentIndex < 0) {
            return Collections.emptyList();
        }
        ArrayList<PhpExpectedFunctionArgument> expectedFunctionArguments = new ArrayList<PhpExpectedFunctionArgument>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] instanceof FunctionReference) {
                expectedFunctionArguments.addAll(this.getArgumentsFromRegisteredArgumentsSet(argumentIndex, (FunctionReference)parameters[i]));
                continue;
            }
            expectedFunctionArguments.addAll(PhpExpectedFunctionArgumentsIndex.getExpectedFunctionArguments(parameters[i], argumentIndex, i, null));
        }
        return expectedFunctionArguments;
    }

    @NotNull
    private Collection<PhpExpectedFunctionArgument> getArgumentsFromRegisteredArgumentsSet(int argumentIndex, FunctionReference argumentsSet) {
        StringLiteralExpression argumentsSetName;
        if (PhpExpectedFunctionArgumentsIndex.metaFunctionWithName(argumentsSet, ARGUMENTS_SET_FUNCTION_NAME) && (argumentsSetName = (StringLiteralExpression)ObjectUtils.tryCast((Object)argumentsSet.getParameter(0), StringLiteralExpression.class)) != null) {
            List list = ContainerUtil.map(this.getRegisteredArguments(argumentsSetName.getContents()), argument -> PhpExpectedFunctionArgumentsCollector.copyWithIndex(argument, argumentIndex));
            if (list == null) {
                PhpExpectedFunctionArgumentsCollector.$$$reportNull$$$0(0);
            }
            return list;
        }
        Set<PhpExpectedFunctionArgument> set = Collections.emptySet();
        if (set == null) {
            PhpExpectedFunctionArgumentsCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    private Collection<PhpExpectedFunctionArgument> getRegisteredArguments(String name) {
        return this.myRegisteredArguments.getOrDefault(name, Collections.emptyList());
    }

    @NotNull
    public static PhpExpectedFunctionArgument copyWithIndex(@NotNull PhpExpectedFunctionArgument argument, int argumentIndex) {
        if (argument == null) {
            PhpExpectedFunctionArgumentsCollector.$$$reportNull$$$0(2);
        }
        return switch (PhpExpectedFunctionArgumentsIndex.getKind(argument)) {
            default -> throw new MatchException(null, null);
            case PhpExpectedFunctionArgumentsIndex.Kind.CONSTANT -> new PhpExpectedFunctionConstantArgument(argument.getValue(), argumentIndex, argument.getOrder(), argument.getArgumentSet(), argument.isFlag(), argument.isFromAttribute());
            case PhpExpectedFunctionArgumentsIndex.Kind.CLASS_CONSTANT -> {
                PhpExpectedFunctionClassConstantArgument classConstantArgument = (PhpExpectedFunctionClassConstantArgument)argument;
                yield new PhpExpectedFunctionClassConstantArgument(classConstantArgument.getClassFqn(), classConstantArgument.getConstantName(), argumentIndex, argument.getOrder(), argument.getArgumentSet(), argument.isFlag(), argument.isFromAttribute());
            }
            case PhpExpectedFunctionArgumentsIndex.Kind.CONSTANTS_FROM_CLASS -> {
                PhpExpectedFunctionConstantsFromClassArgument constantsFromClassArgument = (PhpExpectedFunctionConstantsFromClassArgument)argument;
                yield new PhpExpectedFunctionConstantsFromClassArgument(constantsFromClassArgument.getValue(), argumentIndex, constantsFromClassArgument.isFlag(), argument.isFromAttribute());
            }
            case PhpExpectedFunctionArgumentsIndex.Kind.VALUES_FROM_CONSTANT -> {
                PhpExpectedFunctionValuesFromConstantArguments valuesFromConstant = (PhpExpectedFunctionValuesFromConstantArguments)argument;
                yield new PhpExpectedFunctionValuesFromConstantArguments(valuesFromConstant.getValue(), argumentIndex, valuesFromConstant.isFlag(), valuesFromConstant.isFromAttribute());
            }
            case PhpExpectedFunctionArgumentsIndex.Kind.ANY_EXPRESSION -> PhpAnyExpressionArgument.INSTANCE;
            case PhpExpectedFunctionArgumentsIndex.Kind.SCALAR -> {
                PhpExpectedFunctionScalarArgument scalarArgument = (PhpExpectedFunctionScalarArgument)argument;
                yield new PhpExpectedFunctionScalarArgument(argument.getValue(), argumentIndex, argument.getOrder(), argument.getArgumentSet(), argument.isFlag(), scalarArgument.getType(), argument.isFromAttribute());
            }
        };
    }

    private static int getExpectedArgumentIndexValue(PsiElement expectedArgumentIndex) {
        try {
            return Integer.parseInt(expectedArgumentIndex.getText());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedFunctionArgumentsCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsFromRegisteredArgumentsSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedFunctionArgumentsCollector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyWithIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

