/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.phpunit.PhpUnitDirectoriesManager;
import com.jetbrains.php.phpunit.PhpUnitFrameworkType;
import com.jetbrains.php.phpunit.PhpUnitInfoComponent;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfiguration;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfigurationType;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationSettings;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.testFramework.PhpTestFrameworkComposerConfig;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitComposerConfig
extends PhpTestFrameworkComposerConfig {
    @NonNls
    private static final String PACKAGE = "phpunit/phpunit";
    @NonNls
    private static final String RELATIVE_PATH = "autoload.php";

    public PhpUnitComposerConfig() {
        super(PhpUnitFrameworkType.getInstance(), PACKAGE, RELATIVE_PATH);
    }

    @Override
    public void updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter, @Nullable VirtualFile config) {
        if (project == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(0);
        }
        this.updateSettings(project, interpreter, true, config);
    }

    @Override
    public PhpTestFrameworkConfiguration updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter, boolean withRunConfig, @Nullable VirtualFile composerConfig) {
        if (project == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(1);
        }
        PhpUnitSettings settings = PhpUnitSettingsManager.getInstance(project).getSettingsByInterpreter(interpreter, composerConfig);
        VirtualFile configFile = (VirtualFile)ReadAction.compute(() -> this.findConfigurationFile(project, composerConfig));
        if (withRunConfig) {
            this.updateConfigurations(project, configFile, composerConfig);
        }
        if (PhpUnitComposerConfig.isEnabledForComposerConfig(project, composerConfig, PhpUnitFrameworkType.getInstance()) && (settings == null || StringUtil.isEmpty((String)settings.getCustomLoaderPath()))) {
            String autoloader = this.findFromComposerVendor(project, composerConfig);
            if (StringUtil.isEmpty((String)autoloader)) {
                return null;
            }
            PhpUnitSettings newSettings = PhpUnitSettingsManager.getInstance(project).getOrCreateByInterpreter(interpreter, composerConfig);
            newSettings.setCustomLoaderPath(interpreter == null || !interpreter.isRemote() ? PathUtil.toSystemDependentName((String)autoloader) : autoloader);
            if (newSettings.getLoadMethod() == PhpUnitSettings.LoadMethod.CUSTOM_LOADER) {
                ReadAction.nonBlocking(() -> {
                    PsiFile psiFile = configFile != null ? PsiManager.getInstance((Project)project).findFile(configFile) : null;
                    return psiFile != null && PhpUnitUtil.isPhpUnitConfigurationFile(psiFile);
                }).expireWith((Disposable)ComposerDataService.getInstance(project)).finishOnUiThread(ModalityState.nonModal(), isPhpUnitConfigurationFile -> {
                    if (isPhpUnitConfigurationFile.booleanValue()) {
                        this.updateRunConfigurations(project, newSettings, configFile, withRunConfig);
                    }
                }).submit((Executor)ComposerUtils.COMPOSER_CONFIG_EXECUTOR);
                this.notify(project, newSettings);
            }
            return newSettings;
        }
        return null;
    }

    @Override
    protected void updateRunConfigurations(@NotNull Project project, @NotNull PhpTestFrameworkConfiguration configuration, @Nullable VirtualFile configFile, boolean withRunConfig) {
        if (project == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(3);
        }
        if (configFile == null) {
            return;
        }
        this.updateByConfigurationFile(project, configuration, configFile);
        if (withRunConfig) {
            ConfigurationFactory[] factories = this.getConfigurationType().getConfigurationFactories();
            if (factories == null || factories.length != 1) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            String runConfigName = Registry.is((String)"php.multiple.testframework.configs.per.interpreter") ? configuration.getPresentableName(project) : configFile.getName();
            RunnerAndConfigurationSettings settings = runManager.createConfiguration(runConfigName, factories[0]);
            PhpUnitTestRunnerSettings testRunnerSettings = ((PhpUnitRunConfigurationSettings)((PhpUnitLocalRunConfiguration)settings.getConfiguration()).getSettings()).getTestRunnerSettings();
            testRunnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.XML);
            if (Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
                testRunnerSettings.setUseAlternativeConfigurationFile(true);
                testRunnerSettings.setConfigurationFilePath(configFile.getPath());
            }
            runManager.addConfiguration(settings);
        }
    }

    @Override
    @NotNull
    protected String getDefaultConfigName() {
        return "phpunit.xml";
    }

    @Override
    @NotNull
    protected ConfigurationType getConfigurationType() {
        PhpUnitLocalRunConfigurationType phpUnitLocalRunConfigurationType = PhpUnitLocalRunConfigurationType.getInstance();
        if (phpUnitLocalRunConfigurationType == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(4);
        }
        return phpUnitLocalRunConfigurationType;
    }

    @Override
    protected void updateConfigurations(@NotNull Project project, @Nullable VirtualFile configFile, @Nullable VirtualFile composerConfig) {
        if (project == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(5);
        }
        ReadAction.nonBlocking(() -> PhpUnitComposerConfig.getUpdatedDirectories(project, configFile, composerConfig)).expireWith((Disposable)ComposerDataService.getInstance(project)).finishOnUiThread(ModalityState.nonModal(), dirs -> {
            if (dirs != null) {
                PhpUnitDirectoriesManager.getInstance(project).updateDirectories((List<String>)dirs);
            }
        }).submit((Executor)ComposerUtils.COMPOSER_CONFIG_EXECUTOR);
    }

    @RequiresReadLock
    @Nullable
    private static List<String> getUpdatedDirectories(@NotNull Project project, @Nullable VirtualFile configFile, @Nullable VirtualFile composerConfig) {
        List dirsFromConfig;
        VirtualFile baseDir;
        if (project == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.softAssertReadAccess();
        VirtualFile composerDir = composerConfig != null ? composerConfig.getParent() : null;
        VirtualFile virtualFile = baseDir = composerDir != null ? composerDir : ProjectUtil.guessProjectDir((Project)project);
        if (baseDir == null) {
            return null;
        }
        List oldDirs = PhpUnitDirectoriesManager.getInstance(project).getExistedDirectories();
        List defaultDirs = Collections.singletonList(baseDir.getPath() + "/tests");
        if (composerConfig != null) {
            oldDirs = ContainerUtil.filter(oldDirs, c -> !composerConfig.equals(PhpUnitComposerConfig.getComposerConfig(project, c)));
            defaultDirs = ContainerUtil.filter(defaultDirs, dir -> PhpTestFrameworkComposerConfig.isDefaultTestRootAllowedByComposer(project, composerConfig, dir));
        }
        List<Object> list = dirsFromConfig = configFile != null ? PhpUnitInfoComponent.getPhpUnitDirectories(project, configFile.getPath()) : Collections.emptyList();
        if (PhpUnitComposerConfig.isEnabledForTestFrameworkConfig(project, configFile)) {
            dirsFromConfig = ContainerUtil.filter((Collection)dirsFromConfig, d -> PhpUnitComposerConfig.isControlledByComposer(project, d, composerConfig));
        }
        List newDirs = !dirsFromConfig.isEmpty() ? dirsFromConfig : defaultDirs;
        return ContainerUtil.concat((List)oldDirs, (List)newDirs);
    }

    @Override
    @NotNull
    public Collection<String> getTestRoots(@NotNull Project project) {
        if (project == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(7);
        }
        List<String> list = PhpUnitDirectoriesManager.getInstance(project).getDirectories();
        if (list == null) {
            PhpUnitComposerConfig.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitComposerConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitComposerConfig";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateRunConfigurations";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateConfigurations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedDirectories";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8 -> new IllegalStateException(string);
        };
    }
}

