/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.phpunit.PhpUnitDirectoriesManager;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBaseConfigurableForm;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkConfigurationInfoComponent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitInfoComponent
extends PhpTestFrameworkConfigurationInfoComponent<String> {
    @NotNull
    public static final String TESTSUITES_TAG = "testsuites";
    @NotNull
    public static final String TESTSUITE_TAG = "testsuite";
    @NotNull
    public static final String DIRECTORY_TAG = "directory";
    @NotNull
    private static final String PATH_PART_OF_TEST_ROOT = "test";
    @NotNull
    private List<String> myDirectories;

    public PhpUnitInfoComponent(@NotNull Project project, @Nullable PhpTestFrameworkBaseConfigurableForm<?> form) {
        if (project == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(0);
        }
        super(project, form);
        this.myDirectories = Collections.emptyList();
    }

    @Override
    @NotNull
    @Nls
    protected String getConfigurationsHeaderText() {
        String string = PhpBundle.message("phpunit.config.label", new Object[0]);
        if (string == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void printConfigurationsInfo(@NotNull StyledDocument doc, @NotNull Style style, @NotNull String configDirectoryPath) throws BadLocationException {
        if (doc == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(2);
        }
        if (style == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(3);
        }
        if (configDirectoryPath == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(4);
        }
        for (String directory : this.myDirectories) {
            if (!StringUtil.isNotEmpty((String)directory)) continue;
            doc.insertString(doc.getLength(), PhpBundle.message("phpunit.config.directory.label", new Object[0]), null);
            doc.insertString(doc.getLength(), " ", null);
            doc.insertString(doc.getLength(), FileUtil.getRelativePath((String)configDirectoryPath, (String)directory, (char)'/'), style);
            doc.insertString(doc.getLength(), "\n\n", null);
        }
    }

    @Override
    @NotNull
    public List<String> getDefaultConfigurations() {
        List<String> list = PhpUnitDirectoriesManager.getInstance(this.myProject).getDefaultDirectories();
        if (list == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getConfigurations() {
        List<String> list = this.myDirectories;
        if (list == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getConfigurationsFromSettings() {
        List<String> list = PhpUnitDirectoriesManager.getInstance(this.myProject).getDirectories();
        if (list == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    protected String getConfigurationPath(@NotNull String configuration) {
        if (configuration == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(8);
        }
        return configuration;
    }

    @Override
    public void setConfigurationsToSettings(@NotNull List<String> configurations) {
        if (configurations == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(9);
        }
        PhpUnitDirectoriesManager.getInstance(this.myProject).updateDirectories(configurations);
    }

    @Override
    public void setConfigurations(@NotNull List<String> configurations) {
        if (configurations == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(10);
        }
        this.myDirectories = configurations;
    }

    @Override
    public List<String> analyzeConfigurationFile(@NotNull String configurationPath) {
        if (configurationPath == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(11);
        }
        return PhpUnitInfoComponent.getPhpUnitDirectories(this.myProject, configurationPath);
    }

    @NotNull
    public static List<String> getPhpUnitDirectories(@NotNull Project project, @NotNull String path) {
        XmlTag rootTag;
        PsiFile file;
        if (project == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(12);
        }
        if (path == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(13);
        }
        if ((file = PhpRunUtil.findPsiFile(project, path)) != null && file.getFileType() == XmlFileType.INSTANCE && (rootTag = ((XmlFile)file).getRootTag()) != null) {
            String directoryPath = PathUtil.getParentPath((String)path);
            List list = ((StreamEx)StreamEx.of((Object)rootTag.findFirstSubTag(TESTSUITES_TAG)).nonNull().flatArray(tag -> tag.findSubTags(TESTSUITE_TAG)).flatArray(tag -> tag.findSubTags(DIRECTORY_TAG)).map(XmlTag::getValue).map(XmlTagValue::getTrimmedText).flatMap(pattern -> PhpUnitInfoComponent.getTestDirectories(directoryPath, pattern)).distinct()).toList();
            if (list == null) {
                PhpUnitInfoComponent.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private static StreamEx<String> getTestDirectories(@NotNull String configurationDirectory, @NotNull String pathPattern) {
        if (configurationDirectory == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(16);
        }
        if (pathPattern == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(17);
        }
        String pathBeforeAsterisk = FileUtil.isAbsolutePlatformIndependent((String)pathPattern) ? StringUtil.substringBefore((String)pathPattern, (String)"*") : null;
        String pathToTraverse = pathBeforeAsterisk != null ? StringUtil.substringAfter((String)pathPattern, (String)pathBeforeAsterisk) : pathPattern;
        VirtualFile testRoot = PhpRunUtil.findDirectory((String)ObjectUtils.notNull((Object)pathBeforeAsterisk, (Object)configurationDirectory));
        if (testRoot == null) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                PhpUnitInfoComponent.$$$reportNull$$$0(18);
            }
            return streamEx;
        }
        if (StringUtil.isEmpty((String)pathToTraverse)) {
            StreamEx streamEx = StreamEx.of((Object)testRoot.getPath());
            if (streamEx == null) {
                PhpUnitInfoComponent.$$$reportNull$$$0(19);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.of(PhpUnitInfoComponent.getTestDirectories(testRoot, pathToTraverse)).map(VirtualFile::getPath);
        if (streamEx == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(20);
        }
        return streamEx;
    }

    @NotNull
    private static Collection<VirtualFile> getTestDirectories(@NotNull VirtualFile root, @NotNull String pathToTraverse) {
        if (root == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(21);
        }
        if (pathToTraverse == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(22);
        }
        ArrayDeque<VirtualFile> testDirectories = new ArrayDeque<VirtualFile>();
        testDirectories.add(root);
        for (String path : FileUtil.splitPath((String)pathToTraverse)) {
            ArrayList<VirtualFile> currentDirectories = new ArrayList<VirtualFile>();
            while (!testDirectories.isEmpty()) {
                VirtualFile file = (VirtualFile)testDirectories.poll();
                if (path.equals("*")) {
                    ContainerUtil.addAll(currentDirectories, (Object[])file.getChildren());
                    continue;
                }
                VirtualFile relativeDirectory = file.findFileByRelativePath(path);
                if (relativeDirectory == null || !relativeDirectory.isDirectory()) continue;
                currentDirectories.add(relativeDirectory);
            }
            testDirectories.addAll(currentDirectories);
            if (!StringUtil.startsWithIgnoreCase((String)path, (String)PATH_PART_OF_TEST_ROOT)) continue;
            break;
        }
        ArrayDeque<VirtualFile> arrayDeque = testDirectories;
        if (arrayDeque == null) {
            PhpUnitInfoComponent.$$$reportNull$$$0(23);
        }
        return arrayDeque;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7, 14, 15, 18, 19, 20, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitInfoComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDirectoryPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationDirectory";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPattern";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToTraverse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitInfoComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationsHeaderText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigurations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationsFromSettings";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpUnitDirectories";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "printConfigurationsInfo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationsToSettings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurations";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "analyzeConfigurationFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPhpUnitDirectories";
                break;
            }
            case 16: 
            case 17: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTestDirectories";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7, 14, 15, 18, 19, 20, 23 -> new IllegalStateException(string);
        };
    }
}

