/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInterruptScriptInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpThrowInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpYieldInstruction;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.findUsages.PhpGotoTargetRendererProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpYieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.StatementImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUnitDataProvidersIndex;
import com.jetbrains.php.phpunit.PhpCompositeLocation;
import com.jetbrains.php.phpunit.PhpMethodLocation;
import com.jetbrains.php.phpunit.PhpPsiLocationWithDataSet;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfiguration;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfigurationType;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationSettings;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.phpunit.PhpUnitTestPattern;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerConfigurationEditor;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.run.PhpRunConfigurationExtensionsManager;
import com.jetbrains.php.run.PhpRunUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitRuntimeConfigurationProducer
extends LazyRunConfigurationProducer<PhpUnitLocalRunConfiguration> {
    static final String PARATEST_EXE = "paratest_for_phpstorm";
    private static final String PHPUNIT_TEST_WITH_ATTRIBUTE = "\\PHPUnit\\Framework\\Attributes\\TestWith";

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = PhpUnitLocalRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        if (configuration == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (startRunnable == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(3);
        }
        PhpUnitLocalRunConfiguration phpUnitLocalRunConfiguration = (PhpUnitLocalRunConfiguration)configuration.getConfiguration();
        PhpUnitTestRunnerSettings testRunnerSettings = ((PhpUnitRunConfigurationSettings)phpUnitLocalRunConfiguration.getSettings()).getTestRunnerSettings();
        Location location = context.getLocation();
        if (location instanceof PsiLocation) {
            List<Method> dataSetUsages;
            PhpNamedElement element = (PhpNamedElement)ObjectUtils.tryCast((Object)PhpUnitRuntimeConfigurationProducer.findTestElement(location.getPsiElement()), PhpNamedElement.class);
            PhpMethodLocation dataSet = PhpUnitRuntimeConfigurationProducer.extractDataSetFromDataProvider(location.getPsiElement());
            List<Method> list = dataSetUsages = dataSet != null ? PhpUnitDataProvidersIndex.getDataProviderUsages((Method)dataSet.getPsiElement()).toList() : Collections.emptyList();
            if (dataSet != null && dataSetUsages.size() > 1) {
                PhpUnitRuntimeConfigurationProducer.showDataSetUsageChooser(dataSet, dataSetUsages, context, testRunnerSettings, startRunnable, phpUnitLocalRunConfiguration);
                return;
            }
            if (PhpUnitRuntimeConfigurationProducer.tryRunAbstract(element, context.getDataContext(), testRunnerSettings, startRunnable, phpUnitLocalRunConfiguration, location)) {
                return;
            }
        }
        super.onFirstRun(configuration, context, startRunnable);
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(@NotNull ConfigurationContext context) {
        if (context == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(4);
        }
        RunManager runManager = RunManager.getInstance((Project)context.getProject());
        List configurations = this.getConfigurationSettingsList(runManager);
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        PsiElement psiElement = PhpUnitRuntimeConfigurationProducer.findTestElement(location instanceof PhpCompositeLocation ? ((PhpCompositeLocation)location).getTestDetectionElement() : location.getPsiElement());
        PhpMethodLocation dataSet = PhpUnitRuntimeConfigurationProducer.getDataSetFromDataProvider(location.getPsiElement());
        List<PhpUnitTestPattern> patterns = context.containsMultipleSelection() ? PhpUnitRuntimeConfigurationProducer.getTestPatterns(context.getDataContext()) : Collections.emptyList();
        for (RunnerAndConfigurationSettings configurationSettings : configurations) {
            ProgressManager.checkCanceled();
            PhpUnitLocalRunConfiguration configuration = (PhpUnitLocalRunConfiguration)configurationSettings.getConfiguration();
            if (!(dataSet != null ? this.isConfigurationWithPatterns(configuration, PhpUnitRuntimeConfigurationProducer.buildPatterns(location.getPsiElement(), dataSet)) : psiElement != null && this.isConfigurationFromContext(configuration, location, psiElement, patterns))) continue;
            return configurationSettings;
        }
        return null;
    }

    private static boolean tryRunAbstract(@Nullable PhpNamedElement testTarget, @NotNull DataContext context, @NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull Runnable startRunnable, @NotNull PhpUnitLocalRunConfiguration configuration, @NotNull Location location) {
        PhpClass testClass;
        if (context == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (testRunnerSettings == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (startRunnable == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (location == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(9);
        }
        PhpClass phpClass = testTarget != null ? (testTarget instanceof PhpClass ? (PhpClass)testTarget : PhpUnitRuntimeConfigurationProducer.getContainingClass(location, (Method)testTarget)) : (testClass = null);
        if (testClass != null && testClass.isAbstract()) {
            List testSubClasses = ContainerUtil.filter((Collection)PhpIndex.getInstance((Project)testClass.getProject()).getAllSubclasses(testClass.getFQN()), PhpUnitUtil::isTestClass);
            if (testSubClasses.size() > 1) {
                PhpUnitRuntimeConfigurationProducer.showInheritorChooses(testTarget, context, testRunnerSettings, startRunnable, configuration, location, testSubClasses);
                return true;
            }
            if (testSubClasses.size() == 1) {
                PhpUnitRuntimeConfigurationProducer.configureByAbstractClass(testTarget, testRunnerSettings, startRunnable, configuration, location, (PhpClass)testSubClasses.get(0));
                PhpUnitRuntimeConfigurationProducer.updateNameAndRun(configuration, startRunnable);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PhpClass getContainingClass(@NotNull Location location, @NotNull Method method) {
        if (location == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (method == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(11);
        }
        return location instanceof PhpMethodLocation ? ((PhpMethodLocation)location).getContainingClass() : method.getContainingClass();
    }

    private static void showInheritorChooses(@NotNull PhpNamedElement testTarget, @NotNull DataContext context, @NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull Runnable startRunnable, @NotNull PhpUnitLocalRunConfiguration configuration, @NotNull Location location, @NotNull List<PhpClass> testSubClasses) {
        if (testTarget == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (context == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (testRunnerSettings == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(14);
        }
        if (startRunnable == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(15);
        }
        if (configuration == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(16);
        }
        if (location == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(17);
        }
        if (testSubClasses == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(18);
        }
        String name = testTarget.getName();
        Consumer<Set<?>> callback = PhpUnitRuntimeConfigurationProducer.getRunInheritorsCallback(testTarget, testRunnerSettings, startRunnable, configuration, location, testSubClasses, name);
        PhpUnitRuntimeConfigurationProducer.createChooserPopup(testSubClasses, PhpBundle.message("choose.executable.class.to.run.0", name), false, callback).showInBestPositionFor(context);
    }

    private static void showDataSetUsageChooser(@NotNull PhpMethodLocation dataSet, @NotNull List<Method> dataSetUsages, @NotNull ConfigurationContext context, @NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull Runnable startRunnable, @NotNull PhpUnitLocalRunConfiguration configuration) {
        if (dataSet == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(19);
        }
        if (dataSetUsages == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(20);
        }
        if (context == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(21);
        }
        if (testRunnerSettings == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(22);
        }
        if (startRunnable == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(23);
        }
        if (configuration == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(24);
        }
        String name = Objects.requireNonNull(dataSet.getDataSet());
        Consumer<Set<?>> callback = PhpUnitRuntimeConfigurationProducer.getRunDataSetUsagesCallback(testRunnerSettings, startRunnable, configuration, dataSetUsages, name);
        PhpUnitRuntimeConfigurationProducer.createChooserPopup(dataSetUsages, PhpBundle.message("choose.test.method.to.run.dataset.0", name), true, callback).showInBestPositionFor(context.getDataContext());
    }

    @NotNull
    private static JBPopup createChooserPopup(@NotNull List<?> elements, @NotNull @Nls String title, boolean showMethodName, @NotNull Consumer<Set<?>> chosenCallback) {
        if (elements == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(25);
        }
        if (title == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(26);
        }
        if (chosenCallback == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(27);
        }
        ArrayList jbListItems = new ArrayList(elements);
        jbListItems.add(0, null);
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(jbListItems).setSelectionMode(2).setRenderer((ListCellRenderer)((Object)new PhpRunInheritorsListCellRenderer(elements.size(), showMethodName))).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemsChosenCallback(chosenCallback).createPopup();
        if (jBPopup == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(28);
        }
        return jBPopup;
    }

    @NotNull
    private static Consumer<Set<?>> getRunDataSetUsagesCallback(@NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull Runnable startRunnable, @NotNull PhpUnitLocalRunConfiguration configuration, @NotNull List<Method> values, @NotNull String dataSetName) {
        if (testRunnerSettings == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(29);
        }
        if (startRunnable == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(30);
        }
        if (configuration == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(31);
        }
        if (values == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(32);
        }
        if (dataSetName == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(33);
        }
        Consumer consumer = selectedValues -> {
            Collection valuesToRun = ContainerUtil.exists((Iterable)selectedValues, Objects::isNull) ? values : selectedValues;
            PhpUnitRuntimeConfigurationProducer.configurePattern(testRunnerSettings, PhpUnitRuntimeConfigurationProducer.buildPatterns((Stream<Method>)StreamEx.of((Collection)valuesToRun).select(Method.class), dataSetName));
            PhpUnitRuntimeConfigurationProducer.updateNameAndRun(configuration, startRunnable);
        };
        if (consumer == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(34);
        }
        return consumer;
    }

    @NotNull
    private static Consumer<Set<?>> getRunInheritorsCallback(@NotNull PhpNamedElement testTarget, @NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull Runnable startRunnable, @NotNull PhpUnitLocalRunConfiguration configuration, @NotNull Location location, @NotNull List<PhpClass> testSubClasses, @NotNull String targetName) {
        if (testTarget == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(35);
        }
        if (testRunnerSettings == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(36);
        }
        if (startRunnable == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(37);
        }
        if (configuration == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(38);
        }
        if (location == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(39);
        }
        if (testSubClasses == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(40);
        }
        if (targetName == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(41);
        }
        Consumer consumer = selectedValues -> {
            List valuesToRun;
            List list = valuesToRun = ContainerUtil.exists((Iterable)selectedValues, Objects::isNull) ? testSubClasses : ContainerUtil.filterIsInstance((Collection)selectedValues, PhpClass.class);
            if (valuesToRun.size() == 1) {
                PhpUnitRuntimeConfigurationProducer.configureByAbstractClass(testTarget, testRunnerSettings, startRunnable, configuration, location, (PhpClass)valuesToRun.get(0));
            } else {
                List testPatterns;
                List list2 = testPatterns = testTarget instanceof PhpClass ? ContainerUtil.map((Collection)valuesToRun, PhpUnitTestPattern::create) : Collections.emptyList();
                if (testTarget instanceof Method) {
                    testPatterns = new SmartList();
                    for (PhpClass phpClass : valuesToRun) {
                        String path = phpClass.getContainingFile().getVirtualFile().getPath();
                        testPatterns.add(new PhpUnitTestPattern(phpClass.getPresentableFQN(), targetName, path));
                    }
                }
                PhpUnitRuntimeConfigurationProducer.configurePattern(testRunnerSettings, testPatterns);
            }
            PhpUnitRuntimeConfigurationProducer.updateNameAndRun(configuration, startRunnable);
        };
        if (consumer == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(42);
        }
        return consumer;
    }

    private static void updateNameAndRun(@NotNull PhpUnitLocalRunConfiguration configuration, @NotNull Runnable startRunnable) {
        if (configuration == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(43);
        }
        if (startRunnable == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(44);
        }
        configuration.setName(configuration.suggestedName());
        startRunnable.run();
    }

    private static void configureByAbstractClass(@NotNull PhpNamedElement testTarget, @NotNull PhpUnitTestRunnerSettings testRunnerSettings, @NotNull Runnable startRunnable, @NotNull PhpUnitLocalRunConfiguration configuration, @NotNull Location location, @Nullable PhpClass realTestClass) {
        if (testTarget == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(45);
        }
        if (testRunnerSettings == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(46);
        }
        if (startRunnable == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(47);
        }
        if (configuration == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(48);
        }
        if (location == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(49);
        }
        if (realTestClass != null) {
            assert (!realTestClass.isAbstract());
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)realTestClass);
            if (virtualFile != null) {
                if (testTarget instanceof Method) {
                    PhpUnitRuntimeConfigurationProducer.configureMethodScope(location, virtualFile, testRunnerSettings, realTestClass, testTarget.getName());
                } else {
                    PhpUnitRuntimeConfigurationProducer.configureClassScope(realTestClass, virtualFile, testRunnerSettings);
                }
            }
        }
    }

    protected boolean setupConfigurationFromContext(@NotNull PhpUnitLocalRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        List<PhpUnitTestPattern> patterns;
        PsiElement element;
        Location location;
        if (configuration == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(50);
        }
        if (context == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(51);
        }
        if (sourceElement == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(52);
        }
        if (!((location = context.getLocation()) instanceof PsiLocation)) {
            return false;
        }
        PsiElement originalElement = location.getPsiElement();
        PhpMethodLocation dataSet = PhpUnitRuntimeConfigurationProducer.getDataSetFromDataProvider(location.getPsiElement());
        if (dataSet != null) {
            v0 = dataSet.getPsiElement();
        } else {
            PsiElement psiElement;
            if (location instanceof PhpCompositeLocation) {
                PhpCompositeLocation newLoc = (PhpCompositeLocation)location;
                psiElement = newLoc.getTestDetectionElement();
            } else {
                psiElement = originalElement;
            }
            v0 = element = PhpUnitRuntimeConfigurationProducer.findTestElement(psiElement);
        }
        if (element == null) {
            return false;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return false;
        }
        PhpUnitRunConfigurationSettings settings = (PhpUnitRunConfigurationSettings)configuration.getSettings();
        PhpUnitTestRunnerSettings testRunnerSettings = settings.getTestRunnerSettings();
        List<PhpUnitTestPattern> list = patterns = context.containsMultipleSelection() ? PhpUnitRuntimeConfigurationProducer.getTestPatterns(context.getDataContext()) : Collections.emptyList();
        if (!patterns.isEmpty()) {
            PhpUnitRuntimeConfigurationProducer.configurePattern(testRunnerSettings, patterns);
        } else if (dataSet != null) {
            PhpUnitRuntimeConfigurationProducer.configurePattern(testRunnerSettings, PhpUnitRuntimeConfigurationProducer.buildPatterns(originalElement, dataSet));
        } else if (element instanceof PhpClass) {
            PhpUnitRuntimeConfigurationProducer.configureClassScope((PhpClass)element, virtualFile, testRunnerSettings);
        } else if (element instanceof PsiDirectory) {
            testRunnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.Directory);
            testRunnerSettings.setDirectoryPath(virtualFile.getPresentableUrl());
        } else if (element instanceof Method) {
            PhpClass containingClass = ((Method)element).getContainingClass();
            if (containingClass != null) {
                String methodName = ((Method)element).getName();
                String dataSetName = PhpUnitRuntimeConfigurationProducer.getDataSetName(location);
                if (dataSetName != null) {
                    PhpUnitRuntimeConfigurationProducer.configurePattern(testRunnerSettings, Collections.singletonList(new PhpUnitTestPattern(containingClass.getPresentableFQN(), methodName, virtualFile.getPath(), dataSetName)));
                } else {
                    PhpUnitRuntimeConfigurationProducer.configureMethodScope(location, virtualFile, testRunnerSettings, containingClass, methodName);
                }
            }
        } else if (element instanceof PsiFile) {
            PsiFile psiFile = (PsiFile)element;
            if (PhpUnitUtil.isPhpUnitConfigurationFile(psiFile)) {
                testRunnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.XML);
                testRunnerSettings.setConfigurationFilePath(virtualFile.getPath());
                testRunnerSettings.setUseAlternativeConfigurationFile(true);
            }
        } else {
            return false;
        }
        String defaultParaTestPath = PhpUnitRuntimeConfigurationProducer.getDefaultParaTestPath(configuration, virtualFile);
        if (StringUtil.isEmpty((String)defaultParaTestPath)) {
            String paraTestExe = PhpUnitRuntimeConfigurationProducer.findParaTestExePath(element.getProject(), virtualFile);
            testRunnerSettings.setParaTestPath(paraTestExe);
        } else {
            testRunnerSettings.setParaTestPath(defaultParaTestPath);
        }
        sourceElement.set((Object)element);
        configuration.setName(configuration.suggestedName());
        PhpRunConfigurationExtensionsManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location);
        return true;
    }

    @NotNull
    private static List<PhpUnitTestPattern> buildPatterns(PsiElement element, @NotNull PhpMethodLocation dataSet) {
        if (dataSet == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(53);
        }
        if (PhpUnitRuntimeConfigurationProducer.isTestWithAttribute(element.getParent())) {
            return PhpUnitRuntimeConfigurationProducer.buildPatterns(Stream.of((Method)dataSet.getPsiElement()), dataSet.getDataSet());
        }
        return PhpUnitRuntimeConfigurationProducer.buildPatterns(PhpUnitDataProvidersIndex.getDataProviderUsages((Method)dataSet.getPsiElement()), dataSet.getDataSet());
    }

    @NotNull
    private static List<PhpUnitTestPattern> buildPatterns(Stream<Method> dataSetUsages, @Nullable String dataSetName) {
        List<PhpUnitTestPattern> list = dataSetUsages.filter(m -> m.getContainingClass() != null).map(m -> new PhpUnitTestPattern(m.getContainingClass().getPresentableFQN(), m.getName(), m.getContainingFile().getVirtualFile().getPath(), dataSetName)).toList();
        if (list == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(54);
        }
        return list;
    }

    @NotNull
    static String findParaTestExePath(Project project, @Nullable VirtualFile context) {
        VirtualFileSystem fileSystem;
        String basePath = context != null ? context.getPath() : null;
        String exePath = ComposerConfigUtils.findVendorExecutablePath(project, basePath, PARATEST_EXE);
        VirtualFile dir = ProjectUtil.guessProjectDir((Project)project);
        Object object = context != null ? context.getFileSystem() : (fileSystem = dir != null ? dir.getFileSystem() : null);
        if (fileSystem == null) {
            return "";
        }
        return fileSystem.findFileByPath(exePath) != null ? exePath : "";
    }

    @Nullable
    private static String getDefaultParaTestPath(@NotNull PhpUnitLocalRunConfiguration configuration, VirtualFile locationContext) {
        PhpUnitSettings phpUnitSettings;
        if (configuration == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(55);
        }
        PhpInterpreter interpreter = configuration.getInterpreter();
        PhpUnitSettingsManager settingsManager = PhpUnitSettingsManager.getInstance(configuration.getProject());
        PhpUnitSettings phpUnitSettings2 = phpUnitSettings = interpreter != null ? settingsManager.getSettingsByInterpreter(interpreter, locationContext) : settingsManager.getLocalSettings(locationContext);
        if (phpUnitSettings == null) {
            return null;
        }
        return phpUnitSettings.getParaTestPath();
    }

    public static void configurePattern(PhpUnitTestRunnerSettings testRunnerSettings, List<PhpUnitTestPattern> patterns) {
        testRunnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.Pattern);
        testRunnerSettings.setTestPatterns(patterns);
        PhpUnitTestRunnerConfigurationEditor.setCommonPath(testRunnerSettings, PhpUnitTestRunnerConfigurationEditor.getCommonFileOrDirectory(testRunnerSettings.getTestPatterns()));
    }

    private static void configureMethodScope(Location location, VirtualFile virtualFile, PhpUnitTestRunnerSettings testRunnerSettings, PhpClass containingClass, String methodName) {
        if (containingClass.isAbstract() && location instanceof PhpMethodLocation) {
            containingClass = ((PhpMethodLocation)location).getContainingClass();
            virtualFile = containingClass.getContainingFile().getVirtualFile();
        }
        assert (virtualFile != null);
        testRunnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.Method);
        testRunnerSettings.setFilePath(virtualFile.getPresentableUrl());
        testRunnerSettings.setMethodName(methodName);
        testRunnerSettings.setClassName(containingClass.getPresentableFQN());
    }

    private static void configureClassScope(PhpClass element, VirtualFile virtualFile, PhpUnitTestRunnerSettings testRunnerSettings) {
        testRunnerSettings.setScope(PhpUnitTestRunnerSettings.Scope.Class);
        testRunnerSettings.setFilePath(virtualFile.getPresentableUrl());
        testRunnerSettings.setClassName(element.getPresentableFQN());
    }

    @NotNull
    public static List<PhpUnitTestPattern> getTestPatterns(DataContext dataContext) {
        List list = PhpUnitRuntimeConfigurationProducer.getSelectedLocations(dataContext).map(l -> PhpUnitTestPattern.create(l.getPsiElement(), l.getDataSet())).nonNull().toList();
        if (list == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(56);
        }
        return list;
    }

    @NotNull
    private static StreamEx<? extends PhpPsiLocationWithDataSet> getSelectedLocations(@NotNull DataContext context) {
        Object[] locations;
        if (context == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(57);
        }
        if ((locations = (Location[])Location.DATA_KEYS.getData(context)) != null) {
            StreamEx streamEx = StreamEx.of((Object[])locations).select(PhpPsiLocationWithDataSet.class);
            if (streamEx == null) {
                PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(58);
            }
            return streamEx;
        }
        Object[] elements = (PsiElement[])PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        StreamEx streamEx = elements != null ? StreamEx.of((Object[])elements).select(PhpNamedElement.class).map(PhpUnitRuntimeConfigurationProducer::createLocation) : StreamEx.empty();
        if (streamEx == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(59);
        }
        return streamEx;
    }

    @NotNull
    private static PhpPsiLocationWithDataSet<? extends PsiElement> createLocation(@NotNull PhpNamedElement element) {
        PhpClass containingClass;
        if (element == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(60);
        }
        if (element instanceof Method && (containingClass = ((Method)element).getContainingClass()) != null) {
            return new PhpMethodLocation(element.getProject(), (Method)element, containingClass, null);
        }
        return new PhpPsiLocationWithDataSet<PhpNamedElement>(element.getProject(), element, null);
    }

    public boolean isConfigurationFromContext(@NotNull PhpUnitLocalRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Location location;
        if (configuration == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(61);
        }
        if (context == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(62);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        PhpMethodLocation dataSet = PhpUnitRuntimeConfigurationProducer.getDataSetFromDataProvider(location.getPsiElement());
        if (dataSet != null) {
            return this.isConfigurationWithPatterns(configuration, PhpUnitRuntimeConfigurationProducer.buildPatterns(location.getPsiElement(), dataSet));
        }
        PsiElement psiElement = PhpUnitRuntimeConfigurationProducer.findTestElement(location instanceof PhpCompositeLocation ? ((PhpCompositeLocation)location).getTestDetectionElement() : location.getPsiElement());
        if (psiElement == null) {
            return false;
        }
        List<PhpUnitTestPattern> patterns = context.containsMultipleSelection() ? PhpUnitRuntimeConfigurationProducer.getTestPatterns(context.getDataContext()) : Collections.emptyList();
        return this.isConfigurationFromContext(configuration, location, psiElement, patterns);
    }

    public boolean isConfigurationFromContext(@NotNull PhpUnitLocalRunConfiguration configuration, @NotNull Location location, @NotNull PsiElement psiElement, @NotNull List<PhpUnitTestPattern> patterns) {
        if (configuration == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(63);
        }
        if (location == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(64);
        }
        if (psiElement == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(65);
        }
        if (patterns == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(66);
        }
        if (!patterns.isEmpty()) {
            return this.isConfigurationWithPatterns(configuration, patterns);
        }
        if (psiElement instanceof PsiDirectory) {
            VirtualFile directory = ((PsiDirectory)psiElement).getVirtualFile();
            PhpUnitRunConfigurationSettings settings = (PhpUnitRunConfigurationSettings)configuration.getSettings();
            PhpUnitTestRunnerSettings testRunnerSettings = settings.getTestRunnerSettings();
            String path = testRunnerSettings.getDirectoryPath();
            return testRunnerSettings.getScope() == PhpUnitTestRunnerSettings.Scope.Directory && path != null && VfsUtilCore.pathEqualsTo((VirtualFile)directory, (String)FileUtil.toSystemIndependentName((String)path));
        }
        if (psiElement instanceof PsiFile) {
            VirtualFile virtualFile;
            PsiFile psiFile = (PsiFile)psiElement;
            if (PhpUnitUtil.isPhpUnitConfigurationFile(psiFile) && (virtualFile = psiFile.getVirtualFile()) != null) {
                PhpUnitRunConfigurationSettings settings = (PhpUnitRunConfigurationSettings)configuration.getSettings();
                PhpUnitTestRunnerSettings testRunnerSettings = settings.getTestRunnerSettings();
                String configFileName = testRunnerSettings.getConfigurationFilePath();
                return testRunnerSettings.getScope() == PhpUnitTestRunnerSettings.Scope.XML && configFileName != null && VfsUtilCore.pathEqualsTo((VirtualFile)virtualFile, (String)FileUtil.toSystemIndependentName((String)configFileName));
            }
        } else if (psiElement instanceof Method) {
            Method method = (Method)psiElement;
            PhpClass containingClass = PhpUnitRuntimeConfigurationProducer.getContainingClass(location, method);
            if (containingClass == null) {
                return false;
            }
            if (containingClass.isAbstract()) {
                return false;
            }
            PsiFile containingFile = containingClass.getContainingFile();
            if (containingFile == null) {
                return false;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            String filePath = virtualFile.getPath();
            String classFQN = containingClass.getFQN();
            String methodName = method.getName();
            PhpUnitTestRunnerSettings testRunnerSettings = ((PhpUnitRunConfigurationSettings)configuration.getSettings()).getTestRunnerSettings();
            String dataSetName = PhpUnitRuntimeConfigurationProducer.getDataSetName(location);
            if (testRunnerSettings.getScope() == PhpUnitTestRunnerSettings.Scope.Method) {
                String className = testRunnerSettings.getClassName();
                return dataSetName == null && PhpRunUtil.isFilePathEquals(filePath, testRunnerSettings.getFilePath()) && className != null && PhpLangUtil.equalsClassNames(classFQN, PhpLangUtil.toFQN(className)) && PhpLangUtil.equalsMethodNames(methodName, testRunnerSettings.getMethodName());
            }
            if (dataSetName != null) {
                return this.isConfigurationWithPatterns(configuration, Collections.singletonList(new PhpUnitTestPattern(containingClass.getPresentableFQN(), methodName, filePath, dataSetName)));
            }
        } else if (psiElement instanceof PhpClass) {
            PhpClass phpClass = (PhpClass)psiElement;
            PsiFile containingFile = phpClass.getContainingFile();
            if (containingFile == null) {
                return false;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            String filePath = virtualFile.getPath();
            String classFQN = phpClass.getFQN();
            PhpUnitTestRunnerSettings testRunnerSettings = ((PhpUnitRunConfigurationSettings)configuration.getSettings()).getTestRunnerSettings();
            if (testRunnerSettings.getScope() == PhpUnitTestRunnerSettings.Scope.Class) {
                String className = testRunnerSettings.getClassName();
                return PhpRunUtil.isFilePathEquals(filePath, testRunnerSettings.getFilePath()) && className != null && PhpLangUtil.equalsClassNames(classFQN, PhpLangUtil.toFQN(className));
            }
        }
        return false;
    }

    private boolean isConfigurationWithPatterns(PhpUnitLocalRunConfiguration configuration, List<PhpUnitTestPattern> patterns) {
        PhpUnitTestRunnerSettings testRunnerSettings = ((PhpUnitRunConfigurationSettings)configuration.getSettings()).getTestRunnerSettings();
        return testRunnerSettings.getScope() == PhpUnitTestRunnerSettings.Scope.Pattern && testRunnerSettings.getTestPatterns().equals(patterns);
    }

    @Nullable
    static PhpMethodLocation getDataSetFromDataProvider(PsiElement element) {
        PhpMethodLocation attributeLocation = PhpUnitRuntimeConfigurationProducer.extractLocationFromTestWithAttribute(element.getParent());
        if (attributeLocation != null) {
            return attributeLocation;
        }
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.chLBRACKET) && !PhpPsiUtil.isOfType(element, PhpTokenTypes.kwARRAY)) {
            return null;
        }
        ArrayCreationExpression array = (ArrayCreationExpression)ObjectUtils.tryCast((Object)element.getParent(), ArrayCreationExpression.class);
        if (array == null) {
            return null;
        }
        return (PhpMethodLocation)((Object)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)((Object)PhpUnitRuntimeConfigurationProducer.extractDataSetFromDataProvider(element)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT})));
    }

    @Nullable
    private static PhpMethodLocation extractLocationFromTestWithAttribute(PsiElement element) {
        if (PhpUnitRuntimeConfigurationProducer.isTestWithAttribute(element)) {
            int index;
            PhpClass testClass;
            PhpAttribute attribute = (PhpAttribute)element.getParent();
            Method method = (Method)ObjectUtils.tryCast((Object)attribute.getOwner(), Method.class);
            PhpClass phpClass = testClass = method != null ? method.getContainingClass() : null;
            if (testClass != null && PhpUnitUtil.isTestMethod(method) && (index = method.getAttributes(PHPUNIT_TEST_WITH_ATTRIBUTE).stream().toList().indexOf(attribute)) >= 0) {
                return new PhpMethodLocation(element.getProject(), method, testClass, PhpUnitRuntimeConfigurationProducer.getIndexName(index));
            }
        }
        return null;
    }

    private static boolean isTestWithAttribute(PsiElement element) {
        PhpAttribute attribute;
        PsiElement psiElement;
        return element instanceof ClassReference && (psiElement = element.getParent()) instanceof PhpAttribute && PhpLangUtil.equalsClassNames(PHPUNIT_TEST_WITH_ATTRIBUTE, (attribute = (PhpAttribute)psiElement).getFQN());
    }

    @Nullable
    private static PhpMethodLocation extractDataSetFromDataProvider(PsiElement element) {
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.chLBRACKET) && !PhpPsiUtil.isOfType(element, PhpTokenTypes.kwARRAY)) {
            return null;
        }
        ArrayCreationExpression array = (ArrayCreationExpression)ObjectUtils.tryCast((Object)element.getParent(), ArrayCreationExpression.class);
        if (array == null) {
            return null;
        }
        PsiElement parent = array.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof PhpYield) {
            PhpYield yield = (PhpYield)parent;
            return PhpUnitRuntimeConfigurationProducer.extractDataSetInfoFromYield(yield);
        }
        ArrayHashElement hashElement = (ArrayHashElement)ObjectUtils.tryCast((Object)parent.getParent(), ArrayHashElement.class);
        ArrayCreationExpression dataSetArray = (ArrayCreationExpression)ObjectUtils.tryCast((Object)(parent = hashElement != null ? hashElement : parent).getParent(), ArrayCreationExpression.class);
        if (dataSetArray == null) {
            return null;
        }
        Method method = (Method)PsiTreeUtil.getParentOfType((PsiElement)dataSetArray, Method.class);
        if (method == null || !PhpUnitRuntimeConfigurationProducer.isDataProvider(method)) {
            return null;
        }
        if (!PhpUnitRuntimeConfigurationProducer.isReturnedValue(dataSetArray)) {
            return null;
        }
        PhpClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PhpPsiElement hashElementKey = hashElement != null ? hashElement.getKey() : null;
        String dataSetName = PhpUnitRuntimeConfigurationProducer.extractDataSetName((PsiElement)hashElementKey, PhpUnitRuntimeConfigurationProducer.getDataSetIndex(dataSetArray, parent));
        if (dataSetName == null) {
            return null;
        }
        return new PhpMethodLocation(method.getProject(), method, containingClass, dataSetName);
    }

    @Nullable
    static String extractDataSetName(@Nullable PsiElement key, @NotNull ArrayCreationExpression array, @NotNull PsiElement parent) {
        if (array == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(67);
        }
        if (parent == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(68);
        }
        return PhpUnitRuntimeConfigurationProducer.extractDataSetName(key, PhpUnitRuntimeConfigurationProducer.getDataSetIndex(array, parent));
    }

    @Nullable
    static PhpMethodLocation extractDataSetInfoFromYield(@NotNull PhpYield yield) {
        if (yield == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(69);
        }
        if (PhpUnitRuntimeConfigurationProducer.isPotentiallyConditionalYield((PsiElement)yield) || yield.getArgument() == null) {
            return null;
        }
        Method method = (Method)PsiTreeUtil.getParentOfType((PsiElement)yield, Method.class);
        if (method == null || !PhpUnitRuntimeConfigurationProducer.isDataProvider(method)) {
            return null;
        }
        if (PhpUnitRuntimeConfigurationProducer.hasHaltInstructions(method)) {
            return null;
        }
        PhpYieldInstruction yieldInstruction = PhpControlFlowUtil.getInstruction(yield.getArgument(), PhpYieldInstruction.class);
        if (yieldInstruction == null) {
            return null;
        }
        final Ref yieldsCount = new Ref((Object)0);
        final Ref hasUnsupportedYields = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)yieldInstruction, false, new PhpInstructionProcessor(){

            public boolean processYieldInstruction(PhpYieldInstruction instruction) {
                PhpYield yield = (PhpYield)PsiTreeUtil.getParentOfType((PsiElement)instruction.getAnchor(), PhpYield.class, (boolean)false);
                if (yield != null && PhpUnitRuntimeConfigurationProducer.isPotentiallyConditionalYield((PsiElement)yield)) {
                    hasUnsupportedYields.set((Object)true);
                    this.haltTraversal();
                    return false;
                }
                if (yield != null && !PhpUnitRuntimeConfigurationProducer.isNamedYield(yield)) {
                    yieldsCount.set((Object)((Integer)yieldsCount.get() + 1));
                }
                return true;
            }
        });
        if (((Boolean)hasUnsupportedYields.get()).booleanValue()) {
            return null;
        }
        PsiElement yieldNamedArgument = PhpUnitRuntimeConfigurationProducer.isNamedYield(yield) ? yield.getArgument() : null;
        String dataSetName = PhpUnitRuntimeConfigurationProducer.extractDataSetName(yieldNamedArgument, (Integer)yieldsCount.get());
        if (dataSetName == null) {
            return null;
        }
        PhpClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        return new PhpMethodLocation(method.getProject(), method, containingClass, dataSetName);
    }

    private static boolean hasHaltInstructions(Method method) {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method, () -> CachedValueProvider.Result.create((Object)ContainerUtil.exists((Object[])method.getControlFlow().getInstructions(), i -> i instanceof PhpReturnInstruction || i instanceof PhpThrowInstruction || i instanceof PhpInterruptScriptInstruction), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean isNamedYield(@NotNull PhpYield yield) {
        PsiElement argument;
        if (yield == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(70);
        }
        return PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace(argument = yield.getArgument(), true), PhpTokenTypes.opHASH_ARRAY) && !PhpUnitRuntimeConfigurationProducer.isNumericKey(argument);
    }

    private static boolean isNumericKey(@Nullable PsiElement element) {
        StringLiteralExpression stringLiteralExpression;
        if (PhpCodeInsightUtil.toInt(element) != null) {
            return true;
        }
        StringLiteralExpression stringLiteralExpression2 = stringLiteralExpression = element instanceof StringLiteralExpression ? (StringLiteralExpression)element : null;
        if (stringLiteralExpression == null || stringLiteralExpression.getChildren().length > 0) {
            return false;
        }
        String contents = stringLiteralExpression.getContents();
        return !Strings.isEmpty((String)contents) && StringUtil.isNumeric((CharSequence)contents);
    }

    private static boolean isPotentiallyConditionalYield(@NotNull PsiElement element) {
        if (element == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(71);
        }
        if (element instanceof PhpYield) {
            GroupStatement groupStatement;
            StatementImpl statement;
            PhpYield phpYield = (PhpYield)element;
            if (PhpYieldImpl.getFrom(phpYield) != null) {
                return true;
            }
            PsiElement psiElement = phpYield.getParent();
            return !(psiElement instanceof StatementImpl && (psiElement = (statement = (StatementImpl)psiElement).getParent()) instanceof GroupStatement && (groupStatement = (GroupStatement)psiElement).getParent() instanceof Method);
        }
        return false;
    }

    public static boolean isReturnedValue(ArrayCreationExpression expression) {
        PsiElement parent = PhpPsiUtil.unparenthesize(expression.getParent());
        PhpScopeHolder scope = PhpPsiUtil.getScopeHolder((PsiElement)expression);
        if (scope == null) {
            return false;
        }
        PhpReturnInstruction returnInstruction = PhpUnitRuntimeConfigurationProducer.getSingleOrNullReturnInstruction(scope);
        if (returnInstruction == null) {
            return false;
        }
        if (parent instanceof PhpReturn) {
            return expression.equals((Object)returnInstruction.getArgument());
        }
        AssignmentExpression assignmentExpression = (AssignmentExpression)ObjectUtils.tryCast((Object)parent, AssignmentExpression.class);
        if (assignmentExpression == null) {
            return false;
        }
        final PhpPsiElement variable = assignmentExpression.getVariable();
        if (variable == null) {
            return false;
        }
        PhpAccessVariableInstruction varInstruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
        if (varInstruction == null) {
            return false;
        }
        final Ref isReturned = new Ref((Object)false);
        final Ref ambiguous = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)varInstruction, false, new PhpInstructionProcessor(){

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                Variable returnVar = (Variable)ObjectUtils.tryCast((Object)instruction.getArgument(), Variable.class);
                if (returnVar != null && PhpLangUtil.equalsVariableNames(returnVar.getName(), variable.getName())) {
                    isReturned.set((Object)true);
                }
                return true;
            }

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                return this.processAccessInstruction((PhpAccessInstruction)instruction, instruction.getVariableName());
            }

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                return this.processAccessInstruction((PhpAccessInstruction)instruction, instruction.getVariableName());
            }

            private boolean processAccessInstruction(PhpAccessInstruction instruction, @Nullable CharSequence variableName) {
                if (!PhpLangUtil.equalsVariableNames(variableName, variable.getName())) {
                    return true;
                }
                if (instruction.getAccess().isUnset() || !instruction.getAccess().isRead() && !instruction.getAccess().isLightRead()) {
                    ambiguous.set((Object)true);
                    this.haltTraversal();
                    return false;
                }
                return true;
            }
        });
        return (Boolean)ambiguous.get() == false && (Boolean)isReturned.get() != false;
    }

    @Nullable
    private static PhpReturnInstruction getSingleOrNullReturnInstruction(PhpScopeHolder scope) {
        return (PhpReturnInstruction)CachedValuesManager.getCachedValue((PsiElement)scope, () -> {
            List returnInstructions = ((StreamEx)StreamEx.of((Object[])scope.getControlFlow().getInstructions()).select(PhpReturnInstruction.class).limit(2L)).toList();
            return CachedValueProvider.Result.create((Object)(returnInstructions.size() == 1 ? (PhpReturnInstruction)returnInstructions.get(0) : null), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static Integer getDataSetIndex(@NotNull ArrayCreationExpression array, @NotNull PsiElement element) {
        if (array == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(72);
        }
        if (element == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(73);
        }
        int testIndex = 0;
        for (PhpPsiElement child : ArrayCreationExpressionImpl.children(array)) {
            ArrayHashElement hash;
            if (child instanceof ArrayHashElement && !PhpUnitRuntimeConfigurationProducer.isNumericKey((PsiElement)(hash = (ArrayHashElement)child).getKey())) continue;
            if (element.equals((Object)child)) {
                return testIndex;
            }
            ++testIndex;
        }
        return null;
    }

    @Nullable
    private static String extractDataSetName(@Nullable PsiElement element, @Nullable Integer index) {
        if (element == null || PhpUnitRuntimeConfigurationProducer.isNumericKey(element)) {
            return PhpUnitRuntimeConfigurationProducer.getIndexName(index);
        }
        StringLiteralExpression stringLiteralExpression = (StringLiteralExpression)ObjectUtils.tryCast((Object)element, StringLiteralExpression.class);
        if (stringLiteralExpression == null || stringLiteralExpression.getChildren().length > 0) {
            return null;
        }
        return stringLiteralExpression.getContents();
    }

    @Nullable
    private static String getIndexName(@Nullable Integer index) {
        return index != null ? "#" + index : null;
    }

    private static boolean isDataProvider(Method method) {
        return PhpUnitDataProvidersIndex.getDataProviderUsages(method).findAny().isPresent();
    }

    @Nullable
    private static String getDataSetName(@NotNull Location location) {
        if (location == null) {
            PhpUnitRuntimeConfigurationProducer.$$$reportNull$$$0(74);
        }
        return location instanceof PhpPsiLocationWithDataSet ? ((PhpPsiLocationWithDataSet)location).getDataSet() : null;
    }

    @Nullable
    public static PsiElement findTestElement(@Nullable PsiElement element) {
        if (element == null || DumbService.getInstance((Project)element.getProject()).isDumb()) {
            return null;
        }
        if (element instanceof PsiDirectory) {
            return PhpUnitRuntimeConfigurationProducer.checkDirectoryContainsPhpFiles(((PsiDirectory)element).getVirtualFile(), element.getProject()) ? element : null;
        }
        Method method = (Method)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{Method.class});
        if (method != null && PhpUnitUtil.isTestMethod(method)) {
            return method;
        }
        PhpClass aClass = (PhpClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PhpClass.class});
        if (aClass != null && PhpUnitUtil.isRunnableTestClass(aClass)) {
            return aClass;
        }
        PsiFile psiFile = (PsiFile)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiFile.class});
        if (psiFile instanceof PhpFile) {
            return PhpUnitUtil.findTestClass((PhpFile)psiFile);
        }
        if (psiFile instanceof XmlFile && PhpUnitUtil.isPhpUnitConfigurationFile(psiFile)) {
            return psiFile;
        }
        return null;
    }

    public static boolean checkDirectoryContainsPhpFiles(VirtualFile directory, Project project) {
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(directory);
        if (module != null) {
            GlobalSearchScope scope = module.getModuleContentWithDependenciesScope().intersectWith(GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)directory, (boolean)true));
            return !FileTypeIndex.getFiles((FileType)PhpFileType.INSTANCE, (GlobalSearchScope)scope).isEmpty();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 55, 57, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitRuntimeConfigurationProducer";
                break;
            }
            case 1: 
            case 8: 
            case 16: 
            case 24: 
            case 31: 
            case 38: 
            case 43: 
            case 48: 
            case 50: 
            case 55: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 13: 
            case 21: 
            case 51: 
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 7: 
            case 15: 
            case 23: 
            case 30: 
            case 37: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRunnable";
                break;
            }
            case 6: 
            case 14: 
            case 22: 
            case 29: 
            case 36: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnerSettings";
                break;
            }
            case 9: 
            case 10: 
            case 17: 
            case 39: 
            case 49: 
            case 64: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: 
            case 35: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testTarget";
                break;
            }
            case 18: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSubClasses";
                break;
            }
            case 19: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSet";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSetUsages";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenCallback";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSetName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 60: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 67: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yield";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitRuntimeConfigurationProducer";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createChooserPopup";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunDataSetUsagesCallback";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunInheritorsCallback";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatterns";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestPatterns";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLocations";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onFirstRun";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findExistingConfiguration";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryRunAbstract";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showInheritorChooses";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showDataSetUsageChooser";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createChooserPopup";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getRunDataSetUsagesCallback";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRunInheritorsCallback";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "updateNameAndRun";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "configureByAbstractClass";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "buildPatterns";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultParaTestPath";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedLocations";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createLocation";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "extractDataSetName";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "extractDataSetInfoFromYield";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isNamedYield";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isPotentiallyConditionalYield";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getDataSetIndex";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getDataSetName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 55, 57, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74 -> new IllegalArgumentException(string);
        };
    }

    private static final class PhpRunInheritorsListCellRenderer
    extends PhpGotoTargetRendererProvider.PhpNamedElementPsiElementListCellRenderer {
        private final int myNumberOfInheritors;

        private PhpRunInheritorsListCellRenderer(int numberOfInheritors, boolean showMethodNames) {
            super(showMethodNames);
            this.myNumberOfInheritors = numberOfInheritors;
        }

        protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value == null) {
                renderer.append(PhpBundle.message("all.0", this.myNumberOfInheritors));
                return true;
            }
            return super.customizeNonPsiElementLeftRenderer(renderer, list, value, index, selected, hasFocus);
        }
    }
}

